'
' Example Program Basic Language
' Test character lcd 16x2
' Hardware = CP68HC11 V2.0
'
include  "regs11.lib"

const    write_ins  = $1400
const    read_ins   = $1401
const    write_data = $1402

declare  i
declare  j

declare  lcd_data
declare  lcd_addr

cursor_16x2:
datab   $00,$01,$02,$03,$04,$05,$06,$07
datab   $08,$09,$0a,$0b,$0c,$0d,$0e,$0f
datab   $40,$41,$42,$43,$44,$45,$46,$47
datab   $48,$49,$4a,$4b,$4c,$4d,$4e,$4f

data_font:
datab   'T','e','s','t',' ','6','8','H'
datab   'C','1','1',' ','V','2','.','0'
datab   'B','y',' ','S','B','a','s','i'
datab   'c',' ','V','e','r','1','.','0'

busy_lcd:
do
i = peekb(read_ins)
i = i and $80
loop while i <> 0
return

init_lcd:
gosub busy_lcd
pokeb write_ins,$38
gosub busy_lcd
pokeb write_ins,$0c
gosub busy_lcd
pokeb write_ins,$06
gosub busy_lcd
pokeb write_ins,$01
return

'clear_lcd:
'gosub busy_lcd
'pokeb write_ins,$01
'return

'home_lcd:
'gosub busy_lcd
'pokeb write_ins,$02
'return

'shift_left:
'gosub busy_lcd
'pokeb write_ins,$10
'return

'shift_right:
'gosub busy_lcd
'pokeb write_ins,$14
'return

'insert_left:
'gosub busy_lcd
'pokeb write_ins,$18
'return

'insert_right:
'gosub busy_lcd
'pokeb write_ins,$1c
'return

' input = address cursor in lcd_addr
set_cursor:
gosub busy_lcd
pokeb write_ins,lcd_addr+$80
return

' input = ascii in lcd_data
write_lcd:
gosub busy_lcd
pokeb write_data,lcd_data
return

main:
gosub init_lcd

for j = 0 to 31
lcd_addr = peekb(addr(cursor_16x2) + j)    ' get cursor address
gosub set_cursor
lcd_data = peekb(addr(data_font) + j)      ' get character
gosub write_lcd
next
end





