;/**********************************/;
;/* Demo Program For SPI Interface */;
;/* Hardware : ET-CP68HC11 Ver 2.0 */;
;/* Complier : AS11NEW.EXE (V1.03) */;
;/**********************************/;
;
;/* Interface SPI With 74HC595(ET-7LSD)
;/* MISO (PD2) -- NC
;/* MOSI (PD3) -- DATA  (14)
;/* SCK  (PD4) -- SHIFT (11)
;/* SS#  (PD5) -- LATCH (12)
;
PORTD       EQU     $1008                   ; PortD Data Register
DDRD        EQU     $1009                   ; PortD Data Direction
SPCR        EQU     $1028                   ; SPI Control Register
SPSR        EQU     $1029                   ; SPI Status Register
SPDR        EQU     $102A                   ; SPI Data Register

            ORG     $A000                   ; Start at Rom Monitor
MAIN        LDS     #$9FFF                  ; Stack on RAM 32KB
            LDX     #$1000                  ; Base Register
            JSR     INIT_SPI
LOOP1       LDAB    #10
            LDY     #TAB_SEG                ; 7-Segment Code 0-9
LOOP2       LDAA    0,Y
            JSR     TX_SPI                  ; Display 7LSD
            JSR     DELAY
            INY
            DECB
            BNE     LOOP2
            BRA     LOOP1

;/*********************************/;
;/* Initial SPCR For SPI Port     */;
;/* SPIE = 0 : Interupt Disable   */;
;/* SPE  = 1 : SPI System ON      */;
;/* DWOM = 0 : Output Push-Pull   */;
;/* MSTR = 1 : SPI = Master       */;
;/* CPOL = 0 : Clock Active High  */;
;/* CPHA = 0 : Slave Latch Rising */;
;/* SPSR0,SPSR1 = 11 : Clock / 32 */;
;/*********************************/;
;
INIT_SPI    PSHA                            ; Save Register
            LDAA    #%00111000
            STAA    $1009                   ; PD5 (SS),PD4(SCK),PD3(MOSI)=Output
            LDAA    #%01010011
            STAA    $1028                   ; SPCR SPI Control Register
            PULA                            ; Restore Register
            RTS

;/***************************/;
;/* Send Data 1 Byte to SPI */;
;/* Input : ACC (8Bit-Data) */;
;/***************************/;
;
TX_SPI      PSHX                            ; Save Register
            LDX     #$1000                  ; Base Address Register
            BCLR    $08,X %00100000         ; PortD (SS = Low Falling Edge)
            STAA    SPDR                    ; Store Data for Send
TX_SPI1     LDAA    $1029                   ; SPSR (SPI Status)
            BPL     TX_SPI1
            BSET    $08,X %00100000         ; PortD (SS = High Rising Edge)
            PULX                            ; Restore Register
            RTS

;/*****************************/;
;/* Delay 0.5 Sec at E = 2MHz */;
;/*****************************/;
;
DELAY       PSHX
            PSHB
            LDAB    #$50
DLY10       LDX     #$0D06                  ; 10 mSec counter
DLY20       DEX
            BNE     DLY20
            DECB
            BNE     DLY10                   ; 10mSec x 50 = 0.5 Second
            PULB
            PULX
            RTS

;/*******************/;
;/* Table 7 Segment */;
;/*******************/;
;
TAB_SEG     FCB     $3F,$06,$5B,$4F         ; 0 1 2 3
            FCB     $66,$6D,$7D,$07         ; 4 5 6 7
            FCB     $7F,$6F                 ; 8 9

            ORG     $FFFE                   ; Reset Vectot
            FDB     MAIN

            END

