;/**********************************/;
;/* Demo Program For Scankey 4x4   */;
;/* Hardware : ET-CP68HC11 Ver 2.0 */;
;/* Complier : AS11NEW.EXE (V1.03) */;
;/**********************************/;
;
;/* Address Port of 8255
PA8255      EQU     $1200                   ; PortA = Output
PB8255      EQU     $1201                   ; PortB = Input
PC8255      EQU     $1202                   ; PCL = Output,PCH = Input
CTL8255     EQU     $1203                   ; Control 8255
;
BAUD        EQU     $2B                     ; SCI Baud rate control Reg.
SCCR1       EQU     $2C                     ; SCI Control Register1
SCCR2       EQU     $2D                     ; SCI Control Register2
SCSR        EQU     $2E                     ; SCI Status Register
SCDR        EQU     $2F                     ; SCI Data (RDR=Read,TDR=Write)

            ORG     $00
SCAN_BUF    RMB     1
KEY_FLAG    RMB     1                       ; 1 = old key 0 = new key

            ORG     $A000                   ; Start at ROM Monitor
            ;
START       LDS     #$9FFF                  ; Stack on RAM 32KB
            LDX     #$1000                  ; Base Register Index
            ;
            PSHX
            LDX     #$FFFF                  ; Power on Delay
PWR_DLY     DEX
            BNE     PWR_DLY
            PULX
            ;
            CLRA
            STAA    KEY_FLAG
            LDAA    #%10001000              ; PA,PB,PCL = Output,PCH = Input
            STAA    CTL8255
            ;
            JSR     INIT_SCI                ; Initial SCI = 9600,N,8,1,P
            JSR     PRINT_SCI
            FCB     $0D,$0A
            FCC     'Test Keyboard Telephone 4x3'
            FCB     $0D,$0A
            FCC     'PC0-PC3 = Out, PC4-PC7 = In'
            FCB     $0D,$0A
            FCC     'Pin 1,2 Keyboard = PC0 8255'
            FCB     $0D,$0A
            FCC     'Pin 3   Keyboard = PC1 8255'
            FCB     $0D,$0A
            FCC     'Pin 5   Keyboard = PC2 8255'
            FCB     $0D,$0A
            FCC     'Pin 6   Keyboard = PC3 8255'
            FCB     $0D,$0A
            FCC     'Pin 7   Keyboard = PC4 8255'
            FCB     $0D,$0A
            FCC     'Pin 4,8 Keyboard = PC5 8255'
            FCB     $0D,$0A
            FCC     'Pin 9   Keyboard = PC6 8255'
            FCB     $0A,$0D,$0A,$00
            ;
WAIT_KEY    JSR     SCAN_KEY
            CMPA    #$FF
            BEQ     WAIT_KEY                ; Loop Until Keypress
            ;
            PSHA
            JSR     PRINT_SCI
            FCB     $0D
            FCC     'Keypress = '
            FCB     $00
            PULA
            ;
            JSR     HEX_2ASC
            JSR     TX_SCI
            TBA
            JSR     TX_SCI
            BRA     WAIT_KEY

;/******************************/;
;/* Scan Keyboard Matrix (4x4) */;
;/* PC0..PC3 : Colum (Out)     */;
;/* PC4..PC7 : Row (In)        */;
;/* Output   : ACC (Code 0..F) */;
;/*          : FFH (Not Press) */;
;/******************************/;
;
SCAN_KEY    LDAB    #4                      ; Counter for Scan 4x4
            LDAA    #%00000001              ; Data For Colum Scan
            STAA    SCAN_BUF
            ;
SCAN1       LDAA    SCAN_BUF
            COMA
            STAA    PC8255                  ; Scan Colum (PC0..PC3)
            LDAA    PC8255                  ; In Row (PC4..PC7)
            ANDA    #$F0
            CMPA    #$F0                    ; Check row only (PC0..PC3)
            BNE     KEY_PRES                ; Jump if keypress
            LDAA    SCAN_BUF
            ASLA
            STAA    SCAN_BUF                ; Next Colum Scan
            DECB
            BNE     SCAN1
            LDAA    #$FF                    ; Not Keypress
            CLRB
            STAB    KEY_FLAG                ; Reset Press
            BRA     END_SCAN
            ;
KEY_PRES    JSR     DLY_10MS                ; Debounce key
            LDAA    PC8255                  ; In Row (PC4..PC7)
            ANDA    #$F0
            CMPA    #$F0                    ; Check row only (PC4..PC7)
            BNE     KEY_CODE                ; YES keypress
            BRA     SCAN_KEY                ; NO keybounce or noise
            ;
KEY_CODE    JSR     KEY_NEW
            BCC     SCAN1                   ; Ignore if old key
            LDAB    SCAN_BUF
            ABA                             ; Mix Row & Colum
            ;
            LDY     #KEY_TAB                ; Row & Colum Code
            LDAB    #12                     ; 12 Key Count
CODE1       CMPA    0,Y
            BEQ     CODE2
            INY
            DECB
            BNE     CODE1
            LDAA    #$FF                    ; Not Math in 12 Key
            BRA     END_SCAN
CODE2       DECB
            TBA                             ; Keycode (0..F)
END_SCAN    RTS

;/******************************/;
;/* Check Old & New key Status */;
;/* Out Status = Carry flag    */;
;/* Carry Flag(0) is old press */;
;/* Carry Flag(1) is new press */;
;/******************************/;
;
KEY_NEW     PSHA
            CLC                             ; old key Status
            LDAA    KEY_FLAG
            BNE     END_NEW                 ; Not Zero
            INCA                            ; old key in Next Time
            STAA    KEY_FLAG
            SEC                             ; New Key Status
END_NEW     PULA
            RTS

;/*******************************/;
;/* Table Code For Key Tel. 4x3 */;
;/* Pin 1,2 Keyboard = PC0 8255 */;
;/* Pin 3   Keyboard = PC1 8255 */;
;/* Pin 5   Keyboard = PC2 8255 */;
;/* Pin 6   Keyboard = PC3 8255 */;
;/* Pin 7   Keyboard = PC4 8255 */;
;/* Pin 4,8 Keyboard = PC5 8255 */;
;/* Pin 9   Keyboard = PC6 8255 */;
;/*******************************/;
;
KEY_TAB     FCB     $E1,$B1,$E2,$D2         ; #    *    9    8
            FCB     $B2,$E4,$D4,$B4         ; 7    6    5    4
            FCB     $E8,$D8,$B8,$D1         ; 3    2    1    0

;/*******************************/;
;/* Convert Hex to ASCII to A,B */;
;/* Input  =  ACCA              */;
;/* Output =  ACCA Hi-byte      */;
;/*           ACCB Low-byte     */;
;/*******************************/;
;
HEX_2ASC    PSHA
            JSR     HEX_TO_ASC
            TAB                             ; Transfer B <- A (B = Lo byte)
            PULA
            RORA                            ; Swap A
            RORA
            RORA
            RORA
            JSR     HEX_TO_ASC
            RTS

;/*******************************/;
;/* Convert Hex (0-F) to ASCII  */;
;/* Input  = Register ACC (Hex) */;
;/* Output = Register ACC (ASC) */;
;/*******************************/;
;
HEX_TO_ASC  CLC                             ; clear carry bit
            ANDA    #%00001111
            CMPA    #$09
            BNE     HTOA1
            SEC                             ; set carry bit
HTOA1       BCC     HTOA2                   ; > 0AH
            ORAA    #$30                    ; < 0AH
            JMP     END_HTOA
HTOA2       SBCA    #$09                    ; > 0AH
            ORAA    #$40
END_HTOA    RTS

;/*******************/;
;/* Delay Time 10mS */;
;/* E-Clock = 2 MHz */;
;/*******************/;
;
DLY_10MS    PSHX
            LDX     #$0D06                  ; 10 mSec counter
DLY10       DEX
            BNE     DLY10
            PULX
            RTS

;/****************************************/;
;/* Initial the SCI Port for 68HC11 CPU  */;
;/* Baud rate  : Crystal Oscilator 8MHz  */;
;/* Format SCI : Data 8 bit,1 Stop bit   */;
;/****************************************/;
;
INIT_SCI    LDAA    #%00110000              ; Set Baud rate 9600
            ;LDAA    #%00110001              ; Set Baud rate 4800
            ;LDAA    #%00110010              ; Set Baud rate 2400
            ;LDAA    #%00110011              ; Set Baud rate 1200
            STAA    BAUD,X
            LDAA    #$00
            STAA    SCCR1,X                 ; Set 8bit data,1 Stop bit
            LDAA    #$0C                    ; Enable RXD,TXD pin
            STAA    SCCR2,X
            RTS

;/********************************/;
;/* Transmit ASCII 1byte to SCI  */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : ASCII to SCI Port */;
;/* Register : ACCA,ACCB         */;
;/********************************/;
;
TX_SCI      PSHB
TX_SCI1     BRCLR   SCSR,X $80 TX_SCI1      ; Wait TDRE=1 (Buffer Empty)
            LDAB    SCSR,X                  ; Read For Clear Status
            STAA    SCDR,X                  ; Send character to SCI
TX_SCI2     BRCLR   SCSR,X $40 TX_SCI2      ; Wait  TC=1 (Send Complete)
            PULB
            RTS

;/*************************/;
;/* Receive data from SCI */;
;/* INPUT  : SCI Port     */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RX_SCI      BRCLR   SCSR,X $20 RX_SCI       ; Wait RDRF=1 (Receive Ready)
            LDAA    SCSR,X
            ANDA    #$0E
            BNE     RX_SCI1                 ; Rx Fail
            LDAA    SCDR,X                  ; Rx OK = Read data
            BRA     RX_SCI2
RX_SCI1     LDAA    SCDR,X
            CLRA                            ; Rx Fail Clear Data
RX_SCI2     RTS

;/*******************************/;
;/*  Print Out Data to SCI Port */;
;/*  Usage    : JSR   PRINT_SCI */;
;/*           : FCC   'xxxxxxx' */;
;/*           : FCB   $00       */;
;/*  Register : ACCA            */;
;/*  Call Sub : TX_SCI          */;
;/*  Note     : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRINT_SCI   PULY                            ; Pop Stack (PC Value)
            PSHA
            PSHB
PRN_SCI1    LDAA    0,Y                     ; Get Data For Print
            CMPA    #$00                    ; Check Last Byte
            BNE     PRN_SCI2                ; Jump if not Last Byte
            BRA     PRN_SCI3
PRN_SCI2    JSR     TX_SCI                  ; Send Data
            INY
            BRA     PRN_SCI1
PRN_SCI3    INY                             ; Point to Next Instruction
            PULB
            PULA
            PSHY                            ; Push Stack (PC Value)
            RTS

            ORG     $FFFE                   ; Reset Vector
            FDB     START

            END
