;/**********************************/;
;/* Demo Program For A/D 8 Channel */;
;/* Hardware : ET-CP68HC11 Ver 2.0 */;
;/* Complier : AS11NEW.EXE (V1.03) */;
;/**********************************/;
;
BAUD        EQU     $2B                     ; SCI Baud rate control Reg.
SCCR1       EQU     $2C                     ; SCI Control Register1
SCCR2       EQU     $2D                     ; SCI Control Register2
SCSR        EQU     $2E                     ; SCI Status Register
SCDR        EQU     $2F                     ; SCI Data (RDR=Read,TDR=Write)
;
ADCTL       EQU     $1030                   ; ADC Control Register
ADR1        EQU     $1031                   ; ADC Result Register1
ADR2        EQU     $1032                   ; ADC Result Register2
ADR3        EQU     $1033                   ; ADC Result Register3
ADR4        EQU     $1034                   ; ADC Result Register4
OPTION      EQU     $1039

            ORG     $A000                   ; Start at ROM Monitor
START       LDS     #$9FFF                  ; Stack on RAM 32KB
            LDX     #$1000                  ; Base Register Index
            LDAA    #%10010011              ; Initial Option ADC
            STAA    OPTION
            JSR     INIT_SCI                ; Initial SCI = 9600,N,8,1,P
            ;
            JSR     PRINT_SCI
            FCB     $0D,$0A
            FCC     '*********** Test Analog to Digital ***********'
            FCB     $0D,$0A
            FCC     'ADC1  ADC2  ADC3  ADC4  ADC5  ADC6  ADC7  ADC8'
            FCB     $0D,$0A,$00
TEST_ADC    JSR     MULT_ADC1               ; Convert ADC1..4
            LDAA    #' '
            JSR     TX_SCI
            LDAA    ADR1                    ; ADC1
            JSR     HEX_2ASC
            JSR     TX_SCI
            TBA
            JSR     TX_SCI
            LDAA    #' '
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            ;
            LDAA    ADR2                    ; ADC2
            JSR     HEX_2ASC
            JSR     TX_SCI
            TBA
            JSR     TX_SCI
            LDAA    #' '
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            ;
            LDAA    ADR3                    ; ADC3
            JSR     HEX_2ASC
            JSR     TX_SCI
            TBA
            JSR     TX_SCI
            LDAA    #' '
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            ;
            LDAA    ADR4                    ; ADC4
            JSR     HEX_2ASC
            JSR     TX_SCI
            TBA
            JSR     TX_SCI
            LDAA    #' '
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            ;
            JSR     MULT_ADC2               ; Convert ADC5..8
            LDAA    ADR1                    ; ADC5
            JSR     HEX_2ASC
            JSR     TX_SCI
            TBA
            JSR     TX_SCI
            LDAA    #' '
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            ;
            LDAA    ADR2                    ; ADC6
            JSR     HEX_2ASC
            JSR     TX_SCI
            TBA
            JSR     TX_SCI
            LDAA    #' '
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            ;
            LDAA    ADR3                    ; ADC7
            JSR     HEX_2ASC
            JSR     TX_SCI
            TBA
            JSR     TX_SCI
            LDAA    #' '
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            JSR     TX_SCI
            ;
            LDAA    ADR4                    ; ADC8
            JSR     HEX_2ASC
            JSR     TX_SCI
            TBA
            JSR     TX_SCI
            LDAA    #$0D
            JSR     TX_SCI
            JMP     TEST_ADC

;/*******************************/;
;/* Convert Hex to ASCII to A,B */;
;/* Input  =  ACCA              */;
;/* Output =  ACCA Hi-byte      */;
;/*           ACCB Low-byte     */;
;/*******************************/;
;
HEX_2ASC    PSHA
            JSR     HEX_TO_ASC
            TAB                             ; Transfer B <- A (B = Lo byte)
            PULA
            RORA                            ; Swap A
            RORA
            RORA
            RORA
            JSR     HEX_TO_ASC
            RTS

;/*******************************/;
;/* Convert Hex (0-F) to ASCII  */;
;/* Input  = Register ACC (Hex) */;
;/* Output = Register ACC (ASC) */;
;/*******************************/;
;
HEX_TO_ASC  CLC                             ; clear carry bit
            ANDA    #%00001111
            CMPA    #$09
            BNE     HTOA1
            SEC                             ; set carry bit
HTOA1       BCC     HTOA2                   ; > 0AH
            ORAA    #$30                    ; < 0AH
            JMP     END_HTOA
HTOA2       SBCA    #$09                    ; > 0AH
            ORAA    #$40
END_HTOA    RTS

;/*********************************/;
;/* Multiple 4 Channel Low  (LSB) */;
;/* Output   : ADR1 (Ch1 Result)  */;
;/*          : ADR2 (Ch2 Result)  */;
;/*          : ADR3 (Ch3 Result)  */;
;/*          : ADR4 (Ch4 Result)  */;
;/*********************************/;
;
MULT_ADC1   PSHA
            LDAA    #%00010000              ; Multiple 4 Channel LSB
            STAA    ADCTL
CONVERT1    LDAA    ADCTL
            ANDA    #$80                    ; Convertion Complete Flag
            BEQ     CONVERT1                ; Wait ADC Convert Ready
            PULA
            RTS

;/*********************************/;
;/* Multiple 4 Channel High (MSB) */;
;/* Output    : ADR1 (Ch5 Result) */;
;/*           : ADR2 (Ch6 Result) */;
;/*           : ADR3 (Ch7 Result) */;
;/*           : ADR4 (Ch8 Result) */;
;/*********************************/;
;
MULT_ADC2   PSHA
            LDAA    #%00010100              ; Multiple 4 Channel MSB
            STAA    ADCTL
CONVERT2    LDAA    ADCTL
            ANDA    #$80                    ; Convertion Complete Flag
            BEQ     CONVERT2                ; Wait ADC Convert Ready
            PULA
            RTS

;/****************************************/;
;/* Initial the SCI Port for 68HC11 CPU  */;
;/* Baud rate  : Crystal Oscilator 8MHz  */;
;/* Format SCI : Data 8 bit,1 Stop bit   */;
;/****************************************/;
;
INIT_SCI    LDAA    #%00110000              ; Set Baud rate 9600
            ;LDAA    #%00110001              ; Set Baud rate 4800
            ;LDAA    #%00110010              ; Set Baud rate 2400
            ;LDAA    #%00110011              ; Set Baud rate 1200
            STAA    BAUD,X
            LDAA    #$00
            STAA    SCCR1,X                 ; Set 8bit data,1 Stop bit
            LDAA    #$0C                    ; Enable RXD,TXD pin
            STAA    SCCR2,X
            RTS

;/********************************/;
;/* Transmit ASCII 1byte to SCI  */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : ASCII to SCI Port */;
;/* Register : ACCA,ACCB         */;
;/********************************/;
;
TX_SCI      PSHB
TX_SCI1     BRCLR   SCSR,X $80 TX_SCI1      ; Wait TDRE=1 (Buffer Empty)
            LDAB    SCSR,X                  ; Read For Clear Status
            STAA    SCDR,X                  ; Send character to SCI
TX_SCI2     BRCLR   SCSR,X $40 TX_SCI2      ; Wait  TC=1 (Send Complete)
            PULB
            RTS

;/*************************/;
;/* Receive data from SCI */;
;/* INPUT  : SCI Port     */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RX_SCI      BRCLR   SCSR,X $20 RX_SCI       ; Wait RDRF=1 (Receive Ready)
            LDAA    SCSR,X
            ANDA    #$0E
            BNE     RX_SCI1                 ; Rx Fail
            LDAA    SCDR,X                  ; Rx OK = Read data
            BRA     RX_SCI2
RX_SCI1     LDAA    SCDR,X
            CLRA                            ; Rx Fail Clear Data
RX_SCI2     RTS

;/*******************************/;
;/*  Print Out Data to SCI Port */;
;/*  Usage    : JSR   PRINT_SCI */;
;/*           : FCC   'xxxxxxx' */;
;/*           : FCB   $00       */;
;/*  Register : ACCA            */;
;/*  Call Sub : TX_SCI          */;
;/*  Note     : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRINT_SCI   PULY                            ; Pop Stack (PC Value)
            PSHA
            PSHB
PRN_SCI1    LDAA    0,Y                     ; Get Data For Print
            CMPA    #$00                    ; Check Last Byte
            BNE     PRN_SCI2                ; Jump if not Last Byte
            BRA     PRN_SCI3
PRN_SCI2    JSR     TX_SCI                  ; Send Data
            INY
            BRA     PRN_SCI1
PRN_SCI3    INY                             ; Point to Next Instruction
            PULB
            PULA
            PSHY                            ; Push Stack (PC Value)
            RTS

            ORG     $FFFE                   ; Reset Vector
            FDB     START

            END









