;/**********************************/;
;/* Demo Program Test Graphics LCD */;
;/* Hardware : ET-CP68HC11 Ver 2.0 */;
;/* Complier : AS11NEW.EXE (V1.03) */;
;/**********************************/;
;
;/* Address Port of Character LCD
WRC_COMM    EQU     $1400                   ; Char Write Instruction LCD
RDC_COMM    EQU     $1401                   ; Char Read Address & Busy Flag
WRC_DATA    EQU     $1402                   ; Char Write Data Port LCD
RDC_DATA    EQU     $1403                   ; Char Read Data From DD-RAM
;
;/* Address Port of Graphic LCD Page1
WRG_COMM1   EQU     $1408                   ; Graphic Write Instruction Page1
RDG_COMM1   EQU     $1409                   ; Graphic Reda Busy flag & Address Page1
WRG_DATA1   EQU     $140A                   ; Graphic Write Data Page1
RDG_DATA1   EQU     $140B                   ; Graphic Read Data Page1
;
;/* Address Port of Graphic LCD Page2
WRG_COMM2   EQU     $1404                   ; Graphic Write Instruction Page2
RDG_COMM2   EQU     $1405                   ; Graphic Reda Busy flag & Address Page2
WRG_DATA2   EQU     $1406                   ; Graphic Write Data Page2
RDG_DATA2   EQU     $1407                   ; Graphic Read Data Page2

            ORG     $0000
X_ADDR1     RMB     1       ; Buffer X-Address Page1
X_ADDR2     RMB     1       ; Buffer X-Address Page2
Y_ADDR1     RMB     1       ; Buffer Y-Address Page1
Y_ADDR2     RMB     1       ; Buffer Y-Address Page2
LINE_CNT    RMB     1       ; Buffer Line Count (X)

            ORG     $A000                   ; Start at Rom Monitor
START       LDS     #$9FFF                  ; Stack on RAM 32KB
            LDX     #$FFFF
PWR_DLY     DEX
            BNE     PWR_DLY
            LDX     #$1000                  ; Base Register
NEW_DISP    JSR     INITGLCD                ; Initial Graphic LCD
            LDAA    #8
            STAA    LINE_CNT                ; Counter Line
            LDX     #TAB_FONT               ; Table Font Thai & English
            ;
NEW_FONT    JSR     SET_X1                  ; Set X_Address Page1
            JSR     SET_Y1                  ; Set Y_Address Page1
            LDAB    #64                     ; Counter Y Position Page1
WR_FONT1    JSR     BUSY_LCD1
            LDAA    0,X
            STAA    WRG_DATA1
            INX
            DECB
            BNE     WR_FONT1
            ;
            JSR     SET_X2                  ; Set X_Address Page2
            JSR     SET_Y2                  ; Set Y_Address Page2
            LDAB    #64                     ; Counter Y Position Page2
WR_FONT2    JSR     BUSY_LCD2
            LDAA    0,X
            STAA    WRG_DATA2
            INX
            DECB
            BNE     WR_FONT2
            ;
            INC     X_ADDR1                 ; Next Line Page1
            INC     X_ADDR2                 ; Next Line Page2
            DEC     LINE_CNT
            BNE     NEW_FONT
            ;
            JSR     DELAY
            ;
            ;/* Change to Picture
            ;
            JSR     INITGLCD
            LDAA    #8
            STAA    LINE_CNT                ; Counter Line
            LDX     #LINE1                  ; Table Font Thai & English
            ;
NEW_GRAPH   JSR     SET_X1                  ; Set X_Address Page1
            JSR     SET_Y1                  ; Set Y_Address Page1
            LDAB    #64                     ; Counter Y Position Page1
WR_GRAPH1   JSR     BUSY_LCD1
            LDAA    0,X
            STAA    WRG_DATA1
            INX
            DECB
            BNE     WR_GRAPH1
            ;
            JSR     SET_X2                  ; Set X_Address Page2
            JSR     SET_Y2                  ; Set Y_Address Page2
            LDAB    #64                     ; Counter Y Position Page2
WR_GRAPH2   JSR     BUSY_LCD2
            LDAA    0,X
            STAA    WRG_DATA2
            INX
            DECB
            BNE     WR_GRAPH2
            ;
            INC     X_ADDR1                 ; Next Line Page1
            INC     X_ADDR2                 ; Next Line Page2
            DEC     LINE_CNT
            BNE     NEW_GRAPH
            ;
            JSR     DELAY
            JMP     NEW_DISP

;/*******************/;
;/* Delay Time Sub. */;
;/*******************/;
;
DELAY       PSHX
            PSHB
            ;
            LDAB    #20
DLY0        LDX     #$FFFF
DLY1        DEX
            BNE     DLY1
            DECB
            BNE     DLY0
            ;
            PULB
            PULX
            RTS


;/***********************;/
;/* Initial Graphic LCD */;
;/***********************/;
;
INITGLCD    LDAA    #$3F                    ; Display on-off  X=1 ON,X=0 OFF
            JSR     BUSY_LCD1
            STAA    WRG_COMM1               ; Set Display ON Page1
            JSR     BUSY_LCD2
            STAA    WRG_COMM2               ; Set Display ON Page2
            LDAA    #$C0
            JSR     BUSY_LCD1
            STAA    WRG_COMM1               ; Display Strat Page1
            JSR     BUSY_LCD2
            STAA    WRG_COMM2               ; Display Start Page2
            CLRA
            STAA    X_ADDR1                 ; Start X-Address1 = 0
            STAA    X_ADDR2                 ; Start X-Address2 = 0
            STAA    Y_ADDR1                 ; Start Y-Address1 = 0
            STAA    Y_ADDR2                 ; Start Y-Address2 = 0
            RTS

*****************
* Set X-Address1
* Input : X_ADDR1
*       : (0..7)
*****************
SET_X1      PSHA
            JSR     BUSY_LCD1               ; Wait LCD busy
            LDAA    X_ADDR1
            ANDA    #$07
            ORAA    #$B8
            STAA    WRG_COMM1               ; Set X-Address Page1
            PULA
            RTS

*****************
* Set X-Address2
* Input : X_ADDR2
*       : (0..7)
*****************
SET_X2      PSHA
            JSR     BUSY_LCD2               ; Wait LCD busy
            LDAA    X_ADDR2
            ANDA    #$07
            ORAA    #$B8
            STAA    WRG_COMM2               ; Set X-Address Page2
            PULA
            RTS

*****************
* Set Y-Address1
* Input : Y_ADDR1
*       : (0..63)
*****************
SET_Y1      PSHA
            JSR     BUSY_LCD1               ; Wait LCD busy
            LDAA    Y_ADDR1
            ANDA    #63
            ORAA    #$40
            STAA    WRG_COMM1               ; Set Y-Address Page1
            PULA
            RTS

*****************
* Set Y-Address2
* Input : Y_ADDR2
*       : (0..63)
*****************
SET_Y2      PSHA
            JSR     BUSY_LCD2               ; Wait LCD busy
            LDAA    Y_ADDR2
            ANDA    #63
            ORAA    #$40
            STAA    WRG_COMM2               ; Set Y-Address Page2
            PULA
            RTS

**********************
* Read Busy Flag LCD1
**********************
BUSY_LCD1   PSHA
BUSY1       LDAA    RDG_COMM1
            ANDA    #$80
            BNE     BUSY1                   ; Check Busy Flag
            PULA
            RTS

**********************
* Read Busy Flag LCD2
**********************
BUSY_LCD2   PSHA
BUSY2       LDAA    RDG_COMM2
            ANDA    #$80
            BNE     BUSY2                   ; Check Busy Flag
            PULA
            RTS

TAB_FONT    EQU *

***************************
* English Characters Fonts
***************************
BLANK       FCB $00,$00,$00,$00     ; BLANK
            FCB $00,$00,$00,$00
TOKJAI      FCB $00,$00,$0E,$BF     ; !
            FCB $0E,$00,$00,$00
KUMPUD      FCB $00,$00,$07,$00     ; "
            FCB $07,$00,$00,$00
NUMBER      FCB $00,$24,$FF,$24     ; #
            FCB $24,$FF,$24,$00
DOLLAR      FCB $08,$54,$54,$FE     ; $
            FCB $54,$54,$20,$00
PERCENT     FCB $86,$46,$20,$10     ; %
            FCB $08,$C4,$C2,$00
AMPER       FCB $60,$94,$8E,$9A     ; &
            FCB $6E,$44,$B0,$80
APOS        FCB $00,$00,$00,$05     ; '
            FCB $03,$00,$00,$00
WOPEN       FCB $00,$00,$3C,$42     ; (
            FCB $81,$00,$00,$00
WCLOSE      FCB $00,$00,$00,$81     ; )
            FCB $42,$3C,$00,$00
STAR        FCB $00,$08,$2A,$1C     ; *
            FCB $1C,$2A,$08,$00
PLUS        FCB $00,$08,$08,$3E     ; +
            FCB $3E,$08,$08,$00
COMMA       FCB $00,$00,$00,$A0     ; ,
            FCB $60,$00,$00,$00
MINUS       FCB $00,$08,$08,$08     ; -
            FCB $08,$08,$08,$00
STOP        FCB $00,$00,$00,$C0     ; .
            FCB $C0,$00,$00,$00
SLASH       FCB $00,$C0,$30,$18     ; /
            FCB $0C,$03,$00,$00
ZERO        FCB $00,$7C,$A2,$B2     ; 0
            FCB $9A,$8A,$7C,$00
ONE         FCB $00,$00,$82,$FF     ; 1
            FCB $80,$00,$00,$00
TWO         FCB $00,$86,$C1,$A1     ; 2
            FCB $91,$89,$86,$00
THREE       FCB $00,$42,$81,$89     ; 3
            FCB $89,$89,$76,$00
FOUR        FCB $60,$50,$48,$44     ; 4
            FCB $42,$FF,$40,$00
FIVE        FCB $5F,$85,$85,$85     ; 5
            FCB $85,$49,$30,$00
SIX         FCB $00,$7C,$92,$89     ; 6
            FCB $89,$89,$70,$00
SEVEN       FCB $00,$03,$01,$C1     ; 7
            FCB $31,$0D,$03,$00
EIGHT       FCB $00,$76,$89,$89     ; 8
            FCB $89,$89,$76,$00
NINE        FCB $00,$0E,$91,$91     ; 9
            FCB $91,$49,$3E,$00
COLON       FCB $00,$00,$00,$66     ; :
            FCB $66,$00,$00,$00
SEMI        FCB $00,$00,$80,$76     ; ;
            FCB $36,$00,$00,$00
LESS        FCB $00,$00,$18,$24     ; <
            FCB $42,$81,$00,$00
EQUAL       FCB $00,$24,$24,$24     ; =
            FCB $24,$24,$00,$00
MORE        FCB $00,$00,$81,$42     ; >
            FCB $24,$18,$00,$00
QUES        FCB $00,$06,$09,$0D     ; ?
            FCB $B5,$09,$06,$00
ATAB        FCB $F8,$14,$12,$11     ; A
            FCB $12,$14,$F8,$00
BTAB        FCB $81,$FF,$89,$89     ; B
            FCB $89,$89,$76,$00
CTAB        FCB $00,$3C,$42,$81     ; C
            FCB $81,$81,$42,$00
DTAB        FCB $81,$FF,$81,$81     ; D
            FCB $81,$42,$3C,$00
ETAB        FCB $81,$FF,$89,$89     ; E
            FCB $9D,$81,$E3,$00
FTAB        FCB $81,$FF,$89,$09     ; F
            FCB $1D,$01,$03,$00
GTAB        FCB $00,$7E,$81,$81     ; G
            FCB $91,$51,$F6,$00
HTAB        FCB $00,$FF,$08,$08     ; H
            FCB $08,$08,$FF,$00
ITAB        FCB $00,$00,$81,$FF     ; I
            FCB $81,$00,$00,$00
JTAB        FCB $00,$40,$80,$80     ; J
            FCB $81,$7F,$01,$00
KTAB        FCB $81,$FF,$89,$14     ; K
            FCB $22,$C1,$81,$80
LTAB        FCB $00,$81,$FF,$81     ; L
            FCB $80,$80,$C0,$00
MTAB        FCB $FF,$02,$04,$18     ; M
            FCB $04,$02,$FF,$00
NTAB        FCB $81,$FF,$83,$0C     ; N
            FCB $18,$61,$FF,$01
OTAB        FCB $00,$7E,$81,$81     ; O
            FCB $81,$81,$7E,$00
PTAB        FCB $00,$81,$FE,$91     ; P
            FCB $11,$11,$0E,$00
QTAB        FCB $00,$7E,$81,$91     ; Q
            FCB $A1,$C1,$7F,$80
RTAB        FCB $81,$FF,$89,$19     ; R
            FCB $29,$C9,$86,$80
STAB        FCB $00,$E6,$49,$89     ; S
            FCB $91,$92,$67,$00
TTAB        FCB $03,$01,$81,$FF     ; T
            FCB $81,$01,$03,$00
UTAB        FCB $01,$7F,$81,$80     ; U
            FCB $80,$81,$7F,$01
VTAB        FCB $07,$18,$60,$80     ; V
            FCB $60,$18,$0F,$00
WTAB        FCB $3F,$C0,$20,$10     ; W
            FCB $20,$C0,$3F,$00
XTAB        FCB $C3,$27,$18,$18     ; X
            FCB $18,$27,$C3,$00
YTAB        FCB $01,$03,$84,$F8     ; Y
            FCB $84,$03,$01,$00
ZTAB        FCB $C3,$A1,$91,$89     ; Z
            FCB $85,$83,$C1,$00


*************************
* Thai Characters Fonts
*************************
KAI         FCB $00,$FA,$05,$01
            FCB $01,$01,$FE,$00
KHAI        FCB $00,$02,$05,$FE
            FCB $80,$7F,$00,$00
BUFFALO     FCB $FE,$21,$11,$29
            FCB $11,$01,$FE,$00
RAKANG      FCB $62,$95,$F2,$29
            FCB $46,$80,$FF,$00
NGU         FCB $00,$10,$20,$42
            FCB $85,$FE,$00,$00
JAN         FCB $02,$01,$09,$15
            FCB $79,$81,$FE,$00
CHING       FCB $12,$E9,$B1,$41
            FCB $21,$FE,$A0,$40
CHANG       FCB $04,$F2,$8A,$86
            FCB $84,$FA,$01,$01
SOO         FCB $02,$05,$02,$FD
            FCB $82,$7D,$00,$00
CHER        FCB $7A,$A5,$41,$41
            FCB $A1,$7E,$40,$FF
YING        FCB $7A,$A5,$41,$01
            FCB $FE,$80,$80,$FF
YINGLOW     FCB $00,$00,$00,$00
            FCB $06,$06,$04,$02
CHADA       FCB $42,$A5,$79,$01
            FCB $01,$01,$FE,$80
CHADALOW    FCB $00,$00,$02,$05
            FCB $02,$05,$07,$00
PATAK       FCB $42,$A5,$79,$01
            FCB $81,$01,$FE,$00
PATAKLOW    FCB $02,$05,$02,$05
            FCB $02,$04,$07,$00
TORTAN      FCB $00,$02,$15,$2D
            FCB $F5,$85,$7A,$01
TORTANLOW   FCB $10,$28,$10,$28
            FCB $14,$2A,$1E,$00
MONTO       FCB $02,$E5,$12,$09
            FCB $06,$02,$FF,$00
TORTHOA     FCB $FE,$11,$2A,$52
            FCB $A2,$7E,$40,$BF
NANE        FCB $7A,$A5,$41,$FE
            FCB $40,$FF,$A0,$40
DEK         FCB $FE,$81,$49,$35
            FCB $19,$01,$FE,$00
TORTOA      FCB $FE,$81,$49,$36
            FCB $19,$01,$FE,$00
TUNG        FCB $7A,$A5,$41,$01
            FCB $01,$01,$FE,$00
TAHAN       FCB $02,$F5,$0E,$04
            FCB $02,$01,$FE,$00
TONG        FCB $00,$02,$05,$FD
            FCB $85,$85,$FA,$01
HNOO        FCB $02,$F5,$8E,$40
            FCB $20,$FF,$A0,$40
BAIMAI      FCB $02,$85,$FE,$80
            FCB $80,$80,$FF,$00
PLARHIGH    FCB $00,$00,$00,$00
            FCB $00,$00,$F0,$00
PLAR        FCB $02,$05,$FE,$80
            FCB $80,$80,$FF,$00
PUNG        FCB $00,$7E,$85,$42
            FCB $40,$80,$7E,$00
PHAHIGH     FCB $00,$00,$00,$00
            FCB $00,$00,$F0,$00
PHA         FCB $00,$7E,$85,$42
            FCB $40,$80,$7F,$00
PAN         FCB $02,$05,$FE,$40
            FCB $30,$40,$FF,$00
FUNHIGH     FCB $00,$00,$00,$00
            FCB $00,$00,$F0,$00
FUN         FCB $02,$05,$FE,$40
            FCB $30,$40,$FF,$00
POA         FCB $42,$A5,$79,$01
            FCB $01,$01,$FE,$00
MAR         FCB $42,$A5,$FE,$20
            FCB $20,$40,$FF,$00
YAK         FCB $00,$6E,$95,$92
            FCB $80,$80,$FF,$00
SHIP        FCB $00,$02,$05,$05
            FCB $45,$A5,$7A,$01
LU          FCB $00,$7A,$A5,$41
            FCB $01,$01,$FE,$00
LULOW       FCB $00,$00,$00,$00
            FCB $00,$00,$0F,$00
LING        FCB $02,$71,$A9,$45
            FCB $09,$11,$FE,$00
WAN         FCB $00,$02,$01,$01
            FCB $41,$A1,$7E,$00
SALAHIGH    FCB $00,$00,$00,$00
            FCB $00,$80,$50,$20
SALA        FCB $7E,$81,$79,$15
            FCB $09,$01,$FE,$00
RUSI        FCB $02,$85,$FE,$80
            FCB $98,$90,$FF,$10
TIGERHIGH   FCB $00,$00,$00,$00
            FCB $00,$80,$50,$20
TIGER       FCB $02,$71,$A9,$45
            FCB $09,$11,$FE,$00
HEEP        FCB $02,$FD,$26,$10
            FCB $0A,$0D,$FA,$00
JURAHIGH    FCB $00,$00,$00,$00
            FCB $40,$A0,$C0,$20
JURA        FCB $02,$F5,$4E,$20
            FCB $20,$40,$FF,$00
ANG         FCB $00,$72,$A9,$91
            FCB $81,$81,$7E,$00
HOOKHIGH    FCB $00,$00,$00,$00
            FCB $00,$00,$A0,$40
HOOK        FCB $00,$72,$AD,$95
            FCB $83,$81,$7E,$00
SARAA       FCB $00,$66,$55,$AA
            FCB $88,$44,$22,$00
TOAKUB      FCB $00,$14,$14,$14
            FCB $14,$14,$00,$00
SARAAR      FCB $00,$02,$01,$01
            FCB $01,$01,$FE,$00
SARAUMHIGH  FCB $20,$50,$50,$20
            FCB $00,$00,$00,$00
SARAUM      FCB $00,$02,$01,$01
            FCB $01,$01,$FE,$00
SARAAA      FCB $00,$7F,$A0,$40
            FCB $00,$00,$00,$00
SARAAIR     FCB $00,$7F,$A0,$40
            FCB $7F,$A0,$40,$00
SARAOHIGH   FCB $10,$28,$E8,$08
            FCB $08,$08,$00,$00
SARAO       FCB $00,$00,$FF,$C0
            FCB $00,$00,$00,$00
MAIMOONHIGH FCB $38,$34,$04,$FC
            FCB $00,$00,$00,$00
MAIMOON     FCB $00,$00,$00,$FF
            FCB $C0,$00,$00,$00
MALAIHIGH   FCB $08,$10,$20,$10
            FCB $F8,$00,$00,$00
MALAI       FCB $00,$00,$00,$00
            FCB $FF,$C0,$00,$00
YAMOK       FCB $00,$F0,$D0,$20
            FCB $10,$10,$F0,$00
YAMOKLOW    FCB $00,$00,$18,$04
            FCB $02,$02,$01,$00
PAIYAN      FCB $08,$14,$10,$10
            FCB $08,$04,$FE,$00
SARAUH      FCB $00,$00,$00,$00
            FCB $04,$0A,$3C,$00
SARAUU      FCB $00,$00,$00,$04
            FCB $0A,$3C,$20,$3E
SARAI       FCB $00,$30,$48,$48
            FCB $48,$50,$60,$00
SARAE       FCB $30,$28,$28,$28
            FCB $38,$3C,$00,$00
SARAAU      FCB $00,$03,$48,$48
            FCB $48,$50,$68,$30
SARAAUE     FCB $00,$30,$48,$48
            FCB $50,$58,$60,$78
HUN         FCB $00,$30,$68,$50
            FCB $40,$40,$20,$10
NAMFON      FCB $00,$18,$24,$24
            FCB $14,$08,$00,$00
TAIKU       FCB $70,$48,$28,$28
            FCB $48,$68,$64,$00
MAIAKE      FCB $00,$00,$00,$00
            FCB $00,$70,$00,$00
MAITO       FCB $00,$40,$68,$58
            FCB $40,$40,$20,$10
MAITEE      FCB $78,$48,$10,$18
            FCB $08,$78,$20,$1E
JATAWA      FCB $00,$00,$10,$10
            FCB $7C,$10,$10,$00
KARAN       FCB $00,$70,$50,$10
            FCB $10,$0C,$00,$00
AKEUM       FCB $00,$30,$48,$48
            FCB $48,$30,$06,$00
TOUM        FCB $02,$36,$4C,$4C
            FCB $4A,$31,$00,$00
TEEUM       FCB $06,$35,$4A,$49
            FCB $4E,$34,$02,$01
TAWAUM      FCB $00,$30,$48,$4A
            FCB $4A,$37,$02,$02
AKEHAN      FCB $70,$50,$70,$40
            FCB $40,$4C,$20,$10
TOHAN       FCB $70,$52,$76,$44
            FCB $44,$44,$22,$11
TEEHAN      FCB $70,$57,$75,$42
            FCB $41,$47,$24,$17
TAWAHAN     FCB $70,$50,$74,$44
            FCB $4E,$44,$20,$10
AKEI        FCB $00,$60,$50,$50
            FCB $50,$50,$66,$00
TOI         FCB $00,$60,$52,$56
            FCB $54,$54,$62,$01
TEEI        FCB $00,$6E,$5A,$54
            FCB $52,$5E,$68,$07
TAWAI       FCB $00,$60,$50,$52
            FCB $52,$57,$62,$02
KARANI      FCB $00,$60,$50,$50
            FCB $50,$5C,$6A,$01
AKEE        FCB $60,$50,$50,$50
            FCB $50,$50,$7B,$00
TOE         FCB $60,$52,$56,$54
            FCB $54,$52,$79,$00
TEEE        FCB $6E,$5A,$54,$52
            FCB $5E,$54,$7A,$01
TAWAE       FCB $60,$50,$52,$52
            FCB $57,$52,$7A,$00


;/*******************/;
;/* Graphic Picture */;
;/*******************/;
;
LINE1       FCB     $FF,$FF,$07,$0B,$F3,$13,$13,$13
            FCB     $13,$13,$13,$13,$13,$13,$13,$13
            FCB     $13,$13,$13,$13,$13,$13,$13,$13
            FCB     $13,$13,$13,$13,$13,$13,$13,$13
            FCB     $13,$13,$13,$13,$13,$13,$13,$13
            FCB     $13,$13,$13,$13,$13,$13,$13,$13
            FCB     $13,$13,$13,$13,$13,$13,$13,$13
            FCB     $13,$13,$13,$13,$13,$13,$13,$13
            FCB     $13,$13,$13,$13,$13,$13,$13,$13
            FCB     $13,$13,$13,$13,$13,$13,$13,$13
            FCB     $13,$13,$13,$13,$13,$13,$13,$13
            FCB     $13,$13,$13,$F3,$0B,$07,$FF,$FF
            FCB     $03,$03,$03,$03,$03,$03,$03,$03
            FCB     $03,$03,$43,$83,$03,$03,$03,$E3
            FCB     $03,$03,$83,$43,$03,$03,$03,$03
            FCB     $03,$03,$03,$03,$03,$03,$FF,$FF
LINE2       FCB     $FF,$FF,$00,$00,$FF,$00,$00,$00
            FCB     $00,$80,$60,$18,$04,$02,$01,$01
            FCB     $01,$02,$04,$18,$60,$80,$00,$00
            FCB     $00,$00,$00,$00,$00,$80,$60,$18
            FCB     $04,$02,$01,$01,$01,$02,$04,$18
            FCB     $60,$80,$00,$00,$00,$00,$00,$00
            FCB     $00,$80,$60,$18,$04,$02,$01,$01
            FCB     $01,$02,$04,$18,$60,$80,$00,$00
            FCB     $00,$00,$00,$00,$00,$80,$60,$18
            FCB     $04,$02,$01,$01,$01,$02,$04,$18
            FCB     $60,$80,$00,$00,$00,$00,$00,$00
            FCB     $00,$80,$60,$FF,$00,$00,$FF,$FF
            FCB     $00,$00,$00,$00,$00,$44,$48,$71
            FCB     $1A,$0C,$04,$02,$02,$E1,$11,$51
            FCB     $11,$E2,$02,$04,$0C,$1A,$71,$48
            FCB     $44,$00,$00,$00,$00,$00,$FF,$FF
LINE3       FCB     $FF,$FF,$00,$00,$FF,$08,$08,$04
            FCB     $02,$01,$80,$00,$00,$00,$00,$00
            FCB     $00,$00,$00,$00,$80,$01,$02,$04
            FCB     $08,$08,$08,$04,$02,$01,$80,$00
            FCB     $00,$00,$00,$00,$00,$00,$00,$00
            FCB     $80,$01,$02,$04,$08,$08,$08,$04
            FCB     $02,$01,$80,$00,$00,$00,$00,$00
            FCB     $00,$00,$00,$00,$80,$01,$02,$04
            FCB     $08,$08,$08,$04,$02,$01,$80,$00
            FCB     $00,$00,$00,$00,$00,$00,$00,$00
            FCB     $80,$01,$02,$04,$08,$08,$08,$04
            FCB     $02,$01,$80,$FF,$00,$00,$FF,$FF
            FCB     $00,$00,$00,$00,$00,$00,$00,$40
            FCB     $80,$00,$10,$A0,$80,$40,$41,$79
            FCB     $41,$80,$A0,$10,$00,$80,$40,$00
            FCB     $00,$00,$00,$00,$00,$00,$FF,$FF
LINE4       FCB     $FF,$FF,$00,$00,$FF,$01,$01,$01
            FCB     $01,$01,$E3,$21,$21,$21,$21,$21
            FCB     $21,$21,$21,$21,$E3,$01,$01,$01
            FCB     $01,$01,$01,$01,$01,$01,$E3,$21
            FCB     $21,$21,$21,$21,$21,$21,$21,$21
            FCB     $E3,$01,$01,$01,$01,$01,$01,$01
            FCB     $01,$01,$E3,$21,$21,$21,$21,$21
            FCB     $21,$21,$21,$21,$E3,$01,$01,$01
            FCB     $01,$01,$01,$01,$01,$01,$E3,$21
            FCB     $21,$21,$21,$21,$21,$21,$21,$21
            FCB     $E3,$01,$01,$01,$01,$01,$01,$01
            FCB     $01,$01,$E3,$FF,$00,$00,$FF,$FF
            FCB     $00,$00,$00,$00,$00,$11,$12,$1C
            FCB     $06,$03,$01,$00,$00,$38,$44,$54
            FCB     $44,$38,$00,$01,$03,$06,$1C,$12
            FCB     $11,$00,$00,$00,$00,$00,$FF,$FF
LINE5       FCB     $FF,$FF,$00,$00,$FF,$08,$08,$08
            FCB     $08,$08,$0F,$00,$00,$00,$00,$00
            FCB     $00,$00,$00,$00,$0F,$08,$08,$08
            FCB     $08,$08,$08,$08,$08,$08,$0F,$00
            FCB     $00,$00,$00,$00,$00,$00,$00,$00
            FCB     $0F,$08,$08,$08,$08,$08,$08,$08
            FCB     $08,$08,$0F,$00,$00,$00,$00,$00
            FCB     $00,$00,$00,$00,$0F,$08,$08,$08
            FCB     $08,$08,$08,$08,$08,$08,$0F,$00
            FCB     $00,$00,$00,$00,$00,$00,$00,$00
            FCB     $0F,$08,$08,$08,$08,$08,$08,$08
            FCB     $08,$08,$0F,$FF,$00,$00,$FF,$FF
            FCB     $00,$00,$00,$00,$00,$70,$88,$A8
            FCB     $88,$70,$00,$00,$00,$00,$00,$00
            FCB     $00,$00,$00,$00,$70,$88,$A8,$88
            FCB     $70,$00,$00,$00,$00,$00,$FF,$FF
LINE6       FCB     $FF,$FF,$38,$34,$33,$32,$32,$32
            FCB     $32,$32,$32,$32,$32,$32,$32,$32
            FCB     $32,$32,$32,$32,$32,$32,$32,$32
            FCB     $32,$32,$32,$32,$32,$32,$32,$32
            FCB     $32,$32,$32,$32,$32,$32,$32,$32
            FCB     $32,$32,$32,$32,$32,$32,$32,$32
            FCB     $32,$32,$32,$32,$32,$32,$32,$32
            FCB     $32,$32,$32,$32,$32,$32,$32,$32
            FCB     $32,$32,$32,$32,$32,$32,$32,$32
            FCB     $32,$32,$32,$32,$32,$32,$32,$32
            FCB     $32,$32,$32,$32,$32,$32,$32,$F2
            FCB     $F2,$32,$32,$33,$34,$38,$3F,$3F
            FCB     $30,$30,$30,$30,$30,$30,$30,$30
            FCB     $30,$30,$30,$30,$30,$30,$30,$30
            FCB     $30,$30,$30,$30,$30,$30,$30,$30
            FCB     $30,$30,$30,$30,$30,$30,$FF,$FF
LINE7       FCB     $FF,$FF,$00,$00,$00,$00,$00,$40
            FCB     $20,$20,$20,$C0,$00,$40,$20,$20
            FCB     $20,$C0,$00,$40,$20,$A0,$30,$2A
            FCB     $C6,$00,$48,$AC,$4A,$22,$C4,$48
            FCB     $A0,$14,$0C,$40,$20,$A0,$20,$24
            FCB     $C6,$06,$0A,$F2,$02,$04,$44,$24
            FCB     $A0,$20,$20,$C0,$00,$40,$20,$A0
            FCB     $30,$2A,$C6,$00,$04,$06,$06,$0A
            FCB     $F2,$02,$04,$C4,$24,$A0,$A0,$20
            FCB     $C0,$00,$00,$40,$20,$C0,$00,$00
            FCB     $FC,$00,$00,$00,$00,$00,$00,$FF
            FCB     $FF,$00,$00,$00,$00,$00,$00,$E0
            FCB     $10,$C8,$E8,$E8,$C8,$10,$E0,$00
            FCB     $00,$00,$00,$00,$00,$00,$00,$00
            FCB     $E0,$10,$C8,$E8,$E8,$C8,$10,$E0
            FCB     $00,$00,$00,$00,$00,$00,$FF,$FF
LINE8       FCB     $FF,$FF,$C0,$C0,$C0,$C0,$C0,$C3
            FCB     $C5,$C4,$C4,$C3,$C0,$C3,$C5,$C4
            FCB     $C4,$C3,$C0,$C0,$C3,$C4,$C1,$C2
            FCB     $C7,$C0,$C0,$C0,$C0,$C3,$C4,$C4
            FCB     $C3,$C0,$C0,$C0,$C3,$C4,$C1,$C2
            FCB     $C7,$C0,$C0,$C3,$C4,$C0,$C0,$C3
            FCB     $C4,$C1,$C2,$C7,$C0,$C0,$C3,$C4
            FCB     $C1,$C2,$C7,$C0,$C0,$C0,$C0,$C0
            FCB     $C3,$C4,$C0,$C7,$C1,$C0,$C0,$C0
            FCB     $C7,$C0,$C0,$C2,$C5,$C4,$C4,$C4
            FCB     $C3,$C0,$C0,$C0,$C0,$C0,$C0,$FF
            FCB     $FF,$C0,$C0,$C0,$C0,$C0,$C0,$C1
            FCB     $C2,$C4,$C5,$C5,$C4,$C2,$C1,$C0
            FCB     $C0,$C0,$C0,$C0,$C0,$C0,$C0,$C0
            FCB     $C1,$C2,$C4,$C5,$C5,$C4,$C2,$C1
            FCB     $C0,$C0,$C0,$C0,$C0,$C0,$FF,$FF
            ;
            ORG     $FFFE
            FDB     START

            END

