;/**********************************/;
;/* Demo Program For Character LCD */;
;/* Hardware : ET-CP68HC11 Ver 2.0 */;
;/* Complier : AS11NEW.EXE (V1.03) */;
;/**********************************/;
;
;/* Address Port of Character LCD
WRC_COMM    EQU     $1400                   ; Write Instruction LCD
RDC_COMM    EQU     $1401                   ; Read Address & Busy Flag
WRC_DATA    EQU     $1402                   ; Write Data Port LCD
RDC_DATA    EQU     $1403                   ; Read Data From DD-RAM

            ORG     $00H
            ;
DSP_INDX    RMB     1                       ; Display Pointer Index
DSP_CNT     RMB     1                       ; Display Font Count
LCD_BUFF    RMB     32                      ; LCD Display Buffer 16X2

            ORG     $A000                   ; Start at Rom Monitor
            ;
START       LDS     #$9FFF                  ; Stack on RAM 32KB
            LDX     #$1000                  ; Base Register Index
            JSR     INIT_LCD                ; Initial LCD 16x2
            ;
            LDAA    #$01                    ; Clear display
            STAA    WRC_COMM
            ;
;/************************/;
;/* Display Logo Sign-on */;
;/************************/;
;
DSP_MAIN    LDAA    #1
            STAA    DSP_INDX
            LDAA    #20
            STAA    DSP_CNT
            ;
LFT_RGT1    JSR     SHL1_DSP
            JSR     WR_LCD16X2
            LDX     #$FFFF
DSP_DLY0    DEX
            BNE     DSP_DLY0
            DEC     DSP_CNT
            BNE     LFT_RGT1
            ;
            PSHB
            LDAB    #10
DSP_DL1     LDX     #$FFFF
DSP_DL2     DEX
            BNE     DSP_DL2
            DECB
            BNE     DSP_DL1
            PULB
            ;
            LDAA    #20
            STAA    DSP_CNT
            ;
RGT_LFT1    JSR     SHR1_DSP
            JSR     WR_LCD16X2
            LDX     #$FFFF
DSP_DLY3    DEX
            BNE     DSP_DLY3
            DEC     DSP_CNT
            BNE     RGT_LFT1
            ;
            PSHB
            LDAB    #10
DSP_DL4     LDX     #$FFFF
DSP_DL5     DEX
            BNE     DSP_DL5
            DECB
            BNE     DSP_DL4
            PULB
            ;
            BRA     DSP_MAIN

;/**********************/;
;/* Table Logo Display */;
;/**********************/;
;
TAB_ETT1    FCC     'Example LCD 16x2'
            FCC     '   '
            FCC     'Demo Program LCD'
            FCC     '                '
            FCB     $20,$20
            ;
TAB_ETT2    FCC     '                '
            FCC     'By...ETT CO.,LTD'
            FCC     '   '
            FCC     'CP-68HC11 Ver2.0'
            FCB     $20,$20

TAB_ETT3    FCC     'Example LCD 16x2'
            FCC     '   '
            FCC     'Demo Program LCD'
            FCC     'Example LCD 16x2'

TAB_ETT4    FCC     'CP-68HC11 Ver2.0'
            FCC     'By...ETT CO.,LTD'
            FCC     '   '
            FCC     'CP-68HC11 Ver2.0'

;/**********************/;
;/* Shift Left Display */;
;/**********************/;
;
SHL1_DSP    LDX     #TAB_ETT1-1
            LDY     #LCD_BUFF+0
            LDAB    DSP_INDX
            ABX
            LDAB    #16
SHL_DSP1    LDAA    0,X
            STAA    0,Y
            INX
            INY
            DECB
            BNE     SHL_DSP1
            ;
SHL_DSP2    LDX     #TAB_ETT2+51
            LDY     #LCD_BUFF+31
            LDAB    DSP_INDX
SHL_DSP3    DEX
            DECB
            BNE     SHL_DSP3
            LDAB    #16
SHL_DSP4    LDAA    0,X
            STAA    0,Y
            DEX
            DEY
            DECB
            BNE     SHL_DSP4
            INC     DSP_INDX
            RTS

;/***********************/;
;/* Shift Right Display */;
;/***********************/;
;
SHR1_DSP    LDX     #TAB_ETT3+55
            LDY     #LCD_BUFF+15
            LDAB    DSP_INDX
SHR_DSP1    DEX
            DECB
            BNE     SHR_DSP1
            LDAB    #16
SHR_DSP2    LDAA    0,X
            STAA    0,Y
            DEX
            DEY
            DECB
            BNE     SHR_DSP2
            ;
SHR_DSP3    LDX     #TAB_ETT4-5
            LDY     #LCD_BUFF+16
            LDAB    DSP_INDX
            ABX
            LDAB    #16
SHR_DSP4    LDAA    0,X
            STAA    0,Y
            INX
            INY
            DECB
            BNE     SHR_DSP4
            INC     DSP_INDX
            RTS

;/*************************/;
;/* Initial Dotmatrix LCD */;
;/* 8-Bits Data Interface */;
;/*************************/;
;
INIT_LCD    PSHA
            JSR     BUSY_LCD                ; Wait LCD Ready
            LDAA    #$38                    ; Function Set DL=1,N=1,F=0
            STAA    WRC_COMM                ; 8Bit-Data,2-Line,5x7-Dots
            ;
            JSR     BUSY_LCD                ; Wait LCD Ready
            LDAA    #$0C                    ; Display on-off Control D=1,C=1,B=1
            STAA    WRC_COMM                ; Display on,Cursor off,Cursor not Blink
            ;
            JSR     BUSY_LCD                ; Wait LCD Ready
            LDAA    #$06                    ; Entry Mode Set I/D=1,S=0
            STAA    WRC_COMM                ; Increment Position,Display Shift Enable
            ;
            JSR     BUSY_LCD                ; Wait LCD Ready
            LDAA    #$01                    ; Clear display
            STAA    WRC_COMM
            PULA
            RTS

;/***********************/;
;/* Check Busy Flag LCD */;
;/***********************/;
;
BUSY_LCD    PSHA
WAITBUSY    LDAA    RDC_COMM                ; Read Busy Flag
            ANDA    #$80
            BNE     WAITBUSY                ; Repeat Until Busy
            PULA
            RTS

;/*********************/;
;/* Clear Display LCD */;
;/*********************/;
;
CLR_LCD     JSR     BUSY_LCD
            PSHA
            LDAA    #$01                    ; Clear Display Code
            STAA    WRC_COMM
            PULA
            RTS

;/*******************/;
;/* Return Home LCD */;
;/*******************/;
;
HOME_LCD    JSR     BUSY_LCD
            PSHA
            LDAA    #$02                    ; Return Home Code
            STAA    WRC_COMM
            PULA
            RTS

;/***************************/;
;/* Set Cursor LCD Location */;
;/* Input : A (Address LCD) */;
;/***************************/;
;
GOTO_LCD    JSR     BUSY_LCD
            PSHA
            ADDA    #$80                    ; Set DD-RAM Address
            STAA    WRC_COMM
            PULA
            RTS

;/*********************/;
;/* Wrire Byte to LCD */;
;/* Input : A (ASCII) */;
;/*********************/;
;
WR_LCD      JSR     BUSY_LCD
            STAA    WRC_DATA                ; Write Data to LCD
            RTS

;/*********************************/;
;/*  Print ASCII data to LCD Port */;
;/*  Usage    : JSR  PRINT_LCD    */;
;/*           : FCC  'xxxxxxxx'   */;
;/*           : FCB  $00          */;
;/*  Note     : last byte = $00   */;
;/*********************************/;
;
PRINT_LCD   PULY                            ; Pop Stack
            PSHA
            PSHB
PRN_LCD1    LDAA    0,Y                     ; Get Data For Print
            CMPA    #$00                    ; Check Last Byte
            BNE     PRN_LCD2                ; Jump if not Last Byte
            BRA     PRN_LCD3
PRN_LCD2    JSR     WR_LCD                  ; Write Data to LCD
            INY
            BRA     PRN_LCD1
PRN_LCD3    INY
            PULB
            PULA
            PSHY                            ; Push Stack
            RTS

;/**************************/;
;/* Wrire Data to LCD 16x2 */;
;/* Input : LCD_BUF(ASCII) */;
;/**************************/;
;
WR_LCD16X2  PSHX
            PSHA
            PSHB
            LDX     #LCD_BUFF               ; Display Buffer LCD
            LDAA    #$00                    ; 1st Location Line1
            JSR     GOTO_LCD
            LDAB    #16                     ; 16 Character Count
WR_LINE1    JSR     BUSY_LCD                ; Wait LCD Bysy
            LDAA    0,X
            STAA    WRC_DATA
            INX
            DECB
            BNE     WR_LINE1
            ;
            LDAA    #$40                    ; 1st Location Line2
            JSR     GOTO_LCD
            LDAB    #16                     ; 16 Character Count
WR_LINE2    JSR     BUSY_LCD                ; Wait LCD Bysy
            LDAA    0,X
            STAA    WRC_DATA
            INX
            DECB
            BNE     WR_LINE2
            PULB
            PULA
            PULX
            RTS

            ORG     $FFFE                   ; Reset Vector
            FDB     START

            END





