;/**********************************/;
;/* Demo Program For Test RTC6242  */;
;/*         Interrupt Mode         */;
;/* Hardware : ET-CP68HC11 Ver 2.0 */;
;/* Complier : AS11NEW.EXE (V1.03) */;
;/**********************************/;
;
BAUD        EQU     $2B                     ; SCI Baud rate control Reg.
SCCR1       EQU     $2C                     ; SCI Control Register1
SCCR2       EQU     $2D                     ; SCI Control Register2
SCSR        EQU     $2E                     ; SCI Status Register
SCDR        EQU     $2F                     ; SCI Data (RDR=Read,TDR=Write)
;/* Address Port of Character LCD
WRC_COMM    EQU     $1400                   ; Write Instruction LCD
RDC_COMM    EQU     $1401                   ; Read Address & Busy Flag
WRC_DATA    EQU     $1402                   ; Write Data Port LCD
RDC_DATA    EQU     $1403                   ; Read Data From DD-RAM
;
;/* Address Port of RTC6242
RTC_SEC1    EQU     $1600                   ; Second-1
RTC_SEC10   EQU     $1601                   ; Second-10
RTC_MIN1    EQU     $1602                   ; Minute-1
RTC_MIN10   EQU     $1603                   ; Minute-10
RTC_HR1     EQU     $1604                   ; Hour-1
RTC_HR10    EQU     $1605                   ; Hour-10
RTC_DAY1    EQU     $1606                   ; Day-1
RTC_DAY10   EQU     $1607                   ; Day-10
RTC_MONT1   EQU     $1608                   ; Month-1
RTC_MONT10  EQU     $1609                   ; Month-10
RTC_YEAR1   EQU     $160A                   ; Year-1
RTC_YEAR10  EQU     $160B                   ; Year-10
RTC_WEEK    EQU     $160C                   ; Day of Week
RTC_CTLD    EQU     $160D                   ; Control Register-D
RTC_CTLE    EQU     $160E                   ; Control Register-E
RTC_CTLF    EQU     $160F                   ; Control Register-F
;
;/* Interrupt Vector For Debugger 68HC11 V2.0 */;
IRQ_VEC     EQU     $20EE                   ; IRQ Vector

            ORG     $0000
RTC_FLAG    RMB     1                       ; Flag Buffer

            ORG     $2200                   ; Start of Debugger User Area
MAIN        LDAB    #$7E                    ; Jump-EXT Opcode
            STAB    IRQ_VEC                 ; 1st Byte Debugger Vector
            LDX     #IRQ_INT                ; Address Service Routine
            STX     IRQ_VEC+1               ; 2nd,3rd Byte Debugger Vector
            ;
            LDX     #$1000                  ; Base Register Index
            JSR     INIT_SCI                ; Initial SCI = 9600,N,8,1,P
            ;
            LDAA    #$01                    ; Set 12/24 Hr
            STAA    RTC_CTLF
            LDAA    #$04                    ; Set 24Hr
            STAA    RTC_CTLF
            LDAA    #$04                    ; Set STND Mode 1 Sec
            STAA    RTC_CTLE
            CLRA                            ; Set Hold Bit = 0
            STAA    RTC_CTLD
            ;
            JSR     TX_SCI                  ; Echo Choice
            JSR     PRINT_SCI
            FCB     $0D,$0A
            FCC     '** Test RTC6242 Interrupt **'
            FCB     $0D,$0A,$00
            CLI                             ; Enable Interrupt
            ;
LOOP_RTC    BRSET   RTC_FLAG $01 DSP_TIME   ; Wait RTC Interrupt
            BRA     LOOP_RTC
            ;
DSP_TIME    JSR     PRINT_SCI
            FCB     $0D
            FCC     'Get Time Now : '
            FCB     $00
            ;
            LDAA    RTC_HR1
            ANDA    #$0F
            LDAB    RTC_HR10
            ASLB
            ASLB
            ASLB
            ASLB
            ABA
            JSR     HEX_2ASC
            JSR     TX_SCI                  ; High Byte
            TBA
            JSR     TX_SCI                  ; Low Byte
            ;
            LDAA    #20H                    ; Space
            JSR     TX_SCI
            LDAA    #':'                    ; ":"
            JSR     TX_SCI
            LDAA    #20H                    ; Space
            JSR     TX_SCI
            ;
            LDAA    RTC_MIN1
            ANDA    #$0F
            LDAB    RTC_MIN10
            ASLB
            ASLB
            ASLB
            ASLB
            ABA
            JSR     HEX_2ASC
            JSR     TX_SCI                  ; High Byte
            TBA
            JSR     TX_SCI                  ; Low Byte
            ;
            LDAA    #20H                    ; Space
            JSR     TX_SCI
            LDAA    #':'                    ; ":"
            JSR     TX_SCI
            LDAA    #20H                    ; Space
            JSR     TX_SCI
            ;
            LDAA    RTC_SEC1
            ANDA    #$0F
            LDAB    RTC_SEC10
            ASLB
            ASLB
            ASLB
            ASLB
            ABA
            JSR     HEX_2ASC
            JSR     TX_SCI                  ; High Byte
            TBA
            JSR     TX_SCI                  ; Low Byte
            BCLR    RTC_FLAG $01            ; Reset Flag Status
            JMP     LOOP_RTC

;/*******************************/;
;/* Convert Hex to ASCII to A,B */;
;/* Input  =  ACCA              */;
;/* Output =  ACCA Hi-byte      */;
;/*           ACCB Low-byte     */;
;/*******************************/;
;
HEX_2ASC    PSHA
            JSR     HEX_TO_ASC
            TAB                             ; Transfer B <- A (B = Lo byte)
            PULA
            RORA                            ; Swap A
            RORA
            RORA
            RORA
            JSR     HEX_TO_ASC
            RTS

;/*******************************/;
;/* Convert Hex (0-F) to ASCII  */;
;/* Input  = Register ACC (Hex) */;
;/* Output = Register ACC (ASC) */;
;/*******************************/;
;
HEX_TO_ASC  CLC                             ; clear carry bit
            ANDA    #%00001111
            CMPA    #$09
            BNE     HTOA1
            SEC                             ; set carry bit
HTOA1       BCC     HTOA2                   ; > 0AH
            ORAA    #$30                    ; < 0AH
            JMP     END_HTOA
HTOA2       SBCA    #$09                    ; > 0AH
            ORAA    #$40
END_HTOA    RTS

;/****************************************/;
;/* Initial the SCI Port for 68HC11 CPU  */;
;/* Baud rate  : Crystal Oscilator 8MHz  */;
;/* Format SCI : Data 8 bit,1 Stop bit   */;
;/****************************************/;
;
INIT_SCI    LDAA    #%00110000              ; Set Baud rate 9600
            ;LDAA    #%00110001              ; Set Baud rate 4800
            ;LDAA    #%00110010              ; Set Baud rate 2400
            ;LDAA    #%00110011              ; Set Baud rate 1200
            STAA    BAUD,X
            LDAA    #$00
            STAA    SCCR1,X                 ; Set 8bit data,1 Stop bit
            LDAA    #$0C                    ; Enable RXD,TXD pin
            STAA    SCCR2,X
            RTS

;/********************************/;
;/* Transmit ASCII 1byte to SCI  */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : ASCII to SCI Port */;
;/* Register : ACCA,ACCB         */;
;/********************************/;
;
TX_SCI      PSHB
TX_SCI1     BRCLR   SCSR,X $80 TX_SCI1      ; Wait TDRE=1 (Buffer Empty)
            LDAB    SCSR,X                  ; Read For Clear Status
            STAA    SCDR,X                  ; Send character to SCI
TX_SCI2     BRCLR   SCSR,X $40 TX_SCI2      ; Wait  TC=1 (Send Complete)
            PULB
            RTS

;/*************************/;
;/* Receive data from SCI */;
;/* INPUT  : SCI Port     */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RX_SCI      BRCLR   SCSR,X $20 RX_SCI       ; Wait RDRF=1 (Receive Ready)
            LDAA    SCSR,X
            ANDA    #$0E
            BNE     RX_SCI1                 ; Rx Fail
            LDAA    SCDR,X                  ; Rx OK = Read data
            BRA     RX_SCI2
RX_SCI1     LDAA    SCDR,X
            CLRA                            ; Rx Fail Clear Data
RX_SCI2     RTS

;/*******************************/;
;/*  Print Out Data to SCI Port */;
;/*  Usage    : JSR   PRINT_SCI */;
;/*           : FCC   'xxxxxxx' */;
;/*           : FCB   $00       */;
;/*  Register : ACCA            */;
;/*  Call Sub : TX_SCI          */;
;/*  Note     : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRINT_SCI   PULY                            ; Pop Stack (PC Value)
            PSHA
            PSHB
PRN_SCI1    LDAA    0,Y                     ; Get Data For Print
            CMPA    #$00                    ; Check Last Byte
            BNE     PRN_SCI2                ; Jump if not Last Byte
            BRA     PRN_SCI3
PRN_SCI2    JSR     TX_SCI                  ; Send Data
            INY
            BRA     PRN_SCI1
PRN_SCI3    INY                             ; Point to Next Instruction
            PULB
            PULA
            PSHY                            ; Push Stack (PC Value)
            RTS

;/*************************/;
;/* IRQ Interrupt Service */;
;/*************************/;
;
IRQ_INT:    BSET    RTC_FLAG $01
            RTI

            END




            

