;/**********************************/;
;/* Demo Program For Output (8255) */;
;/* Hardware : ET-CP68HC11 Ver 2.0 */;
;/* Complier : AS11NEW.EXE (V1.03) */;
;/**********************************/;
;
;/* Address Port of 8255
PA8255      EQU     $1200                   ; PortA = Output
PB8255      EQU     $1201                   ; PortB = Input
PC8255      EQU     $1202                   ; PCL = Input,PCH = Output
CTL8255     EQU     $1203                   ; Control 8255

            ORG     $2200               ; Start of Debugger User Area
MAIN        LDAA    #$80                    ; PA,PB,PC = Output
            STAA    CTL8255
            ;
OUT_8255    CLRA                            ; Clear All Output
            STAA    PA8255
            STAA    PB8255
            STAA    PC8255
            ;
            SEC                             ; 1 00000000 (Carry & Data)
            LDAB    #9                      ; Counter
OUT_PA      STAA    PA8255                  ; Write Data to PortA
            JSR     DELAY
            ROLA                            ; Rotate Left data
            DECB
            BNE     OUT_PA
            ;
            CLRA
            STAA    PA8255
            STAA    PC8255
            SEC                             ; 1 00000000 (Carry & Data)
            LDAB    #9                      ; Counter
OUT_PB      STAA    PB8255                  ; Write Data to PortB
            JSR     DELAY
            ROLA                            ;Rotate Right data
            DECB
            BNE     OUT_PB
            ;
            ;
            CLRA
            STAA    PA8255
            STAA    PB8255
            SEC                             ; 1 00000000 (Carry & Data)
            LDAB    #9                      ; Counter
OUT_PC      STAA    PC8255                  ; Write Data to PortC
            JSR     DELAY
            ROLA                            ;Rotate Right data
            DECB
            BNE     OUT_PC
            JMP     OUT_8255

;/*******************/;
;/* Delay Time Sub. */;
;/*******************/;
;
DELAY       PSHX
            PSHB
            LDAB    #2
DLY0        LDX     #$FFFF
DLY1        DEX
            BNE     DLY1
            DECB
            BNE     DLY0
            PULB
            PULX
            RTS

            END

