;/**********************************/;
;/* Demo Program For OutputCompare */;
;/*    Timer Run Interrupt Mode    */;
;/* Used OCX  Gen Square-Wave      */;
;/* Hardware : ET-CP68HC11 Ver 2.0 */;
;/* Complier : AS11NEW.EXE (V1.03) */;
;/**********************************/;
;
;/*** I/O Register Equate ***/;
IOREGS      EQU     $1000                   ; Base Tegister
PORTA       EQU     $00                     ; i/o port a
PIOC        EQU     $02                     ; i/o control reg
PORTC       EQU     $03                     ; i/o port c
PORTB       EQU     $04                     ; i/o port b
PORTCL      EQU     $05                     ; i/o control reg
DDRC        EQU     $07                     ; data direction reg c
PORTD       EQU     $08                     ; i/o port d
DDRD        EQU     $09                     ; data direction reg d
PORTE       EQU     $0A                     ; i/o port e
CFORC       EQU     $0B                     ; force output compare
OC1M        EQU     $0C                     ; OC1 mask bits
OC1D        EQU     $0D                     ; OC1 data bits??
TCNT        EQU     $0E                     ; timer count reg
TIC1        EQU     $10                     ; input capture #1
TIC2        EQU     $12                     ; input capture #2
TIC3        EQU     $14                     ; input capture #3
TOC1        EQU     $16                     ; output compare #1
TOC2        EQU     $18                     ; output compare #2
TOC3        EQU     $1A                     ; output compare #3
TOC4        EQU     $1C                     ; output compare #4
TOC5        EQU     $1E                     ; output compare #5
TCTL1       EQU     $20                     ; timer control reg #1
TCTL2       EQU     $21                     ; timer control reg #2
TMSK1       EQU     $22                     ; timer mask #1
TFLG1       EQU     $23                     ; timer flags reg #1
TMSK2       EQU     $24                     ; timer mask #2
TFLG2       EQU     $25                     ; timer flags reg #2
PACTL       EQU     $26                     ; pulse accum control
PACNT       EQU     $27                     ; pulse accum counter
SPCR        EQU     $28                     ; SPI control reg
SPSR        EQU     $29                     ; SPI status reg
SPDR        EQU     $2A                     ; SPI data reg
BAUD        EQU     $2B                     ; baud rate reg
SCCR1       EQU     $2C                     ; SCI reg 1
SCCR2       EQU     $2D                     ; SCI reg 2
SCSR        EQU     $2E                     ; SCI status reg
SCDR        EQU     $2F                     ; SCI data reg
ADCTL       EQU     $30                     ; a/d control reg
ADR1        EQU     $31                     ; a/d result reg 1
ADR2        EQU     $32                     ; a/d result reg 2
ADR3        EQU     $33                     ; a/d result reg 3
ADR4        EQU     $34                     ; a/d result reg 4
OPTION      EQU     $39                     ; option reg
COPRST      EQU     $3A                     ; COP reset reg
PPROG       EQU     $3B                     ; eeprom programming reg
HPRIO       EQU     $3C                     ; highest-priority reg
INIT        EQU     $3D                     ; memory map initialization
TEST1       EQU     $3E                     ; test reg 1
CONFIG      EQU     $3F                     ; system configuration
;
;/* Interrupt Vector For Debugger 68HC11 V2.0 */;
OC5_VEC     EQU     $20D3
OC4_VEC     EQU     $20D6
OC3_VEC     EQU     $20D9
OC2_VEC     EQU     $20DC
OC1_VEC     EQU     $20DF

            ORG     $2200               ; Start of Debugger User Area
MAIN        LDAB    #$7E                ; Jump-EXT Opcode
            STAB    OC5_VEC             ; 1st Byte Debugger Vector
            STAB    OC4_VEC
            STAB    OC3_VEC
            STAB    OC2_VEC
            STAB    OC1_VEC
            LDX     #OC5_INT            ; Address Service Routine
            STX     OC5_VEC+1           ; 2nd,3rd Byte Debugger Vector
            LDX     #OC4_INT
            STX     OC4_VEC+1
            LDX     #OC3_INT
            STX     OC3_VEC+1
            LDX     #OC2_INT
            STX     OC2_VEC+1
            LDX     #OC1_INT
            STX     OC1_VEC+1
            ;
            LDX     #IOREGS                 ; Base Register Index
            JSR     INIT_SCI                ; Initial SCI = 9600,N,8,1,P
            ;
            JSR     PRINT_SCI
            FCB     $0D,$0A
            FCC     '************ Test Output Compares ************'
            FCB     $0D,$0A
            FCC     'Use OC1 Gen Square Wave on PA7'
            FCB     $0D,$0A
            FCC     'Use OC2 Gen Square Wave on PA6'
            FCB     $0D,$0A
            FCC     'Use OC3 Gen Square Wave on PA5'
            FCB     $0D,$0A
            FCC     'Use OC4 Gen Square Wave on PA4'
            FCB     $0D,$0A
            FCC     'Use OC5 Gen Square Wave on PA3'
            FCB     $0D,$0A,$00
            ;
            BSET    PACTL,X $80             ; PA7 = Output
            BSET    OC1M,X  $80             ; OC1 Active Pin PA7
            BSET    OC1D,X  $80
            LDD     #$FFFF                  ; 65536 x 0.5uS
            STD     CNT_OC1
            LDD     #$7FFF                  ; 32768 x 0.5uS
            STD     CNT_OC2
            LDD     #$3FFF                  ; 16384 x 0.5uS
            STD     CNT_OC3
            LDD     #$1FFF                  ; 8192 x 0.5uS
            STD     CNT_OC4
            LDD     #$0FFF                  ; 4096 x 0.5uS
            STD     CNT_OC5
            ;
            LDAA    #%01010101              ; OMX:OLX = 0:1
            STAA    TCTL1,X                 ; OCX Toggle When Overflow
            LDAA    #%11111000
            STAA    TFLG1,X                 ; Clear OCXF (Clear Overflow Flag)
            STAA    TMSK1,X                 ; Set OCXI (Enable OCX Interupt)
            CLI                             ; Enable Global Interupt
            ;
            BRA     *                       ; Loop Here For Interupt

;/****************************************/;
;/* Initial the SCI Port for 68HC11 CPU  */;
;/* Baud rate  : Crystal Oscilator 8MHz  */;
;/* Format SCI : Data 8 bit,1 Stop bit   */;
;/****************************************/;
;
INIT_SCI    LDAA    #%00110000              ; Set Baud rate 9600
            ;LDAA    #%00110001              ; Set Baud rate 4800
            ;LDAA    #%00110010              ; Set Baud rate 2400
            ;LDAA    #%00110011              ; Set Baud rate 1200
            STAA    BAUD,X
            LDAA    #$00
            STAA    SCCR1,X                 ; Set 8bit data,1 Stop bit
            LDAA    #$0C                    ; Enable RXD,TXD pin
            STAA    SCCR2,X
            RTS

;/********************************/;
;/* Transmit ASCII 1byte to SCI  */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : ASCII to SCI Port */;
;/* Register : ACCA,ACCB         */;
;/********************************/;
;
TX_SCI      PSHB
TX_SCI1     BRCLR   SCSR,X $80 TX_SCI1      ; Wait TDRE=1 (Buffer Empty)
            LDAB    SCSR,X                  ; Read For Clear Status
            STAA    SCDR,X                  ; Send character to SCI
TX_SCI2     BRCLR   SCSR,X $40 TX_SCI2      ; Wait  TC=1 (Send Complete)
            PULB
            RTS

;/*************************/;
;/* Receive data from SCI */;
;/* INPUT  : SCI Port     */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RX_SCI      BRCLR   SCSR,X $20 RX_SCI       ; Wait RDRF=1 (Receive Ready)
            LDAA    SCSR,X
            ANDA    #$0E
            BNE     RX_SCI1                 ; Rx Fail
            LDAA    SCDR,X                  ; Rx OK = Read data
            BRA     RX_SCI2
RX_SCI1     LDAA    SCDR,X
            CLRA                            ; Rx Fail Clear Data
RX_SCI2     RTS

;/*******************************/;
;/*  Print Out Data to SCI Port */;
;/*  Usage    : JSR   PRINT_SCI */;
;/*           : FCC   'xxxxxxx' */;
;/*           : FCB   $00       */;
;/*  Register : ACCA            */;
;/*  Call Sub : TX_SCI          */;
;/*  Note     : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRINT_SCI   PULY                            ; Pop Stack (PC Value)
            PSHA
            PSHB
PRN_SCI1    LDAA    0,Y                     ; Get Data For Print
            CMPA    #$00                    ; Check Last Byte
            BNE     PRN_SCI2                ; Jump if not Last Byte
            BRA     PRN_SCI3
PRN_SCI2    JSR     TX_SCI                  ; Send Data
            INY
            BRA     PRN_SCI1
PRN_SCI3    INY                             ; Point to Next Instruction
            PULB
            PULA
            PSHY                            ; Push Stack (PC Value)
            RTS

;/***********************/;
;/ OC1 Interupt Service */;
;/***********************/;
;
OC1_INT     LDD     CNT_OC1             ; Get Delay Count
            ADDD    TOC1,X              ; TOC1 = Old TOC1 + HDLY
            STD     TOC1,X
            BSET    TFLG1,X %10000000   ; Clear OC1F Flag
            LDAA    OC1D,X              ; Toggle PA7
            COMA
            ANDA    #$80
            STAA    OC1D,X
            RTI

;/***********************/;
;/ OC2 Interupt Service */;
;/***********************/;
;
OC2_INT     LDD     CNT_OC2             ; Get Delay Count
            ADDD    TOC2,X              ; TOC2 = Old TOC2 + HDLY
            STD     TOC2,X
            BSET    TFLG1,X %01000000   ; Clear OC2F Flag
            RTI

;/***********************/;
;/ OC3 Interupt Service */;
;/***********************/;
;
OC3_INT     LDD     CNT_OC3             ; Get Delay Count
            ADDD    TOC3,X              ; TOC3 = Old TOC3 + HDLY
            STD     TOC3,X
            BSET    TFLG1,X %00100000   ; Clear OC3F Flag
            RTI

;/***********************/;
;/ OC4 Interupt Service */;
;/***********************/;
;
OC4_INT     LDD     CNT_OC4             ; Get Delay Count
            ADDD    TOC4,X              ; TOC4 = Old TOC4 + HDLY
            STD     TOC4,X
            BSET    TFLG1,X %00010000   ; Clear OC4F Flag
            RTI

;/***********************/;
;/ OC5 Interupt Service */;
;/***********************/;
;
OC5_INT     LDD     CNT_OC5             ; Get Delay Count
            ADDD    TOC5,X              ; TOC5 = Old TOC5 + HDLY
            STD     TOC5,X
            BSET    TFLG1,X %00001000   ; Clear OC5F Flag
            RTI

;/* Variable Buffer EXT-RAM */;
CNT_OC1     RMB     2                       ; 1/2 Cycle Count
CNT_OC2     RMB     2
CNT_OC3     RMB     2
CNT_OC4     RMB     2
CNT_OC5     RMB     2

            END

