;/**********************************/;
;/* Demo Program For Input Capture */;
;/*    Timer Run Interrupt Mode    */;
;/* Used ICX  Measure Period Width */;
;/* Hardware : ET-CP68HC11 Ver 2.0 */;
;/* Complier : AS11NEW.EXE (V1.03) */;
;/**********************************/;
;
;/***************************/;
;/*** I/O Register Equate ***/;
;/***************************/;
;
IOREGS      EQU     $1000               ; Start of I/O Register
PORTA       EQU     IOREGS+$00          ; I/O Port-A
PIOC        EQU     IOREGS+$02          ; I/O Control Register
PORTC       EQU     IOREGS+$03          ; I/O Port-C
PORTB       EQU     IOREGS+$04          ; I/O Port-B
PORTCL      EQU     IOREGS+$05          ; I/O Control Register
DDRC        EQU     IOREGS+$07          ; Data Direction Register-C
PORTD       EQU     IOREGS+$08          ; I/O Port-D
DDRD        EQU     IOREGS+$09          ; Data Direction Register-D
PORTE       EQU     IOREGS+$0A          ; I/O Port-E
CFORC       EQU     IOREGS+$0B          ; Force Output Compare
OC1M        EQU     IOREGS+$0C          ; OC1 Mask Bits
OC1D        EQU     IOREGS+$0D          ; OC1 Data Bits??
TCNT        EQU     IOREGS+$0E          ; Timer Count Register
TIC1        EQU     IOREGS+$10          ; Input Capture #1
TIC2        EQU     IOREGS+$12          ; Input Capture #2
TIC3        EQU     IOREGS+$14          ; Input Capture #3
TOC1        EQU     IOREGS+$16          ; Output Compare #1
TOC2        EQU     IOREGS+$18          ; Output Compare #2
TOC3        EQU     IOREGS+$1A          ; Output Compare #3
TOC4        EQU     IOREGS+$1C          ; Output Compare #4
TOC5        EQU     IOREGS+$1E          ; Output Compare #5
TCTL1       EQU     IOREGS+$20          ; Timer Control Register #1
TCTL2       EQU     IOREGS+$21          ; Timer Control Register #2
TMSK1       EQU     IOREGS+$22          ; Timer Mask #1
TFLG1       EQU     IOREGS+$23          ; Timer Flags #1
TMSK2       EQU     IOREGS+$24          ; Timer Mask #2
TFLG2       EQU     IOREGS+$25          ; Timer Flags #2
PACTL       EQU     IOREGS+$26          ; Pulse Accum Control
PACNT       EQU     IOREGS+$27          ; Pulse Accum Counter
SPCR        EQU     IOREGS+$28          ; SPI Control Register
SPSR        EQU     IOREGS+$29          ; SPI Status Register
SPDR        EQU     IOREGS+$2A          ; SPI Data Register
;
BAUD        EQU     $2B                 ; Baudrate Register
SCCR1       EQU     $2C                 ; SCI Register 1
SCCR2       EQU     $2D                 ; SCI Register 2
SCSR        EQU     $2E                 ; SCI Status Register
SCDR        EQU     $2F                 ; SCI Data Register
;
ADCTL       EQU     IOREGS+$30          ; A/D Control Register
ADR1        EQU     IOREGS+$31          ; A/D Result 1
ADR2        EQU     IOREGS+$32          ; A/D Result 2
ADR3        EQU     IOREGS+$33          ; A/D Result 3
ADR4        EQU     IOREGS+$34          ; A/D Result 4
OPTION      EQU     IOREGS+$39          ; Option Register
COPRST      EQU     IOREGS+$3A          ; COP Reset Register
PPROG       EQU     IOREGS+$3B          ; EEPROM Programming Register
HPRIO       EQU     IOREGS+$3C          ; Highest-Priority Register
INIT        EQU     IOREGS+$3D          ; Memory Map Initialization
TEST1       EQU     IOREGS+$3E          ; Test Register 1
CONFIG      EQU     IOREGS+$3F          ; System Configuration
;
;/* Interrupt Vector For Debugger 68HC11 V2.0 */;
IC3_VEC     EQU     $20E2
IC2_VEC     EQU     $20E5
IC1_VEC     EQU     $20E8

            ORG     $0000
IC1_STAS    RMB     1                       ; FF= off,0 = 1st,1= 2nd
IC1_RDY     RMB     1                       ; 0 = Not Ready,1=Ready
IC1_BUF1    RMB     2                       ; Rising Edge  (Cycle)
IC1_BUF2    RMB     2                       ; Result Cycle (Rising-Falling)
;
IC2_STAS    RMB     1                       ; FF= off,0 = 1st,1= 2nd
IC2_RDY     RMB     1                       ; 0 = Not Ready,1=Ready
IC2_BUF1    RMB     2                       ; Rising Edge  (Cycle)
IC2_BUF2    RMB     2                       ; Result Cycle (Rising-Falling)
;
IC3_STAS    RMB     1                       ; FF= off,0 = 1st,1= 2nd
IC3_RDY     RMB     1                       ; 0 = Not Ready,1=Ready
IC3_BUF1    RMB     2                       ; Rising Edge  (Cycle)
IC3_BUF2    RMB     2                       ; Result Cycle (Rising-Falling)
;
HEX_BUFF    RMB     2
DEC_BUFF    RMB     5

            ORG     $2200               ; Start of Debugger User Area
MAIN        LDAB    #$7E                ; Jump-EXT Opcode
            STAB    IC1_VEC             ; 1st Byte Debugger Vector
            STAB    IC2_VEC
            STAB    IC3_VEC
            LDX     #IC1_INT            ; Address Service Routine
            STX     IC1_VEC+1           ; 2nd,3rd Byte Debugger Vector
            LDX     #IC2_INT
            STX     IC2_VEC+1
            LDX     #IC3_INT
            STX     IC3_VEC+1
            ;
            LDX     #$1000                  ; Base Register
            JSR     INIT_SCI                ; Initial SCI = 9600,N,8,1,P
            ;
            JSR     PRINT_SCI
            FCB     $0D,$0A,$0A
            FCC     '************* Test Input Capture *************'
            FCB     $0D,$0A
            FCC     'Use IC1 Measure Period on PA2 (32-65535 Cycle)'
            FCB     $0D,$0A
            FCC     'Use IC2 Measure Period on PA1 (32-65535 Cycle)'
            FCB     $0D,$0A
            FCC     'Use IC3 Measure Period on PA0 (32-65535 Cycle)'
            FCB     $0D,$0A,$0A
            FCC     '    IC1             IC2             IC3'
            FCB     $0D,$0A,$00
            ;
            LDAB    #%00010101              ; Capture ICX on Rising Edge
            STAB    TCTL2
            LDAB    #%00000111
            STAB    TMSK1                   ; Enable ICX Interrupt
            STAB    TFLG1                   ; Clear ICXF
            JSR     IC1_STRT                ; Initial IC1
            JSR     IC2_STRT                ; Initial IC2
            JSR     IC3_STRT                ; Initial IC3
            JSR     DSP_CYCLE
            CLI                             ; Enable Global Interrupt
            ;
WAIT_RDY    LDAA    IC1_RDY
            BNE     IC1_DSPY                ; Check IC1 Ready
WAIT_IC2    LDAA    IC2_RDY
            BNE     IC2_DSPY                ; Check IC2 Ready
WAIT_IC3    LDAA    IC3_RDY
            BNE     IC3_DSPY                ; Check IC3 Ready
            BRA     WAIT_RDY
            ;
IC1_DSPY    JSR     DSP_CYCLE
            JSR     IC1_STRT
            JSR     DSP_CYCLE
            JMP     WAIT_IC2
            ;
IC2_DSPY    JSR     DSP_CYCLE
            JSR     IC2_STRT
            JSR     DSP_CYCLE
            JMP     WAIT_IC3
            ;
IC3_DSPY    JSR     DSP_CYCLE
            JSR     IC3_STRT
            JSR     DSP_CYCLE
            JMP     WAIT_RDY

;/*********************/;
;/* Display Cycle ICX */;
;/*********************/;
;
DSP_CYCLE   LDAA    #$0D
            JSR     TX_SCI
            ;
            LDD     IC1_BUF2
            CPD     #32
            BHI     DSP_IC1X
            JSR     PRINT_SCI
            FCC     'Over!'
            FCB     $00
            BRA     DSP_UNT1
            ;
DSP_IC1X    STD     HEX_BUFF
            JSR     HTOD                    ; Convert to 5 Decimal
            LDAA    DEC_BUFF+0
            JSR     TX_SCI
            LDAA    DEC_BUFF+1
            JSR     TX_SCI
            LDAA    DEC_BUFF+2
            JSR     TX_SCI
            LDAA    DEC_BUFF+3
            JSR     TX_SCI
            LDAA    DEC_BUFF+4
            JSR     TX_SCI
DSP_UNT1    JSR     PRINT_SCI
            FCC     ' Cycle     '
            FCB     $00
            ;
            LDD     IC2_BUF2
            CPD     #32
            BHI     DSP_IC2X
            JSR     PRINT_SCI
            FCC     'Over!'
            FCB     $00
            BRA     DSP_UNT2
            ;
DSP_IC2X    STD     HEX_BUFF
            JSR     HTOD                    ; Convert to 5 Decimal
            LDAA    DEC_BUFF+0
            JSR     TX_SCI
            LDAA    DEC_BUFF+1
            JSR     TX_SCI
            LDAA    DEC_BUFF+2
            JSR     TX_SCI
            LDAA    DEC_BUFF+3
            JSR     TX_SCI
            LDAA    DEC_BUFF+4
            JSR     TX_SCI
DSP_UNT2    JSR     PRINT_SCI
            FCC     ' Cycle     '
            FCB     $00
            ;
            LDD     IC3_BUF2
            CPD     #32
            BHI     DSP_IC3X
            JSR     PRINT_SCI
            FCC     'Over!'
            FCB     $00
            BRA     DSP_UNT3
DSP_IC3X    STD     HEX_BUFF
            JSR     HTOD                    ; Convert to 5 Decimal
            LDAA    DEC_BUFF+0
            JSR     TX_SCI
            LDAA    DEC_BUFF+1
            JSR     TX_SCI
            LDAA    DEC_BUFF+2
            JSR     TX_SCI
            LDAA    DEC_BUFF+3
            JSR     TX_SCI
            LDAA    DEC_BUFF+4
            JSR     TX_SCI
DSP_UNT3    JSR     PRINT_SCI
            FCC     ' Cycle'
            FCB     $00
            RTS

;/****************************************/;
;/* Initial the SCI Port for 68HC11 CPU  */;
;/* Baud rate  : Crystal Oscilator 8MHz  */;
;/* Format SCI : Data 8 bit,1 Stop bit   */;
;/****************************************/;
;
INIT_SCI    LDAA    #%00110000              ; Set Baud rate 9600
            ;LDAA    #%00110001              ; Set Baud rate 4800
            ;LDAA    #%00110010              ; Set Baud rate 2400
            ;LDAA    #%00110011              ; Set Baud rate 1200
            STAA    BAUD,X
            LDAA    #$00
            STAA    SCCR1,X                 ; Set 8bit data,1 Stop bit
            LDAA    #$0C                    ; Enable RXD,TXD pin
            STAA    SCCR2,X
            RTS

;/********************************/;
;/* Transmit ASCII 1byte to SCI  */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : ASCII to SCI Port */;
;/* Register : ACCA,ACCB         */;
;/********************************/;
;
TX_SCI      PSHB
TX_SCI1     BRCLR   SCSR,X $80 TX_SCI1      ; Wait TDRE=1 (Buffer Empty)
            LDAB    SCSR,X                  ; Read For Clear Status
            STAA    SCDR,X                  ; Send character to SCI
TX_SCI2     BRCLR   SCSR,X $40 TX_SCI2      ; Wait  TC=1 (Send Complete)
            PULB
            RTS

;/*************************/;
;/* Receive data from SCI */;
;/* INPUT  : SCI Port     */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RX_SCI      BRCLR   SCSR,X $20 RX_SCI       ; Wait RDRF=1 (Receive Ready)
            LDAA    SCSR,X
            ANDA    #$0E
            BNE     RX_SCI1                 ; Rx Fail
            LDAA    SCDR,X                  ; Rx OK = Read data
            BRA     RX_SCI2
RX_SCI1     LDAA    SCDR,X
            CLRA                            ; Rx Fail Clear Data
RX_SCI2     RTS

;/*******************************/;
;/*  Print Out Data to SCI Port */;
;/*  Usage    : JSR   PRINT_SCI */;
;/*           : FCC   'xxxxxxx' */;
;/*           : FCB   $00       */;
;/*  Register : ACCA            */;
;/*  Call Sub : TX_SCI          */;
;/*  Note     : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRINT_SCI   PULY                            ; Pop Stack (PC Value)
            PSHA
            PSHB
PRN_SCI1    LDAA    0,Y                     ; Get Data For Print
            CMPA    #$00                    ; Check Last Byte
            BNE     PRN_SCI2                ; Jump if not Last Byte
            BRA     PRN_SCI3
PRN_SCI2    JSR     TX_SCI                  ; Send Data
            INY
            BRA     PRN_SCI1
PRN_SCI3    INY                             ; Point to Next Instruction
            PULB
            PULA
            PSHY                            ; Push Stack (PC Value)
            RTS

;/**************************/;
;/* Convert HEX to Decimal */;
;/* Input  : IX^2Byte HEX  */;
;/* Output : DEC_BUFF      */;
;/**************************/;
;
HTOD        PSHX                            ; Save-IX
            LDD     HEX_BUFF
            LDX     #10000
            IDIV
            XGDX
            ADDB    #$30
            STAB    DEC_BUFF+0
            XGDX
            LDX     #1000
            IDIV
            XGDX
            ADDB    #$30
            STAB    DEC_BUFF+1
            XGDX
            LDX     #100
            IDIV
            XGDX
            ADDB    #$30
            STAB    DEC_BUFF+2
            XGDX
            LDX     #10
            IDIV
            ADDB    #$30
            STAB    DEC_BUFF+4
            XGDX
            ADDB    #$30
            STAB    DEC_BUFF+3
            PULX                            ; Restore-IX
            RTS

;/*************************/;
;/* Initial IC1 Parameter */;
;/*************************/;
;
IC1_STRT    LDAB    #$FF
            STAB    IC1_STAS                ; FF= off,0 = 1st,1= 2nd
            LDD     #0
            STD     IC1_BUF2
            STAB    IC1_RDY
            LDAB    #%00000100
            STAB    TFLG1                   ; Clear IC1F
            LDAB    TMSK1
            ORAB    #%00000100
            STAB    TMSK1                   ; Enable IC1X
            RTS

;/*************************/;
;/* Initial IC2 Parameter */;
;/*************************/;
;
IC2_STRT    LDAB    #$FF
            STAB    IC2_STAS                ; FF= off,0 = 1st,1= 2nd
            LDD     #0
            STD     IC2_BUF2
            STAB    IC2_RDY
            LDAB    #%00000010
            STAB    TFLG1                   ; Clear IC2F
            LDAB    TMSK1
            ORAB    #%00000010
            STAB    TMSK1                   ; Enable IC2X
            RTS

;/*************************/;
;/* Initial IC3 Parameter */;
;/*************************/;
;
IC3_STRT    LDAB    #$FF
            STAB    IC3_STAS                ; FF= off,0 = 1st,1= 2nd
            LDD     #0
            STD     IC3_BUF2
            STAB    IC3_RDY
            LDAB    #%00000001
            STAB    TFLG1                   ; Clear IC3F
            LDAB    TMSK1
            ORAB    #%00000001
            STAB    TMSK1                   ; Enable IC3X
            RTS

;/***************************/;
;/* IC1 Measure Pulse Width */;
;/*    (Rising...Rising)    */;
;/* Max Cycle = 65535 Cycle */;
;/***************************/;
;
IC1_INT     INC     IC1_STAS
            LDAB    IC1_STAS
            BNE     IC1_EDG2                
IC1_EDG1    LDD     TIC1                    ; Read 1st Rising Edge
            STD     IC1_BUF1
            BRA     IC1_OUT
IC1_EDG2    LDD     TIC1                    ; Read 2nd Rising Edge
            SUBD    IC1_BUF1                ; 2nd Rising - 1st Rising
            STD     IC1_BUF2                ; Result of Cycle
            INC     IC1_RDY
            LDAB    TMSK1
            ANDB    #%11111011
            STAB    TMSK1                   ; Disable IC1X
IC1_OUT     LDAB    #%00000100
            STAB    TFLG1                   ; Clear IC1F
            RTI

;/***************************/;
;/* IC2 Measure Pulse Width */;
;/*    (Rising...Rising)    */;
;/* Max Cycle = 65535 Cycle */;
;/***************************/;
;
IC2_INT     INC     IC2_STAS
            LDAB    IC2_STAS
            BNE     IC2_EDG2
IC2_EDG1    LDD     TIC2                    ; Read 1st Rising Edge
            STD     IC2_BUF1
            BRA     IC2_OUT
IC2_EDG2    LDD     TIC2                    ; Read 2nd Rising Edge
            SUBD    IC2_BUF1                ; 2nd Rising - 1st Rising
            STD     IC2_BUF2                ; Result of Cycle
            INC     IC2_RDY
            LDAB    TMSK1
            ANDB    #%11111101
            STAB    TMSK1                   ; Disable IC2X
IC2_OUT     LDAB    #%00000010
            STAB    TFLG1                   ; Clear IC2F
            RTI

;/***************************/;
;/* IC3 Measure Pulse Width */;
;/*    (Rising...Rising)    */;
;/* Max Cycle = 65535 Cycle */;
;/***************************/;
;
IC3_INT     INC     IC3_STAS
            LDAB    IC3_STAS
            BNE     IC3_EDG2
IC3_EDG1    LDD     TIC3                    ; Read 1st Rising Edge
            STD     IC3_BUF1
            BRA     IC3_OUT
IC3_EDG2    LDD     TIC3                    ; Read 2nd Rising Edge
            SUBD    IC3_BUF1                ; 2nd Rising - 1st Rising
            STD     IC3_BUF2                ; Result of Cycle
            INC     IC3_RDY
            LDAB    TMSK1
            ANDB    #%11111110
            STAB    TMSK1                   ; Disable IC3X
IC3_OUT     LDAB    #%00000001
            STAB    TFLG1                   ; Clear IC3F
            RTI

            END

