#ifndef TOUCH_PIN
#define TOUCH_PIN  PIN_B2
#bit    TOUCH_PIN_BIT = 6.2
#endif

boolean touch_write_byte(byte data) {
     byte i;

     for(i=1;i<=8;++i) {
     output_low(TOUCH_PIN);        // Start Sand DATA  MCU reset pulse 15 ms ( > 1us )
     delay_us(10);
     if(shift_right(&data,1,0)) {
       output_high(TOUCH_PIN);
       if(!TOUCH_PIN_BIT)
         return(0);
     } else {
       output_low(TOUCH_PIN);
       if(TOUCH_PIN_BIT)
         return(0);
     }
     delay_us(50);               // DS1820 Samples  15 - 60 ms
     output_high(TOUCH_PIN);
     delay_us(1);                // 1us < Tsec < ------->
   }
   return(TRUE);
}

byte touch_read_byte() {
   byte i,data;

   for(i=1;i<=8;++i) {
     output_low(TOUCH_PIN);     // MCU active low  ( > 1us )
     delay_us(14);
     output_float(TOUCH_PIN);
     delay_us(1);
     shift_right(&data,1,input(TOUCH_PIN));  // MCU Samples  ( > 15us )
     delay_us(45);
   }
   return(data);
}

boolean touch_present() {
    boolean present;

    output_low(TOUCH_PIN);
    delay_us(500);         // Wait for more than 480 us
    output_float(TOUCH_PIN);
    if(!input(TOUCH_PIN))
       return(FALSE);
    delay_us(65);          // Wait for more than 65 us
    present=!input(TOUCH_PIN);
    if(present) {
       delay_us(400);      // Wait for end of presence pulse
       return(TRUE);
    }
    else
       return(FALSE);
}

read_temperature()
{
  long temperature;
  int  count_remain, count_per_c, tmp, i;

  while(!(touch_present()));   // MCU reset pulse
  touch_write_byte(0xCC);     // Skip rom command ( 0xCC )
  touch_write_byte(0x44);     // Convert temperature ( 0x44 )
  output_float(TOUCH_PIN);
  while(!input(TOUCH_PIN));   // Wait 500 ms
  while(!(touch_present()));   // MCU reset pulse
  touch_write_byte(0xCC);     // Skip rom command ( 0xCC )
  touch_write_byte(0xBE);     // Read scratchpad
  *(&temperature) = touch_read_byte();
  *(&temperature + 1) = touch_read_byte();
  for(i=0; i<4; i++) {
  tmp = touch_read_byte();
  }
  count_remain = touch_read_byte();
  count_per_c  = touch_read_byte();
  putc(*(&temperature+1));
  putc(*(&temperature));
  putc(count_remain);
  putc(count_per_c);
}









