/*****************************************************/
/* Examples Program For "ET-ARM7 BASE LPC2106" Board */
/* Target MCU  : Philips ARM7-LPC2106                */
/*       	   : X-TAL : 19.6608 MHz                 */
/*             : Run Speed 58.9824MHz (With PLL)     */
/* Keil Editor : uVision3 V3.03a                     */
/* Compiler    : Keil CARM V2.50a		             */
/* Create By   : Eakachai Makarn (WWW.ETT.CO.TH)     */
/* Last Update : 17/April/2006                       */
/* Function    : Example Use UART1	                 */
/*****************************************************/
// Print Message to UART1 (9600,N,8,1)

#include <LPC210x.H> 	                                	// LPC2106 MPU Register
#include <stdio.h>											// For Used Function printf 

/* pototype  section */
void init_serial1 (void); 									// Initil UART-1
int putchar (int ch);  										// Put Char to UART-1
int getchar (void);  										// Get Char From UART-1

int main(void)
{  
  char data;												// Char Buffer For UART
  init_serial1();		   									// Initilial UART1 = 9600,N,8,1
  printf("Hello ET-ARM7 BASE LPC2106...TEST UART-1\n"); 	// Call printf Function
  printf("Press Any Key For Test...UART-1\n");

  while(1)													// Loop Continue
  {
    data = getchar();										// Wait Receive Byte From UART-0
	putchar(data);											// Echo Data to UART-0
  }													
}

/******************************/
/* Initial UART1 = 9600,N,8,1 */
/* VPB(pclk) = 29.4912 MHz    */
/******************************/
void init_serial1 (void)  
{
  PINSEL0 &= 0xFFF0FFFF;						// Reset P0.8,P0.9 Pin Config
  PINSEL0 |= 0x00010000;						// Select P0.8 = TxD(UART1)
  PINSEL0 |= 0x00040000;						// Select P0.9 = RxD(UART1)

  U1LCR &= 0xFC;								// Reset Word Select(1:0)
  U1LCR |= 0x03;								// Data Bit = 8 Bit
  U1LCR &= 0xFB;								// Stop Bit = 1 Bit
  U1LCR &= 0xF7;								// Parity = Disable
  U1LCR &= 0xBF;								// Disable Break Control
  U1LCR |= 0x80;								// Enable Programming of Divisor Latches

  // U0DLM:U0DLL = 29.4912MHz / [16 x Baud]
  //             = 29.4912MHz / [16 x 9600]
  //             = 192 = 0x00C0
  U1DLM = 0x00;									// Program Divisor Latch(192) for 9600 Baud
  U1DLL = 0xC0;

  U1LCR &= 0x7F;								// Disable Programming of Divisor Latches

  U1FCR |= 0x01;								// FIF0 Enable
  U1FCR |= 0x02;								// RX FIFO Reset
  U1FCR |= 0x04;								// TX FIFO Reset
  U1FCR &= 0x3F;                       
}

/****************************/
/* Write character to UART1 */
/****************************/
int putchar (int ch)  
{                  
  if (ch == '\n')  
  {
    while (!(U1LSR & 0x20));					// Wait TXD Buffer Empty
    U1THR = 0x0D;                          		// Write CR
  }
  while (!(U1LSR & 0x20)); 						// Wait TXD Buffer Empty
  return (U1THR = ch);						    // Write Character
}

/*****************************/
/* Read character from UART1 */
/*****************************/
int getchar (void)  
{                    
  while (!(U1LSR & 0x01));	 					// Wait RXD Receive Data Ready
  return (U1RBR);								// Get Receice Data & Return
}
