/*****************************************************/
/* Examples Program For "ET-ARM7 BASE LPC2103" Board */
/* Target MCU  : Philips ARM7-LPC2103                */
/*       	   : X-TAL : 19.6608 MHz                 */
/*             : Run Speed 58.9824MHz (With PLL)     */
/* Keil Editor : uVision3 V3.03a                     */
/* Compiler    : Keil CARM V2.50a		             */
/* Create By   : Eakachai Makarn (WWW.ETT.CO.TH)     */
/* Last Update : 17/April/2006                       */
/* Function    : Example Use Timer1 = PWM Mode       */
/*****************************************************/
// GPIO0.12 -> MAT1.0 = PWM0 = 1.0mS/20mS
// GPIO0.13 -> MAT1.1 = PWM1 = 1.5mS/20mS
// GPIO0.19 -> MAT1.2 = PWM2 = 2.0mS/20mS
// GPIO0.20 -> MAT1.3 = Not Connect = PWM Period Count (20mS)

#include <LPC2103.H> 	                                	// LPC2103 MPU Register

// Main Program Start Here //
int main(void)
{  
  // Initial Timer1 Pin Connect   
  PINSEL0 &= 0xFCFFFFFF; 		// 1111 1100 1111 1111 1111 1111 1111 1111 = Reset P0.12 Function 
  PINSEL0 |= 0x02000000; 		// 0000 0010 0000 0000 0000 0000 0000 0000 = P0.12 -> MAT1.0
  PINSEL0 &= 0xF3FFFFFF; 		// 1111 0011 1111 1111 1111 1111 1111 1111 = Reset P0.13 Function 
  PINSEL0 |= 0x08000000; 		// 0000 1000 0000 0000 0000 0000 0000 0000 = P0.13 -> MAT1.1
  PINSEL1 &= 0xFFFFFF3F; 		// 1111 1111 1111 1111 1111 1111 xx11 1111 = Reset P0.19 Function
  PINSEL1 |= 0x00000080; 		// 0000 0000 0000 0000 0000 0000 1000 0000 = P0.19 -> MAT1.2
  PINSEL1 &= 0xFFFFFCFF; 		// 1111 1111 1111 1111 1111 11xx 1111 1111 = Reset P0.20 Function  
  
  // Initial Timer Operate 
  T1TCR   &= 0xFFFFFFFC;		// Timer1 = Timer Mode Count By Rising PCLK Edge    
  T1TC     = 0x00000000;  		// Timer Start = 0
  T1PR     = 0x00000000;  		// Prescale = 0
  T1PC     = 0x00000000;   		// Prescale Count = 0
  
  // Initial Timer1 Match Operate 
  T1MCR	  &= 0xFFFE;			// Disable Interrupt on Match-0 (1111 1111 1111 111x)
  T1MCR   &= 0xFFFD;			// Disable Reset TC on Match-0	(1111 1111 1111 11x1)
  T1MCR   &= 0xFFFB;			// Disable Stop TC on Match-0	(1111 1111 1111 1x11)
  T1MCR	  &= 0xFFF7;			// Disable Interrupt on Match-1	(1111 1111 1111 x111)
  T1MCR   &= 0xFFEF;			// Disable Reset TC on Match-1	(1111 1111 111x 1111)
  T1MCR   &= 0xFFDF;			// Disable Stop TC on Match-1	(1111 1111 11x1 1111)
  T1MCR	  &= 0xFFBF;			// Disable Interrupt on Match-2	(1111 1111 1x11 1111)
  T1MCR   &= 0xFF7F;			// Disable Reset TC on Match-2	(1111 1111 x111 1111)
  T1MCR   &= 0xFEFF;			// Disable Stop TC on Match-2 	(1111 111x 1111 1111)
  T1MCR	  &= 0xFDFF;			// Disable Interrupt on Match-3	(1111 11x1 1111 1111)
  T1MCR   |= 0x0400;			// Enable Reset TC on Match-3	(0000 0x00 0000 0000)
  T1MCR   &= 0xF7FF;			// Disable Stop TC on Match-3 	(1111 x111 1111 1111)
    
  // Initial PWM Function
  // Set   Output By Timer Match
  // Reset Output By TC Reset 
  T1PWMCON |= 0x00000001;		// Enable MAT1.0 = PWM
  T1PWMCON |= 0x00000002;		// Enable MAT1.1 = PWM
  T1PWMCON |= 0x00000004;   	// Enable MAT1.2 = PWM

  // Initial Timer1 Interrupt 
  T1IR &= 0xFE;  				// Disable MAT0 Interrupt (1111111x)
  T1IR &= 0xFD;  				// Disable MAT1 Interrupt (111111x1)
  T1IR &= 0xFB;  				// Disable MAT2 Interrupt (11111x11)
  T1IR &= 0xF7;  				// Disable MAT3 Interrupt (1111x111)
  T1IR &= 0xEF;  				// Disable CAP0 Interrupt (111x1111)
  T1IR &= 0xDF;  				// Disable CAP1 Interrupt (11x11111)
  T1IR &= 0xBF;  				// Disable CAP2 Interrupt (1x111111)
  T1IR &= 0x7F;  				// Disable CAP3 Interrupt (x1111111)

  // Initial PWM Timing 
  // Timer Count PCLK (29.4912MHz)  
  // 1 Cycle Timer  = 33.90842 nS
  // -> 20 mS = 589824 Cycle (90000H)
  // -> 1.0mS = 29491.2 Cycle (7333H)
  // -> 1.5mS = 44236.8 Cycle (ACCDH)
  // -> 2.0mS = 58982.4 Cycle (E666H)
  // -> Used MAT1.0 = Count Low Pulse MAT1.0(Set Output on MAT1.0)
  // -> Used MAT1.1 = Count Low Pulse MAT1.1(Set Output on MAT1.1)
  // -> Used MAT1.2 = Count Low Pulse MAT1.2(Set Output on MAT1.2)
  // -> Used MAT1.3 = Count Period of PWM(Reset TC on MATx.3)
  // Reset All Output on TC Start (TC=0)
  // Set Output on MATx.y (TC=MATx.y)
  // Reset TC on MATx.3

  // MAT1.0 Count Low Pulse of PWM0
  // MAT1.1 Count Low Pulse of PWM1
  // MAT1.2 Count Low Pulse of PWM2
  // MAT1.3 Count Period of All PWM
  T1MR0 = 560333; 				// MAT1.0 = 0..560332.8 (19.0 mS) = Set Output (PWM 1.0 mS)
  T1MR1 = 545587;				// MAT1.1 = 0..545587.2 (18.5 mS) = Set Output (PWM 1.5 mS)
  T1MR2 = 530842;				// MAT1.2 = 0..530841.6 (18.0 mS) = Set Output (PWM 2.0 mS) 
  T1MR3 = 589824;				// MAT1.3 = 0..589824   (20.0 mS) = Reset Output (PWM Period)

  // Initial Timer-1 Control 
  T1TCR |= 0x01;				// Timer-1 Enable 		 (0000000x)
  T1TCR |= 0x02;  				// Timer-1 Press Reset	 (000000x0)
  T1TCR &= 0xFD;  				// Timer-1 Release Reset (111111x1)
    
  // Now GPIO0.12 Generate PWM = 1.0mS
  //     GPIO0.13 Generate PWM = 1.5mS
  //     GPIO0.19 Generate PWM = 2.0mS
  while(1);						// Loop Continue  

}


