/*****************************************************/
/* Examples Program For "ET-ARM7 BASE LPC2103" Board */
/* Target MCU  : Philips ARM7-LPC2103                */
/*       	   : X-TAL : 19.6608 MHz                 */
/*             : Run Speed 58.9824MHz (With PLL)     */
/* Keil Editor : uVision3 V3.03a                     */
/* Compiler    : Keil CARM V2.50a		             */
/* Create By   : Eakachai Makarn (WWW.ETT.CO.TH)     */
/* Last Update : 17/April/2006                       */
/* Function    : Example Display ADC0(P0.22)-> UART0 */
/*****************************************************/
// Used GPIO0.22 = AIN0 (ADC0) Measure Voltage
// Display Result on UART0(9600,N,8,1)

#include <LPC2103.H> 	                                	// LPC2103 MPU Register
#include <stdio.h>											// For Used Function printf 

/* pototype  section */
void init_serial0 (void); 									// Initil UART-0
int putchar (int ch);  										// Put Char to UART-0
int getchar (void);  										// Get Char From Uart-0
void delay(unsigned long int);								// Delay Time Function


unsigned int val;		   									// ADC Result (HEX)
float volt;													// ADC Result Volt

int main(void)
{  
  init_serial0();				   							// Initial UART0 = 9600,N,8,1
  printf("ET-ARM7 BASE LPC2103...TEST ADC-0(P0.22)\n"); 	// Call prinff Function

  // Initial ADC0 (GPIO-0.22) By Set PINSEL1[13:12=11] 
  // xxxx xxxx xxxx xxxx xx11 xxxx xxxx xxxx 
  PINSEL1 &= 0xFFFFCFFF; 									// Select ADC0 Pin Connect P0.22
  PINSEL1 |= 0x00003000; 									
  
  // Initial ADC0 (ADCR=0x01210601)    
  ADINTEN = 0;												// Disable ADC Interrupt
  ADCR &= 0x00000000;										// Clear All Bit Control
  ADCR |= 0x00000001;										// Select ADC = AIN0
  ADCR |= 0x00000600;										// ADC Clock = VBP(PCLK) / 7
  ADCR |= 0x00010000;                                      	// Busrt = 1 = Conversion Continue
  ADCR &= 0xFFF1FFFF;										// CLKS = 000 = 10Bit : 11 Cycle Clock Conversion 
  ADCR |= 0x00200000;										// PDN = 1 = Active ADC Module
  ADCR &= 0xFF3FFFFF;										// TEST[1:0] = 00 = Normal Mode
  ADCR &= 0xF7FFFFFF;										// EDGE = 0 = Conversion on Falling Edge  
  ADCR |= 0x01000000;										// START = 001 = Start Conversion Now
    
  // Start Test Read ADC0 and Display on UART0 //
  while(1)													// Loop Continue
  {
    do			  											// Loop Read ADC0
    {
      val = ADDR0;                   						// Read A/D Data Register 
    }        
      while ((val & 0x80000000) == 0);  					// Wait ADC Conversion Complete	 
	  val = (val >> 6) & 0x03FF; 							// Shift ADC Result to Integer	 	        
	  volt = val * 3.3 / 1023.0;	  						// Volt = ADC Result x [3.3V / 1024]	 
	  printf("\rADC0 Result = %1.1f Volt.",volt); 			// Display 3-Digit Result(0-3.3V)
	  delay(10000);
    }
}

/******************************/
/* Initial UART0 = 9600,N,8,1 */
/* VPB(pclk) = 29.4912 MHz    */
/******************************/
void init_serial0 (void)  
{
  PINSEL0 &= 0xFFFFFFF0;									// Reset P0.0,P0.1 Pin Config
  PINSEL0 |= 0x00000001;									// Select P0.0 = TxD(UART0)
  PINSEL0 |= 0x00000004;									// Select P0.1 = RxD(UART0)

  U0LCR &= 0xFC;											// Reset Word Select(1:0)
  U0LCR |= 0x03;											// Data Bit = 8 Bit
  U0LCR &= 0xFB;											// Stop Bit = 1 Bit
  U0LCR &= 0xF7;											// Parity = Disable
  U0LCR &= 0xBF;											// Disable Break Control
  U0LCR |= 0x80;											// Enable Programming of Divisor Latches

  // U0DLM:U0DLL = 29.4912MHz / [16 x Baud]
  //             = 29.4912MHz / [16 x 9600]
  //             = 192 = 0x00C0
  U0DLM = 0x00;												// Program Divisor Latch(192) for 9600 Baud
  U0DLL = 0xC0;

  U0LCR &= 0x7F;											// Disable Programming of Divisor Latches

  U0FCR |= 0x01;											// FIF0 Enable
  U0FCR |= 0x02;											// RX FIFO Reset
  U0FCR |= 0x04;											// TX FIFO Reset
  U0FCR &= 0x3F;                      
}

/****************************/
/* Write Character To UART0 */
/****************************/
int putchar (int ch)  
{                  
  if (ch == '\n')  
  {
    while (!(U0LSR & 0x20));  								// Wait TXD Buffer Empty
    U0THR = 0x0D;                          					// Write CR
  }
  while (!(U0LSR & 0x20));									// Wait TXD Buffer Empty
  return (U0THR = ch);										// Write Character
}

/*****************************/
/* Read Character From UART0 */
/*****************************/
int getchar (void)  
{                    
  while (!(U0LSR & 0x01));									// Wait RXD Receive Data Ready
  return (U0RBR);											// Get Receice Data & Return
}

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay(unsigned long int count1)
{
  while(count1 > 0) {count1--;}								// Loop Decrease Counter	
}



