;/***************************************/;
;/* Example Form For : CP-JR08GP32 V2.0 */;
;/* Controller       : 68H(R)C908GP32   */;
;/* Assembler        : CASM08Z.EXE      */;
;/* File Name        : LCD4BIT.ASM      */;
;/* Write By         : Eakachai Makarn  */;
;/* File Update      : 15-Nov-2002      */;
;/***************************************/;
;/* Character LCD 4Bit Interface (16x2) */;
;/* Print Message on LCD Display (16x2) */;
;/***************************************/;
;
;/***************************************/;
;/* Start of IO Register Address Equate */;
;/* For Processor : MC68H(R)C908GP32    */;
;/***************************************/;
PTA         EQU     $0000                   ; Port-A Data Register
PTB         EQU     $0001                   ; Port-B Data Register
PTC         EQU     $0002                   ; Port-C Data Register
PTD         EQU     $0003                   ; Port-D Data Regsiter
DDRA        EQU     $0004                   ; Port-A Direction Register
DDRB        EQU     $0005                   ; Port-B Direction Register
DDRC        EQU     $0006                   ; Port-C Direction Register
DDRD        EQU     $0007                   ; Port-D Direction Register
PTE         EQU     $0008                   ; Port-E Data Regsiter
DDRE        EQU     $000C                   ; Port-E Direction Register
PTAPUE      EQU     $000D                   ; Port-A Pull-Up Enable Register
PTCPUE      EQU     $000E                   ; Port-C Pull-Up Enable Register
PTDPUE      EQU     $000F                   ; Port-D Pull-Up Enable Register
;
;/* Bit of SPI Control Register
;/* SPCR Bit Address Equate
SPCR        EQU     $0010                   ; SPI Control Register
SPRIE       EQU     $07                     ; R/W
DMAS        EQU     $06                     ; R
SPMSTR      EQU     $05                     ; R/W
CPOL        EQU     $04                     ; R/W
CPHA        EQU     $03                     ; R/W
SPWOM       EQU     $02                     ; R/W
SPE         EQU     $01                     ; R/W
SPTIE       EQU     $00                     ; R/W
;
;/* Bit of SPI Status and Control
;/* SPSCR Bit Address Equate
SPSCR       EQU     $0011                   ; SPI Status and Control Register
SPRF        EQU     $07                     ; R
ERRIE       EQU     $06                     ; R/W
OVRF        EQU     $05                     ; R
MODF        EQU     $04                     ; R
SPTE        EQU     $03                     ; R
MODFEN      EQU     $02                     ; R/W
SPR1        EQU     $01                     ; R/W
SPR0        EQU     $00                     ; R/W
;
SPDR        EQU     $0012                   ; SPI Data Register
;
;/* Bit of SCI Control Register1
;/* SCC1 Bit Address Equate
SCC1        EQU     $0013                   ; SCI Control Register1
LOOPS       EQU     $07                     ; R/W
ENSCI       EQU     $06                     ; R/W
TXINV       EQU     $05                     ; R/W
M           EQU     $04                     ; R/W
WAKE        EQU     $03                     ; R/W
ILTY        EQU     $02                     ; R/W
PEN         EQU     $01                     ; R/W
PTY         EQU     $00                     ; R/W
;
;/* Bit of SCI Control Register2
;/* SCC2 Bit Address Equate
SCC2        EQU     $0014                   ; SCI Control Register2
SCTIE       EQU     $07                     ; R/W
TCIE        EQU     $06                     ; R/W
SCRIE       EQU     $05                     ; R/W
ILIE        EQU     $04                     ; R/W
TE          EQU     $03                     ; R/W
RE          EQU     $02                     ; R/W
RWU         EQU     $01                     ; R/W
SBK         EQU     $00                     ; R/W
;
;/* Bit of SCI Control Register3
;/* SCC3 Bit Address Equate
SCC3        EQU     $0015                   ; SCI Control Register3
R8          EQU     $07                     ; R
T8          EQU     $06                     ; R/W
DMARE       EQU     $05                     ; R/W
DMATE       EQU     $04                     ; R/W
ORIE        EQU     $03                     ; R/W
NEIE        EQU     $02                     ; R/W
FEIE        EQU     $01                     ; R/W
PEIE        EQU     $00                     ; R/W
;
;/* Bit Of SCI Status Register1
;/* SCS1 Bit Address Equate
SCS1        EQU     $0016                   ; SCI Status Register1
SCTE        EQU     $07                     ; R
TC          EQU     $06                     ; R
SCRF        EQU     $05                     ; R
IDLE        EQU     $04                     ; R
OR          EQU     $03                     ; R
NF          EQU     $02                     ; R
FE          EQU     $01                     ; R
PE          EQU     $00                     ; R
;
;/* Bit of SCI Status Register2
;/* SCS2 Bit Address Equate
SCS2        EQU     $0017                   ; SCI Status Register2
BKF         EQU     $01                     ; R
RPF         EQU     $00                     ; R
;
SCDR        EQU     $0018                   ; SCI Data Register
;
;/* Bit of SCI Baudrate Register
;/* SCBR Bit Address Equate
SCBR        EQU     $0019                   ; SCI Baudrate Register
SCP1        EQU     $05                     ; R/W
SCP0        EQU     $04                     ; R/W
SCR2        EQU     $02                     ; R/W
SCR1        EQU     $01                     ; R/W
SCR0        EQU     $00                     ; R/W
;
;/* Bit of Keyboard Status & Control
;/* INTKBSCR Bit Address Equate
INTKBSCR    EQU     $001A                   ; Keyboard Status and Control Register
KEYF        EQU     $03                     ; R
ACKK        EQU     $02                     ; W
IMASKK      EQU     $01                     ; R/W
MODEK       EQU     $00                     ; R/W
;
;/* Bit of Keyboard Interrupt Enable
;/* INTKBIER Bit Address Equate
INTKBIER    EQU     $001B                   ; Keyboard Interrupt Enable Register
KBIE7       EQU     $07                     ; R/W
KBIE6       EQU     $06                     ; R/W
KBIE5       EQU     $05                     ; R/W
KBIE4       EQU     $04                     ; R/W
KBIE3       EQU     $03                     ; R/W
KBIE2       EQU     $02                     ; R/W
KBIE1       EQU     $01                     ; R/W
KBIE0       EQU     $00                     ; R/W
;
;/* Bit of Time Base Module Control
;/* TBCR Bit Address Equate
TBCR        EQU     $001C                   ; Time Base Module Control Register
TBIF        EQU     $07                     ; R
TBR2        EQU     $06                     ; R/W
TBR1        EQU     $05                     ; R/W
TBR0        EQU     $04                     ; R/W
TACK        EQU     $03                     ; W
TBIE        EQU     $02                     ; R/W
TBON        EQU     $01                     ; R/W
;
;/* Bit of IRQ Status & Control
;/* INTSCR Bit Address Equate
INTSCR      EQU     $001D                   ; IRQ Status and Control Register
IRQF1       EQU     $03                     ; R
ACK1        EQU     $02                     ; W
IMASK1      EQU     $01                     ; R/W
MODE1       EQU     $00                     ; R/W
;
;/* Bit of Config Register2
;/* CONFIG2 Bit Address Equate
CONFIG2     EQU     $001E                   ; Config Register2
OSCSTOPENB  EQU     $01                     ; R/W
SCIBDSRC    EQU     $00                     ; R/W
;
;/* Bit of Config Register1
;/* CONFIG1 Bit Address Equate
CONFIG1     EQU     $001F                   ; Config Register1
COPRS       EQU     $07                     ; R/W
LVISTOP     EQU     $06                     ; R/W
LVIRSTD     EQU     $05                     ; R/W
LVIPWRD     EQU     $04                     ; R/W
LVI5OR3     EQU     $03                     ; R/W
SSREC       EQU     $02                     ; R/W
STOP        EQU     $01                     ; R/W
COPD        EQU     $00                     ; R/W
;
;/* Bit of Timer Status & Control
;/* TxSC Bit Address Equate
T1SC        EQU     $0020                   ; TIM1 Status & Control Register
T2SC        EQU     $002B                   ; TIM2 Status & Control Register
TOF         EQU     $07                     ; R
TOIE        EQU     $06                     ; R/W
TSTOP       EQU     $05                     ; R/W
TRST        EQU     $04                     ; W
PS2         EQU     $02                     ; R/W
PS1         EQU     $01                     ; R/W
PS0         EQU     $00                     ; R/W
;
;/* Bit of Timer CH0 Status & Control Register
;/* TxSC0 Bit Address Equate
T1SC0       EQU     $0025                   ; TIM1 CH0 Status & Control Register
T2SC0       EQU     $0030                   ; TIM2 CH0 Status & Control Register
CH0F        EQU     $07                     ; R/W
CH0IE       EQU     $06                     ; R/W
MS0B        EQU     $05                     ; R/W
MS0A        EQU     $04                     ; R/W
ELS0B       EQU     $03                     ; R/W
ELS0A       EQU     $02                     ; R/W
TOV0        EQU     $01                     ; R/W
CH0MAX      EQU     $00                     ; R/W
;
;/* Bit of Timer CH1 Status & Control Register
;/* TxSC1 Bit Address Equate
T1SC1       EQU     $0028                   ; TIM1 CH1 Status & Control Register
T2SC1       EQU     $0033                   ; TIM2 CH1 Status & Control Register
CH1F        EQU     $07                     ; R/W
CH1IE       EQU     $06                     ; R/W
MS1A        EQU     $04                     ; R/W
ELS1B       EQU     $03                     ; R/W
ELS1A       EQU     $02                     ; R/W
TOV1        EQU     $01                     ; R/W
CH1MAX      EQU     $00                     ; R/W
;
T1CNTH      EQU     $0021                   ; TIM1 Counter High Register
T1CNTL      EQU     $0022                   ; TIM1 Counter Low Register
T1MODH      EQU     $0023                   ; TIM1 Counter Modulo High Register
T1MODL      EQU     $0024                   ; TIM1 Counter Modulo Low Register
T1CH0H      EQU     $0026                   ; TIM1 CH0 High Register
T1CH0L      EQU     $0027                   ; TIM1 CH0 Low Register
T1CH1H      EQU     $0029                   ; TIM1 CH1 High Register
T1CH1L      EQU     $002A                   ; TIM1 CH1 Low Register
T2CNTH      EQU     $002C                   ; TIM2 Counter High Register
T2CNTL      EQU     $002D                   ; TIM2 Counter Low Register
T2MODH      EQU     $002E                   ; TIM2 Counter Modulo High Register
T2MODL      EQU     $002F                   ; TIM2 Counter Modulo Low Register
T2CH0H      EQU     $0031                   ; TIM2 CH0 High Register
T2CH0L      EQU     $0032                   ; TIM2 CH0 Low Register
T2CH1H      EQU     $0034                   ; TIM2 CH1 High Register
T2CH1L      EQU     $0035                   ; TIM2 CH1 Low Register
;
;/* Bit of PLL Control Register
;/* PCTL Bit Address Equate
PCTL        EQU     $0036                   ; PLL Control Register
PLLIE       EQU     $07                     ; R/W
PLLF        EQU     $06                     ; R
PLLON       EQU     $05                     ; R/W
BCS         EQU     $04                     ; R/W
PRE1        EQU     $03                     ; R/W
PRE0        EQU     $02                     ; R/W
VPR1        EQU     $01                     ; R/W
VPR0        EQU     $00                     ; R/W
;
;/* Bit of PLL Bandwidth Control Register
;/* PBWC Bit Address Equate
PBWC        EQU     $0037                   ; PLL Bandwidth Control Register
AUTO        EQU     $07                     ; R/W
LOCK        EQU     $06                     ; R
ACQ         EQU     $05                     ; R/W
;
;/* Bit of PLL Multiply Select High
;/* PMSH Bit Address Equate
PMSH        EQU     $0038                   ; PLL Multiply Select High Register
MUL11       EQU     $03                     ; R/W
MUL10       EQU     $02                     ; R/W
MUL9        EQU     $01                     ; R/W
MUL8        EQU     $00                     ; R/W
;
;/* Bit of Multiply Select Low
;/* PMSL Bit Address Equate
PMSL        EQU     $0039                   ; PLL Multiply Select Low Register
MUL7        EQU     $07                     ; R/W
MUL6        EQU     $06                     ; R/W
MUL5        EQU     $05                     ; R/W
MUL4        EQU     $04                     ; R/W
MUL3        EQU     $03                     ; R/W
MUL2        EQU     $02                     ; R/W
MUL1        EQU     $01                     ; R/W
MUL0        EQU     $00                     ; R/W
;
;/* Bit of PLL VCO Select Range
;/* PMRS Bit Address Equate
PMRS        EQU     $003A                   ; PLL VCO Select Range Register
VRS7        EQU     $07                     ; R/W
VRS6        EQU     $06                     ; R/W
VRS5        EQU     $05                     ; R/W
VRS4        EQU     $04                     ; R/W
VRS3        EQU     $03                     ; R/W
VRS2        EQU     $02                     ; R/W
VRS1        EQU     $01                     ; R/W
VRS0        EQU     $00                     ; R/W
;
;/* Bit of PLL Reference Divider Select
;/* PMDS Bit Address Equate
PMDS        EQU     $003B                   ; PLL Reference Divider Select Register
RDS3        EQU     $03                     ; R/W
RDS2        EQU     $02                     ; R/W
RDS1        EQU     $01                     ; R/W
RDS0        EQU     $00                     ; R/W
;
;/* Bit of ADC Status & Control
;/* ADSCR Bit Address Equate
ADSCR       EQU     $003C                   ; ADC Status & Control Register
COCO        EQU     $07                     ; R/W
AIEN        EQU     $06                     ; R/W
ADCO        EQU     $05                     ; R/W
ADCH4       EQU     $04                     ; R/W
ADCH3       EQU     $03                     ; R/W
ADCH2       EQU     $02                     ; R/W
ADCH1       EQU     $01                     ; R/W
ADCH0       EQU     $00                     ; R/W
;
ADR         EQU     $003D                   ; ADC Data Register
;
;/* Bit of ADC Clock Register
;/* ADCLK Bit Address Equate
ADCLK       EQU     $003E                   ; ADC Clock Register
ADIV2       EQU     $07                     ; R/W
ADIV1       EQU     $06                     ; R/W
ADIV0       EQU     $05                     ; R/W
ADICLK      EQU     $04                     ; R/W
;
;/* Bit of SIM Break Status Register
;/* SBSR Bit Address Equate
SBSR        EQU     $FE00                   ; SIM Break Status Register
SBSW        EQU     $01                     ; R
;
;/* Bit of SIM Reset Status Register
;/* SRSR Bit Address Equate
SRSR        EQU     $FE01                   ; SIM Reset Status Register
POR         EQU     $07                     ; R/W
PIN         EQU     $06                     ; R/W
COP         EQU     $05                     ; R/W
ILOP        EQU     $04                     ; R/W
ILAD        EQU     $03                     ; R/W
MODRST      EQU     $02                     ; R/W
LVI         EQU     $01                     ; R/W
;
SUBAR       EQU     $FE02                   ; SIM Upper Byte Address Register
;
;/* Bit of SIM Break Flag Control
;/* SBFCR Bit Address Equate
SBFCR       EQU     $FE03                   ; SIM Break Flag Control Register
BCFE        EQU     $07                     ; R/W
;
;/* Bit of Interrupt Status Register1
;/* INT1 Bit Address Equate
INT1        EQU     $FE04                   ; Interrupt Status1 Register
IF6         EQU     $07                     ; R
IF5         EQU     $06                     ; R
IF4         EQU     $05                     ; R
IF3         EQU     $04                     ; R
IF2         EQU     $03                     ; R
IF1         EQU     $02                     ; R
;
;/* Bit of Interrupt Status Register2
;/* INT2 Bit Address Equate
INT2        EQU     $FE05                   ; Interrupt Status2 Register
IF14        EQU     $07                     ; R
IF13        EQU     $06                     ; R
IF12        EQU     $05                     ; R
IF11        EQU     $04                     ; R
IF10        EQU     $03                     ; R
IF9         EQU     $02                     ; R
IF8         EQU     $01                     ; R
IF7         EQU     $00                     ; R
;
;/* Bit of Interrupt Status Register3
;/* INT3 Bit Address Equate Equate
INT3        EQU     $FE06                   ; Interrupt Status3 Register
IF16        EQU     $01                     ; R
IF15        EQU     $00                     ; R
;
;/* Bit of Flash Control Register
;/* FLCR Bit Address Equate
FLCR        EQU     $FE08                   ; Flash Control Register
HVEN        EQU     $03                     ; R/W
MASS        EQU     $02                     ; R/W
ERASE       EQU     $01                     ; R/W
PGM         EQU     $00                     ; R/W
;
BRKH        EQU     $FE09                   ; Break Address High Register
BRKL        EQU     $FE0A                   ; Break Address Low Register
;
;/* Bit of Break Status & Control Register
;/* BRKSCR Bit Address Equate
BRKSCR      EQU     $FE0B                   ; Break Status and Control Register
BRKE        EQU     $07                     ; R/W
BRKA        EQU     $06                     ; R/W
;
;/* Bit of LVI Status Register
;/* LVISR Bit Address Equate
LVISR       EQU     $FE0C                   ; LVI Status Register
LVIOUT      EQU     $07                     ; R/W
;
;/* Bit of Flash Block Protect
;/* FLBPR Bit Address Equate
FLBPR       EQU     $FF7E                   ; Flash Block Protect Register
BPR7        EQU     $07                     ; R/W
BPR6        EQU     $06                     ; R/W
BPR5        EQU     $05                     ; R/W
BPR4        EQU     $04                     ; R/W
BPR3        EQU     $03                     ; R/W
BPR2        EQU     $02                     ; R/W
BPR1        EQU     $01                     ; R/W
BPR0        EQU     $00                     ; R/W
COPCTL      EQU     $FFFF                   ; Reset COP Register
;/*************************************/;
;/* End of IO Register Address Equate */;
;/* For Processor : MC68H(R)C908GP32  */;
;/*************************************/;

;/*************************************/;
;/* Start of Equate Hardware I/O Bit  */;
;/* For Standard Board : CP-JR08GP32  */;
;/*************************************/;
;
;/****************************/;
;/* LCD Interface With 4-Bit */;
;/* EN-LCD = PTC2            */;
;/* RS-LCD = PTC4            */;
;/* D4-LCD = PTD0            */;
;/* D5-LCD = PTD1            */;
;/* D6-LCD = PTD2            */;
;/* D7-LCD = PTD3            */;
;/* RW,D0..D3 of LCD = GND   */;
;/****************************/;
DATA_LCD    EQU     PTD                     ; PORTD = Data LCD
DLCD_DIR    EQU     DDRD                    ; Direction For Data LCD
CTRL_LCD    EQU     PTC                     ; PORTC = Control LCD
CLCD_DIR    EQU     DDRC                    ; Direction For Control LCD
EN_LCD      EQU     02H                     ; PTC2
RS_LCD      EQU     04H                     ; PTC4
D4_LCD      EQU     00H                     ; PTD0
D5_LCD      EQU     01H                     ; PTD1
D6_LCD      EQU     02H                     ; PTD2
D7_LCD      EQU     03H                     ; PTD3
;
;/*************************************/;
;/*  End of Equate Hardware I/O Bit   */;
;/* For Standard Board : CP-JR08GP32  */;
;/*************************************/;


            ;/*******************************/;
            ;/* Usercode Program Start Here */;
            ;/* $8000-$FDFF = User Code     */;
            ;/* $FFDC-$FFFF = User Vector   */;
            ;/*******************************/;
            ORG     $8000                   ; Start Main (68HC908GP32 : $8000-$FDFF)
$BASE       10T                             ; Defualt System Number to Decimal
RESET:      BSET    0,CONFIG1               ; Disable COP Watch-Dog
            BSET    0,CONFIG2               ; SCI Baudrate Select From Internal Clock Bus
            LDHX    #$0240                  ; Last Address RAM = Stack (H:X=$0240)
            TXS                             ; [(H:X-1) -> SP] (SP = $023F)
            ;
            ;/*******************************/;
            ;/* Initial  PLL  For Clock Bus */;
            ;/* External X-TAL = 32.768 KHz */;
            ;/* Clock Bus Freq = 7.3728 MHz */;
            ;/*******************************/;
            ;
            BCLR    BCS,PCTL                ; Select External Clock
            BCLR    PLLON,PCTL              ; Turn-off PLL
            BCLR    PRE1,PCTL               ; P = 0
            BCLR    PRE0,PCTL
            BSET    VPR1,PCTL               ; E = 2
            BCLR    VPR0,PCTL
            MOV     #$01,PMDS               ; R = $01
            MOV     #$03,PMSH               ; N = $0384
            MOV     #$84,PMSL
            MOV     #$C0,PMRS               ; L = $C0
            LDA     PCTL                    ; Clear Status
            BSET    AUTO,PBWC               ; Auto Bandwidth Control
            BSET    PLLON,PCTL              ; Turn-on PLL
            BRCLR   LOCK,PBWC,*             ; Wait For PLL Lock Complete
            BSET    BCS,PCTL                ; Select PLL Output as Base Clock
            ;
            ;/*******************************/;
            ; Other User Program Start Here */;
            ;/*******************************/;
            ;
            ;/* Initial LCD Signal Direction */;
            BSET    RS_LCD,CLCD_DIR         ; Control LCD = Output
            BSET    EN_LCD,CLCD_DIR
            BSET    D4_LCD,DLCD_DIR         ; Data LCD = Output
            BSET    D5_LCD,DLCD_DIR
            BSET    D6_LCD,DLCD_DIR
            BSET    D7_LCD,DLCD_DIR
            ;
            ;/* Initial LCD Signal Logic */;
            BCLR    EN_LCD,CTRL_LCD         ; Initial Signal LCD
            BSET    RS_LCD,CTRL_LCD
            BSET    D4_LCD,DATA_LCD
            BSET    D5_LCD,DATA_LCD
            BSET    D6_LCD,DATA_LCD
            BSET    D7_LCD,DATA_LCD
            JSR     INIT_LCD                ; Initial 4-Bit LCD
            ;
            ;
            ;/************************************/;
            ;/* Print Data to Character LCD 16x2 */;
            ;/************************************/;
            ;
TEST_LCD:   LDA     #$00                    ; Start Cursor Line1
            JSR     GOTO_LCD
            JSR     PRINT_LCD
            DB      'Example 4Bit LCD',$00
            LDA     #$40                    ; Start Cursor Line2
            JSR     GOTO_LCD
            JSR     PRINT_LCD
            DB      'CP-JR08GP32 V2.0',$00
            ;
            LDA     #250                    ; Delay 2 Second
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            ;
            LDA     #$00                    ; Start Cursor Line1
            JSR     GOTO_LCD
            JSR     PRINT_LCD
            DB      'CP-JR08GP32 V2.0',$00
            LDA     #$40                    ; Start Cursor Line2
            JSR     GOTO_LCD
            JSR     PRINT_LCD
            DB      'Example 4Bit LCD',$00
            ;
            LDA     #250                    ; Delay 2 Second
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            LDA     #250
            JSR     DLY_MSEC
            ;
            JMP     TEST_LCD                 ; Loop Test

;/********************/;
;/* Initial Char LCD */;
;/* 4-Bit Interface  */;
;/* RS    = Bit-3    */;
;/* EN    = Bit-2    */;
;/* D4..7 = Bit-0..3 */;
;/********************/;
;
INIT_LCD:   LDA     #33H                    ; DL = 1 ,DL =1
            JSR     WR_INS
            LDA     #32H                    ; DL = 1 ,DL =0
            JSR     WR_INS
            LDA     #28H                    ; Function set
            JSR     WR_INS                  ; DL=0(4Bit),N=1(2Line),F=0(5X7)
            LDA     #0CH                    ; Display on/off Control
            JSR     WR_INS                  ; Entry Display,Cursor off,Not Blink
            LDA     #06H                    ; Entry Mode Set
            JSR     WR_INS                  ; I/D=1 Increment,S=0 Cursor Shift
CLR_LCD:    LDA     #01H                    ; Clear Display
            JSR     WR_INS                  ; Clear Display,Set DD RAM Addr=0
            RTS

;/**********************/;
;/* Enable Pin EN CLCD */;
;/* Pin EN LCD = Bit-2 */;
;/* Active Chip select */;
;/**********************/;
;
ENA_LCD:    JSR     BUSY                    ; Busy Delay
            BSET    EN_LCD,CTRL_LCD         ; Enable Chips Select
            ;
            ;/* Delay 10uS (76-Cycle)
            PSHX                            ; 2 Cycle
            LDX     #18                     ; 2 Cycle
ENA_LCD0:   NOP                             ; 1 Cycle
            DBNZX   ENA_LCD0                ; 3 Cycle (18x4 = 72)
            PULX                            ; 2 Cycle
            ;
            BCLR    EN_LCD,CTRL_LCD         ; Disable Chips Select
            RTS

;/*******************/;
;/* Busy CLCD Delay */;
;/* Default = 100uS */;
;/* Fbus = 7.3728Hz */;
;/* 100uS = 737Cycle*/;
;/*******************/;
;
BUSY:       PSHX                            ; 2 Cycle
            LDX     #182                    ; 2 Cycle
BUSY1:      NOP                             ; 1 Cycle
            DBNZX   BUSY1                   ; 3 Cycle (182x4 =728)
            PULX                            ; 2 Cycle
            RTS                             ; 4 Cycle

;/**********************/;
;/* Write ASCII to LCD */;
;/* Input : ACC(ASCII) */;
;/**********************/;
;
WR_LCD:     PSHA                            ; Save ACC(ASCII)
            TPA                             ; CCR -> ACC
            PSHA                            ; Save CCR
            ;
            ;/* Send High Nibble */;
            LDA     2,SP                    ; Get ACC(ASCII)
            AND     #$F0                    ; High Nibble
            NSA                             ; Nibble Swap A (D7..D4 <-> D3..D0)
            BCLR    D4_LCD,DATA_LCD         ; Clear old Signal
            BCLR    D5_LCD,DATA_LCD
            BCLR    D6_LCD,DATA_LCD
            BCLR    D7_LCD,DATA_LCD
            ;
            ;/* Update D4-LCD */;
            LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_LCD01
            BSET    D4_LCD,DATA_LCD
            ;
            ;/* Update D5-LCD */;
WR_LCD01:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_LCD02
            BSET    D5_LCD,DATA_LCD
            ;
            ;/* Update D6-LCD */;
WR_LCD02:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_LCD03
            BSET    D6_LCD,DATA_LCD
            ;
            ;/* Update D7-LCD */;
WR_LCD03:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_LCD04
            BSET    D7_LCD,DATA_LCD
            ;
            ;/* Strobe High Nibble Data */;
WR_LCD04:   BSET    RS_LCD,CTRL_LCD         ; Set RS For Write Data Select
            JSR     ENA_LCD
            ;
            ;/* Send Low Nibble */;
            LDA     2,SP                    ; Get ACC (ASCII)
            AND     #$0F                    ; Low Nibble
            BCLR    D4_LCD,DATA_LCD         ; Clear old Signal
            BCLR    D5_LCD,DATA_LCD
            BCLR    D6_LCD,DATA_LCD
            BCLR    D7_LCD,DATA_LCD
            ;
            ;/* Update D4-LCD */;
            LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_LCD05
            BSET    D4_LCD,DATA_LCD
            ;
            ;/* Update D5-LCD */;
WR_LCD05:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_LCD06
            BSET    D5_LCD,DATA_LCD
            ;
            ;/* Update D6-LCD */;
WR_LCD06:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_LCD07
            BSET    D6_LCD,DATA_LCD
            ;
            ;/* Update D7-LCD */;
WR_LCD07:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_LCD08
            BSET    D7_LCD,DATA_LCD
            ;
            ;/* Strobe Low Nibble Data */;
WR_LCD08:   BSET    RS_LCD,CTRL_LCD         ; Set RS For Write Data Select
            JSR     ENA_LCD
            ;
            PULA                            ; Restore CCR
            TAP                             ; ACC -> CCR
            PULA                            ; Restore ACC(ASCII)
            RTS

;/**************************/;
;/* Write Instruction LCD  */;
;/* Input  : ACC (Command) */;
;/* Output : Data bus LCD  */;
;/**************************/;
;
WR_INS:     PSHA                            ; Save ACC(Command)
            TPA                             ; CCR -> ACC
            PSHA                            ; Save CCR
            ;
            ;/* Send High Nibble */;
            LDA     2,SP                    ; Get ACC(Command)
            AND     #$F0                    ; High Nibble
            NSA                             ; Nibble Swap A (D7..D4 <-> D3..D0)
            BCLR    D4_LCD,DATA_LCD         ; Clear old Signal
            BCLR    D5_LCD,DATA_LCD
            BCLR    D6_LCD,DATA_LCD
            BCLR    D7_LCD,DATA_LCD
            ;
            ;/* Update D4-LCD */;
            LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_INS01
            BSET    D4_LCD,DATA_LCD
            ;
            ;/* Update D5-LCD */;
WR_INS01:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_INS02
            BSET    D5_LCD,DATA_LCD
            ;
            ;/* Update D6-LCD */;
WR_INS02:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_INS03
            BSET    D6_LCD,DATA_LCD
            ;
            ;/* Update D7-LCD */;
WR_INS03:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_INS04
            BSET    D7_LCD,DATA_LCD
            ;
            ;/* Strobe High Nibble Command */;
WR_INS04:   BCLR    RS_LCD,CTRL_LCD         ; Clear RS For Write Instruction
            JSR     ENA_LCD
            ;
            ;/* Send Low Nibble */;
            LDA     2,SP                    ; Get ACC (Command)
            AND     #$0F                    ; Low Nibble
            BCLR    D4_LCD,DATA_LCD         ; Clear old Signal
            BCLR    D5_LCD,DATA_LCD
            BCLR    D6_LCD,DATA_LCD
            BCLR    D7_LCD,DATA_LCD
            ;
            ;/* Update D4-LCD */;
            LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_INS05
            BSET    D4_LCD,DATA_LCD
            ;
            ;/* Update D5-LCD */;
WR_INS05:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_INS06
            BSET    D5_LCD,DATA_LCD
            ;
            ;/* Update D6-LCD */;
WR_INS06:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_INS07
            BSET    D6_LCD,DATA_LCD
            ;
            ;/* Update D7-LCD */;
WR_INS07:   LSRA                            ; [0] -> [ACC] -> [CY]
            BCC     WR_INS08
            BSET    D7_LCD,DATA_LCD
            ;
            ;/* Strobe Low Nibble Command */;
WR_INS08:   BCLR    RS_LCD,CTRL_LCD         ; Clear RS For Write Instruction
            JSR     ENA_LCD
            ;
            LDA     #2                      ; Wait Command Ready = 2mS
            JSR     DLY_MSEC
            ;
            PULA                            ; Restore CCR
            TAP                             ; ACC -> CCR
            PULA                            ; Restore ACC(Command)
            RTS

;/************************/;
;/* Goto position of LCD */;
;/* Input : ACC (addr.)  */;
;/************************/;
;
GOTO_LCD:   ORA     #$80                    ; Set ACC.7
            JSR     WR_INS
            RTS

;/********************************/;
;/* Print ASCII Data to LCD Port */;
;/* Usage    : JSR  PRINT_LCD    */;
;/*          : DB   'xxxxxxxx'   */;
;/*          : DB   $00          */;
;/* Note     : Last Byte = $00   */;
;/********************************/;
;
PRINT_LCD:  PULH                        ; Pop Stack PCH
            PULX                        ; Pop Stack PCL
            PSHA                        ; Save ACC
            ;
PRN_LCD1:   LDA     0,X                 ; Get Data For Print
            BEQ     PRN_LCD2            ; If Last Byte Jump
            JSR     WR_LCD              ; Write Data to LCD
            AIX     #1                  ; Inc (H:X)
            BRA     PRN_LCD1
            ;
PRN_LCD2:   AIX     #1                  ; Skip Last Byte(00)
            ;
            PULA                        ; Restore ACC
            PSHX                        ; Push PCL to Stack
            PSHH                        ; Push PCH to Stack
            RTS

;/*******************/;
;/* Delay Time 1 mS */;
;/* Fbus = 7.372 MHz*/;
;/* 1mS = 7373 Cycle*/;
;/* Input : A (mSec)*/;
;/*******************/;
;
DLY_MSEC:   PSHH                            ; Save Register (2 Cycle)
            PSHX                            ; 2 Cycle
            ;
DLY_MS0:    LDHX    #816                    ; 3 Cycle
DLY_MS1:    NOP                             ; 1 Cycle
            AIX     #-1                     ; H:X - 1 (2 Cycle)
            CPHX    #0                      ; 3 Cycle
            BNE     DLY_MS1                 ; 3 Cycle ( 9 x 886 = 7344 Cycle)
            DBNZA   DLY_MS0                 ; 3 Cycle
            ;
            PULX                            ; 2 Cycle
            PULH                            ; 2 Cycle
            RTS                             ; 4 Cycle


            ;/**************************/;
            ;/* User Vector Start Here */;
            ;/*     2 Byte / Vector    */;
            ;/**************************/;
            ;/* ORG $Vector  Address   */;
            ;/* DW  $Routine Address   */;
            ;/**************************/;
            ORG     $FFFE                   ; User Reset Vector
            DW      RESET                   ; Start Program Address

            END
