;/***************************************/;
;/* Registers Equate : MC68H(R)C908GP32)*/;
;/* Write By         : Eakachai Makarn  */;
;/*                  : ETT CO.,LTD      */;
;/*                  : WWW.ETT.CO.TH    */;
;/***************************************/;
;
;/***************************************/;
;/* Start of IO Register Address Equate */;
;/* For Processor : MC68H(R)C908GP32    */;
;/***************************************/;
PTA         EQU     $0000                   ; Port-A Data Register
PTB         EQU     $0001                   ; Port-B Data Register
PTC         EQU     $0002                   ; Port-C Data Register
PTD         EQU     $0003                   ; Port-D Data Regsiter
DDRA        EQU     $0004                   ; Port-A Direction Register
DDRB        EQU     $0005                   ; Port-B Direction Register
DDRC        EQU     $0006                   ; Port-C Direction Register
DDRD        EQU     $0007                   ; Port-D Direction Register
PTE         EQU     $0008                   ; Port-E Data Regsiter
DDRE        EQU     $000C                   ; Port-E Direction Register
PTAPUE      EQU     $000D                   ; Port-A Pull-Up Enable Register
PTCPUE      EQU     $000E                   ; Port-C Pull-Up Enable Register
PTDPUE      EQU     $000F                   ; Port-D Pull-Up Enable Register
SPCR        EQU     $0010                   ; SPI Control Register
SPSCR       EQU     $0011                   ; SPI Status and Control Register
SPDR        EQU     $0012                   ; SPI Data Register
SCC1        EQU     $0013                   ; SCI Control Register1
SCC2        EQU     $0014                   ; SCI Control Register2
SCC3        EQU     $0015                   ; SCI Control Register3
SCS1        EQU     $0016                   ; SCI Status Register1
SCS2        EQU     $0017                   ; SCI Status Register2
SCDR        EQU     $0018                   ; SCI Data Register
SCBR        EQU     $0019                   ; SCI Baudrate Register
INTKBSCR    EQU     $001A                   ; Keyboard Status and Control Register
INTKBIER    EQU     $001B                   ; Keyboard Interrupt Enable Register
TBCR        EQU     $001C                   ; Time Base Module Control Register
INTSCR      EQU     $001D                   ; IRQ Status and Control Register
CONFIG2     EQU     $001E                   ; Config Register2
CONFIG1     EQU     $001F                   ; Config Register1
T1SC        EQU     $0020                   ; TIM1 Status & Control Register
T1CNTH      EQU     $0021                   ; TIM1 Counter High Register
T1CNTL      EQU     $0022                   ; TIM1 Counter Low Register
T1MODH      EQU     $0023                   ; TIM1 Counter Modulo High Register
T1MODL      EQU     $0024                   ; TIM1 Counter Modulo Low Register
T1SC0       EQU     $0025                   ; TIM1 CH0 Status & Control Register
T1CH0H      EQU     $0026                   ; TIM1 CH0 High Register
T1CH0L      EQU     $0027                   ; TIM1 CH0 Low Register
T1SC1       EQU     $0028                   ; TIM1 CH1 Status & Control Register
T1CH1H      EQU     $0029                   ; TIM1 CH1 High Register
T1CH1L      EQU     $002A                   ; TIM1 CH1 Low Register
T2SC        EQU     $002B                   ; TIM2 Status & Control Register
T2CNTH      EQU     $002C                   ; TIM2 Counter High Register
T2CNTL      EQU     $002D                   ; TIM2 Counter Low Register
T2MODH      EQU     $002E                   ; TIM2 Counter Modulo High Register
T2MODL      EQU     $002F                   ; TIM2 Counter Modulo Low Register
T2SC0       EQU     $0030                   ; TIM2 CH0 Status & Control Register
T2CH0H      EQU     $0031                   ; TIM2 CH0 High Register
T2CH0L      EQU     $0032                   ; TIM2 CH0 Low Register
T2SC1       EQU     $0033                   ; TIM2 CH1 Status & Control Register
T2CH1H      EQU     $0034                   ; TIM2 CH1 High Register
T2CH1L      EQU     $0035                   ; TIM2 CH1 Low Register
PCTL        EQU     $0036                   ; PLL Control Register
PBWC        EQU     $0037                   ; PLL Bandwidth Control Register
PMSH        EQU     $0038                   ; PLL Multiply Select High Register
PMSL        EQU     $0039                   ; PLL Multiply Select Low Register
PMRS        EQU     $003A                   ; PLL VCO Select Range Register
PMDS        EQU     $003B                   ; PLL Reference Divider Select Register
ADSCR       EQU     $003C                   ; ADC Status & Control Register
ADR         EQU     $003D                   ; ADC Data Register
ADCLK       EQU     $003E                   ; ADC Clock Register
SBSR        EQU     $FE00                   ; SIM Break Status Register
SRSR        EQU     $FE01                   ; SIM Reset Status Register
SUBAR       EQU     $FE02                   ; SIM Upper Byte Address Register
SBFCR       EQU     $FE03                   ; SIM Break Flag Control Register
INT1        EQU     $FE04                   ; Interrupt Status1 Register
INT2        EQU     $FE05                   ; Interrupt Status2 Register
INT3        EQU     $FE06                   ; Interrupt Status3 Register
FLCR        EQU     $FE08                   ; Flash Control Register
BRKH        EQU     $FE09                   ; Break Address High Register
BRKL        EQU     $FE0A                   ; Break Address Low Register
BRKSCR      EQU     $FE0B                   ; Break Status and Control Register
LVISR       EQU     $FE0C                   ; LVI Status Register
FLBPR       EQU     $FF7E                   ; Flash Block Protect Register
COPCTL      EQU     $FFFF                   ; Reset COP Register
;/*************************************/;
;/* End of IO Register Address Equate */;
;/* For Processor : MC68H(R)C908GP32  */;
;/*************************************/;
;
;
;
;/************************************/;
;/* Start of IO Register Bit Equate  */;
;/* For Processor : MC68H(R)C908GP32 */;
;/************************************/;
;
;/* Bit of SPI Control Register
;/* SPCR Bit Address Equate
SPRIE       EQU     $07                     ; R/W
DMAS        EQU     $06                     ; R
SPMSTR      EQU     $05                     ; R/W
CPOL        EQU     $04                     ; R/W
CPHA        EQU     $03                     ; R/W
SPWOM       EQU     $02                     ; R/W
SPE         EQU     $01                     ; R/W
SPTIE       EQU     $00                     ; R/W
;
;/* Bit of SPI Status and Control
;/* SPSCR Bit Address Equate
SPRF        EQU     $07                     ; R
ERRIE       EQU     $06                     ; R/W
OVRF        EQU     $05                     ; R
MODF        EQU     $04                     ; R
SPTE        EQU     $03                     ; R
MODFEN      EQU     $02                     ; R/W
SPR1        EQU     $01                     ; R/W
SPR0        EQU     $00                     ; R/W
;
;/* Bit of SCI Control Register1
;/* SCC1 Bit Address Equate
LOOPS       EQU     $07                     ; R/W
ENSCI       EQU     $06                     ; R/W
TXINV       EQU     $05                     ; R/W
M           EQU     $04                     ; R/W
WAKE        EQU     $03                     ; R/W
ILTY        EQU     $02                     ; R/W
PEN         EQU     $01                     ; R/W
PTY         EQU     $00                     ; R/W
;
;/* Bit of SCI Control Register2
;/* SCC2 Bit Address Equate
SCTIE       EQU     $07                     ; R/W
TCIE        EQU     $06                     ; R/W
SCRIE       EQU     $05                     ; R/W
ILIE        EQU     $04                     ; R/W
TE          EQU     $03                     ; R/W
RE          EQU     $02                     ; R/W
RWU         EQU     $01                     ; R/W
SBK         EQU     $00                     ; R/W
;
;/* Bit of SCI Control Register3
;/* SCC3 Bit Address Equate
R8          EQU     $07                     ; R
T8          EQU     $06                     ; R/W
DMARE       EQU     $05                     ; R/W
DMATE       EQU     $04                     ; R/W
ORIE        EQU     $03                     ; R/W
NEIE        EQU     $02                     ; R/W
FEIE        EQU     $01                     ; R/W
PEIE        EQU     $00                     ; R/W
;
;/* Bit Of SCI Status Register1
;/* SCS1 Bit Address Equate
SCTE        EQU     $07                     ; R
TC          EQU     $06                     ; R
SCRF        EQU     $05                     ; R
IDLE        EQU     $04                     ; R
OR          EQU     $03                     ; R
NF          EQU     $02                     ; R
FE          EQU     $01                     ; R
PE          EQU     $00                     ; R
;
;/* Bit of SCI Status Register2
;/* SCS2 Bit Address Equate
BKF         EQU     $01                     ; R
RPF         EQU     $00                     ; R
;
;/* Bit of SCI Baudrate Register
;/* SCBR Bit Address Equate
SCP1        EQU     $05                     ; R/W
SCP0        EQU     $04                     ; R/W
SCR2        EQU     $02                     ; R/W
SCR1        EQU     $01                     ; R/W
SCR0        EQU     $00                     ; R/W
;
;/* Bit of Keyboard Status & Control
;/* INTKBSCR Bit Address Equate
KEYF        EQU     $03                     ; R
ACKK        EQU     $02                     ; W
IMASKK      EQU     $01                     ; R/W
MODEK       EQU     $00                     ; R/W
;
;/* Bit of Keyboard Interrupt Enable
;/* INTKBIER Bit Address Equate
KBIE7       EQU     $07                     ; R/W
KBIE6       EQU     $06                     ; R/W
KBIE5       EQU     $05                     ; R/W
KBIE4       EQU     $04                     ; R/W
KBIE3       EQU     $03                     ; R/W
KBIE2       EQU     $02                     ; R/W
KBIE1       EQU     $01                     ; R/W
KBIE0       EQU     $00                     ; R/W
;
;/* it of Time Base Module Control
;/* TBCR Bit Address Equate
TBIF        EQU     $07                     ; R
TBR2        EQU     $06                     ; R/W
TBR1        EQU     $05                     ; R/W
TBR0        EQU     $04                     ; R/W
TACK        EQU     $03                     ; W
TBIE        EQU     $02                     ; R/W
TBON        EQU     $01                     ; R/W
;
;/* Bit of IRQ Status & Control
;/* INTSCR Bit Address Equate
IRQF1       EQU     $03                     ; R
ACK1        EQU     $02                     ; W
IMASK1      EQU     $01                     ; R/W
MODE1       EQU     $00                     ; R/W
;
;/* Bit of Config Register2
;/* CONFIG2 Bit Address Equate
OSCSTOPENB  EQU     $01                     ; R/W
SCIBDSRC    EQU     $00                     ; R/W
;
;/* Bit of Config Register1
;/* CONFIG1 Bit Address Equate
COPRS       EQU     $07                     ; R/W
LVISTOP     EQU     $06                     ; R/W
LVIRSTD     EQU     $05                     ; R/W
LVIPWRD     EQU     $04                     ; R/W
LVI5OR3     EQU     $03                     ; R/W
SSREC       EQU     $02                     ; R/W
STOP        EQU     $01                     ; R/W
COPD        EQU     $00                     ; R/W
;
;/* Bit of Timer Status & Control
;/* TxSC Bit Address Equate
TOF         EQU     $07                     ; R
TOIE        EQU     $06                     ; R/W
TSTOP       EQU     $05                     ; R/W
TRST        EQU     $04                     ; W
PS2         EQU     $02                     ; R/W
PS1         EQU     $01                     ; R/W
PS0         EQU     $00                     ; R/W
;
;/* Bit of Timer CH0 Status & Control Register
;/* TxSC0 Bit Address Equate
CH0F        EQU     $07                     ; R/W
CH0IE       EQU     $06                     ; R/W
MS0B        EQU     $05                     ; R/W
MS0A        EQU     $04                     ; R/W
ELS0B       EQU     $03                     ; R/W
ELS0A       EQU     $02                     ; R/W
TOV0        EQU     $01                     ; R/W
CH0MAX      EQU     $00                     ; R/W
;
;/* Bit of Timer CH1 Status & Control Register
;/* TxSC1 Bit Address Equate
CH1F        EQU     $07                     ; R/W
CH1IE       EQU     $06                     ; R/W
MS1A        EQU     $04                     ; R/W
ELS1B       EQU     $03                     ; R/W
ELS1A       EQU     $02                     ; R/W
TOV1        EQU     $01                     ; R/W
CH1MAX      EQU     $00                     ; R/W
;
;/* Bit of PLL Control Register
;/* PCTL Bit Address Equate
PLLIE       EQU     $07                     ; R/W
PLLF        EQU     $06                     ; R
PLLON       EQU     $05                     ; R/W
BCS         EQU     $04                     ; R/W
PRE1        EQU     $03                     ; R/W
PRE0        EQU     $02                     ; R/W
VPR1        EQU     $01                     ; R/W
VPR0        EQU     $00                     ; R/W
;
;/* Bit of PLL Bandwidth Control Register
;/* PBWC Bit Address Equate
AUTO        EQU     $07                     ; R/W
LOCK        EQU     $06                     ; R
ACQ         EQU     $05                     ; R/W
;
;/* Bit of PLL Multiply Select High
;/* PMSH Bit Address Equate
MUL11       EQU     $03                     ; R/W
MUL10       EQU     $02                     ; R/W
MUL9        EQU     $01                     ; R/W
MUL8        EQU     $00                     ; R/W
;
;/* Bit of Multiply Select Low
;/* PMSL Bit Address Equate
MUL7        EQU     $07                     ; R/W
MUL6        EQU     $06                     ; R/W
MUL5        EQU     $05                     ; R/W
MUL4        EQU     $04                     ; R/W
MUL3        EQU     $03                     ; R/W
MUL2        EQU     $02                     ; R/W
MUL1        EQU     $01                     ; R/W
MUL0        EQU     $00                     ; R/W
;
;/* Bit of PLL VCO Select Range
;/* PMRS Bit Address Equate
VRS7        EQU     $07                     ; R/W
VRS6        EQU     $06                     ; R/W
VRS5        EQU     $05                     ; R/W
VRS4        EQU     $04                     ; R/W
VRS3        EQU     $03                     ; R/W
VRS2        EQU     $02                     ; R/W
VRS1        EQU     $01                     ; R/W
VRS0        EQU     $00                     ; R/W
;
;/* Bit of PLL Reference Divider Select
;/* PMDS Bit Address Equate
RDS3        EQU     $03                     ; R/W
RDS2        EQU     $02                     ; R/W
RDS1        EQU     $01                     ; R/W
RDS0        EQU     $00                     ; R/W
;
;/* Bit of ADC Status & Control
;/* ADSCR Bit Address Equate
COCO        EQU     $07                     ; R/W
AIEN        EQU     $06                     ; R/W
ADCO        EQU     $05                     ; R/W
ADCH4       EQU     $04                     ; R/W
ADCH3       EQU     $03                     ; R/W
ADCH2       EQU     $02                     ; R/W
ADCH1       EQU     $01                     ; R/W
ADCH0       EQU     $00                     ; R/W
;
;/* Bit of ADC Clock Register
;/* ADCLK Bit Address Equate
ADIV2       EQU     $07                     ; R/W
ADIV1       EQU     $06                     ; R/W
ADIV0       EQU     $05                     ; R/W
ADICLK      EQU     $04                     ; R/W
;
;/* Bit of SIM Break Status Register
;/* SBSR Bit Address Equate
SBSW        EQU     $01                     ; R
;
;/* Bit of SIM Reset Status Register
;/* SRSR Bit Address Equate
POR         EQU     $07                     ; R/W
PIN         EQU     $06                     ; R/W
COP         EQU     $05                     ; R/W
ILOP        EQU     $04                     ; R/W
ILAD        EQU     $03                     ; R/W
MODRST      EQU     $02                     ; R/W
LVI         EQU     $01                     ; R/W
;
;/* Bit of SIM Break Flag Control
;/* SBFCR Bit Address Equate
BCFE        EQU     $07                     ; R/W
;
;/* Bit of Interrupt Status Register1
;/* INT1 Bit Address Equate
IF6         EQU     $07                     ; R
IF5         EQU     $06                     ; R
IF4         EQU     $05                     ; R
IF3         EQU     $04                     ; R
IF2         EQU     $03                     ; R
IF1         EQU     $02                     ; R
;
;/* Bit of Interrupt Status Register2
;/* INT2 Bit Address Equate
IF14        EQU     $07                     ; R
IF13        EQU     $06                     ; R
IF12        EQU     $05                     ; R
IF11        EQU     $04                     ; R
IF10        EQU     $03                     ; R
IF9         EQU     $02                     ; R
IF8         EQU     $01                     ; R
IF7         EQU     $00                     ; R
;
;/* Bit of Interrupt Status Register3
;/* INT3 Bit Address Equate Equate
IF16        EQU     $01                     ; R
IF15        EQU     $00                     ; R
;
;/* Bit of Flash Control Register
;/* FLCR Bit Address Equate
HVEN        EQU     $03                     ; R/W
MASS        EQU     $02                     ; R/W
ERASE       EQU     $01                     ; R/W
PGM         EQU     $00                     ; R/W
;
;/* Bit of Break Status & Control Register
;/* BRKSCR Bit Address Equate
BRKE        EQU     $07                     ; R/W
BRKA        EQU     $06                     ; R/W
;
;/* Bit of LVI Status Register
;/* LVISR Bit Address Equate
LVIOUT      EQU     $07                     ; R/W
;
;/* Bit of Flash Block Protect
;/* FLBPR Bit Address Equate
BPR7        EQU     $07                     ; R/W
BPR6        EQU     $06                     ; R/W
BPR5        EQU     $05                     ; R/W
BPR4        EQU     $04                     ; R/W
BPR3        EQU     $03                     ; R/W
BPR2        EQU     $02                     ; R/W
BPR1        EQU     $01                     ; R/W
BPR0        EQU     $00                     ; R/W
;/************************************/;
;/*  End of IO Register Bit Equate   */;
;/* For Processor : MC68H(R)C908GP32 */;
;/************************************/;
