;/***************************************/;
;/* Port I/O Equate  : CP-JR08GP32 V2.0 */;
;/* Write By         : Eakachai Makarn  */;
;/*                  : ETT CO.,LTD      */;
;/*                  : WWW.ETT.CO.TH    */;
;/***************************************/;
;
;/*************************************/;
;/* Start of Equate Hardware I/O Bit  */;
;/* For Standard Board : CP-JR08GP32  */;
;/*************************************/;
;
;/****************************/;
;/* LCD Interface With 4-Bit */;
;/* EN-LCD = PTC2            */;
;/* RS-LCD = PTC4            */;
;/* D4-LCD = PTD0            */;
;/* D5-LCD = PTD1            */;
;/* D6-LCD = PTD2            */;
;/* D7-LCD = PTD3            */;
;/* RW,D0..D3 of LCD = GND   */;
;/****************************/;
DATA_LCD    EQU     PTD                     ; PORTD = Data LCD
DLCD_DIR    EQU     DDRD                    ; Direction For Data LCD
CTRL_LCD    EQU     PTC                     ; PORTC = Control LCD
CLCD_DIR    EQU     DDRC                    ; Direction For Control LCD
EN_LCD      EQU     02H                     ; PTC2
RS_LCD      EQU     04H                     ; PTC4
D4_LCD      EQU     00H                     ; PTD0
D5_LCD      EQU     01H                     ; PTD1
D6_LCD      EQU     02H                     ; PTD2
D7_LCD      EQU     03H                     ; PTD3
;
;/****************************/;
;/* I2C I/O Device Interface */;
;/* I2C Signal Select Jumper */;
;/*     - SDA = PTC0 or PTB6 */;
;/*     - SCL = PTC1 or PTB7 */;
;/* This Equate to PTC0,PTC1 */;
;/****************************/;
PORT_I2C    EQU     PTC                     ; PORTC = I2C Signal
PDIR_I2C    EQU     DDRC                    ; Direction Read/Write
PULL_I2C    EQU     PTCPUE                  ; Pull-Up Enable
I2C_SDA     EQU     $00                     ; PTC0 = SDA
I2C_SCL     EQU     $01                     ; PTC1 = SCL
;
;/****************************/;
;/* RS-485 Direction Control */;
;/****************************/;
PORT_485    EQU     PTC                     ; PORTC = RS485 Direction Signal Control
PDIR_485    EQU     DDRC                    ; Direction Bit Control (Setup = Output)
POUT_485    EQU     $03                     ; PTC3 = RS485 Bit Signal Direction
;
;/****************************/;
;/* Matrix Keyboard Interface*/;
;/****************************/;
PORT_KEY    EQU     PTA                     ; PORTA = Keyboard Signal
PDIR_KEY    EQU     DDRA                    ; Direction In/Out
PULL_KEY    EQU     PTAPUE                  ; Pull-Up Enable
ROW0_KEY    EQU     $00                     ; PTA0 = Row0
ROW1_KEY    EQU     $01                     ; PTA1 = Row1
ROW2_KEY    EQU     $02                     ; PTA2 = Row2
ROW3_KEY    EQU     $03                     ; PTA3 = Row3
COL0_KEY    EQU     $04                     ; PTA4 = Column0
COL1_KEY    EQU     $05                     ; PTA5 = Column1
COL2_KEY    EQU     $06                     ; PAT6 = Column2
COL3_KEY    EQU     $07                     ; PTA7 = Column3 (Jumper Select = 4x4)
;
;/****************************/;
;/* Speaker or Buzzer Control*/;
;/*   (Jumper Select = 4x3)  */;
;/****************************/;
PORT_SPK    EQU     PTA                     ; PORTA = Speaker Signal Control
PDIR_SPK    EQU     DDRA                    ; Direction Bit Control (Setup = Output)
POUT_SPK    EQU     $07                     ; PTA7 = Speaker Bit Signal
;
;/*****************/;
;/* Relay Control */;
;/*****************/;
PORT_REL    EQU     PTB                     ; PORTB = Relay Signal Control
PDIR_REL    EQU     DDRB                    ; Direction Bit Control (Setup = Output)
POUT_REL    EQU     $07                     ; PTB7 = Speaker Bit Signal
;
;/****************************/;
;/* Magnetic Card Interface  */;
;/* Data Magnetic  = PTD4    */;
;/* Clock Magnetic = PTD5    */;
;/****************************/;
PORT_MAG    EQU     PTD                     ; PORTD = Magnetic Card Reader Signal
PDIR_MAG    EQU     DDRD                    ; Direction Read/Write
PULL_MAG    EQU     PTDPUE                  ; Pull-Up Enable
MAG_DATA    EQU     $04                     ; PTD4 = Data
MAG_CLK     EQU     $05                     ; PTD5 = Clock
;
;/************************/;
;/* RTC PCF8583 Register */;
;/************************/;
CTRL_RTC    EQU     $00                     ; Control/Status RTC
SEC_100     EQU     $01                     ; 1/100 of Second (00-99)
SECOND      EQU     $02                     ; Second (00-59)
MINUTE      EQU     $03                     ; Minute (00-59)
HOUR        EQU     $04                     ; Hour   (00-23) / 01-12(AM/PM)
YEAR_DATE   EQU     $05                     ; Year   (00-03) / Date(01-28,29,30,31)
WEEK_MONTH  EQU     $06                     ; Week   (00-06) / Month (01-12)
TIMER_RTC   EQU     $07                     ; Timer  (00-99)
;
ALARM_CTL   EQU     $08                     ; Alarm Control/Status
ALARM_SEC0  EQU     $09                     ; Alarm 1/100 Second
ALARM_SEC   EQU     $0A                     ; Alarm Second
ALARM_MIN   EQU     $0B                     ; Alarm Minute
ALARM_HOUR  EQU     $0C                     ; Alarm Hour
ALARM_DATE  EQU     $0D                     ; Alarm Date
ALARM_MONTH EQU     $0E                     ; Alarm Month
ALARM_TIMER EQU     $0F                     ; Alarm Timer
;
;/* Internal RTC RAM Address */;
RAM_START   EQU     $10                     ; $10..$FF = 240 Byte RAM
RAM_END     EQU     $FF
;
;/*************************************/;
;/*  End of Equate Hardware I/O Bit   */;
;/* For Standard Board : CP-JR08GP32  */;
;/*************************************/;
