;      **************************************
;      *   SOFTWARE TEST CP-Z80V2           *
;      *         ETT CO.,LTD.               *
;      *   ASM PROGRAM  Z180ASM             *
;      *   USER PORT 8255  30H-33H          *
;      *             8255  40H-43H          *
;      *        LCD  PROT  60H-64H          *
;      *   DISPLAY 16116H LCD               *
;      **************************************
;
         .EQU  PA1,30H
         .EQU  PB1,31H
         .EQU  PC1,32H
         .EQU  PCC1,33H
         .EQU  PA2,40H
         .EQU  PB2,41H
         .EQU  PC2,42H
         .EQU  PCC2,43H
;
         .ORG  0000H
;
START:   LD   HL,0     ;POWER ON DELAY
ST1:     DEC  HL
         LD   A,L
         OR   H
         JP   NZ,ST1
         LD   SP,9FFFH ;LOAD SP

         CALL RESET
         CALL DELAY
         JP   TLCD
;
          .ORG  0038H         ;INT 1 ,MODE 1
;
STINT:     LD  HL,0
STINT1:    DEC HL
           LD  A,L
           OR  H
           JR  NZ,STINT1
           LD  A,00111100B
           OUT (PC1),A
           CALL DELAY
           LD  A,11000011B
           OUT (PC1),A
           CALL DELAY
SINT2:     EI
           RETI
;
         .ORG  100H
;
TLCD:    CALL TESTLCD
         CALL DELAYB
         CALL DELAYB
;
         CALL TEST8255
;
         LD   A,80H    ;SET 8255 A,B,C=OUT
         OUT  (PCC1),A
         OUT  (PCC2),A
;
         LD   C,4
OUTL:    PUSH BC
OUTP1:   LD   A,01H
         LD   D,8
OUTP11:  OUT  (PA1),A
         OUT  (PB1),A
         OUT  (PC1),A
         OUT  (PA2),A
         OUT  (PB2),A
         OUT  (PC2),A
         CALL DELAY
         RLCA
         DEC  D
         JP   NZ,OUTP11
;
OUTP2:   LD   A,80H
         LD   D,8
OUTP22:  OUT  (PA1),A
         OUT  (PB1),A
         OUT  (PC1),A
         OUT  (PA2),A
         OUT  (PB2),A
         OUT  (PC2),A
         CALL DELAY
         RRCA
         DEC  D
         JP   NZ,OUTP22
         POP  BC
         DEC  C
         JP   NZ,OUTL
;
         LD   A,0
         OUT  (PA1),A
         OUT  (PB1),A
         OUT  (PC1),A
         OUT  (PA2),A
         OUT  (PB2),A
         OUT  (PC2),A
         CALL DELAYB
;
         LD   A,0FFH
         OUT  (PA1),A
         OUT  (PB1),A
         OUT  (PC1),A
         OUT  (PA2),A
         OUT  (PB2),A
         OUT  (PC2),A
         CALL DELAYB

         CALL TESTRAM
         CALL DELAYB
         CALL RAM
;
         CALL TESTCTC
         CALL TCTC
         HALT
         CALL DELAY
         CALL DELAY
         DI
         CALL CTCOK
         CALL DELAYB
         CALL DELAYB
         CALL TESTWDT
         CALL WDT
;
         CALL TESTHALT
         HALT
;
;****************************
;*       TEST WDT           *
;****************************
;
         .EQU PWDT,70H
;
WDT:       LD  C,30
TWDT1:     LD  A,0
           OUT (PC1),A
           CALL DELAYW
           LD  A,0FFH
           OUT (PC1),A
           CALL DELAYW
           DEC  C
           JR   NZ,TWDT1
           CALL TWDTOK
           CALL DELAYW
           CALL DELAYW
           CALL DELAYW
           CALL DELAYW
           CALL DELAYW
           RET
;
DELAYW:    LD  HL,0
DELW:      DEC HL
           IN  A,(PWDT)
           LD  A,L
           OR  H
           JR  NZ,DELW
           RET
;
;**************************************
;*   TEST  Z80CTC   CH1 INT  RST 38H  *
;**************************************
;
         .EQU CONCTC0,50H
         .EQU CONCTC1,51H
         .EQU CONCTC2,52H
         .EQU CONCTC3,53H

TCTC:      DI
           LD  A,10100101B
           OUT (CONCTC0),A       ;LOAD CONTROL
           LD  A,0FFH
           OUT (CONCTC0),A       ;LOAD TIMER CONSTANT
           LD  A,0
           OUT (CONCTC0),A
           IM  1
           EI
           RET
;
RAM:     LD   C,00H
         CALL GOTOLCD
         CALL LCDSTG
         .DB  "TEST RAM",00
         LD   C,40H
         CALL GOTOLCD
         CALL LCDSTG
         .DB  ":       ",00
         LD   IX,8000H
         LD   HL,1FE0H
RAM1:    PUSH HL
         LD   A,55H
         LD   (IX+0),A
         LD   A,(IX+0)
         CP   55H
         JP   NZ,ERR
         LD   A,0AAH
         LD   (IX+0),A
         LD   A,(IX+0)
         CP   0AAH
         JP   NZ,ERR
         LD   C,41H
         CALL GOTOLCD
         PUSH IX
         POP  DE
         CALL DSPDELCD
         LD   B,0H
RAM2:    DEC  B
         NOP
         NOP
         NOP
         JP   NZ,RAM2
         INC  IX
         POP  HL
         DEC  HL
         LD   A,L
         OR   H
         JR   NZ,RAM1
         RET
;
ERR:     LD   C,00H
         CALL GOTO
         CALL LCDSTG
         .DB  "RAM ERR:",00
         HALT

;***********************
;      INITIAL LCD     *
;***********************
;
;  I/O LCD PORT    CP-Z80V2
;
         .EQU  PDATA,60H
         .EQU  PSING,62H
         .EQU  PREAD,64H
;
INITLCD:   LD   A,00111000B    ;function set  38H
                              ;DL=1 8 bit,N=1 1/16 duty,F=0 5x7
          OUT  (PDATA),A
          CALL DELAYL
          CALL DELAYL        ;DELAY > 4.1 ms
          LD  A,00001111B    ;display on/off control
                              ;D=1 off,C=1 cursor on,B=1 blink
          OUT  (PDATA),A
          CALL DELAYL

          LD   A,00000110B    ;entry mode set
                              ;I/D=1 increment,S=0 right
          OUT  (PDATA),A
          CALL DELAYL

CLSLCD:   LD   A,00000001B    ;clear all display
          OUT  (PDATA),A
          CALL READ
          RET
;
;***** WRITE BYTE SUB ****
;
WRBYTE:  LD  A,D
         OUT (PSING),A
         CALL READ
         RET
;
;***** READY SUB *****
;
DELAYL:   PUSH BC
          PUSH AF
          LD   B,00H
DELAYL1: DJNZ DELAYL1
          POP  AF
          POP  BC
          RET
;
;******** GOTO ADDR LCD *****
;
GOTO:
         SET  7,A
         OUT  (PDATA),A
         CALL  READ
         RET
;
;******** READ BUSY BIT ******
READ:    IN   A,(PREAD)
         BIT  7,A
         JR   NZ,READ
         RET
;
;******** SYS CALL GOTOLCD ******
;    INPUT  C = GOTO
;
GOTOLCD: LD   A,C
         CALL GOTO
         RET
;
;******** SYS CALL WBYTE ******
;    INPUT  C = ASCII
WBYTELCD: LD    D,C
          CALL  WRBYTE
          RET
;
;******** SYS CALL STGLCD *****
;    INPUT  DB XX-00H
;
LCDSTG:    POP   HL
WRLCDSTG1: LD    C,(HL)
           INC   HL
           XOR   A
           CP    C
           JR    Z,WRSTG2
           CALL  WBYTELCD
           JR    WRLCDSTG1
WRSTG2:    PUSH  HL
           RET
;
;********* SYS CALL CLCD ******
;    INPUT C = HEX
DSPCLCD:   LD    A,C
           CALL  ASCHEX
           PUSH  DE
           LD    C,D
           CALL  WBYTELCD
           POP   DE
           LD    C,E
           CALL  WBYTELCD
           RET
;
;********* SYS CALL DELCD ******
;
DSPDELCD:  LD    C,D
           PUSH  DE
           CALL  DSPCLCD
           POP   DE
           LD    C,E
           CALL  DSPCLCD
           RET
;
;******************************
;*   TEST LCD                 *
;*   16 CHARACTERS * 1 LINE   *
;****************++************
;
RESET:    CALL INITLCD
          LD   HL,TABRES
          CALL WRP
          RET
TABRES:   .DB "[* CPU  RESET *]"
;
TESTLCD:  CALL INITLCD
          LD   HL,TAB161
          CALL WRP
          RET
;
TAB161:  .DB "[TEST--CP-Z80V2]"
;
TEST8255:  LD   HL,TAB162
          CALL WRP
          RET
;
TAB162:  .DB " [ TEST  8255 ] "
;
TESTRAM:  LD   HL,TAB163
          CALL WRP
          RET
;
TAB163:  .DB "[TEST  RAM 6264]"
;
TESTHALT: LD   HL,TAB164
          CALL WRP
          RET
;
TAB164:  .DB "[ SYSTEM  HALT ]"
;
TESTCTC:  LD   HL,TAB165
          CALL WRP
          RET
;
TAB165:  .DB "[ TEST Z80 CTC ]"
;
CTCOK:    LD   HL,TAB168
          CALL WRP
          RET
;
TAB168:  .DB "[ TEST CTC  OK ]"
;
TESTWDT:  LD   HL,TAB166
          CALL WRP
          RET
;
TAB166:   .DB "[   JUMP WDT   ]"
;
TWDTOK:   LD   HL,TAB167
          CALL WRP
          RET
;
TAB167:   .DB "[ TEST WDT OK  ]"
;
WRP:     LD   A,00H
         CALL GOTO
         CALL WRLINE
         LD   A,40H
         CALL GOTO
         CALL WRLINE
         RET
;
;******** WRITE LINE LCD 16*1 *****
WRLINE:  LD   B,8
TEST11:  LD   A,(HL)
         LD   D,A
         CALL WRBYTE
         INC HL
         DJNZ TEST11
         RET
;
ASCHEX:  PUSH AF
         RRCA
         RRCA
         RRCA
         RRCA
         CALL ASCH1
         LD   D,A
         POP  AF
;
ASCH1:   AND  0FH
         ADD  A,90H
         DAA
         ADC  A,40H
         DAA
         LD   E,A
         RET
;
DELAYB:  LD    B,10
DELAYB1: CALL  DELAY
         DEC   B
         JP    NZ,DELAYB1
         RET
;
DELAY:   PUSH AF
         LD   HL,8000H
DELAY1:  DEC  HL
         LD   A,L
         OR   H
         JP   NZ,DELAY1
         POP  AF
         RET

         .END
