;      **************************************
;      *   SOFTWARE TEST CP-Z80V1           *
;      *        ETT CO.,LTD.                *
;      *   ASM PROGRAM    Z180ASM           *
;      *   USER PORT 8255 40H-43H           *
;      *        LCD PORT  80H-82H           *
;      *   DISPLAY 16116H LCD               *
;      **************************************
;
         .EQU  PA,40H
         .EQU  PB,41H
         .EQU  PC,42H
         .EQU  PCC,43H
;
         .ORG  000H

START:   LD   HL,0     ;POWER ON DELAY
ST1:     DEC  HL
         LD   A,L
         OR   H
         JR   NZ,ST1
;
         LD   SP,9FFFH ;LOAD SP
         LD   A,80H    ;SET 8255 A,B,C=OUT
         OUT  (PCC),A
;
TLCD:    CALL TESTLCD
         CALL DELAYB
         CALL DELAYB
;
         CALL TEST8255
;
         LD   C,5
OUTL:    PUSH BC
OUTP1:   LD   A,01H
         LD   D,8
OUTP11:  OUT  (PA),A
         OUT  (PB),A
         OUT  (PC),A
         CALL DELAY
         RLCA
         DEC  D
         JP   NZ,OUTP11
;
OUTP2:   LD   A,80H
         LD   D,8
OUTP22:  OUT  (PA),A
         OUT  (PB),A
         OUT  (PC),A
         CALL DELAY
         RRCA
         DEC  D
         JP   NZ,OUTP22
         POP  BC
         DEC  C
         JP   NZ,OUTL
         LD   A,0
         OUT  (PA),A
         OUT  (PB),A
         OUT  (PC),A
         CALL DELAYB
;
         LD   A,0FFH
         OUT  (PA),A
         OUT  (PB),A
         OUT  (PC),A
         CALL DELAYB
;
         CALL TESTRAM
         CALL DELAYB
         CALL RAM
         CALL TESTHALT
         HALT
;
RAM:     LD   C,00H
         CALL GOTOLCD
         CALL LCDSTG
         .DB  "TEST RAM",00
         LD   C,40H
         CALL GOTOLCD
         CALL LCDSTG
         .DB  ":       ",00
         LD   IX,8000H
         LD   HL,1FE0H
RAM1:    PUSH HL
         LD   A,55H
         LD   (IX+0),A
         LD   A,(IX+0)
         CP   55H
         JP   NZ,ERR
         LD   A,0AAH
         LD   (IX+0),A
         LD   A,(IX+0)
         CP   0AAH
         JP   NZ,ERR
         LD   C,41H
         CALL GOTOLCD
         PUSH IX
         POP  DE
         CALL DSPDELCD
         LD   B,0H
RAM2:    DEC  B
         NOP
         NOP
         NOP
         NOP
         NOP
         NOP
         JP   NZ,RAM2
         INC  IX
         POP  HL
         DEC  HL
         LD   A,L
         OR   H
         JR   NZ,RAM1
         RET
;
ERR:     LD   C,00H
         CALL GOTO
         CALL LCDSTG
         .DB  "RAM ERR:",00
         HALT
;
;***********************
;      INITIAL LCD     *
;***********************
;
;  I/O LCD PORT    CP-Z80V1
         .EQU  PDATA,80H
         .EQU  PSING,82H
         .EQU  PREAD,84H
;
INITLCD:   LD   A,00111000B    ;function set  38H
                              ;DL=1 8 bit,N=1 1/16 duty,F=0 5x7
          OUT  (PDATA),A
          CALL DELAYL
          CALL DELAYL        ;DELAY > 4.1 ms
          LD  A,00001111B    ;display on/off control
                              ;D=1 off,C=1 cursor on,B=1 blink
          OUT  (PDATA),A
          CALL DELAYL

          LD   A,00000110B    ;entry mode set
                              ;I/D=1 increment,S=0 right
          OUT  (PDATA),A
          CALL DELAYL

CLSLCD:   LD   A,00000001B    ;clear all display
          OUT  (PDATA),A
          CALL READ
          RET
;
;***** WRITE BYTE SUB ****
;
WRBYTE:  LD  A,D
         OUT (PSING),A
         CALL READ
         RET
;
;***** READY SUB *****
;
DELAYL:   PUSH BC
          PUSH AF
          LD   B,00H
DELAYL1: DJNZ DELAYL1
          POP  AF
          POP  BC
          RET
;
;******** GOTO ADDR LCD *****
;
GOTO:
         SET  7,A
         OUT  (PDATA),A
         CALL  READ
         RET
;
;******** READ BUSY BIT ******
READ:    IN   A,(PREAD)
         BIT  7,A
         JR   NZ,READ
         RET
;
;******** SYS CALL GOTOLCD ******
;    INPUT  C = GOTO
;
GOTOLCD: LD   A,C
         CALL GOTO
         RET
;
;******** SYS CALL WBYTE ******
;    INPUT  C = ASCII
WBYTELCD: LD    D,C
          CALL  WRBYTE
          RET
;
;******** SYS CALL STGLCD *****
;    INPUT  DB XX-00H
;
LCDSTG:    POP   HL
WRLCDSTG1: LD    C,(HL)
           INC   HL
           XOR   A
           CP    C
           JR    Z,WRSTG2
           CALL  WBYTELCD
           JR    WRLCDSTG1
WRSTG2:    PUSH  HL
           RET
;
;********* SYS CALL CLCD ******
;    INPUT C = HEX
DSPCLCD:   LD    A,C
           CALL  ASCHEX
           PUSH  DE
           LD    C,D
           CALL  WBYTELCD
           POP   DE
           LD    C,E
           CALL  WBYTELCD
           RET
;
;********* SYS CALL DELCD ******
;
DSPDELCD:  LD    C,D
           PUSH  DE
           CALL  DSPCLCD
           POP   DE
           LD    C,E
           CALL  DSPCLCD
           RET
;
;******************************
;*   TEST LCD                 *
;*   16 CHARACTERS * 1 LINE   *
;****************++************
;
TESTLCD:  CALL INITLCD
          LD   HL,TAB161
          CALL WRP
          RET
;
TAB161:  .DB "[TEST  CP-Z80V1]"
;
TEST8255:  LD   HL,TAB162
          CALL WRP
          RET
;
TAB162:  .DB " [ TEST  8255 ] "
;
TESTRAM:  LD   HL,TAB163
          CALL WRP
          RET
;
TAB163:  .DB "[TEST  RAM 6264]"
;
TESTHALT: LD   HL,TAB164
          CALL WRP
          RET
;
TAB164:  .DB "[ SYSTEM  HALT ]"
;

WRP:     LD   A,00H
         CALL GOTO
         CALL WRLINE
         LD   A,40H
         CALL GOTO
         CALL WRLINE
         RET
;
;******** WRITE LINE LCD 16*1 *****
WRLINE:  LD   B,8
TEST11:  LD   A,(HL)
         LD   D,A
         CALL WRBYTE
         INC HL
         DJNZ TEST11
         RET
;
ASCHEX:  PUSH AF
         RRCA
         RRCA
         RRCA
         RRCA
         CALL ASCH1
         LD   D,A
         POP  AF
;
ASCH1:   AND  0FH
         ADD  A,90H
         DAA
         ADC  A,40H
         DAA
         LD   E,A
         RET
;
DELAYB:  LD    B,10
DELAYB1: CALL  DELAY
         DEC   B
         JP    NZ,DELAYB1
         RET
;
DELAY:   PUSH AF
         LD   HL,8000H
DELAY1:  DEC  HL
         LD   A,L
         OR   H
         JP   NZ,DELAY1
         POP  AF
         RET

         .END
