;/***********************************/;
;/* Examples For : BASE51 AC3 V1.0  */;
;/* Controller   : AT89C51AC3       */;
;/* Run X-TAL    : 29.4912 MHz      */;
;/*              : Run X2 Mode      */;
;/* Assembler    : Cross-32 V4.0    */;
;/* File Name    : 74HC595.ASM      */;
;/* Write By     : Eakachai Makarn  */;
;/* File Update  : 1-April-2006     */;
;/* Function     : Demo SPI Master  */;
;/***********************************/;
;/***********************************/;
;/* SPI Master Interface to 74HC595 */;
;/*   AT89C51AC3  --> 74HC595       */;
;/*   MOSI(P4.4)  --> DIN(14)       */;
;/*   MISO(P4.2)  <-- NC            */;
;/*   SCK(P4.3)   --> Shift(11)     */;
;/*   SS(P3.5)    --> NC			*/;
;/*   P4.0        --> Latch(12)     */;
;/*   +VCC        --> MCLR#(10)     */;
;/*   GND         --> OE#(13)       */;
;/* (Moving LED on Output 74HC595)  */;
;/***********************************/;

         			HOF  		"INT8"							; Intel HEX 8 Bit Output	
					CPU			"8051.TBL"						; MCS51 Assembler Code
	  				INCL		"89C51AC3.SFR"					; AT89C51AC3 SFR Register
            		
LATCH_74HC595:		EQU			P4.0							; Latch SPI Slave(74HC595)

                    ORG     	20H
DATA_TEST:          DFS     	1                           	; Data Test SPI
STACK:              DFS     	30                          	; Stack 30 Byte

                    ORG     	0000H                       	; Reset Vector of CPU
                    ;
                    ;/* Initial MCS51 Serial Port */;
MAIN:               MOV     	SP,#STACK                   	; Initial Stack
					MOV     	CKCON0,#00000001B       		; 6 Clock Mode(X2 Mode)
                    MOV     	IE0,#00000000B          		; Initial Interrupt Control
                    ORL     	AUXR,#00000001B         		; Inhibit ALE Signal
                    ;
					;/* Initial SPI                    
					ANL     	SPCON,#01111111B               	; SPIE = 0 = Disable SPI Interrupt
					ANL     	SPCON,#11011111B				; DORD = 0 = MSB First
					ANL     	SPCON,#11110011B               	; CPOL:CPHA  = 0:0 = SCK Rising Edge Shift Data
					ORL     	SPCON,#00000011B				; SPR1:SPR00 = 1:1 = SCK is Fosc/64
					ORL	   		SPCON,#00010000B 			 	; MSTR = 1 = SPI Master Mode                    										
					ORL	   		SPCON,#01000000B               	; SPE  = 1 = SPI Enable				
					;   
					CLR	   		LATCH_74HC595			 		; Prepared Latch 74HC595
					MOV 	   	DATA_TEST,#01111111B		 	; Data = 01111111B
LOOP_SEND_SPI:      MOV	   		A,DATA_TEST	
					RL      	A					      		; Loop Send 011111111 <- 11111110
					MOV     	DATA_TEST,A					
					MOV 	   	SPDAT,A				 	 		; Send Data to SPI								
					;
WAIT_SPI_OK:		MOV	   		A,SPSCR					 		; Read SPI Status	
					JNB	   		ACC.7,WAIT_SPI_OK		 		; Wait SPIF = 1 = SPI Send Complete
					MOV	   		A,SPDAT					 		; Read For Reset SPIF
					;
					SETB	   	LATCH_74HC595			 		; Latch Output 74HC595
					NOP
					NOP
					CLR	   		LATCH_74HC595
					;
					LCALL   	DELAY					 		; Delay Display Data
                    SJMP    	LOOP_SEND_SPI

;/**************************/;
;/* Delay Time For Display */;
;/**************************/;
;
DELAY:      		MOV     R5,#50              		 		; Delay Display
DLY0:       		MOV     R6,#0
DLY1:       		MOV     R7,#0
            		DJNZ    R7,$
            		DJNZ    R6,DLY1
            		DJNZ    R5,DLY0
            		RET

                    END

