;/***********************************/;
;/* Examples For : BASE51 AC3 V1.0  */;
;/* Controller   : AT89C51AC3       */;
;/* Run X-TAL    : 29.4912 MHz      */;
;/*              : Run X2 Mode      */;
;/* Assembler    : Cross-32 V4.0    */;
;/* File Name    : TESTPORT.ASM     */;
;/* Write By     : Eakachai Makarn  */;
;/* File Update  : 1-April-2006     */;
;/* Function     : Demo Test Port   */;
;/***********************************/;				

         	HOF  		"INT8"			; Intel HEX 8 Bit Output	
			CPU			"8051.TBL"		; MCS51 Assembler Code
	  		INCL		"89C51AC3.SFR"	; AT89C51AC3 SFR Register


            ORG     20H                 ; Start Internal RAM Buffer
STACK:      DFS     30                  ; Stack 30 Byte

            ORG     0000H               ; Reset Vector of CPU
MAIN:       MOV     SP,#STACK           ; Initial Stack
			MOV     CKCON0,#00000001B   ; 6 Clock Mode(X2 Mode)
            MOV     IE0,#00000000B      ; Initial Interrupt Control
            ORL     AUXR,#00000001B     ; Inhibit ALE Signal
            ;
LOOP_LED:	MOV		P0,#11111111B
			MOV		P1,#11111111B
			MOV		P2,#11111111B
			MOV		P3,#11111111B
			MOV		P4,#11111111B   
			;     
			;/ Test P0
			MOV		P0,#11111111B	
			MOV		R2,#8  		  
            MOV     A,#11111110B
LOOP_P0:   	MOV     P0,A                ; Moving 8 Bit LED Display on Port
            LCALL   DELAY
            RL      A
            DJNZ	R2,LOOP_P0          ; Loop Test Port
			MOV		P0,#1111111B
			;
			;/ Test P1
			MOV		P1,#11111111B	
			MOV		R2,#8  		  
            MOV     A,#11111110B
LOOP_P1:   	MOV     P1,A                ; Moving 8 Bit LED Display on Port
            LCALL   DELAY
            RL      A
            DJNZ	R2,LOOP_P1          ; Loop Test Port
			MOV		P1,#1111111B
			;
			;/ Test P2
			MOV		P2,#11111111B	
			MOV		R2,#8  		  
            MOV     A,#11111110B
LOOP_P2:   	MOV     P2,A                ; Moving 8 Bit LED Display on Port
            LCALL   DELAY
            RL      A
            DJNZ	R2,LOOP_P2          ; Loop Test Port
			MOV		P2,#1111111B
			;
			;/ Test P3
			MOV		P3,#11111011B	
			MOV		R2,#6  		  
            MOV     A,#11111011B
LOOP_P3:   	MOV     P3,A                ; Moving 8 Bit LED Display on Port
            LCALL   DELAY
            RL      A
            DJNZ	R2,LOOP_P3          ; Loop Test Port
			MOV		P3,#1111111B
			;
			;/ Test P4
			MOV		P4,#11111111B	
			MOV		R2,#5  		  
            MOV     A,#11111110B
LOOP_P4:   	MOV     P4,A                ; Moving 8 Bit LED Display on Port
            LCALL   DELAY
            RL      A
            DJNZ	R2,LOOP_P4          ; Loop Test Port
			MOV		P4,#1111111B
			LJMP	LOOP_LED

;/**************************/;
;/* Delay Time For Display */;
;/**************************/;
;
DELAY:      MOV     R5,#50              ; Delay Display
DLY0:       MOV     R6,#0
DLY1:       MOV     R7,#0
            DJNZ    R7,$
            DJNZ    R6,DLY1
            DJNZ    R5,DLY0
            RET

            END

