;/***************************************/;
;/* Example Form For : BASE51 AC3 V1.0  */;
;/* Controller       : AT89C51AC3       */;
;/* Run X-TAL        : 29.4912 MHz      */;
;/*                  : Run X2 Mode      */;
;/* Assembler        : Cross-32 V4.0    */;
;/* File Name        : TEST_LED.ASM     */;
;/* Write By         : Eakachai Makarn  */;
;/* File Update      : 1-April-2006     */;
;/***************************************/;
;/* System IO Self Test For BASE51 AC3  */;
;/* -> Test P1.0 LED Output Selftest    */;
;/***************************************/;
					
         		HOF  	"INT8"						; Intel HEX 8 Bit Output	
				CPU		"8051.TBL"					; MCS51 Assembler Code
	  			INCL	"89C51AC3.SFR"				; AT89C51AC3 SFR Register
					
;/* LED Output Test Signal */;
TEST_LED:   	EQU 		P1.0                	; Self-Test LED Output
							  		
            	ORG     	20H                 	; Start Internal RAM Buffer
STACK:      	DFS      	30                  	; Stack 30 Byte

            	ORG     	0000H               	; Reset Vector of CPU
MAIN:       	MOV     	SP,#STACK           	; Initial Stack                        	
				MOV     	CKCON0,#00000001B       ; 6 Clock Mode(X2 Mode)
                MOV     	IE0,#00000000B          ; Initial Interrupt Control
                ORL     	AUXR,#00000001B         ; Inhibit ALE Signal
            	;
LOOP_LED:   	CPL     	TEST_LED            	; ON/OFF LED(P1.0)
            	LCALL   	DELAY
            	LJMP    	LOOP_LED            	; Loop Test LED(P1.0)

;/**************************/;
;/* Delay Time For Display */;
;/**************************/;
;
DELAY:      	MOV     	R5,#10              	; Delay Display
DLY0:       	MOV     	R6,#0
DLY1:       	MOV     	R7,#0
            	DJNZ    	R7,$
            	DJNZ    	R6,DLY1
            	DJNZ    	R5,DLY0
            	RET

            	END

