;/***********************************/;
;/* Examples For : BASE51 AC3 V1.0  */;
;/* Controller   : AT89C51AC3       */;
;/* Run X-TAL    : 29.4912 MHz      */;
;/*              : Run X2 Mode      */;
;/* Assembler    : Cross-32 V4.0    */;
;/* File Name    : LCD16X2.ASM      */;
;/* Write By     : Eakachai Makarn  */;
;/* File Update  : 1-April-2006     */;
;/* Function     : Demo CharLCD 16x2*/;
;/***********************************/;			

         			HOF  	"INT8"						; Intel HEX 8 Bit Output	
					CPU		"8051.TBL"					; MCS51 Assembler Code
	  				INCL	"89C51AC3.SFR"				; AT89C51AC3 SFR Register

;/* Character 4-Bit Interface */;
PORT_LCD:           EQU     P2                          ; P2[1..7]
RS_LCD:             EQU     P2.1                  	 	; "0" = INS, "1"=DATA
RW_LCD:             EQU     P2.2                  	 	; "0" = WR,  "1"=RD
EN_LCD:             EQU     P2.3                  	 	; "1" = Enable LCD
;
D4_LCD:             EQU     P2.4
D5_LCD:             EQU     P2.5
D6_LCD:             EQU     P2.6
D7_LCD:             EQU     P2.7

                    ORG     20H
STACK:              DFS     30                          ; Stack 30 Byte

                    ORG     0000H                       ; Reset Vector of CPU
                    ;
                    ;/* Initial MCS51 Serial Port */;
MAIN:               MOV     SP,#STACK                   ; Initial Stack
					MOV     CKCON0,#00000001B       	; 6 Clock Mode(X2 Mode)
                    MOV     IE0,#00000000B          	; Initial Interrupt Control
                    ORL     AUXR,#00000001B         	; Inhibit ALE Signal
                    ;                                       
                    LCALL   INIT_LCD                    ; Initial LCD
LOOP_LCD:           MOV     A,#00H                      ; Cursor Line1
                    LCALL   GOTO_LCD
                    LCALL   PRINT_LCD
                    DFB     "ET-BASE51 AC3 V1",00H
                    MOV     A,#40H                      ; Cursor Line2
                    LCALL   GOTO_LCD
                    LCALL   PRINT_LCD
                    DFB     "BY...ETT CO.,LTD",00H
                    LCALL   DELAY
                    ;
                    MOV     A,#00H                      ; Cursor LIne1
                    LCALL   GOTO_LCD
                    LCALL   PRINT_LCD
                    DFB     "Interface 4-Bits",00H
                    MOV     A,#40H                      ; Cursor Line2
                    LCALL   GOTO_LCD
                    LCALL   PRINT_LCD
                    DFB     "Control By Port2",00H
                    LCALL   DELAY
                    LJMP    LOOP_LCD

;/********************/;
;/* Initial Char-LCD */;
;/* 4-Bit Interfaces */;
;/********************/;
;
INIT_LCD:           CLR     EN_LCD                      ; Start-up Signal Control															
					;
					;/* Power-on Delay = 500mS
					MOV		R2,#250
					LCALL	DLY_MSEC	
					MOV		R2,#250
					LCALL	DLY_MSEC					
					;
					SETB	D4_LCD						
					SETB	D5_LCD
					CLR		D6_LCD
					CLR		D7_LCD
					CLR		RS_LCD
					CLR		RW_LCD
					LCALL   EN_WRLCD					; Enable Pulse				
					;
					; Delay 4.1mS
					MOV		R2,#5
					LCALL	DLY_MSEC					
					;
					SETB	D4_LCD						
					SETB	D5_LCD
					CLR		D6_LCD
					CLR		D7_LCD
					CLR		RS_LCD
					CLR		RW_LCD
					LCALL   EN_WRLCD					; Enable Pulse			
					;
					; Delay 100uS
					MOV		R2,#1
					LCALL	DLY_MSEC
					;
					SETB	D4_LCD						
					SETB	D5_LCD
					CLR		D6_LCD
					CLR		D7_LCD
					CLR		RS_LCD
					CLR		RW_LCD
					LCALL   EN_WRLCD					; Enable Pulse			
					LCALL   BUSY_LCD                    ; Wait LCD Ready
					;   
					CLR		D4_LCD						
					SETB	D5_LCD
					CLR		D6_LCD
					CLR		D7_LCD
					CLR		RS_LCD
					CLR		RW_LCD
					LCALL   EN_WRLCD					; Enable Pulse			
					LCALL   BUSY_LCD                    ; Wait LCD Ready
					;                 
                    MOV     A,#28H                      ; Function Set
                    LCALL   WR_INS                      ; DL=0 4Bit,N=1 2Line,F=0 5X7
                    MOV     A,#0CH                      ; Display on/off Control
                    LCALL   WR_INS                      ; Entry Display,Cursor off,Cursor not blink
                    MOV     A,#06H                      ; Entry Mode Set
                    LCALL   WR_INS                      ; I/D=1 Increment,S=0 Cursor Shift
                    MOV     A,#01H                      ; Clear Display
                    LCALL   WR_INS                      ; Clear Display,Set DD RAM addr=0
                    RET

;/******************************/;
;/* WR_INS : Write Instruction */;
;/* WR_LCD : Write Data to LCD */;
;/* Input  : ACC(Command/Data) */;
;/******************************/;
;
WR_INS:             CLR     RS_LCD                      ; Instruction select
                    SJMP    WR_LCD1
                    ;
WR_LCD:             SETB    RS_LCD                      ; Write Data Select
                    ;
WR_LCD1:            PUSH    ACC                         ; Save Data
                    ANL     A,#11110000B                ; High byte
                    ANL     PORT_LCD,#00001111B         ; Clear old Data
                    ORL     PORT_LCD,A
                    LCALL   EN_WRLCD					; Enable Pulse					
                    POP     ACC                         ; Restore Data
					;
                    ANL     A,#00001111B                ; Low Byte
                    SWAP    A
                    ANL     PORT_LCD,#00001111B         ; Clear old Data
                    ORL     PORT_LCD,A
                    LCALL   EN_WRLCD					; Enable Pulse
					;
                    LCALL   BUSY_LCD                    ; Wait LCD Ready
                    RET

;/************************/;
;/* Goto position of LCD */;
;/* Input : ACC(address) */;
;/************************/;
;
GOTO_LCD:           SETB    ACC.7                       ; Set DD-RAM Address
                    LCALL   WR_INS
                    RET

;/**********************/;
;/*   Mov LCD cursor   */;
;/* to Left 1 position */;
;/**********************/;
;
SHF_LFT:            MOV     A,#10H                      ; Shift Left Cursor
                    LCALL   WR_INS
                    RET

;/***********************/;
;/*    Mov LCD cursor   */;
;/* to Right 1 position */;
;/***********************/;
;
SHF_RGT:            MOV     A,#14H                      ; Shift Right Cursor
                    LCALL   WR_INS
                    RET

;/**********************/;
;/*  Enable Pin E LCD  */;
;/* Active Chip select */;
;/* Active 1 : _/--\_  */;
;/**********************/;
;
EN_WRLCD:           SETB    EN_LCD                      ; Enable CS of LCD
                    NOP
					NOP
					NOP
					NOP
                    CLR     EN_LCD                      ; Disable LCD
                    RET

;/***************************/;
;/* Delay Time for LCD Busy */;
;/* Wait LCD Execute Ready  */;
;/* Maximum Time = 1.64 mS  */;
;/* 30228 Cycle / 18.432MHz */;
;/***************************/;
;
BUSY_LCD:         	PUSH	ACC							; Save ACC
                    ;
					CLR		RS_LCD						; Select Instruction
					SETB	RW_LCD						; Select Read LCD
					ORL		PORT_LCD,#11110000B			; Initial Data Input
					;
					SETB	EN_LCD						; Enable Read
					;
WAIT_BUSY:			MOV		A,PORT_LCD										
					JB		ACC.7,WAIT_BUSY				; Repeat Until LCD Ready
					;
					CLR		EN_LCD						; Disable Read
					;
					CLR		RW_LCD						; Select Write
					POP		ACC							; Restore ACC
                    RET

;/********************************/;
;/*  Print Data to Dotmatrix LCD */;
;/*  Usage   : LCALL   PRINT_LCD */;
;/*          : DB      'xxxx',00 */;
;/*  Data last byte must be = 00 */;
;/********************************/;
;
PRINT_LCD:          POP     DPH                         ; Restore PC to Stack
                    POP     DPL
PRN_LCD1:           CLR     A
                    MOVC    A,@A+DPTR
                    CJNE    A,#00H,PRN_LCD2
                    LJMP    PRN_LCD3
PRN_LCD2:           LCALL   WR_LCD                      ; Write LCD
                    INC     DPTR
                    LJMP    PRN_LCD1
PRN_LCD3:           PUSH    DPL                         ; Restore DPTR to PC
                    PUSH    DPH
                    RET

;/**********************/;
;/* Delay milli-Second */;
;/* (XTAL = 58.982MHz) */;
;/* Input    : R2      */;
;/* Register : R2,R3   */;
;/* 4915 Machine Cycle */;
;/**********************/;
;
DLY_MSEC:           MOV     R3,#245                   	; 1 milli-Second Count
					NOP                                 ; 1 (1)
                    NOP                                 ; 1 (2)
                    NOP                                 ; 1 (3)
                    NOP                                 ; 1 (4)
					NOP                                 ; 1 (5)
                    NOP                                 ; 1 (6)
                    NOP                                 ; 1 (7)
                    NOP                                 ; 1 (8)	
					NOP                                 ; 1 (9)
                    NOP                                 ; 1 (10)
                    NOP                                 ; 1 (11)
                    NOP                                 ; 1 (12)
					NOP                                 ; 1 (13)
                    NOP                                 ; 1 (14)                    
					;
DLY_MS1:            NOP                                 ; 1 (1)
                    NOP                                 ; 1 (2)
                    NOP                                 ; 1 (3)
                    NOP                                 ; 1 (4)
					NOP                                 ; 1 (5)
                    NOP                                 ; 1 (6)
                    NOP                                 ; 1 (7)
                    NOP                                 ; 1 (8)	
					NOP                                 ; 1 (9)
                    NOP                                 ; 1 (10)
                    NOP                                 ; 1 (11)
                    NOP                                 ; 1 (12)
					NOP                                 ; 1 (13)
                    NOP                                 ; 1 (14)
                    NOP                                 ; 1 (15)
                    NOP                                 ; 1 (16)
					NOP                                 ; 1 (17)
					NOP                                 ; 1 (18)
                    DJNZ    R3,DLY_MS1                  ; 2 (20) -> 20 x 245 = 4900
                    DJNZ    R2,DLY_MSEC                 ; Repeat mS
                    ;
                    RET

;/**************************/;
;/* Delay Time For Display */;
;/**************************/;
;
DELAY:              MOV     R5,#100                     ; Delay Display
DLY0:               MOV     R6,#0
DLY1:               MOV     R7,#0
                    DJNZ    R7,$
                    DJNZ    R6,DLY1
                    DJNZ    R5,DLY0
                    RET

                    END

