;/***********************************/;
;/* Examples For : BASE51 AC3 V1.0  */;
;/* Controller   : AT89C51AC3       */;
;/* Run X-TAL    : 29.4912 MHz      */;
;/*              : Run X2 Mode      */;
;/* Assembler    : Cross-32 V4.0    */;
;/* File Name    : ADC8.ASM         */;
;/* Write By     : Eakachai Makarn  */;
;/* File Update  : 1-April-2006     */;
;/* Function     : ADC 10B-it 8-CH  */;
;/***********************************/;					

         			HOF  	"INT8"					; Intel HEX 8 Bit Output	
					CPU		"8051.TBL"				; MCS51 Assembler Code
	  				INCL	"89C51AC3.SFR"			; AT89C51AC3 SFR Register

; Timer1 Baudrate (29.4912 MHz x 2 ) 
; Reload = 256 - [58.9824 MHz / (384 x Baud)]
; 1200   = 0x80(256-128=128)
; 2400   = 0xC0(256-94=192)
; 4800   = 0xE0(256-32=224)
; 9600   = 0xF0(256-16=240)
; 19200  = 0xF8(256-8=248)
; 38400  = 0xFC(256-4=252)   

            		ORG     20H                 	; Start Internal RAM Buffer
ADC_BUFF:   		DFS     3                   	; ADC Result Buffer
STACK:      		DFS     30                  	; Stack 30 Byte

                    ORG     0000H                   ; Reset Vector of CPU
                    ;
                    ;/* Initial MCS51 Serial Port */;
MAIN:               MOV     SP,#STACK               ; Initial Stack
					MOV     CKCON0,#00000001B       ; 6 Clock Mode(X2 Mode)
                    MOV     IE0,#00000000B          ; Initial Interrupt Control
                    ORL     AUXR,#00000001B         ; Inhibit ALE Signal
                    ;                    
                    ;/* Initial MCS51 Serial Port */;                    
                    ANL     TMOD,#00001111B         ; Reset Timer1 Mode Config
                    ORL     TMOD,#00100000B         ; Timer1 = 8Bit-Auto Reload                   
                    MOV     SCON,#01010000B         ; Serial Port Mode 1 (N,8,1)
                    CLR     ES                      ; Disable Serial Interupt
                    CLR     ET1                     ; Disable Timer1 Interrupt                    
                    ANL     PCON,#01111111B         ; SMOD1 = 0 (Disable Double Baudrate)                    
                    MOV     A,#240               	; Setup Baudrate 9600BPS
                    MOV     TH1,A
                    MOV     TL1,A
                    SETB    TR1                     ; Start Timer1 Generate Baudrate
                    ;								                   
					;/*******************************/;
            		;/* Start Function Program Here */;
            		;/*******************************/;
            		;
            		LCALL   PRINT_SER               ; Print Menu Function Test
            		DFB     0DH,0AH,0AH
            		DFB     "Demo Selftest For ET-BASE51 AC3 V1.0"
            		DFB     0DH,0AH
            		DFB     "Test ADC 10Bit/8Ch",0DH,0AH,00H
            		;
            		MOV     ADCF,#11111111B         ; P1 = ADC
            		MOV     ADCON,#00100000B        ; Enable ADC Function
            		;
LOOP_ADC:   		MOV     A,#0DH                  ; Carrier Return
            		LCALL   TX_BYTE
            		ANL     ADCON,#11111000B        ; Select Ch ADC = 000
            		ORL     ADCON,#00000000B        ; Select AD0
            		;
            		ORL     ADCON,#00001000B        ; Start ADC Convert (ADSST=1)
WAIT_AD0:   		MOV     A,ADCON                 ; Wait ADEOC = 1
            		ANL     A,#00010000B
            		CJNE    A,#00010000B,WAIT_AD0
            		;
            		MOV     ADC_BUFF+0,ADDH
            		MOV     ADC_BUFF+1,ADDL
            		ANL     ADCON,#11101111B        ; Clear ADEOC=0
            		LCALL   DSP_ADC
            		;
            		ANL     ADCON,#11111000B        ; Select Ch ADC
            		ORL     ADCON,#00000001B        ; Select AD1
            		;
            		ORL     ADCON,#00001000B        ; Start ADC Convert (ADSST=1)
WAIT_AD1:   		MOV     A,ADCON                 ; Wait ADEOC = 1
            		ANL     A,#00010000B
            		CJNE    A,#00010000B,WAIT_AD1
            		;
           		 	MOV     ADC_BUFF+0,ADDH
            		MOV     ADC_BUFF+1,ADDL
            		ANL     ADCON,#11101111B        ; Clear ADEOC=0
            		LCALL   DSP_ADC
            		;
            		ANL     ADCON,#11111000B        ; Select Ch ADC
            		ORL     ADCON,#00000010B        ; Select AD2
            		;
            		ORL     ADCON,#00001000B        ; Start ADC Convert (ADSST=1)
WAIT_AD2:   		MOV     A,ADCON                 ; Wait ADEOC = 1
            		ANL     A,#00010000B
            		CJNE    A,#00010000B,WAIT_AD2
            		;
           	 		MOV     ADC_BUFF+0,ADDH
            		MOV     ADC_BUFF+1,ADDL
            		ANL     ADCON,#11101111B        ; Clear ADEOC=0
            		LCALL   DSP_ADC
            		;
            		ANL     ADCON,#11111000B        ; Select Ch ADC
            		ORL     ADCON,#00000011B        ; Select AD3
            		;
            		ORL     ADCON,#00001000B        ; Start ADC Convert (ADSST=1)
WAIT_AD3:   		MOV     A,ADCON                 ; Wait ADEOC = 1
            		ANL     A,#00010000B
            		CJNE    A,#00010000B,WAIT_AD3
            		;
            		MOV     ADC_BUFF+0,ADDH
            		MOV     ADC_BUFF+1,ADDL
            		ANL     ADCON,#11101111B        ; Clear ADEOC=0
            		LCALL   DSP_ADC
            		;
            		ANL     ADCON,#11111000B        ; Select Ch ADC
            		ORL     ADCON,#00000100B        ; Select AD4
            		;
            		ORL     ADCON,#00001000B        ; Start ADC Convert (ADSST=1)
WAIT_AD4:   		MOV     A,ADCON                 ; Wait ADEOC = 1
            		ANL     A,#00010000B
            		CJNE    A,#00010000B,WAIT_AD4
            		;
            		MOV     ADC_BUFF+0,ADDH
            		MOV     ADC_BUFF+1,ADDL
            		ANL     ADCON,#11101111B        ; Clear ADEOC=0
            		LCALL   DSP_ADC
            		;
            		ANL     ADCON,#11111000B        ; Select Ch ADC
            		ORL     ADCON,#00000101B        ; Select AD5
            		;
            		ORL     ADCON,#00001000B        ; Start ADC Convert (ADSST=1)
WAIT_AD5:   		MOV     A,ADCON                 ; Wait ADEOC = 1
            		ANL     A,#00010000B
            		CJNE    A,#00010000B,WAIT_AD5
            		;
            		MOV     ADC_BUFF+0,ADDH
            		MOV     ADC_BUFF+1,ADDL
            		ANL     ADCON,#11101111B        ; Clear ADEOC=0
            		LCALL   DSP_ADC
            		;
            		ANL     ADCON,#11111000B        ; Select Ch ADC
            		ORL     ADCON,#00000110B        ; Select AD6
            		;
            		ORL     ADCON,#00001000B        ; Start ADC Convert (ADSST=1)
WAIT_AD6:   		MOV     A,ADCON                 ; Wait ADEOC = 1
            		ANL     A,#00010000B
            		CJNE    A,#00010000B,WAIT_AD6
            		;
            		MOV     ADC_BUFF+0,ADDH
            		MOV     ADC_BUFF+1,ADDL
            		ANL     ADCON,#11101111B        ; Clear ADEOC=0
            		LCALL   DSP_ADC
            		;
            		ANL     ADCON,#11111000B        ; Select Ch ADC
            		ORL     ADCON,#00000111B        ; Select AD7
            		;
            		ORL     ADCON,#00001000B        ; Start ADC Convert (ADSST=1)
WAIT_AD7:   		MOV     A,ADCON                 ; Wait ADEOC = 1
            		ANL     A,#00010000B
            		CJNE    A,#00010000B,WAIT_AD7
            		;
            		MOV     ADC_BUFF+0,ADDH
            		MOV     ADC_BUFF+1,ADDL
            		ANL     ADCON,#11101111B        ; Clear ADEOC=0
            		LCALL   DSP_ADC
            		LJMP    LOOP_ADC

;/********************/;
;/* Display ADC Data */;
;/* Input : ADC_BUFF */;
;/********************/;
;
DSP_ADC:    		ANL     ADC_BUFF+1,#00000011B   ; Low Byte [------10]
            		MOV     A,ADC_BUFF+0            ; High Byte [98765432]
            		RL      A                       ; D1 <- D0  [87654329]
            		RL      A                       ; D2 <- D0  [76543298]
            		ANL     A,#11111100B            ; [765432--]
            		ORL     A,ADC_BUFF+1            ; [765432--] or [------10]
            		MOV     ADC_BUFF+1,A            ; ADC_BUFF+1 = Low Byte[D7..D0]
            		;
            		MOV     A,ADC_BUFF+0            ; High Byte [98765432]
            		RR      A                       ; D6 -> D5  [28976543]
            		RR      A                       ; D6 -> D4  [32987654]
            		RR      A                       ; D6 -> D3  [43298675]
            		RR      A                       ; D6 -> D2  [54329876]
            		RR      A                       ; D6 -> D1  [65432987]
            		RR      A                       ; D6 -> D0  [76543298]
            		ANL     A,#00000011B            ; [------98]
            		MOV     ADC_BUFF+0,A            ; ADC_BUFF+0 = High Byte[D9..D8]
            		;
            		MOV     A,ADC_BUFF+0            ; High Byte [------98]
            		LCALL   TX_2ASC
            		MOV     A,ADC_BUFF+1            ; Low Byte  [76543210]
            		LCALL   TX_2ASC
            		MOV     A,#"H"
            		LCALL   TX_BYTE
            		MOV     A,#20H
            		LCALL   TX_BYTE
            		RET

;/*************************/;
;/* Send 1-Byte to RS-232 */;
;/* Input   : ACC         */;
;/* Output  : Serial port */;
;/*************************/;
;
TX_BYTE:    		MOV     SBUF,A
            		JNB     TI,$                    ; Wait TX Data Ready
            		CLR     TI
            		RET

;/****************************/;
;/* Receive Data From RS-232 */;
;/* Input   :  Serial Port   */;
;/* Output  :  ACC           */;
;/****************************/;
;
RX_BYTE:    		JNB     RI,RX_BYTE              ; Wait RX Data Ready
            		CLR     RI
            		MOV     A,SBUF                  ; Get RX Data
            		RET

;/************************/;
;/* Convert ASCII to HEX */;
;/* Input  : ACC (ASCII) */;
;/* Output : ACC (HEX)   */;
;/************************/;
;
ASC_HEX:    		PUSH    PSW
            		CJNE    A,#41H,ASC_HEX1         ; "A"
ASC_HEX1:   		JC      ASC_HEX3                ; 30H-39H Jump
ASC_HEX2:   		ADD     A,#09H                  ; A-F(ASCII) ==> A-F(Hex)
ASC_HEX3:   		ANL     A,#00001111B            ; Convert ASCII to HEX
            		POP     PSW
            		RET

;/************************/;
;/* Send 2 byte of ASCII */;
;/* Input : ACC (HEX)    */;
;/* Exam. : A = A3H      */;
;/*       : Send 41H,33H */;
;/************************/;
;
TX_2ASC:    		LCALL   HEX_2ASC
            		LCALL   TX_BYTE
            		MOV     A,B
            		LCALL   TX_BYTE
            		RET

;/****************************/;
;/* Convert 1-HEX to 2-ASCII */;
;/* Input  : ACC (Hex)       */;
;/* Output : ACC (High-Byte) */;
;/*        : B   (Low-Byte)  */;
;/* Exam A = 41H => 34H,31H  */;
;/****************************/;
;
HEX_2ASC:   		PUSH    ACC
            		LCALL   HEX_ASC
            		MOV     B,A                     ; B = Lo byte
            		POP     ACC
            		SWAP    A
            		LCALL   HEX_ASC                 ; A = High Byte
            		RET

;/*****************************/;
;/* Convert Hex(0-F) to ASCII */;
;/* Input  : ACC (HEX code)   */;
;/* Output : ACC (ASCII code) */;
;/*****************************/;
;
HEX_ASC:    		PUSH    PSW
            		CLR     CY
            		ANL     A,#00001111B
            		CJNE    A,#09H,HEX_ASC1
            		SETB    CY
HEX_ASC1:   		JNB     CY,HEX_ASC2             ; > 0AH
            		ORL     A,#30H                  ; < 0AH
            		SJMP    HEX_ASC3
HEX_ASC2:   		SUBB    A,#09H                  ; > 0AH
            		ORL     A,#40H
HEX_ASC3:   		POP     PSW
            		RET

;/******************************/;
;/* Print Data to Serial Port  */;
;/* Usage    : LCALL PRINT_SER */;
;/*          : DB   'xxxx',00  */;
;/******************************/;
;
PRINT_SER:  		POP     DPH
            		POP     DPL
PRN_SER1:   		CLR     A
            		MOVC    A,@A+DPTR
            		CJNE    A,#00H,PRN_SER2
            		LJMP    PRN_SER3
PRN_SER2:   		LCALL   TX_BYTE
            		INC     DPTR
            		LJMP    PRN_SER1
PRN_SER3:   		PUSH    DPL
            		PUSH    DPH
            		RET

                    END

