;/***********************************/;
;/* Examples For : BASE51 AC3 V1.0  */;
;/* Controller   : AT89C51AC3       */;
;/* Run X-TAL    : 29.4912 MHz      */;
;/*              : Run X2 Mode      */;
;/* Assembler    : Cross-32 V4.0    */;
;/* File Name    : RS232-1.ASM      */;
;/* Write By     : Eakachai Makarn  */;
;/* File Update  : 1-April-2006     */;
;/* Function     : Demo TX/RX RS232 */;
;/*              : Use Timer1 8 Bit */;
;/*              : Generate Baudrate*/;
;/***********************************/;					

         			HOF  		"INT8"					; Intel HEX 8 Bit Output	
					CPU			"8051.TBL"				; MCS51 Assembler Code
	  				INCL		"89C51AC3.SFR"			; AT89C51AC3 SFR Register

; Timer1 Baudrate (29.4912 MHz x 2 ) 
; Reload = 256 - [58.9824 MHz / (384 x Baud)]
; 1200   = 0x80(256-128=128)
; 2400   = 0xC0(256-94=192)
; 4800   = 0xE0(256-32=224)
; 9600   = 0xF0(256-16=240)
; 19200  = 0xF8(256-8=248)
; 38400  = 0xFC(256-4=252)   

                    ORG     20H
STACK:              DFS     30                          ; Stack 30 Byte

                    ORG     0000H                       ; Reset Vector of CPU
                    ;
                    ;/* Initial MCS51 Serial Port */;
MAIN:               MOV     SP,#STACK                   ; Initial Stack
 					MOV     CKCON0,#00000001B           ; 6 Clock Mode(X2 Mode)
                    MOV     IE0,#00000000B              ; Initial Interrupt Control
                    ORL     AUXR,#00000001B             ; Inhibit ALE Signal
                    ;                    
                    ;/* Initial MCS51 Serial Port */;                   
                    ANL     TMOD,#00001111B             ; Reset Timer1 Mode Config
                    ORL     TMOD,#00100000B             ; Timer1 = 8Bit-Auto Reload                    
                    MOV     SCON,#01010000B             ; Serial Port Mode 1 (N,8,1)
                    CLR     ES                          ; Disable Serial Interupt
                    CLR     ET1                         ; Disable Timer1 Interrupt                    
                    ANL     PCON,#01111111B             ; SMOD1 = 0 (Disable Double Baudrate)                   
                    MOV     A,#240               		; Setup Baudrate 9600BPS
                    MOV     TH1,A
                    MOV     TL1,A
                    SETB    TR1                         ; Start Timer1 Generate Baudrate
                    ;
                    ;/* Start Send Data to RS232 */;
                    MOV     A,#0DH                      ; Enter 
                    LCALL   TX_BYTE
                    MOV     A,#0AH                      ; Line Feed
                    LCALL   TX_BYTE
                    ;
                    MOV     A,#"H"                      ; Sign-On = "Hello >"
                    LCALL   TX_BYTE
                    MOV     A,#"e"
                    LCALL   TX_BYTE
                    MOV     A,#"l"
                    LCALL   TX_BYTE
                    MOV     A,#"l"
                    LCALL   TX_BYTE
                    MOV     A,#"o"
                    LCALL   TX_BYTE
                    MOV     A,#" "
                    LCALL   TX_BYTE
                    MOV     A,#">"
                    LCALL   TX_BYTE
                    ;
LOOP:               LCALL   RX_BYTE                     ; Wait RS232 Receive
                    LCALL   TX_BYTE                     ; Echo Data
                    CJNE    A,#0DH,LOOP                 ; If Enter Auto Line Feed
                    MOV     A,#0AH
                    LCALL   TX_BYTE
                    SJMP    LOOP

;/*************************/;
;/* Send 1-Byte to RS-232 */;
;/* Input   : ACC         */;
;/* Output  : Serial Port */;
;/*************************/;
;
TX_BYTE:            MOV     SBUF,A                      ; Put Data to Send
                    JNB     TI,$                        ; Wait TX Data Ready
                    CLR     TI
                    RET

;/****************************/;
;/* Receive Data From RS-232 */;
;/* Input   :  Serial Port   */;
;/* Output  :  ACC           */;
;/****************************/;
;
RX_BYTE:            JNB     RI,RX_BYTE                  ; Wait RX Data Ready
                    CLR     RI
                    MOV     A,SBUF                      ; Get RX Data
                    RET

                    END

