/*******************************************/
/* Example Program For ET-BASE51 AC3 V1.0  */
/* MCU      : AT89C51AC3(XTAL=29.4912 MHz) */
/*          : Frequency Bus = 58.9824 MHz  */
/* Compiler : Keil C51 (V7.50)             */
/* Write By : Eakachai Makarn(ETT CO.,LTD.)*/
/*******************************************/
/*******************************************/
/* SPI Interface to 74HC595(O/P LED Test)  */
/* MOSI(P4.4)  --> DIN(14)				   */
/* MISO(P4.2)  <-- NC					   */
/* SCK(P4.3)   --> Clock(11)		       */
/* SS#(P3.5)   --> NC                      */
/* P4.0        --> Latch(12)			   */
/*******************************************/
// Demo SPI + ET-MINI 74HC595

/* Include  Section */
#include <reg52.h>										// Standard 8052 SFR : File

/* AT89C51AC3 SFR */
sfr CKCON = 0x8F;										// Clock Control
sfr SPCR  = 0xD4;										// SPI Config
sfr SPSR  = 0xD5;										// SPI Status
sfr SPDR  = 0xD6;										// SPI Data
sfr P4    = 0xC0;										// Port P4
sbit latch_74hc595 = P4^0;								// Latch SPI (74HC595) Signal

/* User Define Function */
void delay(unsigned long);								// Delay Time Function(1..4294967295)

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main()
{
  unsigned char data_out;			 					// Write SPI Buffer
  unsigned char data_in;								// Read  SPI Buffer

  // X2 Mode Run
  CKCON = 0x01;											// Initial X2 Mode (BUS Clock = 58.9824 MHz) 
 
  /* Initial SPI */
  SPCR &= 0x7F;                 						// SPIE = 0 = Disable SPI Interrupt
  SPCR &= 0xdF; 			 							// DORD = 0 = MSB First
  SPCR &= 0xF3;              							// CPOL:CPHA  = 0:0 = SCK Rising Edge Shift Data
  SPCR |= 0x03; 			 							// SPR1:SPR00 = 1:1 = SCK is Fosc/64
  SPCR |= 0x10;  										// MSTR = 1 = SPI Master Mode                    										
  SPCR |= 0x40;              							// SPE  = 1 = SPI Enable				
   
  latch_74hc595	= 0;		 							// Prepared Latch 74HC595
  
  while(1)												// Loop Continue
  { 
    for (data_out = 0x01; data_out; data_out <<= 1)		// Shift Left P1 (10000000 <- 00000001)
    { SPDR = 0xff-data_out;								// Active 8-Bit Output (Toggle Active=0)

	  while((SPSR & 0x80)!= 0x80)						// Wait SPIF = 1
	  { 
	   data_in = SPDR;									// Read For Reset SPIF	   
	  }	 

	  latch_74hc595 = 1;								// Latch Output 74HC595
      latch_74hc595 = 0;
      delay (50000);	  								// Delay Display Output
    }

    for (data_out = 0x80; data_out; data_out >>= 1)		// Shift Right P1(10000000 -> 00000001)
    { SPDR = 0xff-data_out;								// Active 8-Bit Output (Toggle Active=0)      

	  while((SPSR & 0x80)!= 0x80)						// Wait SPIF = 1
	  { 
	   data_in = SPDR;									// Read For Reset SPIF	   
	  }
	  delay(100);

	  latch_74hc595 = 1;								// Latch Output 74HC595
	  latch_74hc595 = 0;
      delay (50000);									// Delay Display Output  			
    }    
  }  

}

/*******************************************/
/* Long Delay Time Function(1..4294967295) */
/*******************************************/
void delay(unsigned long i)
{
  while(i > 0) {i--;}									// Loop Decrease Counter	
  return;
}

					
					

