/*******************************************/
/* Example Program For ET-BASE51 AC3 V1.0  */
/* MCU      : AT89C51AC3(XTAL=29.4912 MHz) */
/*          : Run X2 Mode (58.9824 MHz)    */
/* Compiler : Keil C51 (V7.50)             */
/* Write By : Eakachai Makarn(ETT CO.,LTD.)*/
/*******************************************/

// Movling LED on P4[4..0] <-> P3[7..2] <-> P2[7..0] <-> P1[7..0] <-> P0[7..0]

/* Include  Section */
#include <reg52.h>							// Standard 8052 SFR : File

/* AT89C51AC3 SFR */
sfr CKCON = 0x8F;							// Clock Control
sfr P4 = 0xC0;								// Port P4

/* User Define Function */
void delay(unsigned long);					// Delay Time Function(1..4294967295)
											
void main()
{
  unsigned int j;				   			// LED Output Loop Count

  CKCON = 0x01;								// Initial X2 Mode (BUS Clock = 58.9824 MHz) 

  P0    |= 0xFF;							// OFF P0[7..0] Output
  P1    |= 0xFF;							// OFF P1[7..0] Output
  P2    |= 0xFF;							// OFF P2[7..0] Output
  P3    |= 0xFC;							// OFF P3[7..2] Output
  P4    |= 0x1F;							// OFF P4[4..0] Output

  while (1) 								// Loop Continue 
  {   
	/* Forward Direction */
    // Shift Left P0[7..0]                 							
    for (j=0x01; j<= 0x80; j<<=1)  			// Blink LED P0.7 <- P0.0
    {   
      P0 = 0xFF-j;                         	// Output to LED Port(Toggle Active=0) 			 
      delay(100000);
    }
	P0 |= 0xFF;	 							// OFF P0[7..0] LED Output

	// Shift Left P1[7..0]                 							
    for (j=0x01; j<= 0x80; j<<=1)  			// Blink LED P1.7 <- P1.0
    {   
      P1 = 0xFF-j;                         	// Output to LED Port(Toggle Active=0) 
      delay(100000);
    }
	P1 |= 0xFF;								// OFF P1[7..0] LED Output

	// Shift Left P2[7..0]                 							
    for (j=0x01; j<= 0x80; j<<=1)  			// Blink LED P2.7 <- P2.0
    {   
      P2 = 0xFF-j;                         	// Output to LED Port(Toggle Active=0) 
      delay(100000);
    }
	P2 |= 0xFF;								// OFF P2[7..0] LED Output

	// Shift Left P3[7..2]                 							
    for (j=0x04; j<= 0x80; j<<=1)  			// Blink LED P3.7 <- P3.2
    {   
      P3 = 0xFF-j;                         	// Output to LED Port(Toggle Active=0) 
      delay(100000);
    }
	P3 |= 0xFC;								// OFF P3[7..2] LED Output

	// Shift Left P4[4..0]                 							
    for (j=0x01; j<= 0x10; j<<=1)  			// Blink LED P4.4 <- P4.0
    {   
      P4 = 0xFF-j;                         	// Output to LED Port(Toggle Active=0) 
      delay(100000);
    }
	P4 |= 0x1F;				 				// OFF P4[4..0] LED Output


	/* Reverse Direction */
	// Shift Right P4[4..0]
    for (j=0x10; j>= 0x01; j>>=1)  			// Blink LED P4.4 -> P4.0
    {   
      P4 = 0xFF-j;                         	// Output to LED Port(Toggle Active=0)  
      delay(100000);
    }
	P4 |= 0x1F;								// OFF P4[4..0] LED Output

	// Shift Right P3[7..2]
    for (j=0x80; j>= 0x04; j>>=1)  			// Blink LED P3.7 -> P3.2
    {   
      P3 = 0xFF-j;                         	// Output to LED Port(Toggle Active=0)  
      delay(100000);
    }
	P3 |= 0xFC;								// OFF P3[7..2] LED Output

	// Shift Right P2[7..0]
    for (j=0x80; j>= 0x01; j>>=1)  			// Blink LED P2.7 -> P2.0
    {   
      P2 = 0xFF-j;                         	// Output to LED Port(Toggle Active=0)  
      delay(100000);
    }
	P2 |= 0xFF;								// OFF P2[7..0] LED Output
	
	// Shift Right P1[7..0]
    for (j=0x80; j>= 0x01; j>>=1)  			// Blink LED P1.7 -> P1.0
    {   
      P1 = 0xFF-j;                         	// Output to LED Port(Toggle Active=0)  
      delay(100000);
    }
	P1 |= 0xFF;								// OFF P1[7..0] LED Output

	// Shift Right P0[7..0]
    for (j=0x80; j>= 0x01; j>>=1)  			// Blink LED P0.7 -> P0.0
    {   
      P0 = 0xFF-j;                         	// Output to LED Port(Toggle Active=0)  
      delay(100000);
    }
	P0 |= 0xFF;								// OFF P0[7..0] LED Output
  }
}

/*******************************************/
/* Long Delay Time Function(1..4294967295) */
/*******************************************/
void delay(unsigned long i)
{
  while(i > 0) {i--;}						// Loop Decrease Counter	
  return;
}
	

    
	              
   