/*******************************************/
/* Example Program For ET-BASE51 AC3 V1.0  */
/* MCU      : AT89C51AC3(XTAL=29.4912 MHz) */
/*          : Run X2 Mode (58.9824 MHz)    */
/* Compiler : Keil C51 (V7.50)             */
/* Write By : Eakachai Makarn(ETT CO.,LTD.)*/
/*******************************************/
// LED Blink Test 

/* Include  Section */
#include <reg52.h>							// Standard 8052 SFR : File

/* AT89C51AC3 SFR */
sfr  CKCON = 0x8F;							// Clock Control
sfr  P4    = 0xC0;							// Port P4
sbit led   = P1^0;							// P1.0 = lED ON/OFF

/* User Define Function */
void delay(unsigned long);					// Delay Time Function(1..4294967295)
											
void main()
{
  CKCON = 0x01;								// Initial X2 Mode (BUS Clock = 58.9824 MHz) 
 
  while (1) 								// Loop Continue 
  {   	     
	 led = ~led;							// Tiggle LED
	 delay(50000);							// Delay Blink
  }	
}

/*******************************************/
/* Long Delay Time Function(1..4294967295) */
/*******************************************/
void delay(unsigned long i)
{
  while(i > 0) {i--;}						// Loop Decrease Counter	
  return;
}
	

    
	              
   