/*******************************************/
/* Example Program For ET-BASE51 AC3 V1.0  */
/* MCU      : AT89C51AC3(XTAL=29.4912 MHz) */
/*          : Run X2 Mode (58.9824 MHz)    */
/* Compiler : Keil C51 (V7.50)             */
/* Write By : Eakachai Makarn(ETT CO.,LTD.)*/
/*******************************************/
// Demo UART + Timer2 Baudrate

/* Include  Section */
#include <reg52.h>					// Standard 8052 SFR : File
#include <stdio.h>                	// For printf I/O functions

/* AT89C51AC3 SFR */
sfr CKCON = 0x8F;					// Clock Control

/* Timer2 Baudrate (29.4912 MHz x 2 ) 
   Reload = 65536 - [58.9824 MHz / (32 x Baud)]
   1200   = 0xFA00(65536-1536=64000)
   2400   = 0xFD00(65536-768=64768)
   4800   = 0xFE80(65536-384=65152)
   9600   = 0xFF40(65536-192=65344)
   19200  = 0xFFA0(65536-96=65440)
   38400  = 0xFFD0(65536-48=65488)
   57600  = 0xFFE0(65536-32=65504)
   115200 = 0xFFF0(65536-16=65520) 
*/				

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main (void) 
{      
    CKCON = 0x01;					// Initial X2 Mode (58.9824 MHz)
	                  
	// Initial Timer2 to Gen Baudrate 
    RCAP2H = 0xFF;        			// Setup Timer2 Baudrate = 9600 / 58.9824MHz
    RCAP2L = 0x40;                
    RCLK = 1;                       // Enable RXD Baudrate
    TCLK = 1;                       // Enable TXD Baudrate
	ET2 = 0;     					// Disable Timer2 Interrupt
    TR2 = 1;                        // Start Timer2 Generate Baudrate
    
	// Initial MCS51 Serial Port                           
    SCON  =  0x50;  				// Serial Port Mode 1 (N,8,1)
    ES    =  0;     				// Disable Serial Interupt    
    PCON &=  0x7F;  				// SMOD1 = 0 (Disable Double Baudrate)                                         
    TI    =  1;     				// Set TI to send First Char of UART 

    /* Print Message to RS232 */
    printf ("Hello World From ET-BASE51 AC3 V1.0\n");  

    while (1); 						// Loop Continue       
}


