/*******************************************/
/* Example Program For ET-BASE51 AC3 V1.0  */
/* MCU      : AT89C51AC3(XTAL=29.4912 MHz) */
/*          : Run X2 Mode (58.9824 MHz)    */
/* Compiler : Keil C51 (V7.50)             */
/* Write By : Eakachai Makarn(ETT CO.,LTD.)*/
/*******************************************/
// Demo UART + Timer1 Baudrate

/* Include  Section */
#include <reg52.h>					// Standard 8052 SFR : File
#include <stdio.h>                	// For printf I/O functions

/* AT89C51AC3 SFR */
sfr CKCON = 0x8F;					// Clock Control

/* Timer1 Baudrate (29.4912 MHz x 2 ) 
   Reload = 256 - [58.9824 MHz / (384 x Baud)]
   1200   = 0x80(256-128=128)
   2400   = 0xC0(256-94=192)
   4800   = 0xE0(256-32=224)
   9600   = 0xF0(256-16=240)
   19200  = 0xF8(256-8=248)
   38400  = 0xFC(256-4=252)   
*/				

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main (void) 
{      
    CKCON = 0x01;					// Initial X2 Mode (58.9824 MHz)
	                  
	/* Initial MCS51 Serial Port */
    TMOD &=  0x0F;  				// Reset old Timer1 Mode Config
    TMOD |=  0x20;  				// Update Timer1 = 8 Bit Auto Reload             
    SCON  =  0x50;  				// Serial Port Mode 1 (N,8,1)
    ES    =  0;     				// Disable Serial Interupt
    ET1   =  0;     				// Disable Timer1 Interrupt
    PCON &=  0x7F;  				// SMOD1 = 0 (Disable Double Baudrate)                  
    TH1   =  0xF0;  				// Setup Timer1 Baudrate 9600BPS / 58.9824 MHz
    TL1   =  0xF0;
    TR1   =  1;     				// Start Timer1 Generate Baudrate                      
    TI    =  1;     				// Set TI to send First char of UART

    /* Print Message to RS232 */
    printf ("Hello World From ET-BASE51 AC3 V1.0\n");  

    while (1); 						// Loop Continue       
}


