/*
 * Filename			: STKmc.c
 * Author			: Suwat Taechaphetpaibool    43410007
 *					  Supachai Budsaratij        43410011
 *                    KMUTT-Master Computer Engineering
 * Compiler			: Visual C++ v5
 * Complete Date	: Aug 10,2000  (Version 1.0)
 * Note				: Stack Machine Simulator
 */

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "opdef.h"

#define MAX_STACK       4096    /* 4K :Stack memory */
/*
 * I define stack operation with Hi to Lo.
 * Start of stack = 0x3FFF
 * End of stack   = 0x3000
 */
#define MAX_MEMORY      12288   /* 12K :Data + Code  */
/*
 * Start of Code/Data = 0x0000
 * End of Code/Data   = 0x2FFF
 */

#define MAX_IO  256

unsigned char IO[MAX_IO];

/*unsigned char MEM[MAX_MEMORY+MAX_STACK];*/
unsigned char * MEM;

unsigned short PC;      /* Program Counter : Point to MEM[]*/
unsigned short SP;      /* Stack Pointer   : Point to STK[]*/
unsigned char  IR;      /* IR kept OpCode (8 Bits) */

/*
 * Instruction set design
 *
 *       [-OpCode8bit-]
 *       [-OpCode8bit-][-Data--8bit-]
 *       [-OpCode8bit-][-Data-HiBit-][-Data-LoBit-]
 *
 * Instruction addressing mode
 *
 *       Immediate
 *       Direct
 *       Indirect
 */

unsigned long sum_inst; /* Summary of instruction */
unsigned long sum_clock;

unsigned char  Sflag;    /* Flag register */
unsigned char  Zflag;
unsigned char  Oflag;
unsigned char  Cflag;
/*
 * Byte no. | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
 *          +---+---+---+---+---+---+---+---+
 *          | S | Z | - | - | - | O | - | C |
 *
 *      S - Sign flag : 0 -> + , 1 -> -
 *      Z - Zero flag : 0 -> not 0, 1 -> 0
 *      O - Overflow flag : 0 -> Not overflow, 1 -> Overflow
 *      C - Carry flag : 0 -> Not carry , 1 -> Carry
 */

#define IsZero()        (Zflag == 1)
#define IsSign()        (Sflag == 1)
#define IsOverflow()    (Oflag == 1)
#define IsCarry()       (Cflag == 1)

#define SetZero()		(Zflag = 1)
#define SetSign()		(Sflag = 1)
#define SetOverflow()	(Oflag = 1)
#define SetCarry()		(Cflag = 1)

#define ClrZero()		(Zflag = 0)
#define ClrSign()		(Sflag = 0)
#define ClrOverflow()	(Oflag = 0)
#define ClrCarry()		(Cflag = 0)


void CPU_Reset(void);
void CPU_Fetch(void);
void CPU_Decode(void);
void CPU_Execute(void);
int  FindOperand(int byte);
void LoadOBJ(char * filename);
void LastRun(void);

#include "stkic.h"



void LastRun(void)
{
	FILE * stream;
	int fnd;
	stream = fopen("memmap2.txt","w");
	for (fnd = 0; fnd < MAX_MEMORY; fnd++) {
		//printf("MEM[%05d]=%d\n",fnd,MEM[fnd]);
		fprintf(stream,"MEM[%05d] = %d\n",fnd,MEM[fnd]);
    }
	fclose(stream);
}

void CPU_Reset(void)
{
    int i;

    printf("CPU reset ... ");
	MEM = (unsigned char *)malloc(MAX_MEMORY+MAX_STACK);
	if (MEM == 0) {
		printf("\nERROR\n not enough memory for allocation\n");
		exit(-1);
	}
    /*
     * Clear memory , stack and I/O memory.
     */
    for ( i = 0; i < MAX_MEMORY; i++) MEM[i] = 0x00;
    for ( i = 0; i < MAX_STACK; i++)  MEM[0x3FFF-i] = 0x00;
    for ( i = 0; i < MAX_IO; i++)     IO[i] = 0x00;
    PC = 0x0000;
    SP = 0x0000;
    Sflag = 0;
    Zflag = 0;
    Oflag = 0;
    Cflag = 0;
	sum_inst = 0;
	sum_clock = 0;
    printf(" success ...\n");
}

void CPU_Fetch(void)
{
    IR = MEM[PC];
}

void CPU_Decode(void)
{
    switch (IR) {
    case op_ldi  : opLDI();  break;
    case op_ldiw : opLDIW(); break;
    case op_ldd  : opLDD();  break;
    case op_lddw : opLDDW(); break;
    case op_lda  : opLDA();  break;
    case op_sta  : opSTA();  break;
    case op_std  : opSTD();  break;
    case op_stdw : opSTDW(); break;
    case op_in   : opIN();   break;
    case op_out  : opOUT();  break;
    case op_ldaw : opLDAW(); break;
    case op_staw : opSTAW(); break;
    case op_mul  : opMUL();  break;
    case op_mulw : opMULW(); break;
    case op_div  : opDIV();  break;
    case op_divw : opDIVW(); break;
    case op_sub  : opSUB();  break;
    case op_subw : opSUBW(); break;
    case op_add  : opADD();  break;
    case op_addw : opADDW(); break;
    case op_inc  : opINC();  break;
    case op_incw : opINCW(); break;
    case op_dec  : opDEC();  break;
    case op_decw : opDECW(); break;
    case op_call : opCALL(); break;
    case op_ret  : opRET();  break;
    case op_jmp  : opJMP();  break;
    case op_jmr  : opJMR();  break;
    case op_jz   : opJZ();   break;
    case op_jnz  : opJNZ();  break;
    case op_jo   : opJO();   break;
    case op_jno  : opJNO();  break;
    case op_jc   : opJC();   break;
    case op_jnc  : opJNC();  break;
    case op_js   : opJS();   break;
    case op_jns  : opJNS();  break;
    case op_nop  : break;
    case op_hlt  : printf("\n-HALT-\n");getch();break;
    case op_shl  : opSHL();break;
    case op_shlw : opSHLW();break;
    case op_shr  : opSHR();break;
    case op_shrw : opSHRW();break;
    case op_rol  : opROL();break;
    case op_rolw : opROLW();break;
    case op_ror  : opROR();break;
    case op_rorw : opRORW();break;
    case op_and  : opAND();break;
    case op_andw : opANDW();break;
    case op_or   : opOR();break;
    case op_orw  : opORW();break;
    case op_not  : opNOT();break;
    case op_notw : opNOTW();break;
    case op_xor  : opXOR();break;
    case op_xorw : opXORW();break;
    case op_cmp  : opCMP();break;
    case op_cmpw : opCMPW();break;
	default:
		printf("\n-ERROR-\n unknown machine code\n");
		PC -= icTable[IR].Bytes;
		printf("PC = %05d [%04X], ", PC, PC);
		printf("IR = %03d [%02X]\n", IR, IR);
		free(MEM);
		exit(-1);
    }
	sum_inst++;
	sum_clock+=icTable[IR].Cycle;
	if (PC > 0x2FFF) {
		printf("\n-ERROR-\n PC overload (PC > MAX_MEMORY)\n");
		PC -= icTable[IR].Bytes;
		printf("PC = %05d [%04X], ", PC, PC);
		printf("IR = %03d [%02X]\n", IR, IR);
		free(MEM);
		exit(-1);
	}
}

int FindOperand(int byte)
{
    int loops;
    int yes=0;
    int maxLoops = sizeof(icTable)/sizeof(struct NmTable);

    for (loops = 0; loops < maxLoops; loops++) {
	if (byte == icTable[loops].Hex) {
	    yes = icTable[loops].Bytes;
	    return(yes);
	}
    }
    return(1);
}


void LoadOBJ(char * filename)
{
    FILE *  stream;
    char    byte[20];
    char    addr[20];
    char    opr[20];
    int     addr16;
    unsigned char   hex;
    int     oper;
    int     fnd;
    int     cntMax = 0;

    stream = fopen(filename,"r");
    if (stream == NULL) {
		printf("\nERROR\nFile not found\n");
		exit(-1);
    }
    while (!feof(stream)) {
		fscanf(stream,"%s", addr);
		fscanf(stream,"%s", byte);
		hex = (unsigned char)(atoi(byte));
		addr16 = atoi(addr);
		if (hex == 255) { // read data
			fscanf(stream,"%s", byte);
			hex = (unsigned char)(atoi(byte));
			MEM[addr16] = hex;
			cntMax++;
		}
		else { // OPCode
		    MEM[addr16] = hex;
			cntMax++;
			fnd = FindOperand(hex);
			if (fnd != 1) {
				fscanf(stream, "%s", opr);
				oper = atoi(opr);
				if (fnd == 2) {
					MEM[addr16+1] = (unsigned char)oper;
					cntMax++;
				}
				else {
					MEM[addr16+1] = (unsigned char)Lo(oper);
					MEM[addr16+2] = (unsigned char)Hi(oper);
					cntMax+=2;
				}
			}
		}
    }
    fclose(stream);

	stream = fopen("memmap.txt","w");
	for (fnd = 0; fnd < MAX_MEMORY; fnd++) {
		//printf("MEM[%05d]=%d\n",fnd,MEM[fnd]);
		fprintf(stream,"MEM[%05d] = %d\n",fnd,MEM[fnd]);
    }
	fclose(stream);
}


void main()
{
    char filename[256];

    CPU_Reset();

    printf("- Stack machine simulator -\n");
    printf("- Object code file :");
    gets(filename);
	if (strlen(filename) == 0) {
		printf("\nERROR\n Inputfile error\n");
		printf("program terminated!\n");
	}
	else {
		LoadOBJ(filename);

		do {
			if (_kbhit()) {
				if (getch() == 27) {
					printf("\n-user terminated-\n");
					printf("PC = %05d [%04X], ", PC, PC);
					printf("IR = %03d [%02X]\n", IR, IR);
					LastRun();
					free(MEM);
					exit(-1);
				}
			}
			CPU_Fetch();
//			printf("PC = %05d [%04X]", PC, PC);
//			printf("IR = %03d [%02X]\n", IR, IR);
			ShowRunning();
			CPU_Decode();
		} while (IR != op_hlt);

	}
	printf("No. instruction = %d\nNo. clock = %d,", sum_inst, sum_clock);
	printf("CPI = %f\n",(float)(((float)sum_clock/(float)sum_inst)));
	LastRun();
	free(MEM);
}
