/*
 * Filename			: STKic.H
 * Author			: Suwat Taechaphetpaibool    43410007
 *					  Supachai Budsaratij        43410011
 *                    KMUTT-Master Computer Engineering
 * Compiler			: Visual C++ v5
 * Complete Date	: Aug 10,2000  (Version 1.0)
 * Note				: Stack Machine Simulator
 */

#include <limits.h>
#include <stdlib.h>

int  Hi(int dat);
int  Lo(int dat);
int  pop(void);
void push(int dat);
void opLDI(void);
void opLDIW(void);
void opLDD(void);
void opLDDW(void);
void opLDA(void);
void opSTA(void);
void opSTD(void);
void opSTDW(void);
void opIN(void);
void opOUT(void);
void opMUL(void);
void opMULW(void);
void opDIV(void);
void opDIVW(void);
void opSUB(void);
void opSUBW(void);
void opADD(void);
void opADDW(void);
void opINC(void);
void opINCW(void);
void opDEC(void);
void opDECW(void);
void opCALL(void);
void opRET(void);
void opJMP(void);
void opJMR(void);
void opJZ(void);
void opJNZ(void);
void opJO(void);
void opJNO(void);
void opJC(void);
void opJNC(void);
void opJS(void);
void opJNS(void);
void opSHL(void);
void opSHLW(void);
void opSHR(void);
void opSHRW(void);
void opROL(void);
void opROLW(void);
void opROR(void);
void opRORW(void);
void opAND(void);
void opANDW(void);
void opOR(void);
void opORW(void);
void opNOT(void);
void opNOTW(void);
void opXOR(void);
void opXORW(void);
void opCMP(void);
void opCMPW(void);

// --- ---- --- ---- - -- - -- ---------- - - -

int Hi(int dat)
{
    return(dat>>=8);
}

int Lo(int dat)
{
    return(dat &= 0x00FF);
}

int pop(void)
{
	if (SP > 0x3FFF) {
		printf("\nERROR\n Stack underflow\n");
		printf("PC = %05d [%04X], ", PC, PC);
		printf("IR = %03d [%02X]\n", IR, IR);
		LastRun();
		free(MEM);
		exit(-1);
	}
    SP++;
//    printf("-pop- data=%d\n",MEM[SP-1]);
//    return(MEM[SP-1]);
    return(MEM[SP]);
}

void push(int dat)
{
    if (SP == 0x0000) SP=0x3FFF;
	MEM[SP] = dat;
//    printf("-push- data=%d\n",MEM[SP]);
    SP--;
	if (SP < 0x3000) {
		printf("\nERROR\n Stack overflow\n");
		printf("PC = %05d [%04X], ", PC, PC);
		printf("IR = %03d [%02X]\n", IR, IR);
		LastRun();
		free(MEM);
		exit(-1);
	}
}


void opLDI(void)
{
    push(MEM[PC+1]);
    PC += icTable[op_ldi].Bytes;
}


void opLDIW(void)
{
    push(MEM[PC+2]);
    push(MEM[PC+1]);
    PC += icTable[op_ldiw].Bytes;
}


void opLDD(void)
{
     int addr;
     addr = MEM[PC+1] | (MEM[PC+2]<<8);
     push(MEM[addr]);
     PC += icTable[op_ldd].Bytes;
}


void opLDDW(void)
{
     int addr;
     addr = MEM[PC+1] | (MEM[PC+2]<<8);
     push(MEM[addr+1]);
     push(MEM[addr]);
     PC += icTable[op_lddw].Bytes;
}


void opLDA(void)
{
    int addr;
	int a, b;
    unsigned int indirect;
	a = MEM[PC+1];
	b = MEM[PC+2];
    addr = a | (b<<8);
	a = MEM[addr];
	b = MEM[addr+1];
    indirect = a | (b<<8);
	if (indirect > 0x2FFF) {
		printf("\n-LDA-\n ERROR indirect overload (> MAX_MEMORY)\n");
		printf("PC = %u, IR = %d\n",PC,IR);
		free(MEM);
		exit(-1);
	}
    push(MEM[indirect]);
    PC += icTable[op_lda].Bytes;
}

void opLDAW(void)
{
    int addr;
    int indirect;
    addr = MEM[PC+1] | (MEM[PC+2]<<8);
    indirect = MEM[addr] | (MEM[addr+1]<<8);
    push(MEM[indirect+1]);
    push(MEM[indirect]);
    PC += icTable[op_ldaw].Bytes;
}


void opSTA(void)
{
    int addr;
    int indirect;
    addr = MEM[PC+1] | (MEM[PC+2]<<8);
    indirect = MEM[addr] | (MEM[addr+1]<<8);
	if (indirect > 0x2FFF) {
		printf("\n-STA-\n ERROR indirect overload (> MAX_MEMORY)\n");
		free(MEM);
		exit(-1);
	}
    MEM[indirect] = pop();
    PC += icTable[op_sta].Bytes;
}

void opSTAW(void)
{
    int addr;
    int indirect;
    addr = MEM[PC+1] | (MEM[PC+2]<<8);
    indirect = MEM[addr] | (MEM[addr+1]<<8);
    MEM[indirect] = pop();
    MEM[indirect+1] = pop();
    PC += icTable[op_staw].Bytes;
}


void opSTD(void)
{
     int addr;
     addr = MEM[PC+1] | (MEM[PC+2]<<8);
     MEM[addr] = pop();
     PC += icTable[op_std].Bytes;
}


void opSTDW(void)
{
     int addr;
     addr = MEM[PC+1] | (MEM[PC+2]<<8);
     MEM[addr] = pop();
     MEM[addr+1] = pop();
     PC += icTable[op_stdw].Bytes;
}


void opIN(void)
{
    if (MEM[PC+1] == 1) getch();
    else push(IO[MEM[PC+1]]);
    PC += icTable[op_in].Bytes;
}


void opOUT(void)
{
    IO[MEM[PC+1]] = pop();
    if ((MEM[PC+1]) == 0) {
		printf("\n-[%d : %02Xh]-",IO[MEM[PC+1]],IO[MEM[PC+1]]); 
//		getch();
    }
    PC += icTable[op_out].Bytes;
}


void opMUL(void)
{
    int a,b,c;
    int r;

    a = pop();
    b = pop();
    c = 0;
    ClrOverflow();
    while (b > 0) {
		r = CHAR_MAX-c;
		if (a > r) {
			SetOverflow();
		}
		c +=a;
		b--;
	}
	if (c == 0) {
		SetZero();
	}
	else {
		ClrZero();
	}
	if (c < 0) {
		SetSign();
	}
	else {
		ClrSign();
	}
    push((c));
    PC += icTable[op_mul].Bytes;
}


void opMULW(void)
{
    int a,b,c;
    int r;

    a = pop();
    a = (pop()<<8)|a;
    b = pop();
    b = (pop()<<8)|b;
    c = 0;
    ClrOverflow();
    while (b > 0) {
	r = INT_MAX-c;
	if (a > r) SetOverflow();
	c +=a;
	b--;
    }
    if (c == 0) SetZero();
    else ClrZero();
    if (c < 0) SetSign();
    else ClrSign();
    push(Hi(c));
    push(Lo(c));
    PC += icTable[op_mulw].Bytes;
}


void opDIV(void)
{
    int a,b,c;

    a = pop();
    b = pop();
    if (b == 0) {
		printf("\nERROR\nDevide by zero\n");
		LastRun();
		free(MEM);
		exit(-1);
    }
    c = a/b;
    if (c == 0) SetZero();
    else ClrZero();
    if (c < 0) SetSign();
    else ClrSign();
    push((c));
    PC += icTable[op_div].Bytes;
}


void opDIVW(void)
{
    int a,b,c;

    a = pop();
    a = (pop()<<8)|a;
    b = pop();
    b = (pop()<<8)|b;
    if (b == 0) {
		printf("\nERROR\nDevide by zero\n");
		LastRun();
		free(MEM);
		exit(-1);
    }
    c = a/b;
    if (c == 0) SetZero();
    else ClrZero();
    if (c < 0) SetSign();
    else ClrSign();
    push(Hi(c));
    push(Lo(c));
    PC += icTable[op_divw].Bytes;
}


void opSUB(void)
{
    int a,b,c;

    a = pop();
    b = pop();
    c = a-b;
    if (c == 0) SetZero();
    else ClrZero();
    if (c < 0) SetSign();
    else ClrSign();
    push((c));
    PC += icTable[op_sub].Bytes;
}


void opSUBW(void)
{
    int a,b,c;

    a = pop();
    a = (pop()<<8)|a;
    b = pop();
    b = (pop()<<8)|b;
    c = a-b;
    if (c == 0) SetZero();
    else ClrZero();
    if (c < 0) SetSign();
    else ClrSign();
    push(Hi(c));
    push(Lo(c));
    PC += icTable[op_subw].Bytes;
}

void opADD(void)
{
    int a,b,c;
    int r;

    a = pop();
    b = pop();
    r = CHAR_MAX-a;
    if (b > r) SetOverflow();
    else ClrOverflow();

    c = a+b;
//    printf("-ADD- a=%d, b=%d, c=%d\n",a,b,c); getch();

    if (c == 0) SetZero();
    else ClrZero();
    if (c < 0) SetSign();
    else ClrSign();
    push((c));
    PC += icTable[op_add].Bytes;
}


void opADDW(void)
{
    int a,b,c;
    int r;

    a = pop();
    a = (pop()<<8)|a;
    b = pop();
    b = (pop()<<8)|b;
    r = INT_MAX-a;
    if (b > r) SetOverflow();
    else ClrOverflow();
    c = a+b;
    if (c == 0) SetZero();
    else ClrZero();
    if (c < 0) SetSign();
    else ClrSign();
    push(Hi(c));
    push(Lo(c));
    PC += icTable[op_addw].Bytes;
}


void opINC(void)
{
    int a;
    a = pop();
//    printf("-INC- Be=%d, ",a);
    if (a == 255) SetOverflow();
    else ClrOverflow();
    a++;
    if (a < 0) SetSign();
    else ClrSign();
    if (a == 0) SetZero();
    else ClrZero();
//    printf("Af=%d\n",a); getch();
    push((a));
    PC += icTable[op_inc].Bytes;
}


void opINCW(void)
{
    int a;
    a = pop();
    a = (pop()<<8)|a;
    if (a == INT_MAX) SetOverflow();
    else ClrOverflow();
    a++;
    if (a < 0) SetSign();
    else ClrSign();
    if (a == 0) SetZero();
    else ClrZero();
    push(Hi(a));
    push(Lo(a));
    PC += icTable[op_incw].Bytes;
}


void opDEC(void)
{
    int a;
    a = pop();
    a--;
    if (a < 0) SetSign();
    else ClrSign();
    if (a == 0) SetZero();
    else ClrZero();
    push((a));
    PC += icTable[op_dec].Bytes;
}

void opDECW(void)
{
    int a;
    a = pop();
    a = (pop()<<8)|a;
    a--;
    if (a < 0) SetSign();
    else ClrSign();
    if (a == 0) SetZero();
    else ClrZero();
    push(Hi(a));
    push(Lo(a));
    PC += icTable[op_decw].Bytes;
}


void opCALL(void)
{
    push(Hi(PC+3));
    push(Lo(PC+3));
    PC = MEM[PC+1]|MEM[PC+2]<<8;
}


void opRET(void)
{
    int a;
    a = pop();
    PC = (pop()<<8)|a;
}


void opJMP(void)
{
    PC=MEM[PC+1]|MEM[PC+2]<<8;
}


void opJMR(void)
{
    int a;
    a = PC+1;
    PC += MEM[a];
}


void opJZ(void)
{
	if (IsZero()==1) {
		PC=MEM[PC+1]|(MEM[PC+2]<<8);
		
		//printf("\n-JZ- False\n"); 	getch();
	}
	else {
		PC += icTable[op_jz].Bytes;
		
		//printf("\n-JZ- False\n"); getch();
	}
}


void opJNZ(void)
{
   if (IsZero()==0) PC=MEM[PC+1]|(MEM[PC+2]<<8);
   else PC += icTable[op_jnz].Bytes;
}


void opJO(void)
{
   if (IsOverflow()==1) PC=MEM[PC+1]|(MEM[PC+2]<<8);
   else PC += icTable[op_jo].Bytes;
}


void opJNO(void)
{
   if (IsOverflow()==0) PC=MEM[PC+1]|(MEM[PC+2]<<8);
   else PC += icTable[op_jno].Bytes;
}


void opJC(void)
{
   if (IsCarry()==1) PC=MEM[PC+1]|(MEM[PC+2]<<8);
   else PC += icTable[op_jc].Bytes;
}


void opJNC(void)
{
   if (IsCarry()==0) PC=MEM[PC+1]|(MEM[PC+2]<<8);
   else PC += icTable[op_jnc].Bytes;
}


void opJS(void)
{
   if (IsSign()==1) PC=MEM[PC+1]|(MEM[PC+2]<<8);
   else PC += icTable[op_js].Bytes;
}


void opJNS(void)
{
	if (IsSign()==0) {
		PC=MEM[PC+1]|(MEM[PC+2]<<8);
		
		//printf("\n-JNS- True\n"); getch();
	}
    else {
		PC += icTable[op_jns].Bytes;
		
		// printf("\n-JNS- False\n"); getch();
	}
}


void opSHLW(void)
{
    unsigned int a;
    a = pop();
    a = (pop()<<8)|a;
    if (a & 0x8000) SetCarry();
    else ClrCarry();
    a <<= 1;
    if (a == 0) SetZero();
    else ClrZero();
    push(Hi(a));
    push(Lo(a));
    PC += icTable[op_shlw].Bytes;
}


void opSHL(void)
{
    unsigned int a;
    a = pop();
//    printf("\n-SHL- before ,a=%d\n", a);

    if (a & 0x80) SetCarry();
    else ClrCarry();

//    printf("\n-SHL- before ,a=%d\n", a);
    a <<= 1;

//    printf("\n-SHL- a=%d\n", a);
    if (a == 0) SetZero();
    else ClrZero();
    push((a));
    PC += icTable[op_shl].Bytes;
}


void opSHR(void)
{
    unsigned int a;
    a = pop();
    if (a & 0x01) SetCarry();
    else ClrCarry();
    a >>= 1;
    if (a == 0) SetZero();
    else ClrZero();
    push((a));
    PC += icTable[op_shr].Bytes;
}


void opSHRW(void)
{
    unsigned int a;
    a = pop();
    a = (pop()<<8)|a;
    if (a & 0x01) SetCarry();
    else ClrCarry();
    a >>= 1;
    if (a == 0) SetZero();
    else ClrZero();
    push(Hi(a));
    push(Lo(a));
    PC += icTable[op_shrw].Bytes;
}


void opROL(void)
{
    unsigned int a;
    a = pop();
    if (a&0x80) SetCarry();
    else ClrCarry();
    a <<=1;
    if (IsCarry()) a|=1;
    if (a == 0) SetZero();
    else ClrZero();
    push(a);
    PC += icTable[op_rol].Bytes;
}


void opROLW(void)
{
    unsigned int a;
    a = pop();
    a = (pop()<<8)|a;
    if (a&0x8000) SetCarry();
    else ClrCarry();
    a <<=1;
    if (IsCarry()) a|=1;
    if (a == 0) SetZero();
    else ClrZero();
    push(Hi(a));
    push(Lo(a));
    PC += icTable[op_rolw].Bytes;
}


void opROR(void)
{
    unsigned int a;
    a = pop();
    if (a&0x01) SetCarry();
    else ClrCarry();
    a >>=1;
    if (IsCarry()) a|=0x80;
    if (a == 0) SetZero();
    else ClrZero();
    push(a);
    PC += icTable[op_ror].Bytes;
}


void opRORW(void)
{
    unsigned int a;
    a = pop();
    a = (pop()<<8)|a;
    if (a&0x01) SetCarry();
    else ClrCarry();
    a >>=1;
    if (IsCarry()) a|=0x80;
    if (a == 0) SetZero();
    else ClrZero();
    push(Hi(a));
    push(Lo(a));
    PC += icTable[op_rorw].Bytes;
}


void opAND(void)
{
    unsigned int a,b,c;
    a = pop();
    b = pop();
    c = a&b;
    if (c == 0) SetZero();
    push(c);
    PC += icTable[op_and].Bytes;
}


void opANDW(void)
{
    unsigned int a,b,c;
    a = pop();
    a = pop()<<8|a;
    b = pop();
    b = pop()<<8|b;
    c = a&b;
    if (c == 0) SetZero();
    else ClrZero();
    push(Hi(c));
    push(Lo(c));
    PC += icTable[op_andw].Bytes;
}


void opOR(void)
{
    unsigned int a,b,c;
    a = pop();
    b = pop();
    c = a|b;
    if (c == 0) SetZero();
    else ClrZero();
    push(c);
    PC += icTable[op_or].Bytes;
}


void opORW(void)
{
    unsigned int a,b,c;
    a = pop();
    a = pop()<<8|a;
    b = pop();
    b = pop()<<8|b;
    c = a|b;
    if (c == 0) SetZero();
    else ClrZero();
    push(Hi(c));
    push(Lo(c));
    PC += icTable[op_orw].Bytes;
}


void opNOT(void)
{
    unsigned int a;
    a = pop();
    a = !a;
    if (a == 0) SetZero();
    else ClrZero();
    push(a);
    PC += icTable[op_not].Bytes;
}


void opNOTW(void)
{
    unsigned int a;
    a = pop();
    a = pop()<<8|a;
    a = !a;
    if (a == 0) SetZero();
    else ClrZero();
    push(Hi(a));
    push(Lo(a));
    PC += icTable[op_notw].Bytes;
}


void opXOR(void)
{
    unsigned int a,b,c;
    a = pop();
    b = pop();
    c = a^b;
    if (c == 0) SetZero();
    else ClrZero();
    push(c);
    PC += icTable[op_xor].Bytes;
}


void opXORW(void)
{
    unsigned int a,b,c;
    a = pop();
    a = pop()<<8|a;
    b = pop();
    b = pop()<<8|b;
    c = a^b;
    if (c == 0) SetZero();
    else ClrZero();
    push(Hi(c));
    push(Lo(c));
    PC += icTable[op_xorw].Bytes;
}


void opCMP(void)
{
    int a,b,c;
    a = pop();
    b = pop();
    c = a-b;
    
	// printf("\n-CMP- a=%d, b=%d, c=%d\n",a,b,c);getch();

	if (c == 0) SetZero();
    else ClrZero();
    if (c < 0) SetSign();
    else ClrSign();
    PC += icTable[op_cmp].Bytes;
}

void opCMPW(void)
{
    int a,b,c;
    a = pop();
    a = pop()<<8|a;
    b = pop();
    b = pop()<<8|b;
	c = a-b;
	
	// printf("\n-CMPW- a=%d, b=%d, c=%d\n",a,b,c);getch();

    if (c == 0) SetZero();
    else ClrZero();
    if (c < 0) SetSign();
    else ClrSign();
    PC += icTable[op_cmpw].Bytes;
}
