/*
 * Filename			: STKAsm.C
 * Author			: Suwat Taechaphetpaibool    43410007
 *					  Supachai Budsaratij        43410011
 *                    KMUTT-Master Computer Engineering
 * Compiler			: Visual C++ v5
 * Complete Date	: Aug 10,2000  (Version 1.0)
 * Note				: Stack Machine Assembler
 */

#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include "opdef.h"

#define MAX_SYMB        512

#define SYMBOL          1
#define INSTRUCTION     2
#define DIRECTIVE       3
#define NUMBER          5
#define	DONTKNOWN       6
#define COMMENT			7
#define EndOfLine		9
#define EndOfFile		10

struct SymTable {
    char label[20];
    unsigned short address;
};

struct SymTable sTable[MAX_SYMB];  /* Kept symbol table */
char Directive[][4] = { "org", "end", "db", "dw" };

// ---------------------------------------------------------------

char pFile1[256];
char pFile2[256];
char pFile3[256];
FILE * stream;
FILE * p1stream;
FILE * p2stream;

// ---------------------------------------------------------------

char lbState;
int  counter;
int  symCount;
char token[256];
char text[80];
char * tokenPoint;
long  uLine;
int   passed;

// ---------------------------------------------------------------

void CutExt(char *iFile, char *oFile);
int  ChkExt(char *iFile);
void ChangeExt(char * pFile, char * ext);
int  IsDirective(char * text);
int  IsInstruction(char *test);
int  GetToken(char *buffer);
void pass1(void);

int  IsDirective2(char * text);
int  IsInstruction2(char *test);
void pass2(void);

#include "pass1.h"

// ---------------------------------------------------------------
int Hi(int dat)
{
    return(dat>>=8);
}

int Lo(int dat)
{
    return(dat &= 0x00FF);
}

int IsDirective2(char * text)
{
    int loops;
    int yes=0;
    int maxLoops = sizeof(Directive)/4;
    char cv2i[20];
    char *tmp;
    tmp = cv2i;

    for (loops = 0; loops < maxLoops; loops++) {
	if (strcmp(text,Directive[loops]) == 0) yes = 1;
    }
    if (yes == 1) {
	if (strcmp(text,"org")==0) {
	    while (*tokenPoint == ' ') tokenPoint++;
	    if (isdigit(*tokenPoint)) {
		do  {
		    *tmp++ = *tokenPoint++;
		} while (isdigit(*tokenPoint));
		*tmp = 0;
		counter = atoi(cv2i);
	    }
	}
	else if (strcmp(text,"db") == 0) {
	    while (*tokenPoint == ' ') tokenPoint++;
	    if (isdigit(*tokenPoint)) {
		do  {
		    *tmp++ = *tokenPoint++;
		} while (isdigit(*tokenPoint));
		*tmp = 0;
		fprintf(p2stream,"%d 255 %s\n", counter, cv2i);
		counter++;
	    }
	}
	else if (strcmp(text,"dw") == 0) {
	    while (*tokenPoint == ' ') tokenPoint++;
	    if (isdigit(*tokenPoint)) {
		do  {
		    *tmp++ = *tokenPoint++;
		} while (isdigit(*tokenPoint));
		*tmp = 0;
		fprintf(p2stream,"%d 255 %d\n", counter, Lo(atoi(cv2i)));
		fprintf(p2stream,"%d 255 %d\n", counter+1, Hi(atoi(cv2i)));
		counter+=2;
	    }
	}
    }
    return(yes);
}

// ---------------------------------------------------------------

int IsInstruction2(char * text)
{
    int loops;
    int yes=0;
    char cv2i[20];
    int found = 0;
    int i;
    int maxLoops = sizeof(icTable)/sizeof(struct NmTable);
    char *tmp = cv2i;

    for (loops = 0; loops < maxLoops; loops++) {
	if (strcmp(text,icTable[loops].Nmemonic) == 0) {
	    yes = 1;
	    fprintf(p2stream,"%d %d ",counter, icTable[loops].Hex);
	    if (icTable[loops].Bytes > 1) { // Get operand
		while (*tokenPoint == ' ') tokenPoint++; // skip blank
		if (isdigit(*tokenPoint)) {
		    do  {
			*tmp++ = *tokenPoint++;
		    } while (isdigit(*tokenPoint));
		    *tmp = 0;
		    fprintf(p2stream,"%s ",cv2i);
		}
		// Find symbol
		if (isalpha(*tokenPoint)) {
		    do {
			*tmp++ = *tokenPoint++;
		    } while (isdigit(*tokenPoint)||isalpha(*tokenPoint));
		    *tmp = 0;
		    for (i = 0; i < symCount; i++) {
			if (strcmp(cv2i,sTable[i].label) == 0) {
			    found = 1;
			    fprintf(p2stream, "%d ",sTable[i].address);
			}
		    }
		    if (found == 0) {
			fcloseall();
			printf("\nERROR\nCan not find symbol [%s]\n",cv2i);
			exit(-1);
		    }
		}

	    }
	    fprintf(p2stream,"\n");
	    counter += icTable[loops].Bytes;
	}
	found = 0;
    }
    return(yes);
}

// ---------------------------------------------------------------

char * SkipSpace(char *buffer)
{
	while (*buffer == ' ') buffer++;
	return(buffer);
}

char * SkipUntilEOL(char *buffer)
{
	while ((*buffer != '\r')&&(*buffer != '\n')) {
		printf("%c ",*buffer);
		buffer++;
	}
	return(buffer);
}

int GetToken(char *buffer)
{
    int tokenType = DONTKNOWN;
    char * temp = buffer;
    *temp = 0;
    lbState = 0;

    if (*tokenPoint == '\t') *tokenPoint = ' ';
    
	if (*tokenPoint < ' ') *tokenPoint = ' ';
	
	tokenPoint = SkipSpace(tokenPoint);

    if ((*tokenPoint == '\0')||(*tokenPoint == '\r')||(*tokenPoint == '\n')) {
		uLine++;
		return(EndOfLine);
    }
    
/* Checking for comment */
	if (*tokenPoint == ';') {
		//tokenPoint++;
		tokenPoint = SkipUntilEOL(tokenPoint);
		uLine++;
		return(EndOfLine);
	}
//while (*tokenPoint == ' ') tokenPoint++; // Skip space
    if (*tokenPoint == '[') {
		tokenPoint++;
		lbState = 1;
		if (isalpha(*tokenPoint)) {
			do {
				*temp++ = tolower(*tokenPoint++);
			} while (isalpha(*tokenPoint)||isdigit(*tokenPoint));
			*temp = '\0';
			strcpy(sTable[symCount].label,buffer);
			sTable[symCount].address = counter;
			symCount++;
		    return(SYMBOL);
		}
		return(DONTKNOWN);
	}
	if (isalpha(*tokenPoint)) {
		do {
		    *temp++ = tolower(*tokenPoint++);
		} while (isalpha(*tokenPoint)||isdigit(*tokenPoint));
		*temp = '\0';

		if (passed == 1) {
		    if (IsDirective(buffer)==1)   return(DIRECTIVE);
		    if (IsInstruction(buffer)==1) return(INSTRUCTION);
		}
		else {
		    if (IsDirective2(buffer)==1)   return(DIRECTIVE);
			if (IsInstruction2(buffer)==1) return(INSTRUCTION);
		}
		return(SYMBOL);
		}
		if (isdigit(*tokenPoint)) {
		do  {
			*temp++ = *tokenPoint++;
		} while (isdigit(*tokenPoint));
		*temp = 0;
		return(NUMBER);
    }

    *temp++ = tolower(*tokenPoint++);
    *temp = 0;
    tokenType = DONTKNOWN;

    return(tokenType);
}

// ---------------------------------------------------------------

void pass2()
{
     int    tkType;
     int    endState = 0;

     counter = 0;
     uLine = 0;

     printf("\n-pass2-\n");
     p1stream = fopen(pFile2,"r");
     if (p1stream == 0) {
	 printf("\n File not found\n");
	 return;
     }
     p2stream = fopen(pFile3, "w");
     if (p2stream == 0) {
	 printf("\n File can not create for PASS2\n");
	 return;
     }

     while ((!feof(p1stream))&&(endState==0)) {
	     fgets(token, 256, stream);
	     tokenPoint = token;

	     while ((tkType = GetToken(text)) != EndOfLine) {
			 if (strcmp(text,"end")==0) endState = 1;
	     }

     }
     fclose(p2stream);
     fclose(p1stream);

}

// ---------------------------------------------------------------

void main()
{
    passed = 1;
    pass1();
    passed = 2;
    pass2();
	unlink(pFile2);
}