/*
 * Filename			: Pass1.H
 * Author			: Suwat Taechaphetpaibool    43410007
 *					  Supachai Budsaratij        43410011
 *                    KMUTT-Master Computer Engineering
 * Compiler			: Visual C++ v5
 * Complete Date	: Aug 10,2000  (Version 1.0)
 * Note				: Stack Machine Assembler
 */

void CutExt(char *iFile, char *oFile)
{
    while (*iFile != '.') {
		*oFile++ = *iFile++;
	}
    *oFile = '\0';
}

int ChkExt(char *iFile)
{
    int found;
    found = 0;
    while ((*iFile != '\0')&&(found == 0)) {
		if (*iFile == '.') {
			found = 1;
		}
		iFile++;
    }
    return(found);
}

void ChangeExt(char * pFile, char * ext)
{
    while (*pFile++ != '\0');
    pFile--;
    *pFile++ = '.';
    while(*ext != '\0') {
		*pFile++ = *ext++;
    }
    *pFile = '\0';
}


// ---------------------------------------------------------------

int IsDirective(char * text)
{
    int loops;
    int yes=0;
    int maxLoops = sizeof(Directive)/4;
    char cv2i[20];
    char *tmp;
    tmp = cv2i;

    for (loops = 0; loops < maxLoops; loops++) {
		if (strcmp(text,Directive[loops]) == 0) yes = 1;
    }
    if (yes == 1) {
		if (strcmp(text,"org")==0) {
		    while (*tokenPoint == ' ') tokenPoint++;
		    if (isdigit(*tokenPoint)) {
				do  {
				    *tmp++ = *tokenPoint++;
				} while (isdigit(*tokenPoint));
				*tmp = '\0';
				counter = atoi(cv2i);
				fputs(text,p1stream);
				fputs(" ", p1stream);
				fputs(cv2i, p1stream);
		    }
		    else {
				fcloseall();
				printf("\nERROR\nLine %d : ORG syntax error\n", uLine+1);
				exit(-1);
		    }
		}
		else if (strcmp(text,"db")==0) {
		    while (*tokenPoint == ' ') tokenPoint++;
		    if (isdigit(*tokenPoint)) {
				do  {
				    *tmp++ = *tokenPoint++;
				} while (isdigit(*tokenPoint));
				*tmp = '\0';
				counter++;
				fputs(text,p1stream);
				fputs(" ", p1stream);
				fputs(cv2i, p1stream);
		    }
		    else {
				fcloseall();
				printf("\nERROR\nLine %d : DB syntax error\n", uLine+1);
				exit(-1);
		    }
		}
		else if (strcmp(text,"dw")==0) {
		    while (*tokenPoint == ' ') tokenPoint++;
		    if (isdigit(*tokenPoint)) {
				do  {
				    *tmp++ = *tokenPoint++;
				} while (isdigit(*tokenPoint));
				*tmp = '\0';
				counter+=2;
				fputs(text,p1stream);
				fputs(" ", p1stream);
				fputs(cv2i, p1stream);
		    }
		    else {
				fcloseall();
				printf("\nERROR\nLine %d : DW syntax error\n", uLine+1);
				exit(-1);
		    }
		}
    }
    return(yes);
}

// ---------------------------------------------------------------

int IsInstruction(char * text)
{
    int loops;
    int yes=0;
    int maxLoops = sizeof(icTable)/sizeof(struct NmTable);

    for (loops = 0; loops < maxLoops; loops++) {
		if (strcmp(text,icTable[loops].Nmemonic) == 0) {
		    yes = 1;
		    counter += icTable[loops].Bytes;
		}
    }
    return(yes);
}


// ---------------------------------------------------------------

void pass1()
{
     int    tkType;
     int    endState = 0;

     counter = 0;
     symCount = 0;
     uLine = 0;

     printf("Stack machine assembler ? ");
     gets(pFile1);
	 if (strlen(pFile1) == 0) {
		printf("\nERROR\n Inputfile error\n");
		printf("program terminated!\n");
		exit(-1);
	 }

     if (ChkExt(pFile1) != 0) {
		CutExt(pFile1, pFile2);
		ChangeExt(pFile2,"ps1");
		CutExt(pFile1, pFile3);
		ChangeExt(pFile3, "hx");
     }
     else {
		strcpy(pFile2,pFile1);
		ChangeExt(pFile2,"ps1");
		CutExt(pFile1, pFile3);
		ChangeExt(pFile3, "hx");
     }
     stream = fopen(pFile1,"r");
     if (stream == 0) {
		printf("\n File not found\n");
		return;
     }
     p1stream = fopen(pFile2, "w");
     if (p1stream == 0) {
		printf("\n File can not create for PASS1\n");
		return;
     }

     while ((!feof(stream))&&(endState==0)) {
	     fgets(token, 256, stream);
	     tokenPoint = token;

	     printf("%5d: ",counter);
	     while ((tkType = GetToken(text)) != EndOfLine) {
		 if (tkType != DIRECTIVE) {
		     if (lbState == 0) {
				printf("%s ", text);
				fputs(text,p1stream);
				fputs(" ", p1stream);
		     }
		 }
		 if (strcmp(text,"end")==0) endState = 1;
		 if (tkType == DONTKNOWN) {
		     fcloseall();
		     printf("\nERROR\n");
		     printf("Line %d have syntax error\n", uLine+1);
		     exit(-1);
		 }
	     }
	     printf("\n");
	     fputs("\n",p1stream);

     }
     fclose(p1stream);
     fclose(stream);

     printf("\nSymbol table\n");
     for (tkType = 0; tkType < symCount; tkType++) {
		printf("%5d: %20s\n",sTable[tkType].address, sTable[tkType].label);
     }
}
