/*
 * Filename			: OpDEF.H
 * Author			: Suwat Taechaphetpaibool    43410007
 *					  Supachai Budsaratij        43410011
 *                    KMUTT-Master Computer Engineering
 * Compiler			: Visual C++ v5
 * Complete Date	: Aug 10,2000  (Version 1.0)
 * Note				: OpCode defition header.
 */

#ifndef _OP_DEF_H
#define _OP_DEF_H


/*
 * DIRECTIVE
 *      ORG  ___address___
 *      DB   ___data8bit__
 *      DW   __data16bit__
 *
 * LINE ASSEMBLY
 *      [LABEL    OPCODE  DATA   ;Comment
 *
 * OBJECT CODE FILE
 *      15_ADDR_0  8_OPCODE_0
 *      15_ADDR_0  8_OPCODE_0 8_DATA_0
 *      15_ADDR_0  8_OPCODE_0 15_DATA_0
 */


#define op_ldi   0x00  /*- Load immediate data to stack (1 byte)        -*/
#define op_ldiw  0x01  /*- Load immediate data to stack (2 bytes)       -*/
#define op_ldd   0x02  /*- Load direct data to stack (1 byte)           -*/
#define op_lddw  0x03  /*- Load direct data to stack (2 bytes)          -*/
#define op_lda   0x04  /*- Load indirect                                -*/
#define op_sta   0x05  /*- Store Indirect                               -*/
#define op_std   0x06  /*- Store byte to memory.                        -*/
#define op_stdw  0x07  /*- Store word to memory.                        -*/
#define op_in    0x08  /*- Input port                                   -*/
#define op_out   0x09  /*- Output port                                  -*/
#define op_ldaw  0x0A  /*- Load indirect 2 bytes -*/
#define op_staw  0x0B  /*- Store indirect 2 bytes  -*/

#define op_mul   0x10  /*- Multiply 1 byte                              -*/
#define op_mulw  0x11  /*- Multiply 2 bytes                             -*/
#define op_div   0x12  /*- Devide 1 byte                                -*/
#define op_divw  0x13  /*- Devide 2 bytes                               -*/
#define op_sub   0x14  /*- subtrack 1 byte                              -*/
#define op_subw  0x15  /*- subtrack 2 bytes                             -*/
#define op_add   0x16  /*- add 1 byte                                   -*/
#define op_addw  0x17  /*- add 2 byte                                   -*/
#define op_inc   0x18  /*- Increment data in stack by 1.                -*/
#define op_incw  0x19  /*- Increment data in stack by 1. (2 Bytes)      -*/
#define op_dec   0x1A  /*- Decrement data in stack by 1.                -*/
#define op_decw  0x1B  /*- Decrement data in stack by 1. (2 Bytes)      -*/


#define op_call  0x20  /*- call to address (2 bytes)                    -*/
#define op_ret   0x21  /*- return from subroutine                       -*/


#define op_jmp   0x30  /*- jump to address (2 bytes)                    -*/
#define op_jmr   0x31  /*- jump relate to address -128 to 127 (1 bytes) -*/
#define op_jz    0x32  /*- Jump if zero flag = 1                        -*/
#define op_jnz   0x33  /*- Jump if zero flag = 0                        -*/
#define op_jo    0x34  /*- Jump if overflow flag = 1                    -*/
#define op_jno   0x35  /*- Jump if overflow flag = 0                    -*/
#define op_jc    0x36  /*- Jump if Carry flag = 1                       -*/
#define op_jnc   0x37  /*- Jump if Carry flag = 0                       -*/
#define op_js    0x38  /*- Jump if Sign flag = 1                        -*/
#define op_jns   0x39  /*- Jump if sign flag = 0                        -*/


#define op_nop   0x40  /*- No operation                                 -*/
#define op_hlt   0x41  /*- Halt                                         -*/


#define op_shl   0x50  /*- Shift left 1 bit                             -*/
#define op_shlw  0x51  /*- Shift left  1 bit   (2 Bytes)                -*/
#define op_shr   0x52  /*- Shift right 1 bit                            -*/
#define op_shrw  0x53  /*- Shift right 1 bit   (2 Bytes)                -*/
#define op_rol   0x54  /*- Rotate left 1 bit                            -*/
#define op_rolw  0x55  /*- Rotate left 1 bit   (2 Bytes)                -*/
#define op_ror   0x56  /*- Rotate right 1 bit                           -*/
#define op_rorw  0x57  /*- Rotate right 1 bit  (2 Bytes)                -*/

#define op_and   0x60  /*- AND operator                                 -*/
#define op_andw  0x61  /*- AND operator (2 Bytes)                       -*/
#define op_or    0x62  /*- OR operator                                  -*/
#define op_orw   0x63  /*- OR operator (2 Bytes)                        -*/
#define op_not   0x64  /*- NOT operator (Complement)                    -*/
#define op_notw  0x65  /*- NOT operator (Complement : 2 Bytes)          -*/
#define op_xor   0x66  /*- XOR operator                                 -*/
#define op_xorw  0x67  /*- XOR operator (2 Bytes)                       -*/
#define op_cmp   0x68  /*- Compare value with stack data                -*/
#define op_cmpw  0x69  /*- Compare value with stack data (2 Bytes)      -*/

struct NmTable {
    char Nmemonic[5];
    unsigned char Hex;
    unsigned char Bytes;
    unsigned char Cycle;
};


struct NmTable  icTable[] = {
/* --- Data movement --- */
{"ldi" , op_ldi , 2, 3}, /* 1 */
{"ldiw", op_ldiw, 3, 4},
{"ldd" , op_ldd , 3, 4}, /* 2 */
{"lddw", op_lddw, 3, 5},
{"lda" , op_lda , 3, 5}, /* 3 */
{"sta" , op_sta , 3, 5}, /* 36*/
{"std" , op_std , 3, 4}, /* 4 */
{"stdw", op_stdw, 3, 5},
{"in"  , op_in  , 2, 3}, /* 5 */
{"out" , op_out , 2, 3}, /* 6 */
{"ldaw", op_ldaw, 3, 6},
{"staw", op_staw, 3, 6},
{"",	 0x0C,	  0, 0},
{"",	 0x0D,	  0, 0},
{"",	 0x0E,	  0, 0},
{"",	 0x0F,	  0, 0},

{"mul" , op_mul , 1, 5}, /* 7 */
{"mulw", op_mulw, 1, 8},
{"div" , op_div , 1, 5}, /* 8 */
{"divw", op_divw, 1, 8},
{"sub" , op_sub , 1, 6}, /* 9 */
{"subw", op_subw, 1, 9},
{"add" , op_add , 1, 6}, /* 10 */
{"addw", op_addw, 1, 9},
{"inc" , op_inc , 1, 4}, /* 11 */
{"incw", op_incw, 1, 6},
{"dec" , op_dec , 1, 4}, /* 12 */
{"decw", op_decw, 1, 6},
{"",     0x1C,    0, 0},
{"",     0x1D,    0, 0},
{"",	 0x1E,	  0, 0},
{"",	 0x1F,	  0, 0},

{"call", op_call, 3, 4}, /* 13 */
{"ret" , op_ret , 1, 3}, /* 14 */
{"",	 0x22,	  0, 0},
{"",	 0x23,	  0, 0},
{"",	 0x24,	  0, 0},
{"",	 0x25,	  0, 0},
{"",	 0x26,	  0, 0},
{"",	 0x27,	  0, 0},
{"",	 0x28,	  0, 0},
{"",	 0x29,	  0, 0},
{"",	 0x2A,	  0, 0},
{"",	 0x2B,	  0, 0},
{"",	 0x2C,	  0, 0},
{"",	 0x2D,	  0, 0},
{"",	 0x2E,	  0, 0},
{"",	 0x2F,	  0, 0},

{"jmp" , op_jmp , 3, 5}, /* 15 */
{"jmr" , op_jmr , 2, 4}, /* 16 */
{"jz"  , op_jz  , 3, 5}, /* 17 */
{"jnz" , op_jnz , 3, 5}, /* 18 */
{"jo"  , op_jo  , 3, 5}, /* 19 */
{"jno" , op_jno , 3, 5}, /* 20 */
{"jc"  , op_jc  , 3, 5}, /* 21 */
{"jnc" , op_jnc , 3, 5}, /* 22 */
{"js"  , op_js  , 3, 5}, /* 23 */
{"jns" , op_jns , 3, 5}, /* 24 */
{"",	 0x3A,	  0, 0},
{"",	 0x3B,	  0, 0},
{"",	 0x3C,	  0, 0},
{"",	 0x3D,	  0, 0},
{"",	 0x3E,	  0, 0},
{"",	 0x3F,	  0, 0},

{"nop" , op_nop , 1, 3}, /* 25 */
{"hlt" , op_hlt , 1, 0}, /* 26 */
{"",	 0x42,	  0, 0},
{"",	 0x43,	  0, 0},
{"",	 0x44,	  0, 0},
{"",	 0x45,	  0, 0},
{"",	 0x46,	  0, 0},
{"",	 0x47,	  0, 0},
{"",	 0x48,	  0, 0},
{"",	 0x49,	  0, 0},
{"",	 0x4A,	  0, 0},
{"",	 0x4B,	  0, 0},
{"",	 0x4C,	  0, 0},
{"",	 0x4D,	  0, 0},
{"",	 0x4E,	  0, 0},
{"",	 0x4F,	  0, 0},

{"shl" , op_shl , 1, 4}, /* 27 */
{"shlw", op_shlw, 1, 6},
{"shr" , op_shr , 1, 4}, /* 28 */
{"shrw", op_shrw, 1, 6},
{"rol" , op_rol , 1, 4}, /* 29 */
{"rolw", op_rolw, 1, 6},
{"ror" , op_ror , 1, 4}, /* 30 */
{"rorw", op_rorw, 1, 6},
{"",	 0x58,	  0, 0},
{"",	 0x59,	  0, 0},
{"",	 0x5A,	  0, 0},
{"",	 0x5B,	  0, 0},
{"",	 0x5C,	  0, 0},
{"",	 0x5D,	  0, 0},
{"",	 0x5E,	  0, 0},
{"",	 0x5F,	  0, 0},

{"and" , op_and , 1, 5}, /* 31 */
{"andw", op_andw, 1, 9},
{"or"  , op_or  , 1, 6}, /* 32 */
{"orw" , op_orw , 1, 9},
{"not" , op_not , 1, 5}, /* 33 */
{"notw", op_notw, 1, 7},
{"xor" , op_xor , 1, 6}, /* 34 */
{"xorw", op_xorw, 1, 8},
{"cmp" , op_cmp , 1, 5}, /* 35 */
{"cmpw", op_cmpw, 1, 7},
{"",	 0x6A,	  0, 0},
{"",	 0x6B,	  0, 0},
{"",	 0x6C,	  0, 0},
{"",	 0x6D,	  0, 0},
{"",	 0x6E,	  0, 0},
{"",	 0x6F,	  0, 0}

};


void ShowRunning(void)
{
	static int step = 0;
	switch (step) {
	case 0: printf("-"); step++; break;
	case 1: printf("%c\\",8); step++; break;
	case 2: printf("%c|",8); step++; break;
	case 3: printf("%c/",8); step++; break;
	case 4: printf("%c-",8); step=1; break;
	}
}

#endif /* _OP_DEF_H */
