; -- Filename : Test8.asm
;    Bubble sort with 100 data.
;
        org     0               ; Start at 0x000

[main   ldiw    dFirst
        stdw    ai              ; ai point to first data
        ldiw    dNext
        stdw    aj              ; aj point to next data

[OuterLoop                      ; Outer loop

        ldiw    dLast           ; push dLast(last data ai)
        lddw    ai              ; Push ai to stack
        cmpw                    ; Compare ai with dLast
                                ;     If ai > dLast then not zero
                                ;     If ai = dLast then zero
                                ;     If ai < dLast then negative
        jz      eloop           ; If zero then goto eloop (ai = last time)


[chkaj
; --- If aj = dEnd (last time) must do outer loop
        ldiw    dEnd 
        lddw    aj
        cmpw
        jnz     InnerLoop      ; else do inner loop

; --- ai point to next value
        lddw     ai
        incw
        stdw     ai              ; skip ai to next data

; --- skip aj to ai+1
        lddw     ai
        incw
        stdw     aj              ; aj point to ai+1

        jmp     OuterLoop       ; goto OuterLoop

[InnerLoop
; --- Compare [aj] with [ai] if [ai] > [aj] then swap [aj]<->[ai]
        lda     aj
        lda     ai
        cmp
        js      SkipSwap        ; If [ai] > [aj] , not swap. (Sign = 0)

; --- swap
        lda     ai
        lda     aj
        sta     ai
        sta     aj

[SkipSwap
; --- point aj to next data
        lddw    aj
        incw
        stdw    aj
        jmp     chkAj


[eloop  hlt             ; Terminated

; --------------- Data segment start here
        org     900     
[ai     DW      0
[aj     DW      0


        org     1000    

[dFirst DB      67
[dNext  DB      1
        DB      0
        DB      6
        DB      7
        DB      20
        DB      30
        DB      12
        DB      158
        DB      157
        DB      156
        DB      155
        DB      154
        DB      153
        DB      152
        DB      151
        DB      150
        DB      133
        DB      132
        DB      131
        DB      130
        DB      129
        DB      128
        DB      127
        DB      126
        DB      125
        DB      124
        DB      123
        DB      122
        DB      121
        DB      120
        DB      119
        DB      118
        DB      117
        DB      116
        DB      115
        DB      114
        DB      113
        DB      112
        DB      111
        DB      110
        DB      109
        DB      108
        DB      107
        DB      106
        DB      105
        DB      104
        DB      103
        DB      102
        DB      101
        DB      100
        DB      49
        DB      48
        DB      47
        DB      46
        DB      45
        DB      44
        DB      43
        DB      42
        DB      41
        DB      40
        DB      69
        DB      68
        DB      67
        DB      66
        DB      65
        DB      64
        DB      63
        DB      62
        DB      61
        DB      60
        DB      59
        DB      58
        DB      57
        DB      56
        DB      55
        DB      54
        DB      53
        DB      52
        DB      51
        DB      50
        DB      19
        DB      18
        DB      17
        DB      16
        DB      15
        DB      13
        DB      12
        DB      11
        DB      10
        DB      9
        DB      2
        DB      90
        DB      78
        DB      28
        DB      12
        DB      56
        DB      34
        DB      255
[dLast  DB      200
[dEnd   DB      0

; ------------------------------------------------------------
        end             ; End of program
