; -- Filename : Test7.asm
;    Bubble sort with 3 data.
;
        org     0               ; Start at 0x0000

        call    ShowData
        in      1
[main                           ; Outer loop

        ldiw    data3           ; push 1006 (last data ai)
        lddw    ai              ; Push ai to stack
        cmpw                    ; Compare ai with 1006
                                ;     If ai > 1006 then not zero
                                ;     If ai = 1006 then zero
                                ;     If ai < 1006 then negative
        jz      eloop           ; If zero then goto eloop (ai = last time)

[chkaj
; --- If aj = 1007 (last time) must do outer loop
        ldiw    tmp
        lddw    aj
        cmpw
        jnz     InnerLoop      ; else do inner loop

; --- ai point to next value
        lddw     ai
        incw
        stdw     ai              ; skip ai to next data

; --- skip aj to ai+1
        lddw     ai
        incw
        stdw     aj              ; aj point to ai+1

        jmp     main            ; goto main

[InnerLoop
; --- Compare [aj] with [ai] if [ai] > [aj] then swap [aj]<->[ai]
        lda     aj
        lda     ai
        cmp
        js      SkipSwap        ; If [ai] > [aj] , not swap. (Sign = 0)

        call    Swap

[SkipSwap
; --- point aj to next data
        lddw    aj
        incw
        stdw    aj
        jmp     chkAj


[eloop  call    ShowData
        hlt             ; Terminated


; ---- Subroutine : ShowData
[ShowData
        ldiw    1004            
        stdw    ai              ; ai point to data1

        lda     ai              ; Show data1
        out     0

        lddw    ai
        incw
        stdw    ai              ; ai point to next data
        lda     ai
        out     0               ; Show data2

        lddw    ai
        incw
        stdw    ai              ; ai point to next data
        lda     ai
        out     0               ; Show data3

        ldiw    1004
        stdw    ai

        ret

; --- Subroutine : Swap (swap [ai] with [aj])
[Swap
        lda     ai              ; Push [ai] to stack
        lda     aj              ; Push [aj] to stack
        sta     ai              ; Pop top of the stack to [ai] ([ai] = [aj])
        sta     aj              ; Pop top of the stack to [aj] ([aj] = [ai])
        ret


        org     1000    ; Data segment start here

[ai     DW      1004
[aj     DW      1005
[data1  DB      10
[data2  DB      5
[data3  DB      2
[tmp    DB      0

        end             ; End of program
