; -- Filename : Test6.asm
;
;
        org     0               ; Start at 0x0000
[main   lda     p1              ; Push p1 to stack
        lda     p2              ; Push p2 to stack
        cmp                     ; Compare p1 with p2
                                ;     If p1 > p2 then not zero
                                ;     If p1 = p2 then zero
                                ;     If P1 < p2 then negative
        jz      eloop           ; If zero then goto eloop

; --- Swap value [p1] and [p2] (swap data1<->data2)
        lda     p1              ; Push [p1] to stack
        std     tmp             ; Pop top of the stack to tmp (tmp = [p1])
        lda     p2              ; Push [p2] to stack
        sta     p1              ; Pop top of the stack to [p1] ([p1] = [p2])
        ldd     tmp             ; Push tmp to stack
        sta     p2              ; Pop top of the stack to [p2] ([p2] = tmp)

; --- p1 point to next value (point to data3)
        lddw    p1              ; push p1 to stack
        incw                    ; plus 1
        incw                    ; plus 1
        stdw    p1              ; pop top of stack to p1


; --- Swap value [p1]  and [p2] (swap data2<->data3)
        lda     p1
        std     tmp
        lda     p2
        sta     p1
        ldd     tmp
        sta     p2

; --- p1 point to data1
        lddw    p1
        decw
        decw
        stdw    p1

; --- Show data1
        lda     p1
        out     0

; --- Show data2
        lda     p2
        out     0

; --- p2 point to data3
        lddw    p2
        incw
        stdw    p2

; --- Show data3
        lda     p2
        out     0


[eloop  in      1       ; Wait for key pressed
[hlp    hlt             ; Terminated


; ------ Data segment start here
;
        org     1000 

[p1     DW      1004
[p2     DW      1005
[data1  DB      10
[data2  DB      5
[data3  DB      2
[tmp    DB      0

        end             ; End of program
