;==================================================
; PROJECT NAME : SCOLLING LED MESSAGE DISPLAY     =
; COMPANY      : ETT CO.,LTD.                     =
; LAST UP DATE : 30 JAN. 2001                     =
; ASSEMBLER    : SXA51.EXE                        =
;      USAGE   : SXA51 -L DP750V1.ASM             =
;    OUT FILE  : DP750V1.LST                      =
;              : DP750V1.HEX                      =
;==================================================
;
;        COMMAND FOR CONTROL AS FOLLOWING :
;                   
;            A : MESSAGE NO MOVING. 
;            B : MESSAGE START MOVING ON THE RIGHT CONNER OF DISPLAY.
;            C : MESSAGE START MOVING ON THE LEFT CONNER OF DISPLAY.
;            D : MESSAGE START MOVING BUTTOM TO TOP.
;            E : MESSAGE START MOVING TOP TO BUTTOM.
;            Z : CLEAR DATA IN EEPROM
;                                    
;========= 4017 ==========================================
CLK_ROW   EQU       P3.7      ; CLOCK FOR INCREMENT ROW
RST_ROW   EQU       P3.6      ; RESET 4017

;=========== 74HC595 =====================================
CLK       EQU       P2.0      ; CLOCK BIT
LAT       EQU       P2.2      ; LATCH BIT
G         EQU       P2.5      ; ENABLE BIT
SIN       EQU       P2.1      ; DATA BIT

CLEAR     EQU       P2.7      ; CLEAR OUTPUT
RECEIVE   EQU       P1.1      ; LED SHOW RECEIVE COMMAND

;========= CONSTANT VALUE ================================
; Constant value for protocol

HEADER    EQU       01H
END_BLOCK EQU       04H
ETX       EQU       0DH
MAX_CHAR  EQU       66
STX       EQU       02        ; START OF TEXT IN EEPROM

;==========================================================
; User RAM start here for general purpose and
; don't attemp to change start point of RAM if not understand
; all program.

          ORG       08H
FIX_CO:   DS        1              ; FIX SCAN PAGE COUNTER
COUNT:    DS        1              ; COUNT NUMBER OF CHAR
LOOP:     DS        1              ; LOOP FOR SCAN ONE PAGE
MASK:     DS        1              ; MASK BIT BUFFER
COLUMN:   DS        1              ; COLUMN / ROW =50
POINTER:  DS        1              ; POINTER OF CURRENT CHAR FOR SCAN
START_BUF:DS        1              ; START ADDRESS OF FISRT CHAR
COL_COUNT:DS        1              ; COLUMN IN CURRENT CHAR
;                                  ; 
R_EEP_LOW:DS        1              ; LOW ADDRESS EEPROM READ
R_EEP_HI: DS        1              ; HI ADDRESS EEPROM READ
;
W_EEP_LOW:DS        1              ; LOW ADDRESS EEPROM WRITE
W_EEP_HI: DS        1              ; HI ADDRESS EEPROM WRITE
;
SEC10:    DS        1

;======================================================
          ORG       20H
STATUS:   DS        1              ; STATUS FLAG
SSR:      DS        1              ; SOME STATUS FLAG
TTG:      DS        1              ; GENERAL FLAG
INDEX:    DS        1              ; INDEX OF CHAR BUFFER
DIM_BUF:  DS        1              ; ACALL ETT
C_HIGH:   DS        1              ; COLUMN HIGH
C_LOW:    DS        1              ; COLUMN LOW
COMMAND:  DS        1              ; COMMAND BUFFER
TEMP:     DS        1              ; TEMPOLARY BUFFER
CHBUF:    DS        65+9+9         ; CHAR BUFFER 18 SPACE + 64 CHAR + 1(0DH) = 85 BYTE
SHIFT_BUF:DS        54             ; USE FOR SCROLL DATA UP ANS DONW ONLY
STACK:    DS        32

ENTEX     EQU       STATUS.0
FIX       EQU       STATUS.1
R_FLAG    EQU       STATUS.2
L_FLAG    EQU       STATUS.3
COMPLETE  EQU       STATUS.4
HEAD_FLAG EQU       STATUS.5
FIR_DATA  EQU       STATUS.6
BUSY_FLAG EQU       STATUS.7

L_MOV     EQU       SSR.0
XOR_FLAG  EQU       SSR.1
END_TEXT  EQU       SSR.2
INVERT    EQU       SSR.3
DEMO_FL   EQU       SSR.4
EMPTY     EQU       SSR.5
ERASE     EQU       SSR.6
ONE_STR   EQU       SSR.7

NO_SCAN   EQU       TTG.0
SCAN_UP   EQU       TTG.1
SCAN_DONW EQU       TTG.2
SW1_PRES  EQU       TTG.3

;=====================================================
; Constant variable for speed display .You can be change
;=====================================================

LOOP_F    EQU       10      ; DELAY FOR FIX SCAN
LOOP_R    EQU       6      ; SPEED FOR SCROLLING
LOOP_L    EQU       7      ; SPEED FOR SCROLLING
LOOP_U    EQU       10     ; SPEED FOR SCROLLING UP AND DONW
FIX_LOOP  EQU       30     ; DELAY FOR NO SCROLL IN UP AND DONW SCAN


;=====================================
; EEPROM CONTROL Register
;=====================================
WMCON     EQU       96H                 
EEMWE     EQU       00010000B
EEMEN     EQU       00001000B
WDTRST    EQU       00000010B

;=========================================================
; The program start here when it reset.
          org       0000h               ; reset vector 
;the first instruction jump to START and then work around
;main program loop and wait for new command.when operate
;the first command  or after reset, no anything on display
; 
          sjmp      START

          org       0003h
          ljmp      EXT_ISR             ; goto external interrupt 0 sevice routine

          ORG       000BH
          LJMP      T0_ISR              ; TIMER 0 INTERRUPT SERVICE ROUTINE FOR FLASH LED

          org       0023h
          ljmp      RS_ISR              ; GOTO SERIAL INTERRUPT  SERVICE ROUTINE


; This part use for initialize all memory,uart,stack pointer,clear
; display buffer.
;
;===================================================
START:    MOV       SP,#STACK           ; SET UP STACK POINTER
          CLR       EA                  ; CLEAR ALL INTERRUPT
          LCALL     INIT_SER            ; INITIAL UART PORT          ;
          LCALL     INIT                ; INIT 4071 AND 74HC595
          LCALL     CLR_BUF             ; CLEAR CHAR BUFFER
          MOV       SEC10,#0
          MOV       TTG,#0
          ;
          ORL       WMCON,#EEMEN        ; EEPROM WRITE ENABLE
          ;                             ;
          MOV       R_EEP_LOW,#0H       ;
          MOV       R_EEP_HI,#0H        ;
          ;                             ;
          MOV       W_EEP_LOW,#0H       ;
          MOV       W_EEP_HI,#0H        ;
          ;                             ;
          SETB      P3.2                ; 
          JB        P3.2,SKIP           ; P3.2 PRESSED ?
          ACALL     SELF_TEST           ; YES,OK SELFTEST.
          ;
          CLR       ES
          CLR       EX0
          SETB      EA
;=================================================
; FOR DEMO ONLY
;=================================================
DEM_LOOP: MOV       DPTR,#DEMO_TABLE1
          LCALL     DEMO
          LCALL     DEM_SCAN
          ;
          MOV       DPTR,#DEMO_TABLE2
          LCALL     DEMO
          LCALL     DEM_SCAN
          ;
          MOV       DPTR,#DEMO_TABLE3
          LCALL     DEMO
          LCALL     DEM_SCAN

          MOV       DPTR,#DEMO_TABLE4
          LCALL     DEMO
          LCALL     DEM_SCAN

          MOV       DPTR,#DEMO_TABLE5
          LCALL     DEMO
          LCALL     DEM_SCAN

          SJMP      DEM_LOOP
          ;

;========= START MAIN PROGRAM ============================
; Main program                          ;
;=========================================================

SKIP:     SETB      EA
          MOV       COMMAND,#'W'    ; DUMMY COMMAND
MAIN:     AJMP      TEST_COMMAND
SKIP1:    JB        BUSY_FLAG,$
          SJMP      MAIN            ; jump to main


;=========================================================
; Fix scan display
;=========================================================
FIX_SCAN: MOV       FIX_CO,#LOOP_F      ; SCAN 7 TIMES CAN BE CHANGE
          ;
F_SCAN3:  MOV       POINTER,#0
          MOV       R4,#0
F_SCAN4:  MOV       LOOP,#7             ; repeat scan 7 times per page
F_SCAN2:  MOV       R5,#0               ; ROW=0
F_SCAN1:  ACALL     MASKB               ; find mask BIT of row
          MOV       A,R4                ; R4 = SEG 
		MOV		R6,A                ;
		CLR		ENTEX               ;
		MOV		COL_COUNT,POINTER   ;
          MOV       COLUMN,#50          ; SHIFT OUT DATA 47 TIMES/ROW
          CLR       ET0
F_LOOP1:  MOV       R0,START_BUF        ; LOAD START CHAR POINT
          MOV       A,COL_COUNT         ; LOAD nTH CHAR IN BUFFER
          ADD       A,R0                ; ADD Nth CHAR(COL_COUNT) WITH BASE OF CHAR BUFFER(START_BUF)
          XCH       A,R0                ;
          MOV       A,@R0               ; LOAD Nth CHAR POINTED BY @R0
          CJNE      A,#ETX,F_NEXT       ; CHAR = #13 ?
		MOV		A,#20H			; YES, POINT TO SPACE
          SETB      ENTEX
F_NEXT:   ACALL     CAL_CHR
          JB        BUSY_FLAG,F_END_SCAN
          DJNZ      COLUMN,F_LOOP1     ; SHIFT OUT 1 R5(50 COLUMN) COMPLETE ?
          ACALL     OUT_DATA
          SETB      ET0
F_F:      ACALL     DEL11              ; DELAY FOR ONE ROW
          INC       R5                 ; SCAN NEXT ROW
          JB        BUSY_FLAG,F_END_SCAN
          CJNE      R5,#8,F_SCAN1      ; ROW=8 ?
          ACALL     DEL11
          ACALL     RET_ROW            ; RESET 4017
          DJNZ      LOOP,F_SCAN2
          JB        BUSY_FLAG,F_END_SCAN
          DJNZ      FIX_CO,F_SCAN3
          AJMP      FIX_SCAN
F_END_SCAN:
          SETB      G
          AJMP      SKIP1              ; END SCAN

;=========================================================
; scan display from right => left
;=========================================================
R_SCAN:   ACALL     CAL_PAGE
          MOV       POINTER,#0
          MOV       R4,#0
R_SCAN2:  MOV       LOOP,#LOOP_R
R_SCAN3:  MOV       R5,#0               ; ROW=0
R_SCAN1:  ACALL     MASKB               ; find mask BIT of row
          MOV       A,R4                ; R4 = SEG 
		MOV		R6,A                ;
		CLR		ENTEX               ;
		MOV		COL_COUNT,POINTER   ;
          MOV       COLUMN,#50          ; SHIFT OUT DATA 50 TIMES/R5
          CLR       ET0
R_LOOP1:  MOV       R0,START_BUF        ; LOAD START CHAR POINT
          MOV       A,COL_COUNT         ; LOAD nTH CHAR IN BUFFER
          ADD       A,R0                ; ADD Nth CHAR(COL_COUNT) WITH BASE OF CHAR BUFFER(START_BUF)
          XCH       A,R0                ;
          MOV       A,@R0               ; LOAD Nth CHAR POINTED BY @R0
          CJNE      A,#ETX,R_NEXT       ; CHAR = #13 ?
		MOV		A,#20H			; YES, POINT TO SPACE
          SETB      ENTEX
R_NEXT:   ACALL     CAL_CHR
          JB        BUSY_FLAG,R_END_SCAN
          DJNZ      COLUMN,R_LOOP1       ; SHIFT OUT 1 R5(50 COLUMN) COMPLETE ?
          ACALL     OUT_DATA
          SETB      ET0
R_R:      ACALL     DEL11
          INC       R5                   ; SCAN NEXT ROW
          JB        BUSY_FLAG,R_END_SCAN
          CJNE      R5,#8,R_SCAN1        ; ROW=7 ?
          ACALL     DEL11
          ACALL     RET_ROW
          DJNZ      LOOP,R_SCAN5
          SJMP      R_SCAN4
R_SCAN5:  JB        BUSY_FLAG,R_END_SCAN
          SJMP      R_SCAN3
R_SCAN4:  INC       R4
          CJNE      R4,#6,R_CHECK_COL
          MOV       R4,#0
          INC       POINTER
R_CHECK_COL:
          ACALL     CHECK_SCAN
          JNB       COMPLETE,R_SCAN2
          JB        BUSY_FLAG,R_END_SCAN
          AJMP      R_SCAN
R_END_SCAN:
          SETB      G
          AJMP      SKIP1               ; END SCAN RIGHT TO LEFT


;=========================================================
; SCAN DISPLAY FROM LEFT TO RIGHT
;=========================================================
L_SCAN:   ACALL     CAL_PAGE
          MOV       R4,#0
          MOV       START_BUF,TEMP
          MOV       POINTER,#0
L_SCAN2:  MOV       LOOP,#LOOP_L        ; SCAN 7 TIMES/PAGE
L_SCAN3:  MOV       R5,#0               ; ROW=0
L_SCAN1:  ACALL     MASKB               ; find mask BIT of row
          MOV       A,R4                ; R4 = SEG 
		MOV		R6,A                ;
		CLR		ENTEX               ;
		MOV		COL_COUNT,POINTER   ;
          MOV       COLUMN,#50          ; SHIFT OUT DATA 50 TIMES/R5
          CLR       ET0
L_LOOP1:  MOV       R0,START_BUF        ; LOAD START CHAR POINT
          MOV       A,COL_COUNT         ; LOAD nTH CHAR IN BUFFER
          ADD       A,R0                ; ADD Nth CHAR(COL_COUNT) WITH BASE OF CHAR BUFFER(START_BUF)
          XCH       A,R0                ;
          MOV       A,@R0               ; LOAD Nth CHAR POINTED BY @R0
L_NEXT:   ACALL     CAL_CHR
          JB        BUSY_FLAG,L_END_SCAN
          DJNZ      COLUMN,L_LOOP1     ; SHIFT OUT 1 R5(50 COLUMN) COMPLETE ?
          ACALL     OUT_DATA
          SETB      ET0
L_L:      ACALL     DEL11
          INC       R5                 ; SCAN NEXT ROW
          JB        BUSY_FLAG,L_END_SCAN
          CJNE      R5,#8,L_SCAN1      ; ROW=7 ?
          ACALL     DEL11
          ACALL     RET_ROW
          DJNZ      LOOP,L_SCAN5
          SJMP      L_SCAN4
L_SCAN5:  JB        BUSY_FLAG,L_END_SCAN
          SJMP      L_SCAN3
L_SCAN4:  CJNE      R4,#0,L_DEC_R4
          MOV       R4,#5
          SJMP      L_SCAN6
L_DEC_R4: DEC       R4
          SJMP      L_CHECK_COL
L_SCAN6:  DEC       START_BUF           ; DEC POINTER OF FIRST CHAR
L_CHECK_COL:
          ACALL     CHECK_SCAN
          JNB       COMPLETE,L_SCAN2
          JB        BUSY_FLAG,L_END_SCAN
          AJMP      L_SCAN
L_END_SCAN:
          SETB      G
          AJMP      SKIP1               ; END SCAN LEFT TO RIGHT

;=======================================================
;   up and donw SCAN 
;=======================================================
UP_SCAN2_2:
          CLR       NO_SCAN             ; clear NO_SCAN flag
          CLR       SCAN_UP             ; clear SCAN_UP flag
          MOV       FIX_CO,#8           ; SCAN 8 row CANBE CHANGE
UP_SCAN3:
          MOV       LOOP,#LOOP_U        ; scan 10 times per page
UP_SCAN4: MOV       START_BUF,#(CHBUF+9)
UP_SCAN2: MOV       R5,#0               ; ROW=0
UP_SCAN1: MOV       R1,START_BUF
          ACALL     MASKB               ; find mask BIT of row
          MOV       COLUMN,#50          ; SHIFT OUT DATA 47 TIMES/ROW
          CLR       ET0
FUP_LOOP1:MOV       A,@R1
          CALL      FPOC
          JB        BUSY_FLAG,OUT_UP_SCAN
          INC       R1
          DJNZ      COLUMN,FUP_LOOP1    ; SHIFT OUT 1 R5(50 COLUMN) COMPLETE ?
          ACALL     OUT_DATA
          SETB      ET0
          ACALL     DEL11               ; DELAY FOR ONE ROW
          INC       R5                  ; SCAN NEXT ROW
          JB        BUSY_FLAG,OUT_UP_SCAN
          CJNE      R5,#8,UP_SCAN1      ; ROW=8 ?
          ACALL     DEL11
          ACALL     RET_ROW             ; RESET 4017
          DJNZ      LOOP,UP_SCAN4       ; LOOP SCAN PER FRAME
          ;
          JB        NO_SCAN,UP_SCAN7
          JB        SCAN_DONW,UP_SCAN8
          CALL      SHIFT_UP
          SJMP      UP_SCAN7
          ;
UP_SCAN8: JB        BUSY_FLAG,OUT_UP_SCAN
          CALL      SHIFT_DONW
          ;
UP_SCAN7: DJNZ      FIX_CO,UP_SCAN3
          ;
          JB        BUSY_FLAG,OUT_UP_SCAN
          JB        SCAN_UP,UP_SCAN6
          JB        NO_SCAN,UP_SCAN5
          MOV       FIX_CO,#FIX_LOOP
          SETB      NO_SCAN
          SJMP      UP_SCAN3
          ;
UP_SCAN5:
          JB        BUSY_FLAG,OUT_UP_SCAN
          JB        SCAN_UP,UP_SCAN6
          MOV       FIX_CO,#8             ; scan 8 rows
          SETB      SCAN_UP
          CLR       NO_SCAN
          SJMP      UP_SCAN3
          ;
UP_SCAN6:
          LJMP      UP_SCAN2_2
          ;
OUT_UP_SCAN:
          SETB      G
          LJMP      SKIP1
          ;


;=========================================================
; OUT DATA to LED
;=========================================================
OUT_DATA: SETB      G                   ; disable 74HC595
          NOP
          NOP
          NOP
          ACALL     CLKROW              ; INC ROW 4017
          ACALL     LATCH               ; LATCH DATA ALL COLUMN ON 74HC595
          NOP
          NOP
          NOP
          CLR       G                   ; Enable 74HC595
T_OUT:    RET

;=========================================================
; TEST MOVING COMPLETE
; INPUT : C_HIGH:C_LOW
;=========================================================
CHECK_SCAN:
          MOV       DPL,C_LOW           ; LOAD HI COLUMN
          MOV       DPH,C_HIGH          ; LAOD LO COLUMN
          MOV       A,DPL
          ORL       A,DPH
          JZ        OUT_CHECK1
          ACALL     DEC_DPTR
          MOV       C_HIGH,DPH
          MOV       C_LOW,DPL
          CLR       COMPLETE
          RET
OUT_CHECK1:
          SETB      COMPLETE
          RET


;=========================================================
; CALCULATE PAGE FOR SCAN left and right
; INPUT : COUNT      ( MAX 64 CHAR )
; OUTPUT: C_HIGH:C_LOW  (MAX = (64+9)*6  )
;                            = 438 PAGE  MAX
;=========================================================
CAL_PAGE: MOV       A,COUNT
          JB        FIX,CAL1
          JB        R_FLAG,CAL2
          JB        L_FLAG,CAL2
          RET
CAL2:     ADD       A,#9                ; ADD WITH 9 SPACE LEADING
CAL1:     MOV       B,#6
          MUL       AB                  ; MULTIPLY WITH  6 COLUMN/CHAR
          MOV       C_LOW,A
          MOV       C_HIGH,B
          RET


;=========================================================
; DEC DPTR
;=========================================================
DEC_DPTR: XCH       A,DPL               ;EXCHANGE A FOR DPL
          DEC       A                   ;DECREMENT A (WHICH IS DPL)
          CJNE      A,#0FFH,DEC_DPTR2   ;IF A (DPL) IS NOT #0FFH, CONTINUE NORMALLY
          DEC       DPH                 ;IF A=FFH, WE NEED TO DECREMENT DPH
DEC_DPTR2:XCH       A,DPL               ;EXCHANGE A FOR DPL (THUS SAVING DPL AND RESTORING A)
          RET

;=========================================================
; FIND POINT OF CHAR
; INPUT : A,MASK
; OUTPUT: SIN
;=========================================================
FPOC:     SETB      SIN                 ; CLEAR SERIAL DATA PIN FOR 74HC595 
          ANL		A,MASK              
          JZ        END_FPOC            ; BIT MASKED = 1 ?
          CLR       SIN                 ; YES
END_FPOC: ACALL     CLKCOL              ; SEND ONE CLOCK FOR 74HC595
		RET          

;=========================================================
; RESET ROW 
;=========================================================
RET_ROW:  SETB      RST_ROW             ; RESET 4017
          CLR		RST_ROW             ; RESET 4017
		RET      
          
;=========================================================
; LATCH DATA FOR 74HC595
;=========================================================
LATCH:    SETB      LAT
          CLR       LAT
          RET
          
;=========================================================
; CLOCK DATA FOR 4017  (ROW)
;=========================================================
CLKROW:   SETB      CLK_ROW
          CLR       CLK_ROW
          RET

;=========================================================
; CLOCK DATA FOR 74HC595 COLUMN
;=========================================================
CLKCOL:   SETB      CLK
          CLR       CLK
          RET

;=========================================================
; CLEAR DISPLAY BEFORE DISPLAY NEW DATA
;=========================================================
CLR_DIS:  MOV       R7,#50
          SETB      SIN
CLRD1:    ACALL     CLKCOL
          DJNZ      R7,CLRD1
          ACALL     LATCH
          RET

;=========================================================
; CALCULATE Nth OF CHARACTER POINT BY POINT
; INPUT  : A  ( ASCII)
; OUTPUT : A  ( 1 SEGMENT OF ASCII )
;=========================================================
CAL_CHR:	CLR		C
          SUBB      A,#20H              ; SUB WITH BASE TABLE
          MOV       DPTR,#ASCII_TABLE   ; LOAD START POINT OF TABLE
          MOV       B,#6                ;
          MUL       AB                  ; MUL WITH 6
          ADD       A,DPL               ; ADD DPL
          MOV       DPL,A               ; GET BACK TO DPL
		MOV		A,DPH
          ADDC      A,B                 
		MOV		DPH,A

          MOV       A,DPL
          ADD       A,R6
          MOV       DPL,A
          MOV       A,DPH
          ADDC      A,#0
          MOV       DPH,A
		CLR		A
          MOVC      A,@A+DPTR           ; LOAD R4 OF CHAR (COLUMN)
          ACALL     FPOC                ; SEND DATA ONE POINT
          INC       R6                  ; INC COLUMN POINTER FOR ONE CHAR                                              
          CJNE      R6,#6,OUT_CAL       ; R4 = 6?
          MOV		R6,#0
          JB        L_MOV,FREE
          JB		ENTEX,OUT_CAL
FREE:     INC       COL_COUNT           ; YES ,INC CHAR POINTER
OUT_CAL:  RET

;=========================================================
; CALCULATE MASK BIT FOR SHIFT OUT
; INPUT   : R5  = ROW
; OUTPUT  : MASK
;=========================================================
MASKB:    MOV       A,R5
          INC       A
          ACALL     MASK_BIT      ; FIND MASK BIT
          MOV       MASK,A
		RET

;=======================================================
; INITIAL SYSTEM
;=======================================================   
INIT:     CLR       CLK_ROW        ; INITIAL CLOCK 4017 LOW
          CLR       RST_ROW
          SETB      RST_ROW        ; RESET 4017
          CLR       RST_ROW
          CLR       G              ; ENABLE 74HC595
          CLR       CLK
          CLR       LAT
          SETB      CLEAR
          CLR       CLEAR
          NOP
          NOP
          NOP
          SETB      CLEAR
          RET
          ;      
;=======================================================
; CHECK COMMAND OF SCAN
;=======================================================  
TEST_COMMAND:
          ACALL     RET_ROW
          MOV       STATUS,#0           ; CLEAR STATUS
          CLR       L_MOV
          CLR       END_TEXT  
          SETB      CLEAR
          CLR       G                   ; ENABLE 74HC595
          CLR       SCAN_DONW
          ;
          MOV       A,COMMAND           ; LOAD NEW COMMAND
		CJNE		A,#41H,TEST1
          SJMP      FIX_COM             ; COMMAND = A  NO MOVE
TEST1:    CJNE      A,#42H,TEST2
          SJMP      C_R_SCAN            ; COMMAND = B  MOVING FROM LEFT <== RIGHT
TEST2:    CJNE      A,#43H,TEST3
          SJMP      C_L_SCAN            ; COMMAND = C  MOVING FROM LEFT ==> RIGHT
TEST3:    CJNE      A,#44H,TEST4
          SJMP      C_U_SCAN            ; COMMAND = D  MOVING FROM DONW TO UP
TEST4:    CJNE      A,#45H,NO_COM
          SJMP      C_D_SCAN            ; COMMAND = E  MOVING FROM UP TO DOWN
          ;
FIX_COM:  MOV       START_BUF,#(CHBUF+9); COMMAND 41H "A"
          SETB      FIX
          AJMP      FIX_SCAN
          ;
C_R_SCAN: ACALL     AD_RL
          MOV       START_BUF,#(CHBUF+0); COMMAND 42H "B"
          SETB      R_FLAG
          AJMP      R_SCAN
          ;
C_L_SCAN: ACALL     AD_LR               ; COMMAND 43H "C"
		SETB		L_FLAG
          SETB      L_MOV
          AJMP      L_SCAN
          ;
C_U_SCAN: ACALL     READ_CHAR_2_BUF
          MOV       START_BUF,#(CHBUF+9); COMMAND 44H "D"
          AJMP      UP_SCAN2_2
          ;
C_D_SCAN: ACALL     READ_CHAR_2_BUF
          MOV       START_BUF,#(CHBUF+9); COMMAND 44H "E"
          SETB      SCAN_DONW
          AJMP      UP_SCAN2_2
          ;
NO_COM:   ACALL     RET_ROW
          SETB      ET0
          ;
NO1:      JNB       BUSY_FLAG,NO1       ; wait new data
          AJMP      SKIP1
          ;
;=======================================================
;  READ DATA TO BUFFER FOR UP AND DONW ONLY
;=======================================================
READ_CHAR_2_BUF:
          CLR       ET0
          MOV       R0,#(CHBUF+9)
          MOV       R1,#(SHIFT_BUF)
          MOV       R5,#10               ; 10 CHAR
          ;
RC2_0:    MOV       A,@R0
          INC       R0
          CJNE      A,#0DH,RC2_3
          ;
          MOV       @R0,A
          MOV       A,#20H
RC2_3:    DJNZ      R5,RC2_1
          SJMP      OUT_RC2
          ;
RC2_1:    CLR       C
          SUBB      A,#20H
          MOV       TEMP,A
          MOV       DPTR,#ASCII_TABLE
          ;
          MOV       B,#6                ;
          MUL       AB                  ; MUL WITH 6
          ADD       A,DPL               ; ADD DPL
          MOV       DPL,A               ; GET BACK TO DPL
		MOV		A,DPH
          ADDC      A,B                 
		MOV		DPH,A
          ;
          MOV       R6,#6               ; 6 BYTE/CHAR
          ;
RC2_2:    MOV       A,#0
          MOVC      A,@A+DPTR
          MOV       @R1,A
          ;
          INC       R1
          INC       DPTR
          DJNZ      R6,RC2_2
          ;
          SJMP      RC2_0
          ;
OUT_RC2:  MOV       R6,#54
          MOV       R0,#(CHBUF+9)
FILL_0:   MOV       A,#0
          MOV       @R0,A
          INC       R0
          DJNZ      R6,FILL_0
          ;
          SETB      ET0
          RET
          ;
;=================================================
; SHIFT UP character
;================================================
SHIFT_UP:
          MOV       R0,#(CHBUF+9)
          MOV       R1,#SHIFT_BUF
          MOV       R6,#54
          ;
SH1:      CLR       C
          MOV       A,@R1
          RLC       A
          XCH       A,R3
          ;
          MOV       A,@R0
          RLC       A
          MOV       @R0,A
          ;
          XCH       A,R3
          ;
          MOV       A,@R1
          RLC       A
          MOV       @R1,A
          ;
          INC       R1
          INC       R0
          ;
          DJNZ      R6,SH1
          RET
          ;
;================================================
; SHIFT DONW character
;================================================
SHIFT_DONW:
          MOV       R0,#(CHBUF+9)
          MOV       R1,#SHIFT_BUF
          MOV       R6,#54
          ;
SHD1:     CLR       C
          MOV       A,@R1
          RRC       A
          XCH       A,R3
          ;
          MOV       A,@R0
          RRC       A
          MOV       @R0,A
          ;
          XCH       A,R3
          ;
          MOV       A,@R1
          RRC       A
          MOV       @R1,A
          ;
          INC       R1
          INC       R0
          ;
          DJNZ      R6,SHD1
          RET
          ;
;=======================================================
; ADJUST DATA FOR SCAN LEFT ==> RIGHT
; USES FOR SCAN L==>R ONLY
;=======================================================
AD_LR:    MOV       R0,#(CHBUF+9)       ; POINT TO ADDRESS OF FIRST CHAR
          MOV       A,COUNT
          ADD       A,R0
          XCH       A,R0
          MOV       @R0,#20H            ; PUT 20H AFTER LAST CHAR(AT 0DH)
          MOV       START_BUF,R0
          MOV       TEMP,R0
ADLR1:    INC       R0                  ; CLEAR CHAR BUFFER AFTER LAST CHAR
          MOV       @R0,#20H
          CJNE      R0,#(CHBUF+65+9+9),ADLR1
          RET
          ;
;=======================================================
; ADJUST DATA FOR SCAN LEFT <== RIGHT
; USES FOR SCAN L<==R ONLY
;=======================================================
AD_RL:    MOV       R0,#(CHBUF+8)
          MOV       @R0,#20H            ; FILL CHAR 8th WITH SPACE CHAR
          MOV       A,COUNT
          ADD       A,R0
          XCH       A,R0
          INC       R0                  ; SKIP 0DH
ADRL1:    INC       R0                  ; CHAR BUFFER AFTER LAST CHAR
          MOV       @R0,#20H
          CJNE      R0,#(CHBUF+65+9+9),ADRL1
          RET
          ;
;=======================================================
; CLEAR DISPLAY BUFFER
;=======================================================
CLR_BUF:  MOV       R7,#(65+9+9)   ;
          MOV       A,#20H
          MOV       R0,#CHBUF
CLR2:     MOV       @R0,A
          INC       R0
          DJNZ      R7,CLR2
          RET
          ;
;=======================================================
; INIT UART
;=======================================================
INIT_SER: MOV       TMOD,#00100001B          ; time1 mode2, TIMER 0 MODE 1 FOR DIM
          MOV       SCON,#01010000B          ; mode1 serial port
          MOV       A,#80H
          MOV       PCON,A                     SMOD =1 Double baud rate
          ;
          MOV       TH1,#0FBH                ; BAUD RATE = 19200,N,8,1
          ;
          MOV       TH0,#00H                ; SET TIMER0 FOR FLASH LED
          MOV       TL0,#00H
          ;
          SETB      ET0                      ; TIMER 0 INTERRUPT ENABLE use for DIM
          CLR       ET1                      ; clear timer1 interrupt use for 232
          ;
          SETB      TR0                      ; START TIMER 0
          SETB      TR1                      ; start timer1 for 232
          ;
          SETB      ES                       ; ENABLE SERIAL INTERRUPT
          SETB      PS                       ; SET PIORITY FOR SERIAL
          ;
          SETB      EX0                      ; EXTERNAL INTERRUPT0 ENABLE
          SETB      IT0                      ; EXT0 INTERRUPT ON FALLING EDGE
          ;
          SETB      CLEAR
          MOV       SSR,#0
          RET

;=======================================================
; INTERRUPT  SERVICE ROUTINE FOR RS232
;=======================================================
RS_ISR:   CLR       EA
          PUSH      DPL
          PUSH      DPH
          PUSH      01
          PUSH      PSW
          ;
          CLR       RECEIVE             ; LED ON
          CLR       RI                  ; CLEAR RX FLAG
          ;
          JB        HEAD_FLAG,ISR1
          MOV       A,SBUF              ; GET HEADER
          SETB      G                   ; OFF DISPLAY
          CJNE      A,#HEADER,ISR6         ; CHECK HEAD
          SETB      BUSY_FLAG           
          SETB      HEAD_FLAG           ; SET HEADER FLAG
          MOV       DIM_BUF,COUNT       ; SAVE COUNTER
          MOV       COUNT,#0            ; INITIAL CHAR COUNTER
          MOV       INDEX,#(CHBUF+8)    ; INITIAL CHAR POINTER
          SJMP      OUT_ISR             ;
          ;
ISR1:     JB        FIR_DATA,ISR4       ;
          SETB      FIR_DATA            ;
          MOV       COMMAND,SBUF        ; GET COMMAND
          SETB      BUSY_FLAG           ; 
          SJMP      OUT_ISR             ;
          ;                             ;
ISR4:     JB        END_TEXT,ISR7       ; 
          INC       INDEX               ; NO
          MOV       R1,INDEX            ;
          MOV       A,SBUF              ;
          ;
          CJNE      A,#ETX,ISR3         ; DATA = END OF TEXT ?
          SETB      END_TEXT            ;
          SJMP      ISR3                ;
          ;
ISR7:     MOV       A,SBUF
          CJNE      A,#END_BLOCK,OUT_ISR       ; DATA = END TRANSMISION ?
          DEC       COUNT
          SJMP      ISR6                ; YES
          ;
ISR3:     MOV       @R1,A               ; SAVE DATA
          INC       COUNT               ; INCREAMENT COUNTER
          ;
          MOV       A,COUNT             ;
          CJNE      A,#MAX_CHAR,OUT_ISR       ;
          ;
          MOV       COUNT,#00
          MOV       INDEX,#(CHBUF+8)
          SJMP      OUT_ISR
          ;
ISR6:     CLR       HEAD_FLAG
          CLR       BUSY_FLAG
          CLR       FIR_DATA
          CLR       END_TEXT
          CLR       G
          ;
OUT_ISR:  POP       PSW
          POP       01
          POP       DPH
          POP       DPL
          SETB      EA
          RETI

;============================================
; SEND COMPLETE
;============================================
SEND_COMPLETE:
          CLR       ES
          MOV       A,#1
          ACALL     SEND_BYTE
          MOV       A,#'R'
          ACALL     SEND_BYTE
          MOV       A,#4
          ACALL     SEND_BYTE
          SETB      ES
          RET


;============================================================
; External interrupt 0 service routine for switch
;============================================================
EXT_ISR:  CLR       EA
          CLR       ES
          ;
          ACALL     DELAY1
          ACALL     DELAY1
          ACALL     DELAY1
          ACALL     DELAY1
          ACALL     DELAY1
          ACALL     DELAY1
          ACALL     DELAY1
          ACALL     DELAY1
          ACALL     DELAY1
          ACALL     DELAY1
          ACALL     DELAY1
          ;
          JB        P3.2,OUT_EXT
          ACALL     SEND_COMPLETE

OUT_EXT:  
          SETB      ES
          SETB      EA
          RETI

;============================================================
; TIMER 0 INTERRUPT SERVICE ROUTINE FOR LED FLASH
;============================================================
T0_ISR:   PUSH      PSW
          PUSH      ACC
          INC       SEC10
          MOV       A,SEC10
          CJNE      A,#10,OUT_T0
          MOV       SEC10,#0
          CPL       RECEIVE
OUT_T0:   POP       ACC
          POP       PSW
          RETI

;===================================================
; SEND BYTE
; INPUT :A
;===================================================
SEND_BYTE:MOV       SBUF,A
          JNB       TI,$
          CLR       TI
          ACALL     DEL11       ; DELAY BETWEEN BYTE
          RET
          ;
;===================================================
; GET BYTE
; OUTPUT : A
;===================================================
GET_BYTE: JNB       RI,$
          CLR       RI
          MOV       A,SBUF
          RET
          ;
;===================================================
; SELF TEST
;===================================================
SELF_TEST:
          ACALL     RET_ROW
          CLR       SIN
          MOV       R4,#8
SELF4:    MOV       R3,#50
SELF2:    ACALL     CLKCOL
          DJNZ      R3,SELF2
          ;
          ACALL     CLKROW
          ACALL     LONG_DEL
          DJNZ      R4,SELF4
          ACALL     RET_ROW
          ;
          ACALL     RET_ROW
          SETB      G
          MOV       R4,#8
          ACALL     CLOCK_OUT
          CLR       G
          ACALL     LONG_DEL
          ;
          ACALL     RET_ROW
          SETB      G
          MOV       R4,#7
          ACALL     CLOCK_OUT
          CLR       G
          ACALL     LONG_DEL
          ;
          ACALL     RET_ROW
          SETB      G
          MOV       R4,#6
          ACALL     CLOCK_OUT
          CLR       G
          ACALL     LONG_DEL
          ;
          ACALL     RET_ROW
          SETB      G
          MOV       R4,#5
          ACALL     CLOCK_OUT
          CLR       G
          ACALL     LONG_DEL
          ;
          ACALL     RET_ROW
          SETB      G
          MOV       R4,#4
          ACALL     CLOCK_OUT
          CLR       G
          ACALL     LONG_DEL
          ;
          ACALL     RET_ROW
          SETB      G
          MOV       R4,#3
          ACALL     CLOCK_OUT
          CLR       G
          ACALL     LONG_DEL
          ;
          ACALL     RET_ROW
          SETB      G
          MOV       R4,#2
          ACALL     CLOCK_OUT
          CLR       G
          ACALL     LONG_DEL
          ;
          ACALL     RET_ROW
          SETB      G
          MOV       R4,#1
          ACALL     CLOCK_OUT
          CLR       G
          ACALL     LONG_DEL
          ;
          ACALL     RET_ROW
          ;
          CLR       CLEAR
          NOP
          SETB      CLEAR
          MOV       R3,#00
SELF3:    MOV       R4,#8
SELF1:    ACALL     CLKROW
          ACALL     DELAY1
          DJNZ      R4,SELF1
          DJNZ      R3,SELF3
          RET

CLOCK_OUT:ACALL     CLKROW
          DJNZ      R4,CLOCK_OUT
          RET

;===================================
; DISPLAY FOR DEMO
; INPUT : DPTR
;===================================
DEMO:     ACALL     CLR_BUF
          MOV       R0,#(CHBUF+9)
          MOV       COUNT,#0
          ;
DEMO0:    CLR       A
          MOVC      A,@A+DPTR
          MOV       @R0,A
          INC       R0
          INC       COUNT
          INC       DPTR
          CJNE      A,#ETX,DEMO0
          ;
          DEC       COUNT
          RET
          ;

;=========================================================
; DEMO scan display
;=========================================================
DEM_SCAN: MOV       FIX_CO,#3          ; SCAN 5 TIMES CANBE CHANGE
          MOV       START_BUF,#(CHBUF+9)
          ;
DE_SCAN3: MOV       POINTER,#0
          MOV       R4,#0
DE_SCAN4: MOV       LOOP,#6
DE_SCAN2: MOV       R5,#0               ; ROW=0
DE_SCAN1: ACALL     MASKB               ; find mask BIT of row
          MOV       A,R4                ; R4 = SEG 
		MOV		R6,A                ;
		CLR		ENTEX               ;
		MOV		COL_COUNT,POINTER   ;
          MOV       COLUMN,#50          ; SHIFT OUT DATA 47 TIMES/ROW
          CLR       ET0
FDE_LOOP1:MOV       R0,START_BUF        ; LOAD START CHAR POINT
          MOV       A,COL_COUNT         ; LOAD nTH CHAR IN BUFFER
          ADD       A,R0                ; ADD Nth CHAR(COL_COUNT) WITH BASE OF CHAR BUFFER(START_BUF)
          XCH       A,R0                ;
          MOV       A,@R0               ; LOAD Nth CHAR POINTED BY @R0
          CJNE      A,#ETX,FDE_NEXT       ; CHAR = #13 ?
		MOV		A,#20H			; YES, POINT TO SPACE
          SETB      ENTEX
FDE_NEXT: ACALL     CAL_CHR
          DJNZ      COLUMN,FDE_LOOP1    ; SHIFT OUT 1 R5(50 COLUMN) COMPLETE ?
          ACALL     OUT_DATA
          SETB      ET0
FDE_F:    ACALL     DEL11               ; DELAY FOR ONE ROW
          INC       R5                  ; SCAN NEXT ROW
          CJNE      R5,#8,DE_SCAN1      ; ROW=8 ?
          ACALL     DEL11
          ACALL     RET_ROW             ; RESET 4017
          DJNZ      LOOP,DE_SCAN2
          DJNZ      FIX_CO,DE_SCAN3
FDE_END_SCAN:
          RET       ; END SCAN

;==================================
; LONG TIME DELAY
;==================================
LONG_DEL: PUSH      02
          PUSH      06
          PUSH      07
          MOV       R2,#4
LD1:      MOV       R6,#00
LD2:      MOV       R7,#00
          JB        BUSY_FLAG,OUT_LONG_DEL
          DJNZ      R7,$
          DJNZ      R6,LD2
          DJNZ      R2,LD1
OUT_LONG_DEL:
          POP       07
          POP       06
          POP       02
          RET

;===================================================
; MASK BIT FOR EACH ROW
;===================================================
MASK_BIT: MOVC      A,@A+PC
          RET
          DB        00000001B
          DB        00000010B
          DB        00000100B
          DB        00001000B
          DB        00010000B
          DB        00100000B
          DB        01000000B
          DB        10000000B



DEL11:    PUSH      06
          PUSH      05
          MOV       R6,#1
DEL22:    MOV       R5,#0F0H
          DJNZ      R5,$
          DJNZ      R6,DEL22
          POP       05
          POP       06
          RET

;==========================================
; delay for general
;==========================================
DELAY1:   PUSH      07
          MOV       R7,#3
DELAY11:  ACALL     DEL11
          DJNZ      R7,DELAY11
          POP       07
          RET

;==========================================
; patturn for demo
;==========================================
DEMO_TABLE1:
          DB        0FAH
          DB        0FBH
          DB        0FCH
          DB        89H
          DB        20H
          DB        'E'
          DB        'T'
          DB        'T'
          DB        ETX
DEMO_TABLE2:
          DB        0FDH
          DB        0FEH
          DB        20H
          DB        8AH
          DB        20H
          DB        'E'
          DB        'T'
          DB        'T'
          DB        ETX
DEMO_TABLE3:
          DB        0FAH
          DB        0FBH
          DB        0FCH
          DB        86H
          DB        20H
          DB        'E'
          DB        'T'
          DB        'T'
          DB        ETX
DEMO_TABLE4:
          DB        0FDH
          DB        0FEH
          DB        20H
          DB        8BH
          DB        20H
          DB        'E'
          DB        'T'
          DB        'T'
          DB        ETX
DEMO_TABLE5:
          DB        0FAH
          DB        0FBH
          DB        0FCH
          DB        8CH
          DB        20H
          DB        'E'
          DB        'T'
          DB        'T'
          DB        ETX


;===========================================================
;  EXAMPLES:  A FONT
;                               b7      ;bit 7 not use
;                 * * *         b6
;               *       *       b5
;               *       *       b4
;               *       *       b3
;               * * * * *       b2
;               *       *       b1
;               *       *       b0
;
;               | | | | | |_ 80H = SPACE       
;               | | | | |___ 3FH  COLUMN 4
;               | | | |_____ 44H  COLUMN 3
;               | | |_______ 44H  COLUMN 2
;               | |_________ 44H  COLUMN 1
;               |___________ 3FH  COLUMN 0
;
; font can be created by program FDV10.EXE on this disk
;

ASCII_TABLE:                       
; BIG FONT
               DB   000H,000H,000H,000H,000H,000H      ;20-SPACE
               DB   000H,000H,030H,07DH,030H,000H      ;21-!
               DB   000H,000H,070H,000H,070H,000H      ;22-"
               DB   014H,07FH,014H,07FH,014H,000H      ;23-#
               DB   012H,02AH,07FH,02AH,024H,000H      ;24-$
               DB   062H,064H,008H,013H,023H,000H      ;25-%
               DB   036H,049H,055H,022H,005H,000H      ;26-&
               DB   000H,000H,050H,060H,080h,000H      ;27-'
               DB   000H,000H,01CH,022H,041H,000H      ;28-(
               DB   000H,041H,022H,01CH,000H,000H      ;29-)
               DB   014H,008H,03EH,008H,014H,000H      ;2A-*
               DB   008H,008H,03EH,008H,008H,000H      ;2B-+
               DB   000H,000H,005H,006H,000H,000H      ;2C-,
               DB   008H,008H,008H,008H,008H,000H      ;2D--
               DB   000H,000H,001H,000H,000H,000H      ;2E-.
               DB   002H,004H,008H,010H,020H,000H      ;2F-/
               DB   03EH,045H,049H,051H,03EH,000H      ;30-0
               DB   000H,021H,07FH,001H,000H,000H      ;31-1
               DB   021H,043H,045H,049H,031H,000H      ;32-2
               DB   042H,041H,051H,069H,046H,000H      ;33-3
               DB   00CH,014H,024H,07FH,004H,000H      ;34-4
               DB   072H,051H,051H,051H,04EH,000H      ;35-5
               DB   03EH,049H,049H,049H,026H,000H      ;36-6
               DB   040H,047H,048H,050H,060H,000H      ;37-7
               DB   036H,049H,049H,049H,036H,000H      ;38-8
               DB   032H,049H,049H,049H,03EH,000H      ;39-9
               DB   000H,000H,036H,036H,000H,000H      ;3A-:
               DB   000H,000H,035H,036H,000H,000H      ;3B-;
               DB   000H,008H,014H,022H,041H,000H      ;3C-<
               DB   014H,014H,014H,014H,014H,000H      ;3D-=
               DB   000H,041H,022H,014H,008H,000H      ;3E->
               DB   020H,040H,045H,048H,030H,000H      ;3F-?
			DB	03EH,041H,05DH,055H,05DH,038H		;40-@
               DB   03FH,044H,044H,044H,03FH,000H      ;41-A
               DB   07FH,049H,049H,049H,036H,000H      ;42-B
               DB   03EH,041H,041H,041H,022H,000H      ;43-C
               DB   07FH,041H,041H,022H,01CH,000H      ;44-D
               DB   07FH,049H,049H,049H,041H,000H      ;45-E
               DB   07FH,048H,048H,048H,040H,000H      ;46-F
               DB   03EH,041H,049H,049H,02FH,000H      ;47-G
               DB   07FH,008H,008H,008H,07FH,000H      ;48-H
               DB   000H,041H,07FH,041H,000H,000H      ;49-I
               DB   002H,001H,041H,07EH,040H,000H      ;4A-J
               DB   07FH,008H,014H,022H,041H,000H      ;4B-K
               DB   07FH,001H,001H,001H,001H,000H      ;4C-L
               DB   07FH,020H,010H,020H,07FH,000H      ;4D-M
               DB   07FH,010H,008H,004H,07FH,000H      ;4E-N
               DB   03EH,041H,041H,041H,03EH,000H      ;4F-O
               DB   07FH,048H,048H,048H,030H,000H      ;50-P
               DB   03EH,041H,045H,042H,03DH,000H      ;51-Q
               DB   07FH,048H,04CH,04AH,031H,000H      ;52-R
               DB   032H,049H,049H,049H,026H,000H      ;53-S
               DB   040H,040H,07FH,040H,040H,000H      ;54-T
               DB   07EH,001H,001H,001H,07EH,000H      ;55-U
               DB   07CH,002H,001H,002H,07CH,000H      ;56-V
               DB   07EH,001H,00EH,001H,07EH,000H      ;57-W
               DB   063H,014H,008H,014H,063H,000H      ;58-X
               DB   070H,008H,007H,008H,070H,000H      ;59-Y
               DB   043H,045H,049H,051H,061H,000H      ;5A-Z

; SMALL FONT
               DB   000H,000H,07FH,041H,041H,000H        ;5B-[
               DB   020H,010H,008H,004H,002H,000H        ;5C-\
               DB   000H,041H,041H,07FH,000H,000H        ;5D-]
               DB   010H,020H,040H,020H,010H,000H        ;5E-^
               DB   001H,001H,001H,001H,001H,000H        ;5F-_
               DB   040H,020H,010H,000H,000H,000H        ;60-`
               DB   002H,015H,015H,015H,00FH,000H        ;61-a
               DB   07FH,009H,011H,011H,00EH,000H        ;62-b
               DB   00EH,011H,011H,011H,002H,000H        ;63-c
               DB   00EH,011H,011H,009H,07FH,000H        ;64-d
               DB   00EH,015H,015H,015H,00CH,000H        ;65-e
               DB   008H,03FH,048H,040H,020H,000H        ;66-f
               DB   018H,025H,025H,025H,03EH,000H        ;67-g
               DB   07FH,008H,010H,010H,00FH,000H        ;68-h
               DB   000H,011H,05FH,001H,000H,000H        ;69-i
               DB   002H,001H,011H,05EH,000H,000H        ;6A-j
               DB   000H,07FH,004H,00AH,011H,000H        ;6B-k
               DB   000H,041H,07FH,001H,000H,000H        ;6C-l
               DB   01FH,010H,00CH,010H,00FH,000H        ;6D-m
               DB   01FH,008H,010H,010H,00FH,000H        ;6E-n
               DB   00EH,011H,011H,011H,00EH,000H        ;6F-o
               DB   01FH,014H,014H,014H,008H,000H        ;70-p
               DB   008H,014H,014H,00CH,01FH,000H        ;71-q
               DB   01FH,008H,010H,010H,008H,000H        ;72-r
               DB   009H,015H,015H,015H,002H,000H        ;73-s
               DB   010H,07EH,011H,001H,002H,000H        ;74-t
               DB   01EH,001H,001H,002H,01FH,000H        ;75-u
               DB   01CH,002H,001H,002H,01CH,000H        ;76-v
               DB   01EH,001H,006H,001H,01EH,000H        ;77-w
               DB   011H,00AH,004H,00AH,011H,000H        ;78-x
               DB   018H,005H,005H,005H,01EH,000H        ;79-y
               DB   011H,013H,015H,019H,011H,000H        ;7A-z
               DB   000H,008H,036H,041H,000H,000H        ;7B-{
               DB   000H,000H,077H,000H,000H,000H        ;7C-|-BLANK BAR
               DB   000H,041H,036H,008H,000H,000H        ;7D-}
               DB   00CH,012H,03FH,012H,004H,000H        ;7E-~-CENT SIGN
               DB   000H,000H,000H,000H,000H,000H        ;7F-SPACE

;==========================================================================
; 80H-FFH this  part you may be change for your design as other
; font or symbol. But,in this case for DEMO (DOG)

               DB   030H,070H,062H,074H,03EH,039H        ; 80H
               DB   038H,038H,038H,038H,039H,03EH        ; 81H   1st FRAME
               DB   038H,01EH,011H,008H,004H,000H        ; 82H

               DB   030H,070H,060H,030H,03EH,03DH        ; 83H
               DB   03AH,039H,038H,038H,038H,03EH        ; 84H   2rd FRAME
               DB   038H,01DH,012H,008H,008H,010H        ; 85H

;=====================================================================
; iCON
               DB   03CH,07EH,03FH,07EH,03CH,000H        ; 86H  HEART
               DB   01EH,03CH,07FH,03CH,01EH,000H        ; 87H  PO
               DB   0FFH,0FFH,0FFH,0FFH,0FFH,0FFH        ; 88H  BLOCK
               DB   000H,003H,07FH,020H,010H,000H        ; 89H  1 NOTE
               DB   003H,01FH,020H,046H,07EH,000H        ; 8AH  2 NOTE
               DB   004H,022H,009H,009H,022H,004H        ; 8BH  smile
               DB   000H,009H,01AH,02CH,048H,000H        ; 8CH  FLASH

               DB   000H,000H,000H,000H,000H,000H        ; 8DH
               DB   000H,000H,000H,000H,000H,000H        ; 8EH
               DB   000H,000H,000H,000H,000H,000H        ; 8FH

               DB   000H,000H,000H,000H,000H,000H        ; 90H
               DB   000H,000H,000H,000H,000H,000H        ; 91H
               DB   000H,000H,000H,000H,000H,000H        ; 92H
               DB   000H,000H,000H,000H,000H,000H        ; 93H
               DB   000H,000H,000H,000H,000H,000H        ; 94H
               DB   000H,000H,000H,000H,000H,000H        ; 95H
               DB   000H,000H,000H,000H,000H,000H        ; 96H
               DB   000H,000H,000H,000H,000H,000H        ; 97H
               DB   000H,000H,000H,000H,000H,000H        ; 98H
               DB   000H,000H,000H,000H,000H,000H        ; 99H
               DB   000H,000H,000H,000H,000H,000H        ; 9AH
               DB   000H,000H,000H,000H,000H,000H        ; 9BH
               DB   000H,000H,000H,000H,000H,000H        ; 9CH
               DB   000H,000H,000H,000H,000H,000H        ; 9DH
               DB   000H,000H,000H,000H,000H,000H        ; 9EH
               DB   000H,000H,000H,000H,000H,000H        ; 9FH

               DB   000H,000H,000H,000H,000H,000H        ; A0H
               DB   000H,000H,000H,000H,000H,000H        ; A1H
               DB   000H,000H,000H,000H,000H,000H        ; A2H
               DB   000H,000H,000H,000H,000H,000H        ; A3H
               DB   000H,000H,000H,000H,000H,000H        ; A4H
               DB   000H,000H,000H,000H,000H,000H        ; A5H
               DB   000H,000H,000H,000H,000H,000H        ; A6H
               DB   000H,000H,000H,000H,000H,000H        ; A7H
               DB   000H,000H,000H,000H,000H,000H        ; A8H
               DB   000H,000H,000H,000H,000H,000H        ; A9H
               DB   000H,000H,000H,000H,000H,000H        ; AAH
               DB   000H,000H,000H,000H,000H,000H        ; ABH
               DB   000H,000H,000H,000H,000H,000H        ; ACH
               DB   000H,000H,000H,000H,000H,000H        ; ADH
               DB   000H,000H,000H,000H,000H,000H        ; AEH
               DB   000H,000H,000H,000H,000H,000H        ; AFH

               DB   000H,000H,000H,000H,000H,000H        ; B0H
               DB   000H,000H,000H,000H,000H,000H        ; B1H
               DB   000H,000H,000H,000H,000H,000H        ; B2H
               DB   000H,000H,000H,000H,000H,000H        ; B3H
               DB   000H,000H,000H,000H,000H,000H        ; B4H
               DB   000H,000H,000H,000H,000H,000H        ; B5H
               DB   000H,000H,000H,000H,000H,000H        ; B6H
               DB   000H,000H,000H,000H,000H,000H        ; B7H
               DB   000H,000H,000H,000H,000H,000H        ; B8H
               DB   000H,000H,000H,000H,000H,000H        ; B9H
               DB   000H,000H,000H,000H,000H,000H        ; BAH
               DB   000H,000H,000H,000H,000H,000H        ; BBH
               DB   000H,000H,000H,000H,000H,000H        ; BCH
               DB   000H,000H,000H,000H,000H,000H        ; BDH
               DB   000H,000H,000H,000H,000H,000H        ; BEH
               DB   000H,000H,000H,000H,000H,000H        ; BFH

               DB   000H,000H,000H,000H,000H,000H        ; C0H
               DB   000H,000H,000H,000H,000H,000H        ; C1H
               DB   000H,000H,000H,000H,000H,000H        ; C2H
               DB   000H,000H,000H,000H,000H,000H        ; C3H
               DB   000H,000H,000H,000H,000H,000H        ; C4H
               DB   000H,000H,000H,000H,000H,000H        ; C5H
               DB   000H,000H,000H,000H,000H,000H        ; C6H
               DB   000H,000H,000H,000H,000H,000H        ; C7H
               DB   000H,000H,000H,000H,000H,000H        ; C8H
               DB   000H,000H,000H,000H,000H,000H        ; C9H
               DB   000H,000H,000H,000H,000H,000H        ; CAH
               DB   000H,000H,000H,000H,000H,000H        ; CBH
               DB   000H,000H,000H,000H,000H,000H        ; CCH
               DB   000H,000H,000H,000H,000H,000H        ; CDH
               DB   000H,000H,000H,000H,000H,000H        ; CEH
               DB   000H,000H,000H,000H,000H,000H        ; CFH

               DB   000H,000H,000H,000H,000H,000H        ; D0H
               DB   000H,000H,000H,000H,000H,000H        ; D1H
               DB   000H,000H,000H,000H,000H,000H        ; D2H
               DB   000H,000H,000H,000H,000H,000H        ; D3H
               DB   000H,000H,000H,000H,000H,000H        ; D4H
               DB   000H,000H,000H,000H,000H,000H        ; D5H
               DB   000H,000H,000H,000H,000H,000H        ; D6H
               DB   000H,000H,000H,000H,000H,000H        ; D7H
               DB   000H,000H,000H,000H,000H,000H        ; D8H
               DB   000H,000H,000H,000H,000H,000H        ; D9H
               DB   000H,000H,000H,000H,000H,000H        ; DAH
               DB   000H,000H,000H,000H,000H,000H        ; DBH
               DB   000H,000H,000H,000H,000H,000H        ; DCH
               DB   000H,000H,000H,000H,000H,000H        ; DDH
               DB   000H,000H,000H,000H,000H,000H        ; DEH
               DB   000H,000H,000H,000H,000H,000H        ; DFH

               DB   000H,000H,000H,000H,000H,000H        ; E0H
               DB   000H,000H,000H,000H,000H,000H        ; E1H
               DB   000H,000H,000H,000H,000H,000H        ; E2H
               DB   000H,000H,000H,000H,000H,000H        ; E3H
               DB   000H,000H,000H,000H,000H,000H        ; E4H
               DB   000H,000H,000H,000H,000H,000H        ; E5H
               DB   000H,000H,000H,000H,000H,000H        ; E6H
               DB   000H,000H,000H,000H,000H,000H        ; E7H
               DB   000H,000H,000H,000H,000H,000H        ; E8H
               DB   000H,000H,000H,000H,000H,000H        ; E9H
               DB   000H,000H,000H,000H,000H,000H        ; EAH
               DB   000H,000H,000H,000H,000H,000H        ; EBH
               DB   000H,000H,000H,000H,000H,000H        ; ECH
               DB   000H,000H,000H,000H,000H,000H        ; EDH
               DB   000H,000H,000H,000H,000H,000H        ; EEH
               DB   000H,000H,000H,000H,000H,000H        ; EFH

               DB   000H,000H,000H,000H,000H,000H        ; F0H
               DB   000H,000H,000H,000H,000H,000H        ; F1H
               DB   000H,000H,000H,000H,000H,000H        ; F2H
               DB   000H,000H,000H,000H,000H,000H        ; F3H
               DB   000H,000H,000H,000H,000H,000H        ; F4H
               DB   000H,000H,000H,000H,000H,000H        ; F5H
               DB   000H,000H,000H,000H,000H,000H        ; F6H
               DB   000H,000H,000H,000H,000H,000H        ; F7H
               DB   000H,000H,000H,000H,000H,000H        ; F8H
               DB   000H,000H,000H,000H,000H,000H        ; F9H

               DB   000H,000H,000H,038H,067H,052H        ; FAH
               DB   064H,03CH,07FH,03CH,064H,052H        ; FBH  butterfly 1
               DB   067H,038H,000H,000H,000H,000H        ; FCH

               DB   000H,000H,000H,000H,000H,03EH        ; FDH
               DB   065H,03CH,07FH,03CH,065H,03EH        ; FEH  butterfly 2

               DB   000H,000H,000H,000H,000H,000H        ; FFH


               END

;======================= END OF PROGRAM ===========================

