?a      equ     7

out0    macro   ?p,  ?r
        db      11101101B
        db      00000001B+(?&?r AND 7)  SHL 3
        db      ?p
        endm


; **********************************************************************
; Using the Z182 evaluation board
; This software does DMA by memory to asci
; DMA is the source - Output of ASCI is displayed onto the monitor
; **********************************************************************
        
        org 0E000h
        dw 03031h
        dw 03233h
        dw 03435h
        dw 03637h
        dw 03839h

; *********************************************************************
;       INITIALIZE THE ASCI 
; *********************************************************************

        org 0d400h



        ld a,024h          ; initializing the ASCI
        out0 (00h),a        ; Tx enable, 8-bits, no parity, 1 stop bit 

        ld a,021h          ; not mp mode, ps=1 (/30 mode), x16 sampling rate
        out0 (02h),a    ; parity doesn't matter, divide ratio - /2

        ld a,30h
        out0 (06h),a

; *********************************************************************
;       DMA:  MEMORY TO ASCI INITIALIZATION SEQUENCE
; *********************************************************************

        ld a,000h
        out0 (20h),a    ; load source addr of data memory
        ld a,0E0h         ; source addr is 0E000h
        out0 (21h),a
        ld a,000h
        out0 (22h),a
        
        ld a,006h
        out0 (23h),a   ; load destination addr of data memory
        ld a,000h        ; destination addr is 06h - TDR0
        out0 (24h),a
        ld a,01h         ; TDRE (ASCI channel 0)
        out0 (25b),a    

        ld a,00110010b    ; I/O fixed, Memory +1, burst mode
        out0 (31h),a    ; 

        ld a,009h
        out0 (26h),a   ; load the byte count register
        ld a,000h
        out0 (27h),a

        ld a,004h        ; load the DCNTL w/the trnsfr mode
        out0 (32h),a   ; memory - i/o, DREQ0=edge sense

        ld a,040h        ;disable DMA termination interrupt
        out0 (30h),a   ; load the dma status register

loop:   jp loop

