unit serinit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls;

type
  TMainFrm = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    Crystal_Edit: TEdit;
    CalcBtn: TButton;
    ExitBtn: TButton;
    SerInit_ASM_LST: TListBox;
    Panel1: TPanel;
    procedure CalcBtnClick(Sender: TObject);
    procedure Crystal_EditKeyPress(Sender: TObject; var Key: Char);
    procedure ExitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Crystal_EditChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainFrm: TMainFrm;

implementation

{$R *.DFM}

procedure TMainFrm.CalcBtnClick(Sender: TObject);
var
        Hz      : Integer;
        Config  : Integer;
begin
        Hz := StrToInt(Crystal_Edit.Text);
        Config := Hz div 384;
        SerInit_ASM_LST.clear;
        Serinit_ASM_LST.Items.Add('*');
        SerInit_ASM_LST.Items.Add('* Filename Serinit.ASM');
        SerInit_ASM_LST.Items.Add('* Set up the serial port: serinit(speed)');
        SerInit_ASM_LST.Items.Add('*');
        SerInit_ASM_LST.Items.Add('serinit      MOV     R0,#-5');
        SerInit_ASM_LST.Items.Add('             LCALL   ?auto0');
        SerInit_ASM_LST.Items.Add('             MOV     ?R3,[R0]');
        SerInit_ASM_LST.Items.Add('             INC     R0');
        SerInit_ASM_LST.Items.Add('             MOV     ?R4,[R0]');
        SerInit_ASM_LST.Items.Add('             MOV     A,#'+IntToStr(Config));
        SerInit_ASM_LST.Items.Add('             MOV     B,#='+IntToStr(Config));
        SerInit_ASM_LST.Items.Add('             LCALL   ?div');
        SerInit_ASM_LST.Items.Add('             LCALL   ?neg');
        SerInit_ASM_LST.Items.Add('             MOV     TMOD,#%00100000');
        SerInit_ASM_LST.Items.Add('             MOV     TH1,A');
        SerInit_ASM_LST.Items.Add('             MOV     TL1,A');
        SerInit_ASM_LST.Items.Add('             MOV     TCON,#%01001001');
        SerInit_ASM_LST.Items.Add('             MOV     SCON,#%01010010');
        SerInit_ASM_LST.Items.Add('             RET');
end;

procedure TMainFrm.Crystal_EditKeyPress(Sender: TObject; var Key: Char);
begin
     if Key = #13 then MainFrm.CalcBtnClick(Sender);
     if Key = #27 Then Application.Terminate;
     if (Key > '9') or (Key < '0') and (Key <> #8) Then
     Begin
          Key := #0;
     End;
end;

procedure TMainFrm.ExitBtnClick(Sender: TObject);
begin
     Application.Terminate;
end;

procedure TMainFrm.FormCreate(Sender: TObject);
begin
     CalcBtn.Enabled := False;
end;

procedure TMainFrm.Crystal_EditChange(Sender: TObject);
begin
     if Length(MainFrm.Crystal_Edit.Text) > 0 then
        MainFrm.CalcBtn.Enabled := True
     else
        MainFrm.CalcBtn.Enabled := False;
end;

end.
