/*
 *  Filename : etv6.h
 *  Author   : Supachai Budsaratij
 *             School of Computer and Advanced Technologies
 *             Rajabhat Institute Phetchaburi
 *  e-mail   : raek@se-ed.org
 *  Date     : August 8, 2000
 *  Compiler : Micro-C V2.4
 *  Hardware : ETT ET-BOARD V6 [MCS-51]
 *
 */

#define ETT_V6

/* 8255 User port
 */
#define i8255PA   0xE020
#define i8255PB   0xE021
#define i8255PC   0xE022
#define i8255PX   0xE023

/* 8255 System port
 */
#define s8255PA   0xE000     /* PA0-3 = Selector 7Seg/LED, Other I2C bus */
#define s8255PB   0xE001     /* 7-Segment/LEDx8 */
#define s8255PC   0xE002     /* Hi = Row's Key, Lo = I2C clock/control */
#define s8255PX   0xE003

asm {
i8255PAA      EQU    $E020
i8255PBA      EQU    $E021
i8255PCA      EQU    $E022
i8255PXA      EQU    $E023

s8255PAA      EQU    $E000
s8255PBA      EQU    $E001
s8255PCA      EQU    $E002
s8255PXA      EQU    $E003

WR_INSLCDA    EQU    $E060
RD_INSLCDA    EQU    $E061
WR_DATLCDA    EQU    $E062
RD_DATLCDA    EQU    $E063
}

#define WR_INSLCD  0xE060
#define RD_INSLCD  0xE061  
#define WR_DATLCD  0xE062  
#define RD_DATLCD  0xE063  


#include "Tark5x.h"


#ifdef USE_WATCHDOG

/* ======================================================================

   WatchDogACK( )

   ӡ૵ watch dog timer.

   Parameter : 
   Return    : 
   Notice    : еͧ¡ѧѹͶ͡ Wath dog timer ӧҹ

   ---------------------------------------------------------------------- */

WatchDogACK( ) asm {
    mov    DPTR,#$E0A0
    movx   [DPTR],#$00
}

#endif
