/*                    
 *  Filename : TarkOne.c
 *  Date     : March 31,2000
 *  compile  : cc51 TarkOne -pio m=s
 *  Hardware : ETT  CP-SB31 V1.0/V2.0 with LTC1298 A/D Convertor.
 *  Note  : ͺҹҨҡͫ LTC1298  A/D Convertor  ʴżҹ RS232
 *  ҵͧ I/O  #define USE_xxxx
        #define USE_LCD
        #define USE_8255
        #define USE_RS232
        #define USE_WATCHDOG
        #define USE_ADC
*/

#define USE_8255
#define USE_RS232

#define USE_LCD
#define USE_ADC

#include <8051io.h>
#include "sb31.h"

/* ---- STEPPER Routine ---- */

MotorDelay()
{
     unsigned char  loops;
     for (loops = 0; loops < 220; loops++);
}

MotorStop()
{
    i8255Write(i8255PA,0x00);
}

MotorForward()
{
    i8255Write(i8255PA,0x99); MotorDelay();
    i8255Write(i8255PA,0x88); MotorDelay(); 
    i8255Write(i8255PA,0xCC); MotorDelay(); 
    i8255Write(i8255PA,0x44); MotorDelay(); 
    i8255Write(i8255PA,0x66); MotorDelay();  
    i8255Write(i8255PA,0x22); MotorDelay();  
    i8255Write(i8255PA,0x33); MotorDelay();  
    i8255Write(i8255PA,0x11); MotorDelay();  
}

MotorBackward()
{
    i8255Write(i8255PA,0x11); MotorDelay();
    i8255Write(i8255PA,0x33); MotorDelay(); 
    i8255Write(i8255PA,0x22); MotorDelay(); 
    i8255Write(i8255PA,0x66); MotorDelay(); 
    i8255Write(i8255PA,0x44); MotorDelay();  
    i8255Write(i8255PA,0xCC); MotorDelay();  
    i8255Write(i8255PA,0x88); MotorDelay();  
    i8255Write(i8255PA,0x99); MotorDelay();  
}

MotorLeft()
{
    i8255Write(i8255PA,0x09); MotorDelay(); 
    i8255Write(i8255PA,0x08); MotorDelay(); 
    i8255Write(i8255PA,0x0C); MotorDelay(); 
    i8255Write(i8255PA,0x04); MotorDelay(); 
    i8255Write(i8255PA,0x06); MotorDelay(); 
    i8255Write(i8255PA,0x02); MotorDelay(); 
    i8255Write(i8255PA,0x03); MotorDelay(); 
    i8255Write(i8255PA,0x01); MotorDelay();
}

MotorRight()
{
    i8255Write(i8255PA,0x90); MotorDelay(); 
    i8255Write(i8255PA,0x80); MotorDelay(); 
    i8255Write(i8255PA,0xC0); MotorDelay(); 
    i8255Write(i8255PA,0x40); MotorDelay(); 
    i8255Write(i8255PA,0x60); MotorDelay(); 
    i8255Write(i8255PA,0x20); MotorDelay(); 
    i8255Write(i8255PA,0x30); MotorDelay(); 
    i8255Write(i8255PA,0x10); MotorDelay();
}


/* ---- MAIN FUNCTION ----*/

ShowSensor()
{
    int left, right;

    left  = ReadLTC1298(0);
    right = ReadLTC1298(1);

    left >>= 8;
    right >>= 8;

    LcdCommand(LCD_CLS);
    LcdGoto(0,0); LcdPutS("> Tark51 ROBOT <");
    LcdGoto(0,1); LcdPutS("----------------");
    LcdGoto(0,2);
    (left>0)?LcdPutS("Left sensor  = 1"):LcdPutS("Left sensor  = 0");
    LcdGoto(0,3);
    (right>0)?LcdPutS("Right sensor = 1"):LcdPutS("Right sensor = 0");
}

main()
{
    register char menu;

    PowerOnReset();
    printf("Hello\n");

    while (1) {
        MotorStop();
        ShowSensor();

        printf("\n--INTbot MENU--\n");
        printf("\n1. Forward");
        printf("\n2. Backward");
        printf("\n3. Turn Left");
        printf("\n4. Turn Right");
        printf("\n5. Sensor status");
        printf("\n--------------");
        printf("\nX. Exit");
        printf("\n--------------");
        printf("\nChoose > ");

        menu = getch();
        putch(menu);

        LcdCommand(LCD_CLS);
        switch (menu) {
        case '1':
            while (chkchr()==-1) {
                MotorForward();
                ShowSensor();
            }
            break;
        case '2':
            while (chkchr()==-1) {
                MotorBackward();
                ShowSensor();
            }
            break;
        case '3':
            while (chkchr()==-1) {
                MotorLeft();
                ShowSensor();
            }
            break;
        case '4':
            while (chkchr()==-1) {
                MotorRight();
                ShowSensor();
            }
            break;
        case '5':
            while (chkchr()==-1) {
                ShowSensor();
            }
            break;
        case 'x':
        case 'X':
            exit();
        }
    }
}
