/*
 *  Filename : mtool7.h
 *  Author   : Supachai Budsaratij
 *             School of Computer and Advanced Technologies
 *             Rajabhat Institute Phetchaburi
 *  e-mail   : raek@se-ed.org
 *  Date     : March 27,2000
 *  Compiler : Micro-C V2.4
 *  Hardware : SILA MTOOL-7 V2.0
 *
 */

#define SILA_MTOOL7

#define USE_LCD
#define USE_8255
#define USE_RS232
#define USE_WATCHDOG

#define i8255PA                 0xFC00
#define i8255PB                 0xFC01
#define i8255PC                 0xFC02
#define i8255PX                 0xFC03

#define WR_INSLCD               0xFA00  
#define RD_INSLCD               0xFA01  
#define WR_DATLCD               0xFA02  
#define RD_DATLCD               0xFA03  

asm {
i8255PAA      EQU    $FC00
i8255PBA      EQU    $FC01
i8255PCA      EQU    $FC02
i8255PXA      EQU    $FC03

WR_INSLCDA    EQU    $FA00  
RD_INSLCDA    EQU    $FA01  
WR_DATLCDA    EQU    $FA02  
RD_DATLCDA    EQU    $FA03  
}

#include "Tark5x.h"


/* ======================================================================

   WatchDogACK( )

   Reset watch dog timer.

   Parameter : none
   Return    : none
   Notice    : Must call this function before 1.2 sec because WatchDog
               Timer must reset MTOOL-7.

   ---------------------------------------------------------------------- */

WatchDogACK( ) asm {
    clr   P3.2
    setb  P3.2
}

/*
WatchDogACK( )
{
    clrbit(P3.2);
    setbit(P3.2);
}
*/

