/*
 *  Filename    : Misc.h
 *  Author      : Supachai Budsaratij
 *                School of Computer and Advanced Technologies
 *                Rajabhat Institute Phetchaburi
 *  e-mail      : raek@se-ed.org
 *  Date        : March 27,2000
 *  Last update :
 *  Compiler    : Micro-C V2.4
 *  Hardware    : ETT  CP-SB31 V1.0/V2.0
 *                SILA MTOOL-7 V2.0
 *
 */

#ifndef MISC_H

#define MISC_H

/* ======================================================================

   PowerOnReset( )

   繤觷¡͹ź Tark51 Шз˹ҷ˹㹡÷ӧҹͧ I/O

   Parameter : 
   Return    : 
   Notice    : 

   ---------------------------------------------------------------------- */

PowerOnReset()
{
#ifdef USE_8255
    unsigned char inner, outer;

    for (outer = 0x00; outer < 0x40; outer++) {
        for (inner = 0x00; inner < 0xFF; inner++);

#ifdef USE_WATCHDOG
        WatchDogACK();
#endif
    }
    poke(i8255PX, 0x80);
#endif

#ifdef USE_LCD
    LcdInit();
#endif

#ifdef USE_RS232
    serinit(9600);
#endif
}

/* ======================================================================

   IsDEC(ch)

   Ǩͺ ch 繵ѡŢҹ 10 

   Parameter : ch =  ASCII ͧõǨͺ
   Return    : 0  ch ѡâͧŢҹ 10
               1  ch 繵ѡâͧŢҹ 10
   Notice    : 

   ---------------------------------------------------------------------- */

unsigned char IsDEC(ch)
unsigned char ch;
{
    if ((ch>='0')&&(ch<='9'))
        return(1);
    return(0);
}



/* ======================================================================

   IsHEX(ch)

   Ǩͺ ch 繵ѡŢҹ 16 

   Parameter : ch =  ASCII ͧõǨͺ
   Return    : 0  ch ѡâͧŢҹ 16
               1  ch 繵ѡâͧŢҹ 16
   Notice    : 

   ---------------------------------------------------------------------- */

unsigned char IsHEX(ch)
unsigned char ch;
{
    if (((ch>='0')&&(ch<='9'))||
        ((ch>='a')&&(ch<='f'))||
        ((ch>='A')&&(ch<='F')))
        return(1);
    return(0);
}


#ifdef USE_RS232
/* ======================================================================

   gotoxy( x, y )

   ˹˹觢ͧ캹͹ء

   Parameter : x = Ңͧ
y = Ңͧ
   Return    : 
   Notice    : ӧҹѺ÷ͧѺ÷ӧҹҹʴŤ ANSI ҹ

   ---------------------------------------------------------------------- */

gotoxy(x,y)
unsigned char x,y;
{
    printf("%c[%02d;%02dH",27,y,x);
}
#endif


#ifdef USE_ADC


/* ======================================================================

   ReadLTC1298( ch )

   ҹҨҡͫ LTC1298  CP-SB31 V2.0

   Parameter : ch = Ţͧѭҳͧҹ. (0 or 1)
   Return    : ҢҴ 12 Եҹ
   Notice    : 

   ---------------------------------------------------------------------- */

int ReadLTC1298( ) asm {
                mov     R0,#-5
                lcall   ?auto0
                mov     A,[R0]          Now A kept chanel number
        
                swap    A               Swap between HI-Nibble and LO-Nibble
                rl      A
                setb    A.7
                setb    A.6
                setb    A.4             Read MSB first
                setb    P1.7            set bit of I2C_CLK
                setb    P1.6            set bit of I2C_DATA
                setb    P1.4            set bit of ADC_CS
                clr     P1.4            clear bit of ADC_CS          
        
                mov     R1,#4
?ADC12S1        rlc     A
                clr     P1.7            clear bit of I2C_CLK
                mov     P1.6,C          transfer C to I2C_DATA
                setb    P1.7            set bit of I2C_CLK
                djnz    R1,?ADC12S1

                setb    P1.6            set bit of I2C_DATA
                clr     P1.7            clear bit of I2C_CLK
                mov     R1,#5           Read Hi-Byte (nibble and NULL)
?ADC12S2        mov     C,P1.6          transfer data from I2C_DATA to C
                rlc     A
                setb    P1.7            set bit of I2C_CLK
                clr     P1.7            clear bit of I2C_CLK
                djnz    R1,?ADC12S2
                anl     A,#$0F
                mov     B,A             Keep Hi-byte into B

                clr     A
                mov     R1,#8           Read low-byte
?ADC12S3        mov     C,P1.6          Transfer data from I2C_DATA to C
                rlc     A
                setb    P1.7            set bit of I2C_CLK
                clr     P1.7            clear bit of I2C_CLK
                djnz    R1,?ADC12S3
}

#endif

#endif
