/*
 *  Filename : LCD.h
 *  Author   : Supachai Budsaratij
 *             School of Computer and Advanced Technologies
 *             Rajabhat Institute Phetchaburi
 *  e-mail   : raek@se-ed.org
 *  Date     : March 27,2000
 *  Compiler : Micro-C V2.4
 *  Hardware : ETT  CP-SB31 V1.0/V2.0
 *             SILA MTOOL-7 V2.0
 *
 */

#ifndef LCD_H

#define LCD_H

#define LCD_CLS                 0x01
#define LCD_HOME                0x02

/*
 * LCD set up mode
 */

#define LCD_SET_8B2L5x10        0x3C /* 8bit, 2Line, 5x10 */
#define LCD_SET_8B2L5x7         0x38 /* 8bit, 2Line, 5x7  */
#define LCD_SET_8B1L5x10        0x34 /* 8bit, 1Line, 5x10 */
#define LCD_SET_8B1L5x7         0x30 /* 8bit, 1Line, 5x7  */
#define LCD_SET_4B2L5x10        0x2C /* 4bit, 2Line, 5x10 */
#define LCD_SET_4B2L5x7         0x28 /* 4bit, 2Line, 5x7  */
#define LCD_SET_4B1L5x10        0x24 /* 4bit, 1Line, 5x10 */
#define LCD_SET_4B1L5x7         0x20 /* 4bit, 1Line, 5x7  */

/*
 * LCD Shift cursor or display
 */

#define LCD_SHL_CUR             0x10
#define LCD_SHL_DSP             0x18
#define LCD_SHR_CUR             0x14
#define LCD_SHR_DSP             0x1C

/*
 * LCD Entry mode
 */

#define LCD_ENT_DTINC           0x06 /* Data not move, Cursor move */
#define LCD_ENT_CUINC           0x07 /* Data move, Cursor not move */
#define LCD_ENT_DTDEC           0x04 /* Data not move, Cursor move */
#define LCD_ENT_CUDEC           0x05 /* Data move, Cursor not move */

/*
 * LCD Display mode
 */

#define LCD_DSP_OFF             0x08 /* Display OFF */
#define LCD_DSP_ON              0x0C /* Display ON */
#define LCD_DSP_CURSOR          0x0E /* Display ON, CURSOR ON */
#define LCD_DSP_CBLINK          0x0F /* Display ON, CURSOR BLINK */


/* ======================================================================

   LcdBusy( )

   ͨ LCD ҧҡ÷ӧҹ

   Parameter : 
   Return    : 
   Notice    : 觹Ѻ 8 Եҹ

   ---------------------------------------------------------------------- */

LcdBusy( ) asm {
            mov       DPTR,#RD_INSLCDA
?LcdBusy    movx      A,[DPTR]
            jb        A.7,?LcdBusy

#ifdef USE_WATCHDOG
            lcall     WatchDogACK
#endif
}



/* ======================================================================

   LcdCommand( command )

  觤令Ǻ LCD.

   Parameter : command = Ңͧ觷ͧ价 LCD
   Return    : 
   Notice    : 

   ---------------------------------------------------------------------- */

LcdCommand() asm {
    mov         R0,#-5
    lcall       ?auto0

    mov         A,[R0]
    mov         DPTR,#WR_INSLCDA
    movx        [DPTR],A

    lcall       LcdBusy
}


/* ======================================================================

   LcdPutC( ascii )

   ʴѡú LCD

   Parameter : ascii =  ASCII ͧʴ
   Return    : 
   Notice    : 

   ---------------------------------------------------------------------- */

LcdPutC( ) asm {
    mov         R0,#-5
    lcall       ?auto0

    mov         A,[R0]
    mov         DPTR,#WR_DATLCDA
    movx        [DPTR],A

    lcall       LcdBusy
}



/* ======================================================================

   LcdPutS( string )

   ʴͤ LCD

   Parameter : string = Data of null string.
   Return    : 
   Notice    : ͤԹҤ٧ش LCD Ѻ.

   ---------------------------------------------------------------------- */

LcdPutS(string)
unsigned char  *string;
{
    while (*string != 0x00) {
        LcdPutC(*string);
        string++;
    }
}


/* ======================================================================

   LcdGoto(x,y)

   ˹˹觢ͧʴ
   Parameter : x = Ҥ. (0-15)
               y = . (0-3)
   Return    : 
   Notice    : ҧѺ LCD Ẻ 16  4  ҹ

   ---------------------------------------------------------------------- */

LcdGoto(x,y)
unsigned char x;
unsigned char y;
{
    switch (y) {
    case 0: y = 0x80; break;
    case 1: y = 0xC0; break;
    case 2: y = 0x90; break;
    case 3: y = 0xD0; break;
    }
    y += x;
    LcdBusy();
    poke(WR_INSLCD,y);
}


/* ======================================================================

   LcdInit( )

   ˹㹡÷ӧҹͧ LCD

   Parameter : 
   Return    : 
   Notice    : 

   ---------------------------------------------------------------------- */

LcdInit()
{
    LcdCommand(LCD_SET_8B2L5x10);
    LcdCommand(LCD_DSP_ON);
    LcdCommand(LCD_ENT_DTINC);
    LcdCommand(LCD_CLS);
}


#endif
