/*
 *  Filename : i8255.h
 *  Author   : Supachai Budsaratij
 *             School of Computer and Advanced Technologies
 *             Rajabhat Institute Phetchaburi
 *  e-mail   : raek@se-ed.org
 *  Date     : March 27,2000
 *  Compiler : Micro-C V2.4
 *  Hardware : ETT  CP-SB31 V1.0/V2.0
 *             SILA MTOOL-7 V2.0
 *
 */

#ifndef i8255_H

#define i8255_H

#define i8255waitF              50 /* Fast */
#define i8255waitM              100 /* Middle */
#define i8255waitS              150 /* Slow */



/* ======================================================================

   i8255Delay( )

   ˹ǧ 8255 ӧҹ稡͹

   Parameter : 
   Return    : 
   Notice    : 

   ---------------------------------------------------------------------- */

i8255Delay( )
{
    unsigned char i;

#ifdef i8255_FAST
         for (i=0;i<i8255waitF;i++);
#else ifdef i8255_SLOW
         for (i=0;i<i8255waitS;i++);
#else
         for (i=0;i<i8255waitM;i++);
#endif

#ifdef USE_WATCHDOG
    WatchDogACK();
#endif

}


/* ======================================================================

   i8255Write( portx, pdata )

   觢ŷ pdata 价 portx ͧ 8255.

   Parameter : portx = ʹʢͧ
               pdata = ŷͧ portx
   Return    : 
   Notice    : 

   ---------------------------------------------------------------------- */

i8255Write(portx,pdata)
int portx;
unsigned char pdata;
{
    poke(portx, pdata);
    i8255Delay();

#ifdef USE_WATCHDOG
    WatchDogACK();
#endif

}


/* ======================================================================

   i8255Read( portx )

   ҹŨҡ portx ͧ 8255.

   Parameter : portx = ʹʢͧ
   Return    : ҷҹҡ portx.
   Notice    : 

   ---------------------------------------------------------------------- */

unsigned char i8255Read( ) asm {
    mov      R0,#-5
    lcall    ?auto0

#ifdef USE_WATCHDOG
    lcall    WatchDogACK
#endif

    mov      A,[R0]      Move LO-BYTE into A
    mov      DPL,A

    inc      R0          Get next byte (HI-BYTE)
    mov      A,[R0]      Move HI-BYTE into A
    mov      DPH,A

    movx     A,[DPTR]
    mov      B,#$00
}



#endif
