/*
 *  Filename : HelloSB.c
 *  Author   : Supachai Budsaratij
 *             School of Computer and Advanced Technologies
 *             Rajabhat Institute Phetchaburi
 *  e-mail   : raek@se-ed.org
 *  Date     : March 27,2000
 *  compile  : cc51 helloSB -pio m=s
 *  Hardware : ETT  CP-SB31 V1.0/V2.0
 *  ҵͧ I/O  #define USE_xxxx
        #define USE_LCD
        #define USE_8255
        #define USE_RS232
        #define USE_WATCHDOG
        #define USE_ADC
*/

#define USE_LCD
#define USE_RS232

#include <8051io.h>
#include "sb31.h"

main()
{
    int count;

    PowerOnReset();
    count = 0;
    LcdCommand(LCD_CLS);
    LcdGoto(0,0); LcdPutS("- drOT startup -");
    LcdGoto(1,1); LcdPutS("Line 2.");
    LcdGoto(2,2); LcdPutS("Line 3.");
    LcdGoto(3,3); LcdPutS("Line 4.");

    while(1) {
        printf("Hello no.%d\n", count);
        if (count++ == 10000) {
            count = 0;
        }
    }
}
