/*
 *  Filename : getADC.c
 *  Author   : Supachai Budsaratij
 *             School of Computer and Advanced Technologies
 *             Rajabhat Institute Phetchaburi
 *  e-mail   : raek@se-ed.org
 *  Date     : March 30,2000
 *  compile  : cc51 getADC -pio m=s
 *  Hardware : ETT  CP-SB31 V1.0/V2.0 with LTC1298 A/D Convertor.
 *  Note  : ͺҹҨҡͫ LTC1298  A/D Convertor  ʴżҹ RS232
 *  ҵͧ I/O  #define USE_xxxx
        #define USE_LCD
        #define USE_8255
        #define USE_RS232
        #define USE_WATCHDOG
        #define USE_ADC
*/

#define USE_LCD
#define USE_ADC

/*
   The value return from LDR-Sensor:
        White zone = 0
        Dark zone  = 1
 */

#include <8051io.h>
#include "sb31.h"

main()
{
    int left, right;

    PowerOnReset();
    LcdCommand(LCD_CLS);
    LcdGoto(0,0); LcdPutS("> Tark51 ROBOT <");
    LcdGoto(0,1); LcdPutS("----------------");
    LcdGoto(0,2); LcdPutS("Left sensor  = 0");
    LcdGoto(0,3); LcdPutS("Right sensor = 0");

    while(1) {
        left  = ReadLTC1298(0);
        right = ReadLTC1298(1);

        left >>= 8;
        right >>= 8;

        LcdGoto(0,2);
        (left>0)?LcdPutS("Left sensor  = 1"):LcdPutS("Left sensor  = 0");

        LcdGoto(0,3);
        (right>0)?LcdPutS("Right sensor = 1"):LcdPutS("Right sensor = 0");
    }
}
