



/***********************************************************************************************
 *                                                                                             *
 *     Ex5 : Font Shift Left(<--- ) RGB LED8x8(WS2812B) For "ET-BASE AVR MEGA128"              *
 *                                                                                             *
 *           Interface RGB LED by SPI (Hardware)  Speed SCK = 8 Mhz =125ns                     *
 *                                                                                             *
 ***********************************************************************************************
 *                                                                                             *
 * Target MCU     : ATMEL AVR-MEGA128                                                          *
 *                : X-TAL : 16 MHz                                                             * 
 *                                                                                             *
 * Editor         : AVR Studio 4.15 Build 623                                                  *
 * Compiler       : WinAVR-20081205                                                            *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                       *
 * Last Update    : 7/April/2014                                                              *
 *                                                                                             *
 *                                                                                             *
 * Port Interface :  ---- MCU-Mega128 ----                    ---- ET-iLED-RGB----             *
 *                                                                                             *
 *        SPI     :    PB2(MOSI-Out)            Connect                DI                      *
 *                     PB1(SCK-Out)             No Use                                         *
 *                     PB0(SS-Out)              No Use                                         *
 *                                                                                             *
 *                     SPI Clock SCK = 125 ns                                                  *
 *                                                                                             *
 ***********************************************************************************************/


#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/pgmspace.h>            //for progrm data to Area Flash  Set array[0..32767]
#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include <util/delay.h>              //call function delay



/******************************************************
 *			 Font 5x7(English)				          *
 *											          *
 ******************************************************
 * -ASCII fonts from 0x20 ~ 0x7F(DEC 32 ~ 127)     	  *
 *  composed of following characters 			      *
 *                                                    * 
 * -XSize : 5  pixcels (Array 5byte 0-->4)            *
 * -YSize : 7  pixcels (Array 1 Byte)			      *
 *											       	  *
 *                                                    *
 *        ......... <- bit7(Blank,Not Use)            *
 *   End  ..OOOOO.. <- bit6  	  (y)	              *
 *    ^   ..OOOOO.. <- bit5	       ^	              *
 *    |   ..OOOOO.. <- bit4	       |	              *
 *    |   ..OOOOO.. <- bit3	       |		          *
 *    |   ..OOOOO.. <- bit2	       |	              *
 *    |   ..OOOOO.. <- bit1	       |	              *
 *  start ..OOOOO.. <- bit0	       +----->(x)         *
 *                                                    *   
 *  Byte0-----------> Byte4                           *
 *												      *
 *     (O = 1 Byte Array  in Table)                   *
 *  Byte = colum ,Bit in byte = Row                   *
 *                                                    *
 ******************************************************/

 prog_char font_5x7[96][5] = {
        {0x00,0x00,0x00,0x00,0x00}, //
        {0x00,0x00,0xfa,0x00,0x00}, // !
        {0x00,0xe0,0x00,0xe0,0x00}, // "
        {0x28,0xfe,0x28,0xfe,0x28}, // #
        {0x24,0x54,0xfe,0x54,0x48}, // $
        {0xc4,0xc8,0x10,0x26,0x46}, // %
        {0x6c,0x92,0xaa,0x44,0x0a}, // &
        {0x00,0xa0,0xc0,0x00,0x00}, // '
        {0x00,0x38,0x44,0x82,0x00}, // (
        {0x00,0x82,0x44,0x38,0x00}, // )
        {0x10,0x54,0x38,0x54,0x10}, // *
        {0x10,0x10,0x7c,0x10,0x10}, // +
        {0x00,0x0a,0x0c,0x00,0x00}, // ,
        {0x10,0x10,0x10,0x10,0x10}, // -
        {0x00,0x06,0x06,0x00,0x00}, // .
        {0x04,0x08,0x10,0x20,0x40}, // /
        {0x7c,0x8a,0x92,0xa2,0x7c}, // 0
        {0x00,0x42,0xfe,0x02,0x00}, // 1
        {0x42,0x86,0x8a,0x92,0x62}, // 2
        {0x84,0x82,0xa2,0xd2,0x8c}, // 3
        {0x18,0x28,0x48,0xfe,0x08}, // 4
        {0xe4,0xa2,0xa2,0xa2,0x9c}, // 5
        {0x3c,0x52,0x92,0x92,0x0c}, // 6
        {0x80,0x8e,0x90,0xa0,0xc0}, // 7
        {0x6c,0x92,0x92,0x92,0x6c}, // 8
        {0x60,0x92,0x92,0x94,0x78}, // 9
        {0x00,0x6c,0x6c,0x00,0x00}, // :
        {0x00,0x6a,0x6c,0x00,0x00}, // ;
        {0x00,0x10,0x28,0x44,0x82}, // <
        {0x28,0x28,0x28,0x28,0x28}, // =
        {0x82,0x44,0x28,0x10,0x00}, // >
        {0x40,0x80,0x8a,0x90,0x60}, // ?
        {0x4c,0x92,0x9e,0x82,0x7c}, // @
        {0x7e,0x88,0x88,0x88,0x7e}, // A
        {0xfe,0x92,0x92,0x92,0x6c}, // B
        {0x7c,0x82,0x82,0x82,0x44}, // C
        {0xfe,0x82,0x82,0x44,0x38}, // D
        {0xfe,0x92,0x92,0x92,0x82}, // E
        {0xfe,0x90,0x90,0x80,0x80}, // F
        {0x7c,0x82,0x82,0x8a,0x4c}, // G
        {0xfe,0x10,0x10,0x10,0xfe}, // H
        {0x00,0x82,0xfe,0x82,0x00}, // I
        {0x04,0x02,0x82,0xfc,0x80}, // J
        {0xfe,0x10,0x28,0x44,0x82}, // K
        {0xfe,0x02,0x02,0x02,0x02}, // L
        {0xfe,0x40,0x20,0x40,0xfe}, // M
        {0xfe,0x20,0x10,0x08,0xfe}, // N
        {0x7c,0x82,0x82,0x82,0x7c}, // O
        {0xfe,0x90,0x90,0x90,0x60}, // P
        {0x7c,0x82,0x8a,0x84,0x7a}, // Q
        {0xfe,0x90,0x98,0x94,0x62}, // R
        {0x62,0x92,0x92,0x92,0x8c}, // S
        {0x80,0x80,0xfe,0x80,0x80}, // T
        {0xfc,0x02,0x02,0x02,0xfc}, // U
        {0xf8,0x04,0x02,0x04,0xf8}, // V
        {0xfe,0x04,0x18,0x04,0xfe}, // W
        {0xc6,0x28,0x10,0x28,0xc6}, // X
        {0xc0,0x20,0x1e,0x20,0xc0}, // Y
        {0x86,0x8a,0x92,0xa2,0xc2}, // Z
        {0x00,0x00,0xfe,0x82,0x82}, // [
        {0x40,0x20,0x10,0x08,0x04}, // "\"
        {0x82,0x82,0xfe,0x00,0x00}, // ]
        {0x20,0x40,0x80,0x40,0x20}, // ^
        {0x02,0x02,0x02,0x02,0x02}, // _
        {0x00,0x80,0x40,0x20,0x00}, // `
        {0x04,0x2a,0x2a,0x2a,0x1e}, // a
        {0xfe,0x12,0x22,0x22,0x1c}, // b
        {0x1c,0x22,0x22,0x22,0x04}, // c
        {0x1c,0x22,0x22,0x12,0xfe}, // d
        {0x1c,0x2a,0x2a,0x2a,0x18}, // e
        {0x10,0x7e,0x90,0x80,0x40}, // f
        {0x10,0x28,0x2a,0x2a,0x3c}, // g
        {0xfe,0x10,0x20,0x20,0x1e}, // h
        {0x00,0x22,0xbe,0x02,0x00}, // i
        {0x04,0x02,0x22,0xbc,0x00}, // j
        {0x00,0xfe,0x08,0x14,0x22}, // k
        {0x00,0x82,0xfe,0x02,0x00}, // l
        {0x3e,0x20,0x18,0x20,0x1e}, // m
        {0x3e,0x10,0x20,0x20,0x1e}, // n
        {0x1c,0x22,0x22,0x22,0x1c}, // o
        {0x3e,0x28,0x28,0x28,0x10}, // p
        {0x10,0x28,0x28,0x18,0x3e}, // q
        {0x3e,0x10,0x20,0x20,0x10}, // r
        {0x12,0x2a,0x2a,0x2a,0x04}, // s
        {0x20,0xfc,0x22,0x02,0x04}, // t
        {0x3c,0x02,0x02,0x04,0x3e}, // u
        {0x38,0x04,0x02,0x04,0x38}, // v
        {0x3c,0x02,0x0c,0x02,0x3c}, // w
        {0x22,0x14,0x08,0x14,0x22}, // x
        {0x30,0x0a,0x0a,0x0a,0x3c}, // y
        {0x22,0x26,0x2a,0x32,0x22}, // z
        {0x00,0x10,0x6c,0x82,0x00}, // {
        {0x00,0x00,0xfe,0x00,0x00}, // |
        {0x00,0x82,0x6c,0x10,0x00}, // }
        {0x40,0x80,0xc0,0x40,0x80}, // ~
        {0x00,0x00,0x00,0x00,0x00}, //
};


/******************************************************
 *                                                    *
 *			 Font 8x8 Bold(English)				      *
 *											          *
 ******************************************************
 * -ASCII fonts from 0x20 ~ 0x7F(DEC 32 ~ 127)     	  *
 *  composed of following characters 			      *
 *                                                    * 
 * -XSize : 8  pixcels (Array 8byte 0-->7)            *
 * -YSize : 8  pixcels (Array 1 Byte 8 bit)			  *
 *											       	  *
 *                                                    *
 *   End  ..OOOOOOOO.. <- bit7                        *
 *    ^   ..OOOOOOOO.. <- bit6   	  (y)	          *
 *    |   ..OOOOOOOO.. <- bit5   	   ^	          *
 *    |   ..OOOOOOOO.. <- bit4  	   |	          *
 *    |   ..OOOOOOOO.. <- bit3  	   |		      *
 *    |   ..OOOOOOOO.. <- bit2   	   |	          *
 *    |   ..OOOOOOOO.. <- bit1  	   |	          *
 *  start ..OOOOOOOO.. <- bit0   	   +----->(x)     *
 *                                                    *   
 *     Byte0-----------> Byte7                        *
 *												      *
 *     (O = 1 Byte Array  in Table)                   *
 *                                                    *
 ******************************************************/

prog_char font_8x8[96][8] = {
        {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, //
        {0x00,0x60,0xfa,0xfa,0x60,0x00,0x00,0x00}, // !
        {0x00,0xe0,0xe0,0x00,0xe0,0xe0,0x00,0x00}, // "
        {0x28,0xfe,0xfe,0x28,0xfe,0xfe,0x28,0x00}, // #
        {0x24,0x74,0xd6,0xd6,0x5c,0x48,0x00,0x00}, // $
        {0x62,0x66,0x0c,0x18,0x30,0x66,0x46,0x00}, // %
        {0x0c,0x5e,0xf2,0xba,0xec,0x5e,0x12,0x00}, // &
        {0x20,0xe0,0xc0,0x00,0x00,0x00,0x00,0x00}, // '
        {0x00,0x38,0x7c,0xc6,0x82,0x00,0x00,0x00}, // (
        {0x00,0x82,0xc6,0x7c,0x38,0x00,0x00,0x00}, // )
        {0x10,0x54,0x7c,0x38,0x38,0x7c,0x54,0x10}, // *
        {0x10,0x10,0x7c,0x7c,0x10,0x10,0x00,0x00}, // +
        {0x00,0x05,0x07,0x06,0x00,0x00,0x00,0x00}, // ,
        {0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00}, // -
        {0x00,0x00,0x06,0x06,0x00,0x00,0x00,0x00}, // .
        {0x06,0x0c,0x18,0x30,0x60,0xc0,0x80,0x00}, // /
        {0x7c,0xfe,0x9a,0xb2,0xfe,0x7c,0x00,0x00}, // 0
        {0x42,0x42,0xfe,0xfe,0x02,0x02,0x00,0x00}, // 1
        {0x46,0xce,0x9a,0x92,0xf6,0x66,0x00,0x00}, // 2
        {0x44,0xc6,0x92,0x92,0xfe,0x6c,0x00,0x00}, // 3
        {0x18,0x38,0x68,0xc8,0xfe,0xfe,0x08,0x00}, // 4
        {0xe4,0xe6,0xa2,0xa2,0xbe,0x9c,0x00,0x00}, // 5
        {0x3c,0x7e,0xd2,0x92,0x9e,0x0c,0x00,0x00}, // 6
        {0xc0,0xc6,0x8e,0x98,0xf0,0xe0,0x00,0x00}, // 7
        {0x6c,0xfe,0x92,0x92,0xfe,0x6c,0x00,0x00}, // 8
        {0x60,0xf2,0x92,0x96,0xfc,0x78,0x00,0x00}, // 9
        {0x00,0x00,0x36,0x36,0x00,0x00,0x00,0x00}, // :
        {0x00,0x05,0x37,0x36,0x00,0x00,0x00,0x00}, // ;
        {0x10,0x38,0x6c,0xc6,0x82,0x00,0x00,0x00}, // <
        {0x28,0x28,0x28,0x28,0x28,0x28,0x00,0x00}, // =
        {0x00,0x82,0xc6,0x6c,0x38,0x10,0x00,0x00}, // >
        {0x40,0xc0,0x8a,0x9a,0xf0,0x60,0x00,0x00}, // ?
        {0x7c,0xfe,0x82,0xba,0xba,0xf8,0x78,0x00}, // @
        {0x3e,0x7e,0xc8,0xc8,0x7e,0x3e,0x00,0x00}, // A
        {0x82,0xfe,0xfe,0x92,0x92,0xfe,0x6c,0x00}, // B
        {0x38,0x7c,0xc6,0x82,0x82,0xc6,0x44,0x00}, // C
        {0x82,0xfe,0xfe,0x82,0xc6,0xfe,0x38,0x00}, // D
        {0x82,0xfe,0xfe,0x92,0xba,0x82,0xc6,0x00}, // E
        {0x82,0xfe,0xfe,0x92,0xb8,0x80,0xc0,0x00}, // F
        {0x38,0x7c,0xc6,0x82,0x8a,0xce,0x4e,0x00}, // G
        {0xfe,0xfe,0x10,0x10,0xfe,0xfe,0x00,0x00}, // H
        {0x00,0x82,0xfe,0xfe,0x82,0x00,0x00,0x00}, // I
        {0x0c,0x0e,0x02,0x82,0xfe,0xfc,0x80,0x00}, // J
        {0x82,0xfe,0xfe,0x10,0x38,0xee,0xc6,0x00}, // K
        {0x82,0xfe,0xfe,0x82,0x02,0x06,0x0e,0x00}, // L
        {0xfe,0xfe,0x60,0x30,0x60,0xfe,0xfe,0x00}, // M
        {0xfe,0xfe,0x60,0x30,0x18,0xfe,0xfe,0x00}, // N
        {0x38,0x7c,0xc6,0x82,0xc6,0x7c,0x38,0x00}, // O
        {0x82,0xfe,0xfe,0x92,0x90,0xf0,0x60,0x00}, // P
        {0x78,0xfc,0x84,0x8e,0xfe,0x7a,0x00,0x00}, // Q
        {0x82,0xfe,0xfe,0x98,0x9c,0xf6,0x62,0x00}, // R
        {0x64,0xe6,0xb2,0x9a,0xde,0x4c,0x00,0x00}, // S
        {0xc0,0x82,0xfe,0xfe,0x82,0xc0,0x00,0x00}, // T
        {0xfe,0xfe,0x02,0x02,0xfe,0xfe,0x00,0x00}, // U
        {0xf8,0xfc,0x06,0x06,0xfc,0xf8,0x00,0x00}, // V
        {0xfe,0xfe,0x0c,0x18,0x0c,0xfe,0xfe,0x00}, // W
        {0xc6,0xee,0x38,0x10,0x38,0xee,0xc6,0x00}, // X
        {0xe0,0xf2,0x1e,0x1e,0xf2,0xe0,0x00,0x00}, // Y
        {0xe6,0xce,0x9a,0xb2,0xe2,0xc6,0x8e,0x00}, // Z
        {0x00,0xfe,0xfe,0x82,0x82,0x00,0x00,0x00}, // [
        {0x80,0xc0,0x60,0x30,0x18,0x0c,0x06,0x00}, // "\"
        {0x00,0x82,0x82,0xfe,0xfe,0x00,0x00,0x00}, // ]
        {0x10,0x30,0x60,0xc0,0x60,0x30,0x10,0x00}, // ^
        {0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01}, // _
        {0x00,0x00,0xc0,0xe0,0x20,0x00,0x00,0x00}, // `
        {0x04,0x2e,0x2a,0x2a,0x3c,0x1e,0x02,0x00}, // a
        {0x82,0xfc,0xfe,0x22,0x22,0x3e,0x1c,0x00}, // b
        {0x1c,0x3e,0x22,0x22,0x36,0x14,0x00,0x00}, // c
        {0x0c,0x1e,0x12,0x92,0xfc,0xfe,0x02,0x00}, // d
        {0x1c,0x3e,0x2a,0x2a,0x3a,0x18,0x00,0x00}, // e
        {0x12,0x7e,0xfe,0x92,0xc0,0x40,0x00,0x00}, // f
        {0x19,0x3d,0x25,0x25,0x1f,0x3e,0x20,0x00}, // g
        {0x82,0xfe,0xfe,0x10,0x20,0x3e,0x1e,0x00}, // h
        {0x00,0x22,0xbe,0xbe,0x02,0x00,0x00,0x00}, // i
        {0x02,0x23,0x21,0xbf,0xbe,0x00,0x00,0x00}, // j
        {0x82,0xfe,0xfe,0x08,0x1c,0x36,0x22,0x00}, // k
        {0x00,0x82,0xfe,0xfe,0x02,0x00,0x00,0x00}, // l
        {0x3e,0x3e,0x30,0x18,0x30,0x3e,0x1e,0x00}, // m
        {0x3e,0x3e,0x20,0x20,0x3e,0x1e,0x00,0x00}, // n
        {0x1c,0x3e,0x22,0x22,0x3e,0x1c,0x00,0x00}, // o
        {0x21,0x3f,0x1f,0x25,0x24,0x3c,0x18,0x00}, // p
        {0x18,0x3c,0x24,0x25,0x1f,0x3f,0x21,0x00}, // q
        {0x22,0x3e,0x1e,0x22,0x38,0x18,0x00,0x00}, // r
        {0x12,0x3a,0x2a,0x2a,0x2e,0x24,0x00,0x00}, // s
        {0x00,0x20,0x7c,0xfe,0x22,0x24,0x00,0x00}, // t
        {0x3c,0x3e,0x02,0x02,0x3c,0x3e,0x02,0x00}, // u
        {0x38,0x3c,0x06,0x06,0x3c,0x38,0x00,0x00}, // v
        {0x3c,0x3e,0x06,0x0c,0x06,0x3e,0x3c,0x00}, // w
        {0x22,0x36,0x1c,0x08,0x1c,0x36,0x22,0x00}, // x
        {0x39,0x3d,0x05,0x05,0x3f,0x3e,0x00,0x00}, // y
        {0x32,0x26,0x2e,0x3a,0x32,0x26,0x00,0x00}, // z
        {0x10,0x10,0x7c,0xee,0x82,0x82,0x00,0x00}, // {
        {0x00,0x00,0x00,0xee,0xee,0x00,0x00,0x00}, // |
        {0x82,0x82,0xee,0x7c,0x10,0x10,0x00,0x00}, // }
        {0x40,0xc0,0x80,0xc0,0x40,0xc0,0x80,0x00}, // ~
        {0x1e,0x3e,0x62,0xc2,0x62,0x3e,0x1e,0x00}, //
};


/*#################################################################
 ##                                                              ##
 ##                   Define Color 24 Bit RGB                    ##
 ##                                                              ##
 #################################################################*/

#define   Snow                0xFFFAFA
#define   GhostWhite          0xF8F8FF
#define   WhiteSmoke          0xF5F5F5
#define   Gainsboro           0xDCDCDC
#define   FloralWhite         0xFFFAF0
#define   OldLace             0xFDF5E6
#define   Linen               0xFAF0E6
#define   AntiqueWhite        0xFAEBD7
#define   PapayaWhip          0xFFEFD5
#define   BlanchedAlmond      0xFFEBCD
#define   Bisque              0xFFE4C4
#define   PeachPuff           0xFFDAB9
#define   NavajoWhite         0xFFDEAD
#define   Moccasin            0xFFE4B5
#define   Cornsilk            0xFFF8DC
#define   Ivory               0xFFFFF0
#define   LemonChiffon        0xFFFACD
#define   Seashell            0xFFF5EE
#define   Honeydew            0xF0FFF0
#define   MintCream           0xF5FFFA
#define   Azure               0xF0FFFF
#define   AliceBlue           0xF0F8FF
#define   lavender            0xE6E6FA
#define   LavenderBlush       0xFFF0F5
#define   MistyRose           0xFFE4E1
#define   White               0xFFFFFF
#define   Black               0x000000
#define   DarkSlateGray       0x2F4F4F
#define   DimGrey             0x696969
#define   SlateGrey           0x708090
#define   LightSlateGray      0x778899
#define   Grey                0xBEBEBE
#define   LightGray           0xD3D3D3
#define   MidnightBlue        0x191970
#define   NavyBlue            0x000080
#define   CornflowerBlue      0x6495ED
#define   DarkSlateBlue       0x483D8B
#define   SlateBlue           0x6A5ACD
#define   MediumSlateBlue     0x7B68EE
#define   LightSlateBlue      0x8470FF
#define   MediumBlue          0x0000CD
#define   RoyalBlue           0x4169E1
#define   Blue                0x0000FF
#define   DodgerBlue          0x1E90FF
#define   DeepSkyBlue         0x00BFFF
#define   SkyBlue             0x87CEEB
#define   LightSkyBlue        0x87CEFA
#define   SteelBlue           0x4682B4
#define   LightSteelBlue      0xB0C4DE
#define   LightBlue           0xADD8E6
#define   PowderBlue          0xB0E0E6
#define   PaleTurquoise       0xAFEEEE
#define   DarkTurquoise       0x00CED1
#define   MediumTurquoise     0x48D1CC
#define   Turquoise           0x40E0D0
#define   Cyan                0x00FFFF
#define   LightCyan           0xE0FFFF
#define   CadetBlue           0x5F9EA0
#define   MediumAquamarine    0x66CDAA
#define   Aquamarine          0x7FFFD4
#define   DarkGreen           0x006400
#define   DarkOliveGreen      0x556B2F
#define   DarkSeaGreen        0x8FBC8F
#define   SeaGreen            0x2E8B57
#define   MediumSeaGreen      0x3CB371
#define   LightSeaGreen       0x20B2AA
#define   PaleGreen           0x98FB98
#define   SpringGreen         0x00FF7F
#define   LawnGreen           0x7CFC00
#define   Green               0x00FF00
#define   Chartreuse          0x7FFF00
#define   MedSpringGreen      0x00FA9A
#define   GreenYellow         0xADFF2F
#define   LimeGreen           0x32CD32
#define   YellowGreen         0x9ACD32
#define   ForestGreen         0x228B22
#define   OliveDrab           0x6B8E23
#define   DarkKhaki           0xBDB76B
#define   PaleGoldenrod       0xEEE8AA
#define   LtGoldenrodYello    0xFAFAD2
#define   LightYellow         0xFFFFE0
#define   Yellow              0xFFFF00
#define   Gold                0xFFD700
#define   LightGoldenrod      0xEEDD82
#define   goldenrod           0xDAA520
#define   DarkGoldenrod       0xB8860B 
#define   RosyBrown           0xBC8F8F
#define   IndianRed           0xCD5C5C
#define   SaddleBrown         0x8B4513
#define   Sienna              0xA0522D
#define   Peru                0xCD853F
#define   Burlywood           0xDEB887
#define   Beige               0xF5F5DC
#define   Wheat               0xF5DEB3
#define   SandyBrown          0xF4A460
#define   Tan                 0xD2B48C
#define   Chocolate           0xD2691E
#define   Firebrick           0xB22222
#define   Brown               0xA52A2A
#define   DarkSalmon          0xE9967A   
#define   Salmon              0xFA8072
#define   LightSalmon         0xFFA07A
#define   Orange              0xFFA500
#define   DarkOrange          0xFF8C00
#define   Coral               0xFF7F50
#define   LightCoral          0xF08080
#define   Tomato              0xFF6347
#define   OrangeRed           0xFF4500
#define   Red                 0xFF0000
#define   HotPink             0xFF69B4
#define   DeepPink            0xFF1493
#define   Pink                0xFFC0CB
#define   LightPink           0xFFB6C1
#define   PaleVioletRed       0xDB7093
#define   Maroon              0xB03060
#define   MediumVioletRed     0xC71585
#define   VioletRed           0xD02090
#define   Magenta             0xFF00FF
#define   Violet              0xEE82EE
#define   Plum                0xDDA0DD
#define   Orchid              0xDA70D6
#define   MediumOrchid        0xBA55D3
#define   DarkOrchid          0x9932CC
#define   DarkViolet          0x9400D3
#define   BlueViolet          0x8A2BE2
#define   Purple              0xA020F0
#define   MediumPurple        0x9370DB
#define   Thistle             0xD8BFD8
#define   Snow1               0xFFFAFA
#define   Snow2               0xEEE9E9 
#define   Snow3               0xCDC9C9
#define   Snow4               0x8B8989
#define   Seashell1           0xFFF5EE
#define   Seashell2           0xEEE5DE
#define   Seashell3           0xCDC5BF
#define   Seashell4           0x8B8682
#define   AntiqueWhite1       0xFFEFDB
#define   AntiqueWhite2       0xEEDFCC
#define   AntiqueWhite3       0xCDC0B0
#define   AntiqueWhite4       0x8B8378
#define   Bisque1             0xFFE4C4
#define   Bisque2             0xEED5B7
#define   Bisque3             0xCDB79E
#define   Bisque4             0x8B7D6B
#define   PeachPuff1          0xFFDAB9
#define   PeachPuff2          0xEECBAD
#define   PeachPuff3          0xCDAF95
#define   PeachPuff4          0x8B7765
#define   NavajoWhite1        0xFFDEAD
#define   NavajoWhite2        0xEECFA1
#define   NavajoWhite3        0xCDB38B
#define   NavajoWhite4        0x8B795E
#define   LemonChiffon1       0xFFFACD
#define   LemonChiffon2       0xEEE9BF
#define   LemonChiffon3       0xCDC9A5
#define   LemonChiffon4       0x8B8970
#define   Cornsilk1           0xFFF8DC
#define   Cornsilk2           0xEEE8CD
#define   Cornsilk3           0xCDC8B1
#define   Cornsilk4           0x8B8878
#define   Ivory1              0xFFFFF0
#define   Ivory2              0xEEEEE0
#define   Ivory3              0xCDCDC1
#define   Ivory4              0x8B8B83
#define   Honeydew1           0xF0FFF0
#define   Honeydew2           0xE0EEE0
#define   Honeydew3           0xC1CDC1
#define   Honeydew4           0x838B83
#define   LavenderBlush1      0xFFF0F5
#define   LavenderBlush2      0xEEE0E5
#define   LavenderBlush3      0xCDC1C5
#define   LavenderBlush4      0x8B8386
#define   MistyRose1          0xFFE4E1
#define   MistyRose2          0xEED5D2 
#define   MistyRose3          0xCDB7B5
#define   MistyRose4          0x8B7D7B
#define   Azure1              0xF0FFFF
#define   Azure2              0xE0EEEE
#define   Azure3              0xC1CDCD
#define   Azure4              0x838B8B
#define   SlateBlue1          0x836FFF
#define   SlateBlue2          0x7A67EE
#define   SlateBlue3          0x6959CD
#define   SlateBlue4          0x473C8B
#define   RoyalBlue1          0x4876FF
#define   RoyalBlue2          0x436EEE
#define   RoyalBlue3          0x3A5FCD
#define   RoyalBlue4          0x27408B
#define   Blue1               0x0000FF
#define   Blue2               0x0000EE
#define   Blue3               0x0000CD
#define   Blue4               0x00008B
#define   DodgerBlue1         0x1E90FF
#define   DodgerBlue2         0x1C86EE
#define   DodgerBlue3         0x1874CD
#define   DodgerBlue4         0x104E8B
#define   SteelBlue1          0x63B8FF
#define   SteelBlue2          0x5CACEE
#define   SteelBlue3          0x4F94CD
#define   SteelBlue4          0x36648B
#define   DeepSkyBlue1        0x00BFFF
#define   DeepSkyBlue2        0x00B2EE
#define   DeepSkyBlue3        0x009ACD
#define   DeepSkyBlue4        0x00688B
#define   SkyBlue1            0x87CEFF
#define   SkyBlue2            0x7EC0EE
#define   SkyBlue3            0x6CA6CD
#define   SkyBlue4            0x4A708B
#define   LightSkyBlue1       0xB0E2FF
#define   LightSkyBlue2       0xA4D3EE
#define   LightSkyBlue3       0x8DB6CD
#define   LightSkyBlue4       0x607B8B
#define   SlateGray1          0xC6E2FF
#define   SlateGray2          0xB9D3EE
#define   SlateGray3          0x9FB6CD
#define   SlateGray4          0x6C7B8B
#define   LightSteelBlue1     0xCAE1FF
#define   LightSteelBlue2     0xBCD2EE 
#define   LightSteelBlue3     0xA2B5CD
#define   LightSteelBlue4     0x6E7B8B
#define   LightBlue1          0xBFEFFF
#define   LightBlue2          0xB2DFEE
#define   LightBlue3          0x9AC0CD
#define   LightBlue4          0x68838B
#define   LightCyan1          0xE0FFFF
#define   LightCyan2          0xD1EEEE
#define   LightCyan3          0xB4CDCD
#define   LightCyan4          0x7A8B8B
#define   PaleTurquoise1      0xBBFFFF
#define   PaleTurquoise2      0xAEEEEE
#define   PaleTurquoise3      0x96CDCD
#define   PaleTurquoise4      0x668B8B
#define   CadetBlue1          0x98F5FF
#define   CadetBlue2          0x8EE5EE
#define   CadetBlue3          0x7AC5CD
#define   CadetBlue4          0x53868B
#define   Turquoise1          0x00F5FF
#define   Turquoise2          0x00E5EE
#define   Turquoise3          0x00C5CD
#define   Turquoise4          0x00868B
#define   Cyan1               0x00FFFF
#define   Cyan2               0x00EEEE
#define   Cyan3               0x00CDCD
#define   Cyan4               0x008B8B
#define   DarkSlateGray1      0x97FFFF
#define   DarkSlateGray2      0x8DEEEE
#define   DarkSlateGray3      0x79CDCD
#define   DarkSlateGray4      0x528B8B
#define   Aquamarine1         0x7FFFD4
#define   Aquamarine2         0x76EEC6
#define   Aquamarine3         0x66CDAA
#define   Aquamarine4         0x458B74
#define   DarkSeaGreen1       0xC1FFC1
#define   DarkSeaGreen2       0xB4EEB4
#define   DarkSeaGreen3       0x9BCD9B
#define   DarkSeaGreen4       0x698B69
#define   SeaGreen1           0x54FF9F
#define   SeaGreen2           0x4EEE94
#define   SeaGreen3           0x43CD80
#define   SeaGreen4           0x2E8B57
#define   PaleGreen1          0x9AFF9A
#define   PaleGreen2          0x90EE90 
#define   PaleGreen3          0x7CCD7C
#define   PaleGreen4          0x548B54
#define   SpringGreen1        0x00FF7F
#define   SpringGreen2        0x00EE76
#define   SpringGreen3        0x00CD66
#define   SpringGreen4        0x008B45
#define   Green1              0x00FF00
#define   Green2              0x00EE00
#define   Green3              0x00CD00
#define   Green4              0x008B00
#define   Chartreuse1         0x7FFF00
#define   Chartreuse2         0x76EE00
#define   Chartreuse3         0x66CD00
#define   Chartreuse4         0x458B00
#define   OliveDrab1          0xC0FF3E
#define   OliveDrab2          0xB3EE3A
#define   OliveDrab3          0x9ACD32
#define   OliveDrab4          0x698B22
#define   DarkOliveGreen1     0xCAFF70
#define   DarkOliveGreen2     0xBCEE68
#define   DarkOliveGreen3     0xA2CD5A
#define   DarkOliveGreen4     0x6E8B3D
#define   Khaki1              0xFFF68F
#define   Khaki2              0xEEE685
#define   Khaki3              0xCDC673
#define   Khaki4              0x8B864E
#define   LightGoldenrod1     0xFFEC8B
#define   LightGoldenrod2     0xEEDC82
#define   LightGoldenrod3     0xCDBE70
#define   LightGoldenrod4     0x8B814C
#define   LightYellow1        0xFFFFE0
#define   LightYellow2        0xEEEED1
#define   LightYellow3        0xCDCDB4
#define   LightYellow4        0x8B8B7A
#define   Yellow1             0xFFFF00
#define   Yellow2             0xEEEE00
#define   Yellow3             0xCDCD00
#define   Yellow4             0x8B8B00
#define   Gold1               0xFFD700
#define   Gold2               0xEEC900
#define   Gold3               0xCDAD00
#define   Gold4               0x8B7500
#define   oldenrod1           0xFFC125
#define   Goldenrod2          0xEEB422
#define   Goldenrod3          0xCD9B1D
#define   Goldenrod4          0x8B6914
#define   DarkGoldenrod1      0xFFB90F
#define   DarkGoldenrod2      0xEEAD0E
#define   DarkGoldenrod3      0xCD950C
#define   DarkGoldenrod4      0x8B658B
#define   RosyBrown1          0xFFC1C1
#define   RosyBrown2          0xEEB4B4
#define   RosyBrown3          0xCD9B9B
#define   RosyBrown4          0x8B6969
#define   IndianRed1          0xFF6A6A
#define   IndianRed2          0xEE6363
#define   IndianRed3          0xCD5555
#define   IndianRed4          0x8B3A3A
#define   Sienna1             0xFF8247
#define   Sienna2             0xEE7942
#define   Sienna3             0xCD6839
#define   Sienna4             0x8B4726
#define   Burlywood1          0xFFD39B
#define   Burlywood2          0xEEC591
#define   Burlywood3          0xCDAA7D
#define   Burlywood4          0x8B7355
#define   Wheat1              0xFFE7BA
#define   Wheat2              0xEED8AE
#define   Wheat3              0xCDBA96
#define   Wheat4              0x8B7E66
#define   Tan1                0xFFA54F
#define   Tan2                0xEE9A49
#define   Tan3                0xCD853F
#define   Tan4                0x8B5A2B
#define   Chocolate1          0xFF7F24
#define   Chocolate2          0xEE7621
#define   Chocolate3          0xCD661D
#define   Chocolate4          0x8B4513
#define   Firebrick1          0xFF3030
#define   Firebrick2          0xEE2C2C
#define   Firebrick3          0xCD2626
#define   Firebrick4          0x8B1A1A
#define   Brown1              0xFF4040
#define   Brown2              0xEE3B3B
#define   Brown3              0xCD3333
#define   Brown4              0x8B2323
#define   Salmon1             0xFF8C69
#define   Salmon2             0xEE8262
#define   Salmon3             0xCD7054
#define   Salmon4             0x8B4C39
#define   LightSalmon1        0xFFA07A
#define   LightSalmon2        0xEE9572
#define   LightSalmon3        0xCD8162
#define   LightSalmon4        0x8B5742
#define   Orange1             0xFFA500
#define   Orange2             0xEE9A00
#define   Orange3             0xCD8500
#define   Orange4             0x8B5A00
#define   DarkOrange1         0xFF7F00
#define   DarkOrange2         0xEE7600
#define   DarkOrange3         0xCD6600
#define   DarkOrange4         0x8B4500
#define   Coral1              0xFF7256
#define   Coral2              0xEE6A50
#define   Coral3              0xCD5B45
#define   Coral4              0x8B3E2F
#define   Tomato1             0xFF6347
#define   Tomato2             0xEE5C42
#define   Tomato3             0xCD4F39
#define   Tomato4             0x8B3626
#define   OrangeRed1          0xFF4500
#define   OrangeRed2          0xEE4000
#define   OrangeRed3          0xCD3700
#define   OrangeRed4          0x8B2500
#define   Red1                0xFF0000
#define   Red2                0xEE0000
#define   Red3                0xCD0000
#define   Red4                0x8B0000
#define   DeepPink1           0xFF1493
#define   DeepPink2           0xEE1289
#define   DeepPink3           0xCD1076
#define   DeepPink4           0x8B0A50
#define   HotPink1            0xFF6EB4
#define   HotPink2            0xEE6AA7
#define   HotPink3            0xCD6090
#define   HotPink4            0x8B3A62
#define   Pink1               0xFFB5C5
#define   Pink2               0xEEA9B8
#define   Pink3               0xCD919E
#define   Pink4               0x8B636C
#define   LightPink1          0xFFAEB9
#define   LightPink2          0xEEA2AD
#define   LightPink3          0xCD8C95
#define   LightPink4          0x8B5F65
#define   PaleVioletRed1      0xFF82AB
#define   PaleVioletRed2      0xEE799F
#define   PaleVioletRed3      0xCD6889
#define   PaleVioletRed4      0xB475D
#define   Maroon1             0xFF34B3
#define   Maroon2             0xEE30A7
#define   Maroon3             0xCD2990
#define   Maroon4             0x8B1C62
#define   VioletRed1          0xFF3E96
#define   VioletRed2          0xEE3A8C
#define   VioletRed3          0xCD3278
#define   VioletRed4          0x8B2252
#define   Magenta1            0xFF00FF
#define   Magenta2            0xEE00EE
#define   Magenta3            0xCD00CD
#define   Magenta4            0x8B008B
#define   Orchid1             0xFF83FA
#define   Orchid2             0xEE7AE9
#define   Orchid3             0xCD69C9
#define   Orchid4             0x8B4789
#define   Plum1               0xFFBBFF
#define   Plum2               0xEEAEEE
#define   Plum3               0xCD96CD
#define   Plum4               0x8B668B
#define   MediumOrchid1       0xE066FF
#define   MediumOrchid2       0xD15FEE
#define   MediumOrchid3       0xB452CD
#define   MediumOrchid4       0x7A378B
#define   DarkOrchid1         0xBF3EFF
#define   DarkOrchid2         0xB23AEE
#define   DarkOrchid3         0x9A32CD
#define   DarkOrchid4         0x68228B
#define   Purple1             0x9B30FF
#define   Purple2             0x912CEE
#define   Purple3             0x7D26CD
#define   Purple4             0x551A8B
#define   MediumPurple1       0xAB82FF
#define   MediumPurple2       0x9F79EE
#define   MediumPurple3       0x8968CD
#define   MediumPurple4       0x5D478B
#define   Thistle1            0xFFE1FF
#define   Thistle2            0xEED2EE
#define   Thistle3            0xCDB5CD
#define   Thistle4            0x8B7B8B
#define   grey11              0x1C1C1C
#define   grey21              0x363636
#define   grey31              0x4F4F4F
#define   grey41              0x696969
#define   grey51              0x828282
#define   grey61              0x9C9C9C
#define   grey71              0xB5B5B5
#define   gray81              0xCFCFCF
#define   gray91              0xE8E8E8
#define   DarkGrey            0xA9A9A9
#define   DarkBlue            0x00008B
#define   DarkCyan            0x008B8B
#define   DarkMagenta         0x8B008B
#define   DarkRed             0x8B0000
#define   LightGreen          0x90EE90




/*#################################################################
 ##                                                              ##
 ##         Define Valu Data for Logic Code (High ,Low)          ##
 ##                                                              ##
 #################################################################*/


#define Logic_Low    0xC0            //Data Logic LOW (Pulse 1=250n[2bitx125ns] ,0=750ns[6bitx125ns] )
#define Logic_High   0xFC            //Data Logic High(Pulse 1=750n[6bitx125ns] ,0=250ns[2bitx125ns] )


/*#################################################################
 ##                                                              ##
 ##                        Define Variable                       ##
 ##                                                              ##
 #################################################################*/

 
#define  Num_LED    64                           // Number LED Serial Connect in Circuit
 
unsigned long LED_Buf[Num_LED]             ;     //Buffer Array LED Display for keep Data Color of LED All 

unsigned char Text_Buf[20]                 ;     //Buffer Keep Text Shift (array= number byte data (wide of 1 charecter)  )
unsigned char  num_colum = 8               ;     //Number Colume LED (Dot LED in 1 Row}

/*#################################################################
 ##                                                              ##
 ##                            Sub-program                       ##
 ##                                                              ##
 ##################################################################*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++
 ++                                                ++
 ++            1.Function:Delay(us)                ++
 ++++++++++++++++++++++++++++++++++++++++++++++++++++
 ++   Input :                                      ++
 ++           cnt = Time Delay  (us)               ++
 ++                                                ++
 +++++++++++++++++++++++++++++++++++++++++++++++++++*/

 void delay_us(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_us(1);
  }


/*+++++++++++++++++++++++++++++++++++++++++++++++++++
 ++                                                ++
 ++            2.Function:Delay(ms)                ++
 ++++++++++++++++++++++++++++++++++++++++++++++++++++
 ++   Input :                                      ++
 ++           cnt = Time Delay  (ms)               ++
 ++                                                ++
 +++++++++++++++++++++++++++++++++++++++++++++++++++*/

 void delay_ms(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_ms(1);
  }


 /*+++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                ++
  ++          3.Function:Initial Port               ++
  ++                                                ++ 
  +++++++++++++++++++++++++++++++++++++++++++++++++++*/

 void Init_Port(void)
  {
    
   DDRB  = 0x07     ;        //Set PB2(DO),PB1(SCK),PB0(SS):Output (1=Out)
   PORTB = 0x00     ;        //Set default PB =0x00      
    
  
  //-------------- Initial SPI Module ----------------

   SPCR=0x5C       ;         // Enable,Bit MSB Transmittede First ,SPI bus as Master,devider(/2),CPOL:CPHA=1
   SPSR=0x01       ;         // Oscillator Freq (SCK)= Fosc/2 when Fosc= 16MHz,(0x01)
                      

  }



/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                    ++
  ++                   4.Function: SPI Sent Data 8 bit                  ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                    ++
  ++    Clock SPI = 16MHz/2 = 8MHz = 1/8Mhz = 125 ns                    ++
  ++                                                                    ++
  ++    Input :                                                         ++
  ++            DataByte = Data 1 Byte for Build Logic High,Low 1 bit   ++                                         
  ++                                                                    ++
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void spi_wr(unsigned char DataByte)
 {
   SPDR = DataByte               ; //Write data to Buffer SPI Module 
   while ((SPSR&0x80) == 0) {;}    //Check Sent data to Buffer Ready
  
 }


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                   ++
  ++      5.Function :Write Data 1 Color 24 Bit GRB    ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                   ++
  ++     Input :  GRB = Color 24 bit GRB               ++
  ++                                                   ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void WrRGB_24Bit(unsigned long GRB)
 {
   unsigned char bt   ;

 //-------------------------Start Write Data RGB Color 24 bit -----------------------------
   
    for(bt=0;bt<24;bt++)              //Loop Write Data  1 Color 24 bit)
    {
      
       if(GRB & 0x80000000)           //Check Color 24 bit[32..16] Start Bit 32 
        {
          spi_wr(Logic_High)      ;   // Write bit data Color  Logic 1
        }
       else
        {
          spi_wr(Logic_Low)       ;   // Write bit data Color  Logic 0
          
        }      
      
        GRB = GRB <<1             ;  //Shift Left  bit data Color 1 bit
    
    } 

 }




/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++    6.Function:Convert Data Color 24 bit RGB in Buffer LED All       ++
  ++               to GRB Color 32 bit                                  ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++   Valiable :                                                        ++
  ++             Num_LED = Number LED All at Connect Serial              ++       
  ++                                                                     ++
  ++             LED_Buf = Array Buffer of LED All for Keep Color GRB    ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void RGB_TO_GRB(void)
{
  unsigned int led      ; 
  unsigned long RGB,GRB ; 

   for(led=0;led<Num_LED;led++)         //Loop Read/Write Data Color from Buffer LED All
    { 
	     
     RGB    =  LED_Buf[led]         ;   //Read Code Color RGB from Buffer LED
     RGB  <<=  8                    ;   //Shift Left RGB Color bit [0..23]  to  RGB Color bit [31..16] 
 
     //----------- Exchange RGB Color to GRB Color follow Pattern Data color of WS2812B -----------

     GRB   = RGB & 0x0000FF00       ;   //Mark bit[15..8]   for Color Blue
         
     GRB  |= (RGB & 0x00FF0000)<<8  ;   //Mark bit[23..16]  for Color Green and Shift Left to bit[31..24]
  
     GRB  |= (RGB & 0xFF000000)>>8  ;   //Mark bit[31..24]  for Color Red and Shift Right to bit [23..16](GRB Color Ready)

     LED_Buf[led]  =  GRB           ;   //Keep Data Color GRB to LED_Buf[]
    }
}


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++        7. Function:Write Frame Color to LED All                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++   Valiable :                                                        ++
  ++             Num_LED = Number LED All at Connect Serial              ++       
  ++                                                                     ++
  ++             LED_Buf = Array Buffer of LED All keep Color GRB        ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


void Sent_Frame_Led(void)
 {
   unsigned int led  ; 
  

   RGB_TO_GRB()                       ;  // Chang RGB to GRB

   for(led=0;led<Num_LED;led++)
    { 
      WrRGB_24Bit(LED_Buf[led])       ; //Sent frame color all
    }

   delay_us(50)                       ; //Reset  Code
 }




/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++                  8. Function : Clear LED All                        ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++       Input :                                                       ++
  ++               Clear_Color = Color RGB for Clear  LED                ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


void Clear_LED(unsigned long Clear_Color)
 {
   unsigned int array  ;  
 
 //---- Keep Data Color to LED Bufer ------

   for(array=0;array<Num_LED;array++)
    { 
      LED_Buf[array]  = Clear_Color      ; //Keep data Color Black to Buffer LED  
    }

 //---------- Sent Data to LED Display ------------  
    Sent_Frame_Led()                     ; //Update LED

 }



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++              8.Function: Write text to LED_Buf and Display LED      ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++      Befor use This Function must use Function ShiftL_Text()        ++
  ++      for Detetmine Text                                             ++
  ++                                                                     ++
  ++       Input :                                                       ++
  ++                  font  = Format font Select                         ++
  ++                          1:Font Size 5x7 (Regular)                  ++
  ++                          2:Font Size 8x8 (Bold)                     ++
  ++               tx_color = Color RGB Chrector                         ++
  ++               bg_color = Color RGB BackGround                       ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


 void Text_LED(unsigned long tx_color,unsigned long bg_color)
 {
   unsigned char col,n                 ;
   unsigned char tx =0                 ;
   unsigned char pt = Num_LED          ;   //Pointer for LED_Buf[] : ex.= 64 LED

 
   pt --                               ;   //Start Array for LED_Buf[] at 63

   for(col=0;col<num_colum;col++)          //Loop Number Colume LED (Numer LED in 1 Row ) 
	{

     //---Keep byte Data Charecter to Led Buffer (Start data Bit LSB-Colume odd 7,5,3,1)-----

      tx = Text_Buf[col]                      ;   // Read byte data charecter (data colum )
		 
	  for(n=0;n<8;n++)		                      //Loop Keep data Charecter 1 byte(8bit)
	   {
	     if(tx & 0x01)				              //if Byte Charecter bit0 = 1 
		  {              
            LED_Buf[pt] = tx_color             ;  //Keep Color Charecter for 1 bit data=24bit Color to Buffer Display			  
            pt--                               ;  //Decrement Pointer Array
		  }
		 else						              //if Byte Charecter bit0 = 0 
		  {
		    LED_Buf[pt] = bg_color             ;  //Keep Color BackGround for 1 bit data=24 bit Color to Buffer Display	
		    pt--                               ;  //Decrement Pointer Array
	      }

		 tx = tx >> 1                          ;  //Shift Right bit in Byte Charecter 

	   }  //For n=8 

            
      //---Keep Data Charecter to Led Buffer (Start data Bit MSB-Colume Even 6,4,2,0)----- -----

      col++ ;                                        //Increment Array Next Byte   

	  if(col<num_colum)                              //Check Number Byte Data Charecter (wide)
	   {
	        
		 tx = Text_Buf[col]                       ;  // Read byte data charecter (data colum )

	   	 for(n=0;n<8;n++)		                     //Loop Keep data Charecter 1 byte(8bit)
		  {
	       if(tx & 0x80)				             //if Byte Charecter bit7 = 1 
		 	{              
              LED_Buf[pt] = tx_color              ;  //Keep Color Charecter for 1 bit data=24bit Color to Buffer Display				  
              pt--                                ;  //Decrement Pointer Array
		    }
		   else						                 //if Byte Charecter bit7 = 0 
		    { 
		      LED_Buf[pt] = bg_color              ;  //Keep Color BackGround for 1 bit data=24bit Color to Buffer Display	
	   	      pt--                                ;  //Decrement Pointer Array
			}
	
		    tx = tx << 1                          ;  //Shift Left bit in Byte Charecter 

		  }  //For n=8

       }    //if col< ft

    }       //for col=0



 //----------- Write 1 Charecter to LED Display---------

   Sent_Frame_Led();



 }


 /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ++                                                                    ++
   ++                    9.Function : Shift Left String                  ++
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ++                                                                    ++
   ++      Input  :  													 ++
   ++               *str = Charecter ASCII (String)					     ++
   ++               font = Format font Select                            ++
   ++                      1:Font Size 5x7 (Regular)                     ++
   ++                      2:Font Size 8x8 (Bold)                        ++
   ++           tx_color = Color RGB Chrector                            ++
   ++           bg_color = Color RGB BackGround                          ++
   ++            dly_ms  = Delay ms for Speed Shift                      ++ 
   ++                                                                    ++
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/



void ShiftL_Text(char *str,unsigned char font,unsigned long tx_color,unsigned long bg_color,unsigned int dly_ms)
{
  unsigned char row,col,ft=0  ;
  signed char nm_col ;
  unsigned char num_str,ascii;
  

   //------------ Loop Read String for Shift -------------

  for(num_str=0;str[num_str] != '\0';num_str++)
   {	

     ascii = str[num_str]                          ;   //Read Text Ascii from User
     row   = ascii-0x20                            ;   //Convert Ascii to value Array Row

     //-----Select Font ------
     if(font== 1)
       ft = 5 ;                                        //Select font 5x7:Determine Number Byte wide of 1 Charecter  
     if(font==2)	 
       ft = 8 ;                                        //Select font 8x8:Determine Number Byte wide of 1 Charecter  

     for(col=0;col<num_colum;col++)                    //Loop Number Colume LED(Number LED in 1 Row) 
	  {

       //----Read Byte Data Charecter from font array----
	    
       if(font== 1)
	    {
	      if(col<ft)
            ascii = pgm_read_byte(&font_5x7[row][col]) ;  //Read data font Charecter 5x7
          else
		    ascii = 0  ;                                  //Data 0 for not data of font  
        }
       if(font== 2)
	    {
	      if(col<ft)
            ascii = pgm_read_byte(&font_8x8[row][col]) ;  //Read data font Charecter 8x8
          else
	   	    ascii = 0  ;                                  //Data 0 for not data of font 
        }


	   Text_Buf[0] = ascii                             ;  //Keep data for Shift

       Text_LED(tx_color,bg_color)                     ;  //Display Text to LED


       for(nm_col=(num_colum-1);nm_col>0 ;nm_col--)       //Loop Shift Left Byte Data colume 
        {
          
		 Text_Buf[nm_col] =  Text_Buf[nm_col-1]        ;
	   
        }
       

	  delay_ms(dly_ms) ;   //delay Speed Shift

     }  //for col

   } //for num str
}



/*##########################################################################
 ##                                                                       ##
 ##                            MAIN PROGRAM                               ##
 ##                                                                       ##
 ###########################################################################*/

int main(void)
 {
   
  Init_Port()     ;
  delay_ms(200)   ;
  Clear_LED(Black);

   while(1)
    {

      ShiftL_Text("DEMO ",2,Blue,Black,170) ;
	  ShiftL_Text("ET-iLED8x8-RGB ",2,Yellow,Black,170) ;
	  ShiftL_Text("*By ETT.,LTD.* ",1,Red,Black,200) ;

    }

}


   

